/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property;

import com.android.ide.common.res2.ResourceItem;
import com.android.tools.adtui.workbench.ToolContent;
import com.android.tools.idea.common.analytics.NlUsageTrackerManager;
import com.android.tools.idea.common.model.ModelListener;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.DesignSurfaceListener;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.property.NlProperties;
import com.android.tools.idea.uibuilder.property.NlPropertiesPanel;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.NlPropertyItem;
import com.android.tools.idea.uibuilder.property.ToggleXmlPropertyEditor;
import com.android.tools.idea.uibuilder.property.ViewAllPropertiesAction;
import com.android.tools.idea.uibuilder.property.assistant.ComponentAssistant;
import com.android.tools.idea.uibuilder.property.editors.NlPropertyEditors;
import com.android.tools.idea.uibuilder.property.inspector.InspectorPanel;
import com.android.util.PropertiesMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Divider;
import com.intellij.openapi.ui.Splitter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.util.Alarm;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlPropertiesManager
implements ToolContent<DesignSurface>,
DesignSurfaceListener,
ModelListener {
    public static final int UPDATE_DELAY_MSECS = 250;
    private final Project myProject;
    private JBLoadingPanel myLoadingPanel;
    private NlPropertiesPanel myPropertiesPanel;
    private final NlPropertyEditors myEditors;
    private final AndroidFacet myFacet;
    @Nullable
    private DesignSurface mySurface;
    @Nullable
    private SceneView mySceneView;
    private MergingUpdateQueue myUpdateQueue;
    private boolean myFirstLoad;
    private boolean myLoading;
    private int myUpdateCount;
    private JBSplitter mySplitter;
    private ComponentAssistant myComponentAssistant;

    public NlPropertiesManager(@NotNull AndroidFacet facet, @Nullable DesignSurface designSurface) {
        if (facet == null) {
            NlPropertiesManager.$$$reportNull$$$0(0);
        }
        this.myFirstLoad = true;
        this.myProject = facet.getModule().getProject();
        this.myFacet = facet;
        this.myEditors = NlPropertyEditors.getInstance(this.myProject);
        this.mySurface = designSurface;
        this.setToolContextWithoutCheck(designSurface);
    }

    public void activatePropertySheet() {
        this.getPropertiesPanel().activatePropertySheet();
    }

    public void activateInspector() {
        this.getPropertiesPanel().activateInspector();
    }

    public void setToolContext(@Nullable DesignSurface designSurface) {
        if (designSurface == this.mySurface) {
            return;
        }
        this.setToolContextWithoutCheck(designSurface);
    }

    public void setRestoreToolWindow(@NotNull Runnable restoreToolWindowCallback) {
        if (restoreToolWindowCallback == null) {
            NlPropertiesManager.$$$reportNull$$$0(1);
        }
        this.myPropertiesPanel.setRestoreToolWindow(restoreToolWindowCallback);
    }

    @NotNull
    private JBLoadingPanel getLoadingPanel() {
        if (this.myLoadingPanel == null) {
            this.myLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this, 20);
            this.myLoadingPanel.add((Component)this.getContentPanel());
        }
        JBLoadingPanel jBLoadingPanel = this.myLoadingPanel;
        if (jBLoadingPanel == null) {
            NlPropertiesManager.$$$reportNull$$$0(2);
        }
        return jBLoadingPanel;
    }

    @NotNull
    private NlPropertiesPanel getPropertiesPanel() {
        if (this.myPropertiesPanel == null) {
            this.myPropertiesPanel = new NlPropertiesPanel(this, (Disposable)this);
        }
        NlPropertiesPanel nlPropertiesPanel = this.myPropertiesPanel;
        if (nlPropertiesPanel == null) {
            NlPropertiesManager.$$$reportNull$$$0(3);
        }
        return nlPropertiesPanel;
    }

    @NotNull
    private ComponentAssistant getComponentAssistant() {
        if (this.myComponentAssistant == null) {
            this.myComponentAssistant = new ComponentAssistant(this.myProject);
        }
        ComponentAssistant componentAssistant = this.myComponentAssistant;
        if (componentAssistant == null) {
            NlPropertiesManager.$$$reportNull$$$0(4);
        }
        return componentAssistant;
    }

    @NotNull
    private JBSplitter getContentPanel() {
        if (this.mySplitter == null) {
            this.mySplitter = new JBSplitter(true, 0.8f){
                {
                    this.setDividerWidth(9);
                }

                protected Divider createDivider() {
                    Splitter.DividerImpl divider = new Splitter.DividerImpl((Splitter)this);
                    divider.setBorder(IdeBorderFactory.createBorder((int)10));
                    return divider;
                }
            };
            this.mySplitter.setFirstComponent((JComponent)this.getPropertiesPanel());
        }
        JBSplitter jBSplitter = this.mySplitter;
        if (jBSplitter == null) {
            NlPropertiesManager.$$$reportNull$$$0(5);
        }
        return jBSplitter;
    }

    private void setToolContextWithoutCheck(@Nullable DesignSurface designSurface) {
        if (this.mySurface != null) {
            this.mySurface.removeListener(this);
        }
        this.mySurface = designSurface;
        if (this.mySurface == null) {
            this.setSceneView(null);
        } else {
            this.mySurface.addListener(this);
            SceneView sceneView = this.mySurface.getCurrentSceneView();
            this.setSceneView(sceneView);
            List<NlComponent> selection = sceneView != null ? sceneView.getSelectionModel().getSelection() : Collections.emptyList();
            this.componentSelectionChanged(this.mySurface, selection);
        }
    }

    @NotNull
    public JComponent getComponent() {
        JBLoadingPanel jBLoadingPanel = this.getLoadingPanel();
        if (jBLoadingPanel == null) {
            NlPropertiesManager.$$$reportNull$$$0(6);
        }
        return jBLoadingPanel;
    }

    @NotNull
    public JComponent getFocusedComponent() {
        JBSplitter jBSplitter = this.getContentPanel();
        if (jBSplitter == null) {
            NlPropertiesManager.$$$reportNull$$$0(7);
        }
        return jBSplitter;
    }

    @NotNull
    public List<AnAction> getGearActions() {
        ImmutableList immutableList = ImmutableList.of((Object)((Object)new ToggleXmlPropertyEditor(this)));
        if (immutableList == null) {
            NlPropertiesManager.$$$reportNull$$$0(8);
        }
        return immutableList;
    }

    @NotNull
    public List<AnAction> getAdditionalActions() {
        List<ViewAllPropertiesAction> list = Collections.singletonList(new ViewAllPropertiesAction(this.getPropertiesPanel()));
        if (list == null) {
            NlPropertiesManager.$$$reportNull$$$0(9);
        }
        return list;
    }

    public boolean supportsFiltering() {
        return true;
    }

    public void setFilter(@NotNull String filter) {
        if (filter == null) {
            NlPropertiesManager.$$$reportNull$$$0(10);
        }
        this.getPropertiesPanel().setFilter(filter);
    }

    @NotNull
    public KeyListener getFilterKeyListener() {
        KeyListener keyListener = this.getPropertiesPanel().getFilterKeyListener();
        if (keyListener == null) {
            NlPropertiesManager.$$$reportNull$$$0(11);
        }
        return keyListener;
    }

    @Nullable
    public DesignSurface getDesignSurface() {
        return this.mySurface;
    }

    private void setSceneView(@Nullable SceneView sceneView) {
        if (sceneView == this.mySceneView) {
            return;
        }
        if (this.mySceneView != null) {
            this.mySceneView.getModel().removeListener(this);
        }
        this.mySceneView = sceneView;
        if (this.mySceneView != null) {
            this.mySceneView.getModel().addListener(this);
        }
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            NlPropertiesManager.$$$reportNull$$$0(12);
        }
        return project;
    }

    @NotNull
    public AndroidFacet getFacet() {
        AndroidFacet androidFacet = this.myFacet;
        if (androidFacet == null) {
            NlPropertiesManager.$$$reportNull$$$0(13);
        }
        return androidFacet;
    }

    @NotNull
    public NlPropertyEditors getPropertyEditors() {
        NlPropertyEditors nlPropertyEditors = this.myEditors;
        if (nlPropertyEditors == null) {
            NlPropertiesManager.$$$reportNull$$$0(14);
        }
        return nlPropertyEditors;
    }

    @NotNull
    public InspectorPanel getInspector() {
        InspectorPanel inspectorPanel = this.getPropertiesPanel().getInspector();
        if (inspectorPanel == null) {
            NlPropertiesManager.$$$reportNull$$$0(15);
        }
        return inspectorPanel;
    }

    @NotNull
    private MergingUpdateQueue getUpdateQueue() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myUpdateQueue == null) {
            this.myUpdateQueue = new MergingUpdateQueue("android.layout.propertysheet", 250, true, null, (Disposable)this.mySurface, null, Alarm.ThreadToUse.SWING_THREAD);
        }
        MergingUpdateQueue mergingUpdateQueue = this.myUpdateQueue;
        if (mergingUpdateQueue == null) {
            NlPropertiesManager.$$$reportNull$$$0(16);
        }
        return mergingUpdateQueue;
    }

    private void setSelectedComponents(@NotNull List<NlComponent> components, @Nullable Runnable postUpdateRunnable) {
        if (components == null) {
            NlPropertiesManager.$$$reportNull$$$0(17);
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (components == null) {
                NlPropertiesManager.$$$reportNull$$$0(41);
            }
            Table<String, String, NlPropertyItem> properties = !components.isEmpty() ? NlProperties.getInstance().getProperties(this, components) : ImmutableTable.of();
            UIUtil.invokeLaterIfNeeded(() -> {
                if (components == null) {
                    NlPropertiesManager.$$$reportNull$$$0(42);
                }
                if (this.myProject.isDisposed()) {
                    return;
                }
                this.getPropertiesPanel().setItems(components, properties, this);
                if (postUpdateRunnable != null) {
                    this.myLoading = false;
                    postUpdateRunnable.run();
                }
            });
        });
    }

    @NotNull
    public PropertiesMap getDefaultProperties(@NotNull List<NlComponent> components) {
        if (components == null) {
            NlPropertiesManager.$$$reportNull$$$0(18);
        }
        if (components.isEmpty()) {
            PropertiesMap propertiesMap = PropertiesMap.EMPTY_MAP;
            if (propertiesMap == null) {
                NlPropertiesManager.$$$reportNull$$$0(19);
            }
            return propertiesMap;
        }
        if (this.mySurface == null) {
            PropertiesMap propertiesMap = PropertiesMap.EMPTY_MAP;
            if (propertiesMap == null) {
                NlPropertiesManager.$$$reportNull$$$0(20);
            }
            return propertiesMap;
        }
        SceneView view = this.mySurface.getCurrentSceneView();
        if (view == null) {
            PropertiesMap propertiesMap = PropertiesMap.EMPTY_MAP;
            if (propertiesMap == null) {
                NlPropertiesManager.$$$reportNull$$$0(21);
            }
            return propertiesMap;
        }
        Map<Object, PropertiesMap> map = view.getSceneManager().getDefaultProperties();
        ArrayList<PropertiesMap> propertiesMaps = new ArrayList<PropertiesMap>(components.size());
        for (NlComponent component2 : components) {
            PropertiesMap propertiesMap = map.get(component2.getSnapshot());
            if (propertiesMap == null) {
                PropertiesMap propertiesMap2 = PropertiesMap.EMPTY_MAP;
                if (propertiesMap2 == null) {
                    NlPropertiesManager.$$$reportNull$$$0(22);
                }
                return propertiesMap2;
            }
            propertiesMaps.add(propertiesMap);
        }
        PropertiesMap first = (PropertiesMap)propertiesMaps.get(0);
        if (propertiesMaps.size() == 1) {
            PropertiesMap propertiesMap = first;
            if (propertiesMap == null) {
                NlPropertiesManager.$$$reportNull$$$0(23);
            }
            return propertiesMap;
        }
        PropertiesMap commonProperties = new PropertiesMap();
        for (Map.Entry property : first.entrySet()) {
            boolean include = true;
            for (int index = 1; index < propertiesMaps.size(); ++index) {
                PropertiesMap other = (PropertiesMap)propertiesMaps.get(index);
                if (((PropertiesMap.Property)property.getValue()).equals(other.get(property.getKey()))) continue;
                include = false;
                break;
            }
            if (!include) continue;
            commonProperties.put(property.getKey(), property.getValue());
        }
        PropertiesMap propertiesMap = commonProperties;
        if (propertiesMap == null) {
            NlPropertiesManager.$$$reportNull$$$0(24);
        }
        return propertiesMap;
    }

    public void setValue(@NotNull NlProperty property, @Nullable String value) {
        if (property == null) {
            NlPropertiesManager.$$$reportNull$$$0(25);
        }
        property.setValue(value);
    }

    public void updateSelection() {
        if (this.mySurface == null || this.mySceneView == null) {
            return;
        }
        ImmutableList<NlComponent> selection = this.mySceneView.getModel().getSelectionModel().getSelection();
        this.componentSelectionChanged(this.mySurface, (List<NlComponent>)selection);
        ++this.myUpdateCount;
    }

    int getUpdateCount() {
        return this.myUpdateCount;
    }

    public void propertyChanged(@NotNull NlProperty property, @Nullable String oldValue, @Nullable String newValue) {
        if (property == null) {
            NlPropertiesManager.$$$reportNull$$$0(26);
        }
        if (property.getComponents().size() == 1 && "merge".equals(property.getComponents().get(0).getTagName()) && "http://schemas.android.com/tools".equals(property.getNamespace()) && "parentTag".equals(property.getName())) {
            this.updateSelection();
            return;
        }
        if (PropertiesComponent.getInstance().getBoolean("NlXmlPropertyEditor") && (NlPropertyItem.isReference(oldValue) || NlPropertyItem.isReference(newValue))) {
            this.updateSelection();
        }
    }

    public void starStateChanged() {
        this.updateSelection();
    }

    public void resourceChanged(@NotNull ResourceItem item, @Nullable String oldValue, @Nullable String newValue) {
        if (item == null) {
            NlPropertiesManager.$$$reportNull$$$0(27);
        }
        if (PropertiesComponent.getInstance().getBoolean("NlXmlPropertyEditor") && (NlPropertyItem.isReference(oldValue) || NlPropertyItem.isReference(newValue))) {
            this.updateSelection();
        }
    }

    public void logPropertyChange(@NotNull NlProperty property) {
        if (property == null) {
            NlPropertiesManager.$$$reportNull$$$0(28);
        }
        NlUsageTrackerManager.getInstance(this.mySurface).logPropertyChange(property, this.getPropertiesPanel().getPropertiesViewMode(), this.getPropertiesPanel().getFilterMatchCount());
    }

    public void logFavoritesChange(@NotNull String added, @NotNull String removed, @NotNull List<String> favorites) {
        if (added == null) {
            NlPropertiesManager.$$$reportNull$$$0(29);
        }
        if (removed == null) {
            NlPropertiesManager.$$$reportNull$$$0(30);
        }
        if (favorites == null) {
            NlPropertiesManager.$$$reportNull$$$0(31);
        }
        if (this.mySceneView == null) {
            return;
        }
        NlUsageTrackerManager.getInstance(this.mySurface).logFavoritesChange(added, removed, favorites, this.mySceneView.getModel().getFacet());
    }

    @Override
    public void componentSelectionChanged(@NotNull DesignSurface surface, final @NotNull List<NlComponent> newSelection) {
        if (surface == null) {
            NlPropertiesManager.$$$reportNull$$$0(32);
        }
        if (newSelection == null) {
            NlPropertiesManager.$$$reportNull$$$0(33);
        }
        if (surface != this.mySurface) {
            return;
        }
        if (!newSelection.isEmpty() && this.myFirstLoad) {
            this.myFirstLoad = false;
            this.getLoadingPanel().startLoading();
        }
        ComponentAssistant assistant = this.getComponentAssistant();
        assistant.componentSelectionChanged(surface, (List<? extends NlComponent>)newSelection);
        this.getContentPanel().setSecondComponent((JComponent)(assistant.isVisible() ? assistant : null));
        this.myLoading = true;
        MergingUpdateQueue queue = this.getUpdateQueue();
        queue.queue(new Update("updateProperties"){

            public void run() {
                NlPropertiesManager.this.setSelectedComponents(newSelection, () -> ((JBLoadingPanel)NlPropertiesManager.this.getLoadingPanel()).stopLoading());
            }

            public boolean canEat(Update update) {
                return true;
            }
        });
    }

    @Override
    public void sceneChanged(@NotNull DesignSurface surface, @Nullable SceneView sceneView) {
        if (surface == null) {
            NlPropertiesManager.$$$reportNull$$$0(34);
        }
        this.getComponentAssistant().sceneChanged(surface, sceneView);
    }

    @Override
    public void modelChanged(@NotNull DesignSurface surface, @Nullable NlModel model) {
        if (surface == null) {
            NlPropertiesManager.$$$reportNull$$$0(35);
        }
        this.getComponentAssistant().modelChanged(surface, model);
    }

    @Override
    public void modelChangedOnLayout(@NotNull NlModel model, boolean animate) {
        if (model == null) {
            NlPropertiesManager.$$$reportNull$$$0(36);
        }
    }

    @Override
    public boolean activatePreferredEditor(@NotNull DesignSurface surface, @NotNull NlComponent component2) {
        String propertyName;
        if (surface == null) {
            NlPropertiesManager.$$$reportNull$$$0(37);
        }
        if (component2 == null) {
            NlPropertiesManager.$$$reportNull$$$0(38);
        }
        this.getComponentAssistant().activatePreferredEditor(surface, component2);
        ViewHandler handler = NlComponentHelperKt.getViewHandler(component2);
        String string = propertyName = handler != null ? handler.getPreferredProperty() : null;
        if (propertyName == null) {
            return false;
        }
        this.getPropertiesPanel().activatePreferredEditor(propertyName, this.myLoading);
        return true;
    }

    @Override
    public void modelRendered(@NotNull NlModel model) {
        if (model == null) {
            NlPropertiesManager.$$$reportNull$$$0(39);
        }
        this.getPropertiesPanel().modelRendered(this);
    }

    @Override
    public void modelChanged(@NotNull NlModel model) {
        if (model == null) {
            NlPropertiesManager.$$$reportNull$$$0(40);
        }
        this.getPropertiesPanel().modelRendered(this);
    }

    public void dispose() {
        this.setToolContext(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restoreToolWindowCallback";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/property/NlPropertiesManager";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 17: 
            case 18: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 25: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "added";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "removed";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "favorites";
                break;
            }
            case 32: 
            case 34: 
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSelection";
                break;
            }
            case 36: 
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/property/NlPropertiesManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadingPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertiesPanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentAssistant";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentPanel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFocusedComponent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getGearActions";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalActions";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterKeyListener";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacet";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyEditors";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspector";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpdateQueue";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setRestoreToolWindow";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setFilter";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedComponents";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultProperties";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "setValue";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "propertyChanged";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "resourceChanged";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "logPropertyChange";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "logFavoritesChange";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "componentSelectionChanged";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "sceneChanged";
                break;
            }
            case 35: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "modelChanged";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "modelChangedOnLayout";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "activatePreferredEditor";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "modelRendered";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "lambda$setSelectedComponents$1";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

