/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.inspector;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.property.NlProperties;
import com.android.tools.idea.uibuilder.property.NlPropertiesManager;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.editors.NlComponentEditor;
import com.android.tools.idea.uibuilder.property.inspector.InspectorComponent;
import com.android.tools.idea.uibuilder.property.inspector.InspectorPanel;
import com.android.tools.idea.uibuilder.property.inspector.InspectorProvider;
import icons.AndroidIcons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FavoritesInspectorProvider
implements InspectorProvider {
    private final List<String> myStarredPropertyNames = new ArrayList<String>();
    private FavoritesInspectorComponent myInspectorComponent;
    private String myLastStarredPropertyListValue;

    @Override
    public boolean isApplicable(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
        if (components == null) {
            FavoritesInspectorProvider.$$$reportNull$$$0(0);
        }
        if (properties == null) {
            FavoritesInspectorProvider.$$$reportNull$$$0(1);
        }
        if (propertiesManager == null) {
            FavoritesInspectorProvider.$$$reportNull$$$0(2);
        }
        this.loadStarredPropertiesIfNeeded();
        for (String propertyName : this.myStarredPropertyNames) {
            if (!properties.containsKey(FavoritesInspectorProvider.removePropertyPrefix(propertyName))) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public InspectorComponent createCustomInspector(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
        if (components == null) {
            FavoritesInspectorProvider.$$$reportNull$$$0(3);
        }
        if (properties == null) {
            FavoritesInspectorProvider.$$$reportNull$$$0(4);
        }
        if (propertiesManager == null) {
            FavoritesInspectorProvider.$$$reportNull$$$0(5);
        }
        if (this.myInspectorComponent == null) {
            this.myInspectorComponent = new FavoritesInspectorComponent(this.myStarredPropertyNames);
        }
        this.myInspectorComponent.updateProperties(components, properties, propertiesManager);
        FavoritesInspectorComponent favoritesInspectorComponent = this.myInspectorComponent;
        if (favoritesInspectorComponent == null) {
            FavoritesInspectorProvider.$$$reportNull$$$0(6);
        }
        return favoritesInspectorComponent;
    }

    @Override
    public void resetCache() {
        this.myLastStarredPropertyListValue = null;
        this.myStarredPropertyNames.clear();
        this.myInspectorComponent = null;
    }

    private void loadStarredPropertiesIfNeeded() {
        if (!Objects.equals(this.myLastStarredPropertyListValue, NlProperties.getStarredPropertiesAsString())) {
            this.loadStarredProperties();
        }
    }

    private void loadStarredProperties() {
        this.myLastStarredPropertyListValue = NlProperties.getStarredPropertiesAsString();
        this.myStarredPropertyNames.clear();
        for (String propertyName : NlProperties.getStarredProperties()) {
            if (!propertyName.startsWith("tools:")) {
                propertyName = FavoritesInspectorProvider.removePropertyPrefix(propertyName);
            }
            this.myStarredPropertyNames.add(propertyName);
        }
        Collections.sort(this.myStarredPropertyNames);
    }

    @NotNull
    private static String removePropertyPrefix(@NotNull String propertyName) {
        if (propertyName == null) {
            FavoritesInspectorProvider.$$$reportNull$$$0(7);
        }
        String string = propertyName.substring(propertyName.indexOf(58) + 1);
        if (string == null) {
            FavoritesInspectorProvider.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertiesManager";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/property/inspector/FavoritesInspectorProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/property/inspector/FavoritesInspectorProvider";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createCustomInspector";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "removePropertyPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createCustomInspector";
                break;
            }
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyPrefix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FavoritesInspectorComponent
    implements InspectorComponent {
        private final List<String> myStarredPropertyNames;
        private final Map<String, NlComponentEditor> myEditorMap;

        private FavoritesInspectorComponent(@NotNull List<String> starredPropertyNames) {
            if (starredPropertyNames == null) {
                FavoritesInspectorComponent.$$$reportNull$$$0(0);
            }
            this.myStarredPropertyNames = starredPropertyNames;
            this.myEditorMap = new HashMap<String, NlComponentEditor>(starredPropertyNames.size());
        }

        @Override
        public void updateProperties(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
            if (components == null) {
                FavoritesInspectorComponent.$$$reportNull$$$0(1);
            }
            if (properties == null) {
                FavoritesInspectorComponent.$$$reportNull$$$0(2);
            }
            if (propertiesManager == null) {
                FavoritesInspectorComponent.$$$reportNull$$$0(3);
            }
            this.myEditorMap.clear();
            for (String propertyName : this.myStarredPropertyNames) {
                NlProperty property = FavoritesInspectorComponent.findProperty(propertyName, properties);
                NlComponentEditor editor = this.myEditorMap.get(propertyName);
                if (property == null) {
                    if (editor == null) continue;
                    this.myEditorMap.remove(propertyName);
                    continue;
                }
                if (editor == null) {
                    editor = propertiesManager.getPropertyEditors().create(property);
                    this.myEditorMap.put(propertyName, editor);
                }
                editor.setProperty(property);
            }
        }

        @Nullable
        private static NlProperty findProperty(@NotNull String propertyName, @NotNull Map<String, NlProperty> properties) {
            if (propertyName == null) {
                FavoritesInspectorComponent.$$$reportNull$$$0(4);
            }
            if (properties == null) {
                FavoritesInspectorComponent.$$$reportNull$$$0(5);
            }
            boolean designPropertyRequired = propertyName.startsWith("tools:");
            NlProperty property = properties.get(propertyName = FavoritesInspectorProvider.removePropertyPrefix(propertyName));
            if (property == null) {
                return null;
            }
            if (designPropertyRequired) {
                property = property.getDesignTimeProperty();
            }
            return property;
        }

        @Override
        public int getMaxNumberOfRows() {
            return 1 + this.myStarredPropertyNames.size();
        }

        @Override
        public void attachToInspector(@NotNull InspectorPanel inspector) {
            if (inspector == null) {
                FavoritesInspectorComponent.$$$reportNull$$$0(6);
            }
            inspector.addTitle("Favorite Attributes");
            for (String propertyName : this.myStarredPropertyNames) {
                NlComponentEditor editor = this.myEditorMap.get(propertyName);
                if (editor == null) continue;
                NlProperty property = editor.getProperty();
                JLabel label = inspector.addComponent(property.getName(), property.getTooltipText(), editor.getComponent());
                if ("http://schemas.android.com/tools".equals(property.getNamespace())) {
                    label.setIcon(AndroidIcons.NeleIcons.DesignProperty);
                }
                editor.setLabel(label);
            }
        }

        @Override
        public void refresh() {
            for (String propertyName : this.myStarredPropertyNames) {
                NlComponentEditor editor = this.myEditorMap.get(propertyName);
                if (editor == null) continue;
                editor.refresh();
            }
        }

        @Override
        @NotNull
        public List<NlComponentEditor> getEditors() {
            ArrayList<NlComponentEditor> editors = new ArrayList<NlComponentEditor>(this.myStarredPropertyNames.size());
            for (String propertyName : this.myStarredPropertyNames) {
                NlComponentEditor editor = this.myEditorMap.get(propertyName);
                if (editor == null) continue;
                editors.add(editor);
            }
            ArrayList<NlComponentEditor> arrayList = editors;
            if (arrayList == null) {
                FavoritesInspectorComponent.$$$reportNull$$$0(7);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "starredPropertyNames";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "components";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "properties";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "propertiesManager";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "propertyName";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inspector";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/uibuilder/property/inspector/FavoritesInspectorProvider$FavoritesInspectorComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/uibuilder/property/inspector/FavoritesInspectorProvider$FavoritesInspectorComponent";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEditors";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "updateProperties";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "findProperty";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "attachToInspector";
                    break;
                }
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

