/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.State;
import com.android.tools.idea.common.model.ModelListener;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.DesignSurfaceListener;
import com.android.tools.idea.common.surface.PanZoomListener;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.android.tools.sherpa.drawing.BlueprintColorSet;
import com.android.tools.sherpa.drawing.ColorSet;
import com.google.common.collect.ImmutableList;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.ui.popup.IconButton;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.ui.AncestorListenerAdapter;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.AdjustmentEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PanZoomPanel
extends JPanel
implements DesignSurfaceListener,
PanZoomListener,
ModelListener,
JBPopupListener {
    public static final String PROP_X_POS = "ANDROID.PANZOOM_X_POS";
    public static final String PROP_Y_POS = "ANDROID.PANZOOM_Y_POS";
    public static final String PROP_OPEN = "ANDROID.PANZOOM_OPENED";
    public static final String TITLE = "Pan and Zoom";
    public static final String HINT = "(Scroll to Zoom)";
    private static final IconButton CANCEL_BUTTON = new IconButton("Close", AllIcons.Actions.Close, AllIcons.Actions.CloseHovered);
    private static final int SCREEN_SPACE = 10;
    private static final Dimension PREFERRED_SIZE = new Dimension(250, 216);
    private static final BlueprintColorSet BLUEPRINT_COLOR_SET = new BlueprintColorSet();
    private static final JBColor DRAWING_SURFACE_RECTANGLE_COLOR = JBColor.red;
    private static final JBColor OVERLAY_COLOR = new JBColor(new Color(232, 232, 232, 127), new Color(80, 80, 80, 127));
    private static final JBColor NORMAL_SCREEN_VIEW_COLOR = new JBColor((Color)Gray._255, (Color)Gray._240);
    private static final Color BLUEPRINT_SCREEN_VIEW_COLOR = BLUEPRINT_COLOR_SET.getBackground();
    private static final Color COMPONENT_STROKE_COLOR = BLUEPRINT_COLOR_SET.getFrames();
    private static final Color BACKGROUND_COLOR = BLUEPRINT_COLOR_SET.getBackground();
    private final Point myDesignSurfaceOffset;
    private final Point mySecondScreenOffset;
    private final AncestorListenerAdapter myAncestorListener;
    private final Point myCenterOffset;
    private final Point myRelativeLocation;
    private final ColorSet myColorSet;
    private final MiniMap myMiniMap;
    @Nullable
    private NlDesignSurface myDesignSurface;
    @Nullable
    private NlComponent myComponent;
    @Nullable
    private JBPopup myContainerPopup;
    @Nullable
    private Dimension myCurrentSceneViewSize;
    @Nullable
    private Dimension myDesignSurfaceSize;
    @Nullable
    private Dimension myDeviceSize;
    @Nullable
    private ComponentListener myApplicationComponentAdapter;
    @Nullable
    private ComponentListener myPopupComponentAdapter;
    private boolean myIsZoomed;
    private double mySceneViewScale;
    private double myDeviceScale;
    private int myYScreenNumber;
    private int myXScreenNumber;
    private int myScaledScreenSpace;

    public PanZoomPanel(@NotNull NlDesignSurface surface) {
        if (surface == null) {
            PanZoomPanel.$$$reportNull$$$0(0);
        }
        super(new BorderLayout());
        this.myRelativeLocation = new Point();
        this.myDesignSurfaceOffset = new Point();
        this.mySecondScreenOffset = new Point();
        this.myCenterOffset = new Point();
        this.myMiniMap = new MiniMap();
        this.myAncestorListener = new MyAncestorListenerAdapter();
        this.myColorSet = BLUEPRINT_COLOR_SET;
        this.setPreferredSize(PREFERRED_SIZE);
        this.setOpaque(true);
        this.setSurface(surface);
        this.updateComponents(null);
        this.add((Component)this.myMiniMap, "Center");
        MouseInteractionListener listener = new MouseInteractionListener();
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
        this.addMouseWheelListener(listener);
        this.configureUI();
    }

    public void configureUI() {
        if (this.myDesignSurface == null) {
            return;
        }
        this.computeScale(this.myDesignSurface.getCurrentSceneView(), this.myDesignSurface.getSize(), this.myDesignSurface.getContentSize(null));
        if (this.myDeviceSize != null) {
            this.computeOffsets(this.myDeviceSize, this.myDesignSurface.getCurrentSceneView());
        }
    }

    public void updateComponents(@Nullable List<NlComponent> selectedComponents) {
        ScreenView currentSceneView;
        if (selectedComponents != null && !selectedComponents.isEmpty()) {
            this.myComponent = selectedComponents.get(0);
        } else if (this.myComponent != null) {
            this.myComponent = this.myComponent.getRoot();
        } else if (this.myDesignSurface != null && (currentSceneView = this.myDesignSurface.getCurrentSceneView()) != null) {
            ImmutableList<NlComponent> components = currentSceneView.getModel().getComponents();
            this.myComponent = !components.isEmpty() ? (NlComponent)components.get(0) : null;
        }
        this.myMiniMap.repaint();
    }

    @Override
    public void componentSelectionChanged(@NotNull DesignSurface surface, @NotNull List<NlComponent> selectedComponents) {
        if (surface == null) {
            PanZoomPanel.$$$reportNull$$$0(1);
        }
        if (selectedComponents == null) {
            PanZoomPanel.$$$reportNull$$$0(2);
        }
        this.updateComponents(selectedComponents);
        this.configureUI();
    }

    @Override
    public void sceneChanged(@NotNull DesignSurface surface, @Nullable SceneView sceneView) {
        if (surface == null) {
            PanZoomPanel.$$$reportNull$$$0(3);
        }
        assert (surface instanceof NlDesignSurface);
        this.setSurface((NlDesignSurface)surface);
        assert (this.myDesignSurface != null);
        this.computeOffsets(this.myDeviceSize, this.myDesignSurface.getCurrentSceneView());
        this.myMiniMap.repaint();
    }

    @Override
    public void modelChanged(@NotNull DesignSurface surface, @Nullable NlModel model) {
        if (surface == null) {
            PanZoomPanel.$$$reportNull$$$0(4);
        }
        assert (surface instanceof NlDesignSurface);
        this.setSurface((NlDesignSurface)surface);
        if (model != null) {
            model.addListener(this);
        }
        this.computeOffsets(this.myDeviceSize, surface.getCurrentSceneView());
        if (model != null) {
            ImmutableList<NlComponent> selection = model.getSelectionModel().getSelection();
            if (selection.isEmpty()) {
                selection = model.getComponents();
            }
            this.updateComponents((List<NlComponent>)selection);
        }
        this.configureUI();
        this.myMiniMap.repaint();
    }

    @Override
    public void modelChangedOnLayout(@NotNull NlModel model, boolean animate) {
        if (model == null) {
            PanZoomPanel.$$$reportNull$$$0(5);
        }
    }

    @Override
    public boolean activatePreferredEditor(@NotNull DesignSurface surface, @NotNull NlComponent component2) {
        if (surface == null) {
            PanZoomPanel.$$$reportNull$$$0(6);
        }
        if (component2 == null) {
            PanZoomPanel.$$$reportNull$$$0(7);
        }
        return false;
    }

    @Override
    public void modelDerivedDataChanged(@NotNull NlModel model) {
        if (model == null) {
            PanZoomPanel.$$$reportNull$$$0(8);
        }
        if (this.myDesignSurface != null) {
            this.updateDeviceConfiguration(this.myDesignSurface.getConfiguration());
            this.updateComponents((List<NlComponent>)model.getComponents());
            this.updateScreenNumber(this.myDesignSurface);
            this.myMiniMap.repaint();
        }
    }

    @Override
    public void modelRendered(@NotNull NlModel model) {
        if (model == null) {
            PanZoomPanel.$$$reportNull$$$0(9);
        }
    }

    @Override
    public void zoomChanged(DesignSurface designSurface) {
        assert (designSurface instanceof NlDesignSurface);
        this.setSurface((NlDesignSurface)designSurface);
        this.myMiniMap.repaint();
    }

    @Override
    public void panningChanged(AdjustmentEvent adjustmentEvent) {
        if (this.myDesignSurface == null) {
            return;
        }
        Point scrollPosition = this.myDesignSurface.getScrollPosition();
        ScreenView currentSceneView = this.myDesignSurface.getCurrentSceneView();
        if (currentSceneView != null) {
            this.myDesignSurfaceSize = this.myDesignSurface.getSize(this.myDesignSurfaceSize);
            Dimension contentSize = this.myDesignSurface.getContentSize(null);
            if (this.myDesignSurfaceSize != null) {
                this.computeScale(currentSceneView, this.myDesignSurfaceSize, contentSize);
            }
        }
        this.myDesignSurfaceOffset.setLocation(scrollPosition.getX() * this.mySceneViewScale, scrollPosition.getY() * this.mySceneViewScale);
        this.repaint();
    }

    public void beforeShown(LightweightWindowEvent event) {
        if (this.myDesignSurface == null) {
            return;
        }
        this.myContainerPopup = event.asPopup();
        this.registerPopupWindowComponentAdapter(this.myContainerPopup, this.myDesignSurface, this.myRelativeLocation);
        this.registerApplicationWindowComponentAdapter(this.myDesignSurface, this.myContainerPopup, this.myRelativeLocation);
        PropertiesComponent.getInstance().setValue(PROP_OPEN, true);
    }

    public void onClosed(LightweightWindowEvent event) {
        if (this.myContainerPopup != null) {
            this.myContainerPopup.removeListener((JBPopupListener)this);
            UIUtil.getWindow((Component)this.myContainerPopup.getContent()).removeComponentListener(this.myPopupComponentAdapter);
            this.myContainerPopup = null;
        }
        if (this.myDesignSurface != null) {
            UIUtil.getWindow((Component)this.myDesignSurface).removeComponentListener(this.myApplicationComponentAdapter);
        }
        if (!event.isOk()) {
            PropertiesComponent.getInstance().setValue(PROP_OPEN, false);
        }
    }

    @Override
    public boolean isVisible() {
        return this.myContainerPopup != null && this.myContainerPopup.isVisible() && super.isVisible();
    }

    public void setSurface(@Nullable NlDesignSurface surface) {
        Configuration configuration;
        ScreenView currentSceneView;
        this.updateScreenNumber(surface);
        if (surface == this.myDesignSurface) {
            return;
        }
        if (this.myDesignSurface != null) {
            this.myDesignSurface.removeListener(this);
            this.myDesignSurface.removePanZoomListener(this);
            this.myDesignSurface.removeAncestorListener((AncestorListener)this.myAncestorListener);
            currentSceneView = this.myDesignSurface.getCurrentSceneView();
            if (currentSceneView != null) {
                currentSceneView.getModel().removeListener(this);
            }
        }
        this.myDesignSurface = surface;
        if (this.myDesignSurface == null) {
            return;
        }
        this.myDesignSurface.addListener(this);
        this.myDesignSurface.addPanZoomListener(this);
        this.myDesignSurface.addAncestorListener((AncestorListener)this.myAncestorListener);
        currentSceneView = this.myDesignSurface.getCurrentSceneView();
        if (currentSceneView != null) {
            currentSceneView.getModel().addListener(this);
        }
        if ((configuration = this.myDesignSurface.getConfiguration()) != null) {
            this.updateDeviceConfiguration(configuration);
        }
    }

    private void updateScreenNumber(@Nullable NlDesignSurface surface) {
        if (surface != null) {
            this.myXScreenNumber = !surface.isStackVertically() && surface.getScreenMode() == NlDesignSurface.ScreenMode.BOTH ? 2 : 1;
            this.myYScreenNumber = surface.isStackVertically() && surface.getScreenMode() == NlDesignSurface.ScreenMode.BOTH ? 2 : 1;
        }
    }

    private void updateDeviceConfiguration(Configuration configuration) {
        Device device = configuration.getDevice();
        State deviceState = configuration.getDeviceState();
        if (device != null && deviceState != null) {
            this.myDeviceSize = device.getScreenSize(deviceState.getOrientation());
        }
    }

    private void computeScale(@Nullable SceneView currentSceneView, @Nullable Dimension designSurfaceSize, @NotNull Dimension contentSize) {
        if (contentSize == null) {
            PanZoomPanel.$$$reportNull$$$0(10);
        }
        if (currentSceneView == null || this.myMiniMap == null || designSurfaceSize == null) {
            return;
        }
        this.myIsZoomed = designSurfaceSize.getWidth() < (double)currentSceneView.getX() + contentSize.getWidth() || designSurfaceSize.getHeight() < (double)currentSceneView.getY() + contentSize.getHeight();
        double surfaceScale = designSurfaceSize.height <= 0 || designSurfaceSize.width <= 0 ? 1.0 : Math.min((double)PanZoomPanel.PREFERRED_SIZE.height / designSurfaceSize.getHeight(), (double)PanZoomPanel.PREFERRED_SIZE.width / designSurfaceSize.getWidth());
        this.myScaledScreenSpace = (int)Math.round(10.0 * surfaceScale);
        this.mySceneViewScale = Math.min((double)PanZoomPanel.PREFERRED_SIZE.height / contentSize.getHeight(), (double)PanZoomPanel.PREFERRED_SIZE.width / contentSize.getWidth());
        if (this.myDeviceSize != null) {
            this.myDeviceScale = Math.min((double)PanZoomPanel.PREFERRED_SIZE.height / this.myDeviceSize.getHeight() / (double)this.myYScreenNumber, (double)PanZoomPanel.PREFERRED_SIZE.width / this.myDeviceSize.getWidth() / (double)this.myXScreenNumber);
            this.computeOffsets(this.myDeviceSize, currentSceneView);
        }
    }

    private void computeOffsets(@Nullable Dimension deviceSize, @Nullable SceneView currentSceneView) {
        if (this.myDesignSurface != null && currentSceneView != null && deviceSize != null) {
            this.myCurrentSceneViewSize = currentSceneView.getSize(this.myCurrentSceneViewSize);
            if (this.myDesignSurface.getScreenMode() == NlDesignSurface.ScreenMode.BOTH) {
                if (this.myDesignSurface.isStackVertically()) {
                    this.mySecondScreenOffset.setLocation(0.0, deviceSize.getHeight() * this.myDeviceScale + (double)this.myScaledScreenSpace);
                } else {
                    this.mySecondScreenOffset.setLocation(deviceSize.getWidth() * this.myDeviceScale + (double)this.myScaledScreenSpace, 0.0);
                }
            }
            this.myCenterOffset.x = (int)Math.round((PREFERRED_SIZE.getWidth() - (double)this.myXScreenNumber * deviceSize.getWidth() * this.myDeviceScale) / 2.0);
            this.myCenterOffset.y = (int)Math.round((PREFERRED_SIZE.getHeight() - (double)this.myYScreenNumber * deviceSize.getHeight() * this.myDeviceScale) / 2.0);
            this.mySecondScreenOffset.translate(this.myCenterOffset.x, this.myCenterOffset.y);
        }
    }

    @NotNull
    public JBPopup showPopup() {
        if (this.myContainerPopup != null && !this.myContainerPopup.isDisposed()) {
            JBPopup jBPopup = this.myContainerPopup;
            if (jBPopup == null) {
                PanZoomPanel.$$$reportNull$$$0(11);
            }
            return jBPopup;
        }
        JBPopup popup2 = this.createPopup();
        if (this.myDesignSurface == null) {
            JBPopup jBPopup = popup2;
            if (jBPopup == null) {
                PanZoomPanel.$$$reportNull$$$0(12);
            }
            return jBPopup;
        }
        PanZoomPanel.getSavedScreenLocation(this.myRelativeLocation);
        Point screenPosition = new Point(this.myRelativeLocation);
        SwingUtilities.convertPointToScreen(screenPosition, this.myDesignSurface);
        popup2.show(new RelativePoint((Component)this.myDesignSurface, this.myRelativeLocation));
        if (!ScreenUtil.isVisible((Point)popup2.getLocationOnScreen())) {
            PanZoomPanel.computeDefaultLocation(this.myRelativeLocation, this.myDesignSurface);
            PanZoomPanel.savePopupLocation(this.myRelativeLocation);
            screenPosition.setLocation(this.myRelativeLocation);
            SwingUtilities.convertPointToScreen(screenPosition, this.myDesignSurface);
            popup2.setLocation(screenPosition);
        }
        PropertiesComponent.getInstance().setValue(PROP_OPEN, true);
        JBPopup jBPopup = popup2;
        if (jBPopup == null) {
            PanZoomPanel.$$$reportNull$$$0(13);
        }
        return jBPopup;
    }

    private void registerPopupWindowComponentAdapter(@NotNull JBPopup popup2, Component popupOwner, Point relativePosition) {
        if (popup2 == null) {
            PanZoomPanel.$$$reportNull$$$0(14);
        }
        UIUtil.getWindow((Component)popup2.getContent()).addComponentListener(this.getPopupWindowListener(popupOwner, relativePosition));
    }

    private void registerApplicationWindowComponentAdapter(@NotNull Component popupOwner, @NotNull JBPopup containerPopup, @NotNull Point relativeLocation) {
        if (popupOwner == null) {
            PanZoomPanel.$$$reportNull$$$0(15);
        }
        if (containerPopup == null) {
            PanZoomPanel.$$$reportNull$$$0(16);
        }
        if (relativeLocation == null) {
            PanZoomPanel.$$$reportNull$$$0(17);
        }
        UIUtil.getWindow((Component)popupOwner).addComponentListener(this.getApplicationWindowListener(popupOwner, containerPopup, relativeLocation));
    }

    public void hidePopup() {
        if (this.myContainerPopup != null) {
            this.myContainerPopup.closeOk(null);
            this.myContainerPopup = null;
        }
    }

    public void closePopup() {
        if (this.myContainerPopup != null) {
            this.myContainerPopup.cancel();
            this.myContainerPopup = null;
        }
    }

    private static void computeDefaultLocation(@NotNull Point popupLocation, @NotNull DesignSurface surface) {
        if (popupLocation == null) {
            PanZoomPanel.$$$reportNull$$$0(18);
        }
        if (surface == null) {
            PanZoomPanel.$$$reportNull$$$0(19);
        }
        popupLocation.x = surface.getWidth() - PanZoomPanel.PREFERRED_SIZE.width - surface.getScrollPane().getVerticalScrollBar().getWidth();
        popupLocation.y = 20;
    }

    private static void getSavedScreenLocation(@NotNull Point popupLocation) {
        if (popupLocation == null) {
            PanZoomPanel.$$$reportNull$$$0(20);
        }
        popupLocation.x = PropertiesComponent.getInstance().getInt(PROP_X_POS, -1);
        popupLocation.y = PropertiesComponent.getInstance().getInt(PROP_Y_POS, -1);
    }

    @NotNull
    private ComponentListener getPopupWindowListener(@NotNull Component popupOwner, @NotNull Point relativePosition) {
        if (popupOwner == null) {
            PanZoomPanel.$$$reportNull$$$0(21);
        }
        if (relativePosition == null) {
            PanZoomPanel.$$$reportNull$$$0(22);
        }
        if (this.myPopupComponentAdapter == null) {
            this.myPopupComponentAdapter = new MyPopupWindowComponentAdapter(popupOwner, relativePosition);
        }
        ComponentListener componentListener = this.myPopupComponentAdapter;
        if (componentListener == null) {
            PanZoomPanel.$$$reportNull$$$0(23);
        }
        return componentListener;
    }

    @NotNull
    private ComponentListener getApplicationWindowListener(@NotNull Component popupOwner, @NotNull JBPopup containerPopup, @NotNull Point relativePosition) {
        if (popupOwner == null) {
            PanZoomPanel.$$$reportNull$$$0(24);
        }
        if (containerPopup == null) {
            PanZoomPanel.$$$reportNull$$$0(25);
        }
        if (relativePosition == null) {
            PanZoomPanel.$$$reportNull$$$0(26);
        }
        if (this.myApplicationComponentAdapter == null) {
            this.myApplicationComponentAdapter = new MyApplicationWindowComponentAdapter(popupOwner, containerPopup, relativePosition);
        }
        ComponentListener componentListener = this.myApplicationComponentAdapter;
        if (componentListener == null) {
            PanZoomPanel.$$$reportNull$$$0(27);
        }
        return componentListener;
    }

    private static void savePopupLocation(@NotNull Point screenLocation) {
        if (screenLocation == null) {
            PanZoomPanel.$$$reportNull$$$0(28);
        }
        PropertiesComponent.getInstance().setValue(PROP_X_POS, screenLocation.x, -1);
        PropertiesComponent.getInstance().setValue(PROP_Y_POS, screenLocation.y, -1);
    }

    @NotNull
    private JBPopup createPopup() {
        JBPopup jBPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)this, (JComponent)this).setTitle(TITLE).setMinSize(this.getSize()).setResizable(false).setMovable(true).setRequestFocus(true).setLocateWithinScreenBounds(false).setCancelButton(CANCEL_BUTTON).setShowBorder(true).setShowShadow(true).setCancelOnClickOutside(false).setCancelOnWindowDeactivation(false).setCancelOnOtherWindowOpen(true).addListener((JBPopupListener)this).createPopup();
        if (jBPopup == null) {
            PanZoomPanel.$$$reportNull$$$0(29);
        }
        return jBPopup;
    }

    public static boolean isPropertyComponentOpen() {
        return PropertiesComponent.getInstance().getBoolean(PROP_OPEN, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 23: 
            case 27: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 23: 
            case 27: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedComponents";
                break;
            }
            case 5: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentSize";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 23: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/surface/PanZoomPanel";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popup";
                break;
            }
            case 15: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupOwner";
                break;
            }
            case 16: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containerPopup";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativeLocation";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupLocation";
                break;
            }
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePosition";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "screenLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/surface/PanZoomPanel";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "showPopup";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getPopupWindowListener";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicationWindowListener";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "componentSelectionChanged";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "sceneChanged";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "modelChanged";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "modelChangedOnLayout";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "activatePreferredEditor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "modelDerivedDataChanged";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "modelRendered";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "computeScale";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 23: 
            case 27: 
            case 29: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "registerPopupWindowComponentAdapter";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "registerApplicationWindowComponentAdapter";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "computeDefaultLocation";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getSavedScreenLocation";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getPopupWindowListener";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getApplicationWindowListener";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "savePopupLocation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 23: 
            case 27: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyApplicationWindowComponentAdapter
    extends ComponentAdapter {
        private final Component myDesignSurface;
        private final JBPopup myContainerPopup;
        private final Point myRelativeLocation;
        private final Point myScreenLocation;

        public MyApplicationWindowComponentAdapter(@NotNull Component designSurface, @NotNull JBPopup containerPopup, @NotNull Point relativeLocation) {
            if (designSurface == null) {
                MyApplicationWindowComponentAdapter.$$$reportNull$$$0(0);
            }
            if (containerPopup == null) {
                MyApplicationWindowComponentAdapter.$$$reportNull$$$0(1);
            }
            if (relativeLocation == null) {
                MyApplicationWindowComponentAdapter.$$$reportNull$$$0(2);
            }
            this.myDesignSurface = designSurface;
            this.myContainerPopup = containerPopup;
            this.myRelativeLocation = relativeLocation;
            this.myScreenLocation = new Point();
        }

        @Override
        public void componentResized(ComponentEvent e) {
            this.repositionPopup();
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            this.repositionPopup();
        }

        private void repositionPopup() {
            this.myScreenLocation.setLocation(this.myRelativeLocation);
            SwingUtilities.convertPointToScreen(this.myScreenLocation, this.myDesignSurface);
            this.myContainerPopup.setLocation(this.myScreenLocation);
            this.myContainerPopup.setUiVisible(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "designSurface";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "containerPopup";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "relativeLocation";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/uibuilder/surface/PanZoomPanel$MyApplicationWindowComponentAdapter";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyPopupWindowComponentAdapter
    extends ComponentAdapter {
        private final Component myPopupOwner;
        private final Point myRelativePosition;

        public MyPopupWindowComponentAdapter(@NotNull Component popupOwner, @NotNull Point relativePosition) {
            if (popupOwner == null) {
                MyPopupWindowComponentAdapter.$$$reportNull$$$0(0);
            }
            if (relativePosition == null) {
                MyPopupWindowComponentAdapter.$$$reportNull$$$0(1);
            }
            this.myPopupOwner = popupOwner;
            this.myRelativePosition = relativePosition;
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            this.myRelativePosition.setLocation(e.getComponent().getLocation());
            SwingUtilities.convertPointFromScreen(this.myRelativePosition, this.myPopupOwner);
            PanZoomPanel.savePopupLocation(this.myRelativePosition);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "popupOwner";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "relativePosition";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/uibuilder/surface/PanZoomPanel$MyPopupWindowComponentAdapter";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MiniMap
    extends JPanel {
        private MiniMap() {
        }

        @Override
        public void paintComponent(Graphics g) {
            ScreenView currentSceneView;
            Graphics2D gc = (Graphics2D)g;
            gc.setBackground(UIUtil.getWindowColor());
            gc.clearRect(0, 0, this.getWidth(), this.getHeight());
            if (PanZoomPanel.this.myDesignSurface != null && (currentSceneView = PanZoomPanel.this.myDesignSurface.getCurrentSceneView()) != null) {
                PanZoomPanel.this.myDesignSurfaceSize = PanZoomPanel.this.myDesignSurface.getSize(PanZoomPanel.this.myDesignSurfaceSize);
                Dimension contentSize = PanZoomPanel.this.myDesignSurface.getContentSize(null);
                PanZoomPanel.this.computeScale(currentSceneView, PanZoomPanel.this.myDesignSurfaceSize, contentSize);
                gc.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                gc.setColor(BACKGROUND_COLOR);
                this.drawScreenViews(gc, currentSceneView);
                if (PanZoomPanel.this.myIsZoomed) {
                    this.drawDesignSurface(gc, currentSceneView);
                }
                gc.setColor(COMPONENT_STROKE_COLOR);
                if (PanZoomPanel.this.myComponent != null) {
                    this.drawAllComponents(gc, PanZoomPanel.this.myComponent.getRoot());
                }
            }
        }

        private void drawAllComponents(@NotNull Graphics2D gc, @NotNull NlComponent component2) {
            if (gc == null) {
                MiniMap.$$$reportNull$$$0(0);
            }
            if (component2 == null) {
                MiniMap.$$$reportNull$$$0(1);
            }
            Color color = gc.getColor();
            if (PanZoomPanel.this.myComponent != null && component2.getId() != null && component2.getId().equals(PanZoomPanel.this.myComponent.getId())) {
                gc.setColor(PanZoomPanel.this.myColorSet.getSelectedFrames());
            }
            this.drawComponent(gc, component2);
            gc.setColor(color);
            int childCount = component2.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                NlComponent child = component2.getChild(i);
                assert (child != null);
                this.drawAllComponents(gc, child);
            }
        }

        private void drawComponent(@NotNull Graphics2D gc, @NotNull NlComponent component2) {
            if (gc == null) {
                MiniMap.$$$reportNull$$$0(2);
            }
            if (component2 == null) {
                MiniMap.$$$reportNull$$$0(3);
            }
            double componentRatio = PanZoomPanel.this.myDeviceScale;
            gc.drawRect((int)Math.round((double)((PanZoomPanel)PanZoomPanel.this).myCenterOffset.x + (double)NlComponentHelperKt.getX(component2) * componentRatio), (int)Math.round((double)((PanZoomPanel)PanZoomPanel.this).myCenterOffset.y + (double)NlComponentHelperKt.getY(component2) * componentRatio), (int)Math.round((double)NlComponentHelperKt.getW(component2) * componentRatio), (int)Math.round((double)NlComponentHelperKt.getH(component2) * componentRatio));
            assert (PanZoomPanel.this.myDesignSurface != null);
            NlDesignSurface nlDesignSurface = PanZoomPanel.this.myDesignSurface;
            if (nlDesignSurface.getScreenMode() == NlDesignSurface.ScreenMode.BOTH) {
                gc.drawRect((int)Math.round((double)((PanZoomPanel)PanZoomPanel.this).mySecondScreenOffset.x + (double)NlComponentHelperKt.getX(component2) * componentRatio), (int)Math.round((double)((PanZoomPanel)PanZoomPanel.this).mySecondScreenOffset.y + (double)NlComponentHelperKt.getY(component2) * componentRatio), (int)Math.round((double)NlComponentHelperKt.getW(component2) * componentRatio), (int)Math.round((double)NlComponentHelperKt.getH(component2) * componentRatio));
            }
        }

        private void drawScreenViews(Graphics2D gc, @NotNull SceneView currentSceneView) {
            if (currentSceneView == null) {
                MiniMap.$$$reportNull$$$0(4);
            }
            if (PanZoomPanel.this.myDeviceSize == null) {
                return;
            }
            assert (PanZoomPanel.this.myDesignSurface != null);
            NlDesignSurface.ScreenMode screenMode = PanZoomPanel.this.myDesignSurface.getScreenMode();
            int scaledDeviceWidth = (int)Math.round(PanZoomPanel.this.myDeviceSize.getWidth() * PanZoomPanel.this.myDeviceScale);
            int scaledDeviceHeight = (int)Math.round(PanZoomPanel.this.myDeviceSize.getHeight() * PanZoomPanel.this.myDeviceScale);
            if (screenMode == NlDesignSurface.ScreenMode.SCREEN_ONLY) {
                this.drawNormalScreenView(gc, currentSceneView, ((PanZoomPanel)PanZoomPanel.this).myCenterOffset.x, ((PanZoomPanel)PanZoomPanel.this).myCenterOffset.y, scaledDeviceWidth, scaledDeviceHeight);
            } else if (screenMode == NlDesignSurface.ScreenMode.BLUEPRINT_ONLY) {
                this.drawBlueScreenView(gc, ((PanZoomPanel)PanZoomPanel.this).myCenterOffset.x, ((PanZoomPanel)PanZoomPanel.this).myCenterOffset.y, scaledDeviceWidth, scaledDeviceHeight);
            } else if (screenMode == NlDesignSurface.ScreenMode.BOTH) {
                this.drawNormalScreenView(gc, currentSceneView, ((PanZoomPanel)PanZoomPanel.this).myCenterOffset.x, ((PanZoomPanel)PanZoomPanel.this).myCenterOffset.y, scaledDeviceWidth, scaledDeviceHeight);
                this.drawBlueScreenView(gc, ((PanZoomPanel)PanZoomPanel.this).mySecondScreenOffset.x, ((PanZoomPanel)PanZoomPanel.this).mySecondScreenOffset.y, scaledDeviceWidth, scaledDeviceHeight);
            }
        }

        private void drawNormalScreenView(@NotNull Graphics2D gc, @NotNull SceneView currentSceneView, int x, int y, int scaledDeviceWidth, int scaledDeviceHeight) {
            if (gc == null) {
                MiniMap.$$$reportNull$$$0(5);
            }
            if (currentSceneView == null) {
                MiniMap.$$$reportNull$$$0(6);
            }
            gc.setColor((Color)NORMAL_SCREEN_VIEW_COLOR);
            gc.fillRect(x, y, scaledDeviceWidth, scaledDeviceHeight);
            this.drawRenderedImage(gc, currentSceneView, ((PanZoomPanel)PanZoomPanel.this).myCenterOffset.x, ((PanZoomPanel)PanZoomPanel.this).myCenterOffset.y, scaledDeviceWidth, scaledDeviceHeight);
        }

        private void drawBlueScreenView(Graphics2D gc, int x, int y, int scaledDeviceWidth, int scaledDeviceHeight) {
            gc.setColor(BLUEPRINT_SCREEN_VIEW_COLOR);
            gc.fillRect(x, y, scaledDeviceWidth, scaledDeviceHeight);
        }

        private void drawRenderedImage(@NotNull Graphics2D gc, @NotNull SceneView currentSceneView, int x, int y, int scaledDeviceWidth, int scaledDeviceHeight) {
            RenderResult renderResult;
            SceneManager builder;
            if (gc == null) {
                MiniMap.$$$reportNull$$$0(7);
            }
            if (currentSceneView == null) {
                MiniMap.$$$reportNull$$$0(8);
            }
            if ((builder = currentSceneView.getSceneManager()) instanceof LayoutlibSceneManager && (renderResult = ((LayoutlibSceneManager)builder).getRenderResult()) != null) {
                renderResult.getRenderedImage().drawImageTo(gc, x, y, scaledDeviceWidth, scaledDeviceHeight);
            }
        }

        private void drawDesignSurface(@NotNull Graphics2D gc, @NotNull SceneView currentSceneView) {
            if (gc == null) {
                MiniMap.$$$reportNull$$$0(9);
            }
            if (currentSceneView == null) {
                MiniMap.$$$reportNull$$$0(10);
            }
            if (PanZoomPanel.this.myDesignSurfaceSize == null) {
                return;
            }
            gc.setColor((Color)DRAWING_SURFACE_RECTANGLE_COLOR);
            int x = (int)Math.round((double)(((PanZoomPanel)PanZoomPanel.this).myCenterOffset.x + ((PanZoomPanel)PanZoomPanel.this).myDesignSurfaceOffset.x) - (double)currentSceneView.getX() / 2.0 * PanZoomPanel.this.mySceneViewScale);
            int y = (int)Math.round((double)(((PanZoomPanel)PanZoomPanel.this).myCenterOffset.y + ((PanZoomPanel)PanZoomPanel.this).myDesignSurfaceOffset.y) - (double)currentSceneView.getY() / 2.0 * PanZoomPanel.this.mySceneViewScale);
            int width = (int)Math.round((PanZoomPanel.this.myDesignSurfaceSize.getWidth() - (double)currentSceneView.getX() / 2.0) * PanZoomPanel.this.mySceneViewScale);
            int height = (int)Math.round((PanZoomPanel.this.myDesignSurfaceSize.getHeight() - (double)currentSceneView.getY() / 2.0) * PanZoomPanel.this.mySceneViewScale);
            Rectangle intersection = new Rectangle(x, y, width, height).intersection(this.getVisibleRect());
            x = intersection.x;
            y = intersection.y;
            width = intersection.width - 1;
            height = intersection.height - 1;
            gc.drawRect(x, y, width, height);
            if (PanZoomPanel.this.myDeviceSize == null) {
                return;
            }
            gc.setColor((Color)OVERLAY_COLOR);
            gc.fillRect(0, 0, x, this.getHeight());
            gc.fillRect(x, 0, width, y);
            gc.fillRect(x + width, 0, PREFERRED_SIZE.width, this.getHeight());
            gc.fillRect(x, y + height, width, (int)Math.round(Math.max(PanZoomPanel.this.myDeviceSize.getHeight() * PanZoomPanel.this.myDeviceScale * (double)PanZoomPanel.this.myYScreenNumber - (double)y - (double)height, PanZoomPanel.this.myDeviceSize.getWidth() * PanZoomPanel.this.myDeviceScale * (double)PanZoomPanel.this.myXScreenNumber - (double)y - (double)height)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gc";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 4: 
                case 6: 
                case 8: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "currentSceneView";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/surface/PanZoomPanel$MiniMap";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "drawAllComponents";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "drawComponent";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "drawScreenViews";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "drawNormalScreenView";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "drawRenderedImage";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "drawDesignSurface";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MouseInteractionListener
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener {
        private final Point myMouseOrigin = new Point(0, 0);
        private final Point mySurfaceOrigin = new Point(0, 0);
        private double myNewXOffset;
        private double myNewYOffset;
        private Dimension mySceneViewSize = new Dimension();
        private SceneView myCurrentSceneView;
        private boolean myCanDrag;

        private MouseInteractionListener() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.myCanDrag) {
                this.myNewXOffset = this.mySurfaceOrigin.x + e.getX() - this.myMouseOrigin.x;
                this.myNewYOffset = this.mySurfaceOrigin.y + e.getY() - this.myMouseOrigin.y;
                assert (PanZoomPanel.this.myDesignSurface != null);
                PanZoomPanel.this.myDesignSurface.setScrollPosition((int)Math.round(this.myNewXOffset / PanZoomPanel.this.mySceneViewScale), (int)Math.round(this.myNewYOffset / PanZoomPanel.this.mySceneViewScale));
            }
        }

        public boolean isInDesignSurfaceRectangle(MouseEvent e) {
            assert (PanZoomPanel.this.myDesignSurface != null);
            return e.getX() > ((PanZoomPanel)PanZoomPanel.this).myDesignSurfaceOffset.x + ((PanZoomPanel)PanZoomPanel.this).myCenterOffset.x && (double)e.getX() < (double)(((PanZoomPanel)PanZoomPanel.this).myDesignSurfaceOffset.x + ((PanZoomPanel)PanZoomPanel.this).myCenterOffset.x) + (double)PanZoomPanel.this.myDesignSurface.getWidth() * PanZoomPanel.this.mySceneViewScale && e.getY() > ((PanZoomPanel)PanZoomPanel.this).myDesignSurfaceOffset.y + ((PanZoomPanel)PanZoomPanel.this).myCenterOffset.y && (double)e.getY() < (double)(((PanZoomPanel)PanZoomPanel.this).myDesignSurfaceOffset.y + ((PanZoomPanel)PanZoomPanel.this).myCenterOffset.y) + (double)PanZoomPanel.this.myDesignSurface.getHeight() * PanZoomPanel.this.mySceneViewScale;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (PanZoomPanel.this.myDesignSurface != null && this.isInDesignSurfaceRectangle(e)) {
                this.myCurrentSceneView = PanZoomPanel.this.myDesignSurface.getCurrentSceneView();
                if (this.myCurrentSceneView == null) {
                    return;
                }
                this.mySceneViewSize = this.myCurrentSceneView.getSize(this.mySceneViewSize);
                this.myMouseOrigin.setLocation(e.getX(), e.getY());
                this.mySurfaceOrigin.setLocation(((PanZoomPanel)PanZoomPanel.this).myDesignSurfaceOffset.x, ((PanZoomPanel)PanZoomPanel.this).myDesignSurfaceOffset.y);
                this.myCanDrag = true;
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.myCanDrag = false;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (this.isInDesignSurfaceRectangle(e) && PanZoomPanel.this.myIsZoomed) {
                PanZoomPanel.this.setCursor(Cursor.getPredefinedCursor(13));
            } else {
                PanZoomPanel.this.setCursor(Cursor.getDefaultCursor());
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            PanZoomPanel.this.setCursor(Cursor.getDefaultCursor());
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            block4: {
                int wheelRotation;
                block3: {
                    if (PanZoomPanel.this.myDesignSurface == null) {
                        return;
                    }
                    wheelRotation = e.getWheelRotation();
                    if (wheelRotation >= 0) break block3;
                    for (int i = 0; i > wheelRotation; --i) {
                        PanZoomPanel.this.myDesignSurface.zoomIn();
                    }
                    break block4;
                }
                if (wheelRotation <= 0) break block4;
                for (int i = 0; i < wheelRotation; ++i) {
                    PanZoomPanel.this.myDesignSurface.zoomOut();
                }
            }
        }
    }

    private class MyAncestorListenerAdapter
    extends AncestorListenerAdapter {
        private MyAncestorListenerAdapter() {
        }

        public void ancestorRemoved(AncestorEvent event) {
            super.ancestorRemoved(event);
            if (PanZoomPanel.this.myContainerPopup != null) {
                PanZoomPanel.this.hidePopup();
            }
        }
    }
}

