/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.databinding.DataBindingProjectComponent;
import com.android.tools.idea.lang.databinding.DataBindingCompletionUtil;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.XmlAttributeInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.HashSet;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.converters.DelimitedListConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.android.ClassMaps;
import org.jetbrains.android.dom.AndroidDomElementDescriptorProvider;
import org.jetbrains.android.dom.AndroidResourceDomFileDescription;
import org.jetbrains.android.dom.AttributeProcessingUtil;
import org.jetbrains.android.dom.animation.AndroidAnimationUtils;
import org.jetbrains.android.dom.animator.AndroidAnimatorUtil;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.dom.color.ColorDomFileDescription;
import org.jetbrains.android.dom.converters.FlagConverter;
import org.jetbrains.android.dom.drawable.AndroidDrawableDomUtil;
import org.jetbrains.android.dom.font.FontFamilyDomFileDescription;
import org.jetbrains.android.dom.layout.AndroidLayoutUtil;
import org.jetbrains.android.dom.layout.Data;
import org.jetbrains.android.dom.layout.DataBindingDomFileDescription;
import org.jetbrains.android.dom.layout.LayoutDomFileDescription;
import org.jetbrains.android.dom.layout.LayoutElement;
import org.jetbrains.android.dom.manifest.ManifestDomFileDescription;
import org.jetbrains.android.dom.raw.RawDomFileDescription;
import org.jetbrains.android.dom.transition.TransitionDomFileDescription;
import org.jetbrains.android.dom.transition.TransitionDomUtil;
import org.jetbrains.android.dom.xml.AndroidXmlResourcesUtil;
import org.jetbrains.android.dom.xml.PreferenceElement;
import org.jetbrains.android.dom.xml.XmlResourceDomFileDescription;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;

public class AndroidCompletionContributor
extends CompletionContributor {
    private static final String LAYOUT_ATTRIBUTE_PREFIX = "layout_";

    private static void addAll(Collection<String> collection, CompletionResultSet set) {
        for (String s : collection) {
            set.addElement((LookupElement)LookupElementBuilder.create((String)s));
        }
    }

    private static boolean completeTagNames(@NotNull AndroidFacet facet, @NotNull XmlFile xmlFile, @NotNull CompletionResultSet resultSet) {
        if (facet == null) {
            AndroidCompletionContributor.$$$reportNull$$$0(0);
        }
        if (xmlFile == null) {
            AndroidCompletionContributor.$$$reportNull$$$0(1);
        }
        if (resultSet == null) {
            AndroidCompletionContributor.$$$reportNull$$$0(2);
        }
        if (ManifestDomFileDescription.isManifestFile(xmlFile, facet)) {
            resultSet.addElement((LookupElement)LookupElementBuilder.create((String)"manifest"));
            return false;
        }
        if (LayoutDomFileDescription.isLayoutFile(xmlFile)) {
            Map<String, PsiClass> classMap = ClassMaps.getInstance(facet).getClassMap("android.view.View");
            for (String rootTag : AndroidLayoutUtil.getPossibleRoots(facet)) {
                LookupElementBuilder builder;
                PsiClass aClass = classMap.get(rootTag);
                if (aClass != null) {
                    String name;
                    builder = LookupElementBuilder.create((Object)aClass, (String)rootTag);
                    String qualifiedName = aClass.getQualifiedName();
                    String string = name = qualifiedName == null ? null : AndroidUtils.getUnqualifiedName(qualifiedName);
                    if (name != null) {
                        builder = builder.withLookupString(name);
                    }
                } else {
                    builder = LookupElementBuilder.create((String)rootTag);
                }
                Icon icon = AndroidDomElementDescriptorProvider.getIconForViewTag(rootTag);
                if (icon != null) {
                    builder = builder.withIcon(icon);
                }
                resultSet.addElement((LookupElement)builder);
            }
            return false;
        }
        if (AndroidResourceDomFileDescription.doIsMyFile(xmlFile, ResourceFolderType.ANIM)) {
            AndroidCompletionContributor.addAll(AndroidAnimationUtils.getPossibleRoots(), resultSet);
            return false;
        }
        if (AndroidResourceDomFileDescription.doIsMyFile(xmlFile, ResourceFolderType.ANIMATOR)) {
            AndroidCompletionContributor.addAll(AndroidAnimatorUtil.getPossibleRoots(), resultSet);
            return false;
        }
        if (XmlResourceDomFileDescription.isXmlResourceFile(xmlFile)) {
            AndroidCompletionContributor.addAll(AndroidXmlResourcesUtil.getPossibleRoots(facet), resultSet);
            return false;
        }
        if (AndroidDrawableDomUtil.isDrawableResourceFile(xmlFile)) {
            AndroidCompletionContributor.addAll(AndroidDrawableDomUtil.getPossibleRoots(facet), resultSet);
            return false;
        }
        if (TransitionDomFileDescription.isTransitionFile(xmlFile)) {
            AndroidCompletionContributor.addAll(TransitionDomUtil.getPossibleRoots(), resultSet);
            return false;
        }
        if (ColorDomFileDescription.isColorResourceFile(xmlFile)) {
            resultSet.addElement((LookupElement)LookupElementBuilder.create((String)"selector"));
            return false;
        }
        if (RawDomFileDescription.isRawFile(xmlFile)) {
            resultSet.addElement((LookupElement)LookupElementBuilder.create((String)"resources"));
            return false;
        }
        if (AndroidResourceDomFileDescription.doIsMyFile(xmlFile, ResourceFolderType.MIPMAP)) {
            AndroidCompletionContributor.addAll(AndroidDrawableDomUtil.getPossibleRoots(facet, ResourceFolderType.MIPMAP), resultSet);
            return false;
        }
        if (FontFamilyDomFileDescription.isFontFamilyFile(xmlFile)) {
            resultSet.addElement((LookupElement)LookupElementBuilder.create((String)"font-family"));
            return false;
        }
        return true;
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet resultSet) {
        PsiElement originalParent;
        if (parameters == null) {
            AndroidCompletionContributor.$$$reportNull$$$0(3);
        }
        if (resultSet == null) {
            AndroidCompletionContributor.$$$reportNull$$$0(4);
        }
        PsiElement position = parameters.getPosition();
        PsiElement originalPosition = parameters.getOriginalPosition();
        AndroidFacet facet = AndroidFacet.getInstance(position);
        if (facet == null) {
            return;
        }
        PsiElement parent = position.getParent();
        PsiElement psiElement = originalParent = originalPosition != null ? originalPosition.getParent() : null;
        if (parent instanceof XmlTag) {
            int refOffset;
            PsiElement element;
            XmlTag tag = (XmlTag)parent;
            if (tag.getParentTag() != null) {
                return;
            }
            ASTNode startTagName = XmlChildRole.START_TAG_NAME_FINDER.findChild(tag.getNode());
            if (startTagName == null || startTagName.getPsi() != position) {
                return;
            }
            PsiFile file = tag.getContainingFile();
            if (!(file instanceof XmlFile)) {
                return;
            }
            PsiReference reference = file.findReferenceAt(parameters.getOffset());
            if (reference != null && (element = reference.getElement()) != null && (refOffset = element.getTextRange().getStartOffset() + reference.getRangeInElement().getStartOffset()) != position.getTextRange().getStartOffset()) {
                return;
            }
            if (!AndroidCompletionContributor.completeTagNames(facet, (XmlFile)file, resultSet)) {
                resultSet.stopHere();
            }
        } else if (parent instanceof XmlAttribute) {
            ASTNode attrName = XmlChildRole.ATTRIBUTE_NAME_FINDER.findChild(parent.getNode());
            if (attrName == null || attrName.getPsi() != position) {
                return;
            }
            AndroidCompletionContributor.addAndroidPrefixElement(position, parent, resultSet);
            XmlAttribute attribute = (XmlAttribute)parent;
            String namespace = attribute.getNamespace();
            if ("http://schemas.android.com/tools".equals(namespace)) {
                AndroidCompletionContributor.addDesignTimeAttributes(attribute.getNamespacePrefix(), position, facet, attribute, resultSet);
            }
            AndroidCompletionContributor.addDataBindingAttributes(attribute.getNamespacePrefix(), position, facet, attribute, resultSet);
            AndroidCompletionContributor.customizeAddedAttributes(facet, parameters, attribute, resultSet);
        } else if (originalParent instanceof XmlAttributeValue) {
            AndroidCompletionContributor.completeTailsInFlagAttribute(parameters, resultSet, (XmlAttributeValue)originalParent);
            AndroidCompletionContributor.completeDataBindingTypeAttr(parameters, resultSet, (XmlAttributeValue)originalParent);
        }
    }

    private static void addDesignTimeAttributes(@NotNull String namespacePrefix, @NotNull PsiElement psiElement, @NotNull AndroidFacet facet, @NotNull XmlAttribute attribute, @NotNull CompletionResultSet resultSet) {
        if (namespacePrefix == null) {
            AndroidCompletionContributor.$$$reportNull$$$0(5);
        }
        if (psiElement == null) {
            AndroidCompletionContributor.$$$reportNull$$$0(6);
        }
        if (facet == null) {
            AndroidCompletionContributor.$$$reportNull$$$0(7);
        }
        if (attribute == null) {
            AndroidCompletionContributor.$$$reportNull$$$0(8);
        }
        if (resultSet == null) {
            AndroidCompletionContributor.$$$reportNull$$$0(9);
        }
        XmlTag tag = attribute.getParent();
        DomElement element = DomManager.getDomManager((Project)tag.getProject()).getDomElement(tag);
        HashSet registeredAttributes = new HashSet();
        if (element instanceof LayoutElement) {
            AttributeProcessingUtil.processLayoutAttributes(facet, tag, (LayoutElement)element, (Set<XmlName>)registeredAttributes, (xmlName, attrDef, parentStyleableName) -> {
                if (psiElement == null) {
                    AndroidCompletionContributor.$$$reportNull$$$0(18);
                }
                if (namespacePrefix == null) {
                    AndroidCompletionContributor.$$$reportNull$$$0(19);
                }
                if (resultSet == null) {
                    AndroidCompletionContributor.$$$reportNull$$$0(20);
                }
                if ("http://schemas.android.com/apk/res/android".equals(xmlName.getNamespaceKey())) {
                    String localName = xmlName.getLocalName();
                    LookupElementBuilder lookupElement = LookupElementBuilder.create((Object)psiElement, (String)localName).withInsertHandler((InsertHandler)XmlAttributeInsertHandler.INSTANCE).withPresentableText(namespacePrefix + ":" + localName);
                    resultSet.addElement((LookupElement)lookupElement);
                }
                return null;
            });
        }
    }

    private static void addAndroidPrefixElement(PsiElement position, PsiElement parent, CompletionResultSet resultSet) {
        if (position.getText().startsWith("android:")) {
            return;
        }
        PsiElement grandparent = parent.getParent();
        if (!(grandparent instanceof XmlTag)) {
            return;
        }
        DomElement element = DomManager.getDomManager((Project)grandparent.getProject()).getDomElement((XmlTag)grandparent);
        if (!(element instanceof LayoutElement) && !(element instanceof PreferenceElement)) {
            return;
        }
        String prefix = ((XmlTag)grandparent).getPrefixByNamespace("http://schemas.android.com/apk/res/android");
        if (prefix == null || prefix.length() < 3) {
            return;
        }
        LookupElementBuilder e = LookupElementBuilder.create((String)(prefix + ":")).withTypeText("[Namespace Prefix]", true);
        resultSet.addElement(PrioritizedLookupElement.withPriority((LookupElement)e, (double)Double.MAX_VALUE));
    }

    private static void customizeAddedAttributes(AndroidFacet facet, CompletionParameters parameters, XmlAttribute attribute, CompletionResultSet resultSet) {
        boolean localNameCompletion;
        XmlTag gp = attribute.getParent();
        if (gp == null) {
            return;
        }
        XmlTag tag = gp;
        DomElement element = DomManager.getDomManager((Project)gp.getProject()).getDomElement(tag);
        if (!(element instanceof LayoutElement)) {
            return;
        }
        if (attribute.getName().contains(":")) {
            String nsPrefix = attribute.getNamespacePrefix();
            if (nsPrefix.isEmpty()) {
                return;
            }
            if (!"http://schemas.android.com/apk/res/android".equals(tag.getNamespaceByPrefix(nsPrefix))) {
                return;
            }
            localNameCompletion = true;
        } else {
            localNameCompletion = false;
        }
        HashMap prefix2ns = new HashMap();
        resultSet.runRemainingContributors(parameters, result -> {
            LookupElement lookupElement = result.getLookupElement();
            Object obj = lookupElement.getObject();
            if (obj instanceof String) {
                String s = (String)obj;
                int index = s.indexOf(58);
                String attributeName = s.substring(index + 1);
                if (index > 0) {
                    String prefix = s.substring(0, index);
                    String ns = (String)prefix2ns.get(prefix);
                    if (ns == null) {
                        ns = tag.getNamespaceByPrefix(prefix);
                        prefix2ns.put(prefix, ns);
                    }
                    if ("http://schemas.android.com/apk/res/android".equals(ns)) {
                        boolean deprecated = AndroidCompletionContributor.isFrameworkAttributeDeprecated(facet, attribute, attributeName);
                        result = AndroidCompletionContributor.customizeLayoutAttributeLookupElement(lookupElement, result, attributeName, deprecated);
                    }
                } else if (localNameCompletion) {
                    result = AndroidCompletionContributor.customizeLayoutAttributeLookupElement(lookupElement, result, attributeName, false);
                }
            }
            resultSet.passResult(result);
        });
    }

    private static boolean isFrameworkAttributeDeprecated(AndroidFacet facet, XmlAttribute attribute, String attributeName) {
        ResourceManager manager = ModuleResourceManagers.getInstance(facet).getResourceManager("android", (PsiElement)attribute.getParent());
        if (manager == null) {
            return false;
        }
        AttributeDefinitions attributes = manager.getAttributeDefinitions();
        if (attributes == null) {
            return false;
        }
        AttributeDefinition attributeDefinition = attributes.getAttrDefByName(attributeName);
        return attributeDefinition != null && attributeDefinition.isAttributeDeprecated();
    }

    private static CompletionResult customizeLayoutAttributeLookupElement(LookupElement lookupElement, CompletionResult result, String localName, final boolean markDeprecated) {
        if (!localName.startsWith(LAYOUT_ATTRIBUTE_PREFIX)) {
            if (markDeprecated) {
                return result.withLookupElement(PrioritizedLookupElement.withPriority((LookupElement)new LookupElementDecorator<LookupElement>(lookupElement){

                    public void renderElement(LookupElementPresentation presentation) {
                        super.renderElement(presentation);
                        presentation.setStrikeout(true);
                    }
                }, (double)-1.0));
            }
            return result;
        }
        String localSuffix = localName.substring(LAYOUT_ATTRIBUTE_PREFIX.length());
        if (!localSuffix.isEmpty()) {
            final HashSet lookupStrings = new HashSet((Collection)lookupElement.getAllLookupStrings());
            lookupStrings.add((Object)localSuffix);
            lookupElement = new LookupElementDecorator<LookupElement>(lookupElement){

                public Set<String> getAllLookupStrings() {
                    return lookupStrings;
                }

                public void renderElement(LookupElementPresentation presentation) {
                    super.renderElement(presentation);
                    presentation.setStrikeout(markDeprecated);
                }
            };
        }
        return result.withLookupElement(PrioritizedLookupElement.withPriority((LookupElement)lookupElement, (double)100.0));
    }

    private static void addDataBindingAttributes(@NotNull String prefix, @NotNull PsiElement position, @NotNull AndroidFacet facet, @NotNull XmlAttribute attribute, @NotNull CompletionResultSet resultSet) {
        PsiFile containingFile;
        if (prefix == null) {
            AndroidCompletionContributor.$$$reportNull$$$0(10);
        }
        if (position == null) {
            AndroidCompletionContributor.$$$reportNull$$$0(11);
        }
        if (facet == null) {
            AndroidCompletionContributor.$$$reportNull$$$0(12);
        }
        if (attribute == null) {
            AndroidCompletionContributor.$$$reportNull$$$0(13);
        }
        if (resultSet == null) {
            AndroidCompletionContributor.$$$reportNull$$$0(14);
        }
        if (!((containingFile = attribute.getContainingFile()) instanceof XmlFile) || !DataBindingDomFileDescription.hasDataBindingRootTag((XmlFile)containingFile)) {
            return;
        }
        Module module = facet.getModule();
        DataBindingProjectComponent dataBindingComponent = (DataBindingProjectComponent)module.getProject().getComponent(DataBindingProjectComponent.class);
        if (dataBindingComponent == null) {
            return;
        }
        dataBindingComponent.getBindingAdapterAttributes(module).forEach(dataBindingAttribute -> {
            if (prefix == null) {
                AndroidCompletionContributor.$$$reportNull$$$0(15);
            }
            if (resultSet == null) {
                AndroidCompletionContributor.$$$reportNull$$$0(16);
            }
            if (position == null) {
                AndroidCompletionContributor.$$$reportNull$$$0(17);
            }
            if (!prefix.isEmpty()) {
                dataBindingAttribute = StringUtil.trimStart((String)dataBindingAttribute, (String)(prefix + ":"));
            }
            resultSet.addElement((LookupElement)LookupElementBuilder.create((Object)position, (String)dataBindingAttribute).withInsertHandler((InsertHandler)XmlAttributeInsertHandler.INSTANCE));
        });
    }

    private static void completeDataBindingTypeAttr(CompletionParameters parameters, CompletionResultSet resultSet, XmlAttributeValue originalParent) {
        PsiElement gp = originalParent.getParent();
        if (!(gp instanceof XmlAttribute)) {
            return;
        }
        GenericAttributeValue domElement = DomManager.getDomManager((Project)gp.getProject()).getDomElement((XmlAttribute)gp);
        if (domElement == null) {
            return;
        }
        if (DomUtil.getParentOfType((DomElement)domElement, Data.class, (boolean)true) != null && ((XmlAttribute)gp).getName().equals("type")) {
            DataBindingCompletionUtil.addCompletions(parameters, resultSet);
        }
    }

    private static void completeTailsInFlagAttribute(CompletionParameters parameters, CompletionResultSet resultSet, XmlAttributeValue parent) {
        String prefix;
        Set<String> valueSet;
        Converter converter;
        String currentValue = parent.getValue();
        if (currentValue == null || currentValue.isEmpty() || currentValue.endsWith("|")) {
            return;
        }
        PsiElement grandparent = parent.getParent();
        if (!(grandparent instanceof XmlAttribute)) {
            return;
        }
        GenericAttributeValue domValue = DomManager.getDomManager((Project)grandparent.getProject()).getDomElement((XmlAttribute)grandparent);
        Converter converter2 = converter = domValue != null ? domValue.getConverter() : null;
        if (!(converter instanceof FlagConverter)) {
            return;
        }
        TextRange valueRange = parent.getValueTextRange();
        if (valueRange != null && valueRange.getEndOffset() == parameters.getOffset() && !(valueSet = ((FlagConverter)converter).getValues()).isEmpty() && valueSet.contains(prefix = resultSet.getPrefixMatcher().getPrefix())) {
            ArrayList<String> filteredValues = new ArrayList<String>(valueSet);
            DelimitedListConverter.filterVariants(filteredValues, (GenericDomValue)domValue);
            for (String variant : filteredValues) {
                resultSet.addElement((LookupElement)LookupElementBuilder.create((String)(prefix + "|" + variant)));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlFile";
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 14: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSet";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 5: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespacePrefix";
                break;
            }
            case 6: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/android/AndroidCompletionContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "completeTagNames";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "fillCompletionVariants";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "addDesignTimeAttributes";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "addDataBindingAttributes";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$addDataBindingAttributes$2";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$addDesignTimeAttributes$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

