/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.android.dom.converters.OnClickConverter;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidImplicitUsagesProvider
implements ImplicitUsageProvider {
    public boolean isImplicitUsage(PsiElement element) {
        if (element instanceof PsiField) {
            return AndroidImplicitUsagesProvider.isImplicitFieldUsage((PsiField)element);
        }
        if (element instanceof PsiParameter) {
            return AndroidImplicitUsagesProvider.isImplicitParameterUsage((PsiParameter)element);
        }
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            if (method.isConstructor()) {
                return this.isImplicitConstructorUsage(method);
            }
            return this.isImplicitMethodUsage(method);
        }
        return false;
    }

    private static boolean isImplicitParameterUsage(@NotNull PsiParameter parameter) {
        if (parameter == null) {
            AndroidImplicitUsagesProvider.$$$reportNull$$$0(0);
        }
        if (AndroidFacet.getInstance((PsiElement)parameter) == null) {
            return false;
        }
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)parameter, PsiMethod.class);
        if (method == null || !OnClickConverter.CONVERTER_FOR_LAYOUT.checkSignature(method) && !OnClickConverter.CONVERTER_FOR_MENU.checkSignature(method)) {
            return false;
        }
        PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)method, PsiClass.class);
        if (aClass == null) {
            return false;
        }
        PsiClass activityBaseClass = JavaPsiFacade.getInstance((Project)aClass.getProject()).findClass("android.app.Activity", parameter.getResolveScope());
        if (activityBaseClass == null) {
            return false;
        }
        return aClass.isInheritor(activityBaseClass, true);
    }

    private static boolean isImplicitFieldUsage(@NotNull PsiField field) {
        if (field == null) {
            AndroidImplicitUsagesProvider.$$$reportNull$$$0(1);
        }
        if (!"CREATOR".equals(field.getName())) {
            return false;
        }
        PsiModifierList modifierList = field.getModifierList();
        if (modifierList == null || !modifierList.hasModifierProperty("static")) {
            return false;
        }
        PsiClass aClass = field.getContainingClass();
        return aClass != null && InheritanceUtil.isInheritor((PsiClass)aClass, (String)"android.os.Parcelable");
    }

    public boolean isImplicitRead(PsiElement element) {
        return false;
    }

    public boolean isImplicitWrite(PsiElement element) {
        if (!(element instanceof PsiField)) {
            return false;
        }
        AndroidFacet facet = AndroidFacet.getInstance(element);
        if (facet == null) {
            return false;
        }
        PsiField field = (PsiField)element;
        PsiModifierList modifierList = field.getModifierList();
        if (modifierList == null) {
            return false;
        }
        for (PsiAnnotation annotation : modifierList.getAnnotations()) {
            for (PsiNameValuePair pair : annotation.getParameterList().getAttributes()) {
                PsiAnnotationMemberValue value = pair.getValue();
                if (!AndroidImplicitUsagesProvider.isResourceReference(value)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isResourceReference(@Nullable PsiAnnotationMemberValue value) {
        if (!(value instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression exp = (PsiReferenceExpression)value;
        String refName = exp.getReferenceName();
        if (refName == null || refName.isEmpty()) {
            return false;
        }
        PsiExpression qExp = exp.getQualifierExpression();
        if (!(qExp instanceof PsiReferenceExpression)) {
            return false;
        }
        exp = (PsiReferenceExpression)qExp;
        refName = exp.getReferenceName();
        if (refName == null || refName.isEmpty()) {
            return false;
        }
        qExp = exp.getQualifierExpression();
        if (!(qExp instanceof PsiReferenceExpression)) {
            return false;
        }
        exp = (PsiReferenceExpression)qExp;
        return "R".equals(exp.getReferenceName());
    }

    public boolean isImplicitMethodUsage(PsiMethod method) {
        for (PsiAnnotation annotation : method.getModifierList().getAnnotations()) {
            String qualifiedName = annotation.getQualifiedName();
            if (!"android.arch.lifecycle.OnLifecycleEvent".equals(qualifiedName)) continue;
            return true;
        }
        return false;
    }

    public boolean isImplicitConstructorUsage(PsiMethod method) {
        PsiClass aClass;
        if (!method.isConstructor()) {
            return false;
        }
        if (!method.hasModifierProperty("public")) {
            return false;
        }
        PsiParameterList parameterList = method.getParameterList();
        int parameterCount = parameterList.getParametersCount();
        if (parameterCount == 0) {
            PsiClass aClass2 = method.getContainingClass();
            return aClass2 != null && (InheritanceUtil.isInheritor((PsiClass)aClass2, (String)"android.app.Fragment") || InheritanceUtil.isInheritor((PsiClass)aClass2, (String)"android.support.v4.app.Fragment") || InheritanceUtil.isInheritor((PsiClass)aClass2, (String)"android.app.backup.BackupAgent"));
        }
        if (parameterCount < 1 || parameterCount > 3) {
            return false;
        }
        PsiParameter[] parameters = parameterList.getParameters();
        PsiType type = parameters[0].getType();
        if (!(type instanceof PsiClassReferenceType)) {
            return false;
        }
        PsiClassReferenceType classType = (PsiClassReferenceType)type;
        PsiClass resolvedParameter = classType.resolve();
        if (resolvedParameter == null || !"android.content.Context".equals(resolvedParameter.getQualifiedName())) {
            return false;
        }
        if (parameterCount > 1) {
            type = parameters[1].getType();
            if (!(type instanceof PsiClassReferenceType)) {
                return false;
            }
            classType = (PsiClassReferenceType)type;
            resolvedParameter = classType.resolve();
            if (resolvedParameter == null || !"android.util.AttributeSet".equals(resolvedParameter.getQualifiedName())) {
                return false;
            }
            if (parameterCount > 2 && !PsiType.INT.equals((Object)(type = parameters[2].getType()))) {
                return false;
            }
        }
        if ((aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)method, PsiClass.class)) == null) {
            return false;
        }
        PsiClass viewBaseClass = JavaPsiFacade.getInstance((Project)aClass.getProject()).findClass("android.view.View", method.getResolveScope());
        if (viewBaseClass == null) {
            return false;
        }
        return aClass.isInheritor(viewBaseClass, true) || parameterCount == 1 && InheritanceUtil.isInheritor((PsiClass)aClass, (String)"android.view.ActionProvider");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/android/AndroidImplicitUsagesProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitParameterUsage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitFieldUsage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

