/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.lint.LintIdeClient;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.lint.checks.ApiLookup;
import com.android.tools.lint.checks.ApiMember;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.android.dom.RemovedApiField;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidPermissionConverter
extends Converter<String>
implements CustomReferenceConverter<String> {
    private static final String PERMISSION_CLASS_NAME = "android.Manifest.permission";
    private static final String PERMISSION_CLASS_NAME_FOR_API_LOOKUP = "android/Manifest$permission";
    private static final String PERMISSION_PREFIX = "android.permission.";

    public String fromString(@Nullable @NonNls String str, ConvertContext context) {
        return str;
    }

    public String toString(@Nullable String value, ConvertContext context) {
        return value;
    }

    @NotNull
    public PsiReference[] createReferences(@NotNull GenericDomValue<String> value, @NotNull PsiElement element, @NotNull ConvertContext context) {
        AndroidModel model;
        AndroidFacet facet;
        if (value == null) {
            AndroidPermissionConverter.$$$reportNull$$$0(0);
        }
        if (element == null) {
            AndroidPermissionConverter.$$$reportNull$$$0(1);
        }
        if (context == null) {
            AndroidPermissionConverter.$$$reportNull$$$0(2);
        }
        DomElement domElement = context.getInvocationElement();
        Module module = context.getModule();
        GlobalSearchScope scope = module != null ? GlobalSearchScope.allScope((Project)module.getProject()) : domElement.getResolveScope();
        JavaPsiFacade javaFacade = JavaPsiFacade.getInstance((Project)context.getPsiManager().getProject());
        PsiClass permissionClass = javaFacade.findClass(PERMISSION_CLASS_NAME, scope);
        if (permissionClass == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                AndroidPermissionConverter.$$$reportNull$$$0(3);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        int minVersion = 1;
        int maxVersion = Integer.MAX_VALUE;
        if (module != null && (facet = AndroidFacet.getInstance(module)) != null && (model = facet.getAndroidModel()) != null) {
            AndroidVersion version = model.getMinSdkVersion();
            if (version != null) {
                minVersion = version.getApiLevel();
            }
            if ((version = model.getTargetSdkVersion()) != null) {
                maxVersion = version.getApiLevel();
            }
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{new MyReference(element, permissionClass, minVersion, maxVersion)};
        if (psiReferenceArray == null) {
            AndroidPermissionConverter.$$$reportNull$$$0(4);
        }
        return psiReferenceArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/dom/converters/AndroidPermissionConverter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/dom/converters/AndroidPermissionConverter";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createReferences";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyReference
    extends PsiReferenceBase<PsiElement> {
        private final PsiClass myPermissionClass;
        private final int myMinVersion;
        private final int myMaxVersion;

        public MyReference(@NotNull PsiElement element, @NotNull PsiClass permissionClass, int minVersion, int maxVersion) {
            if (element == null) {
                MyReference.$$$reportNull$$$0(0);
            }
            if (permissionClass == null) {
                MyReference.$$$reportNull$$$0(1);
            }
            super(element, true);
            this.myPermissionClass = permissionClass;
            this.myMinVersion = minVersion;
            this.myMaxVersion = maxVersion;
        }

        @Nullable
        public PsiElement resolve() {
            return (PsiElement)ResolveCache.getInstance((Project)this.myElement.getProject()).resolveWithCaching((PsiReference)this, (ResolveCache.AbstractResolver)new ResolveCache.Resolver(){

                @Nullable
                public PsiElement resolve(@NotNull PsiReference reference, boolean incompleteCode) {
                    if (reference == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return this.resolveInner();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "org/jetbrains/android/dom/converters/AndroidPermissionConverter$MyReference$1", "resolve"));
                }
            }, false, false);
        }

        @Nullable
        private PsiElement resolveInner() {
            String qualifiedName = this.getValue();
            if (!qualifiedName.startsWith(AndroidPermissionConverter.PERMISSION_PREFIX)) {
                return null;
            }
            String name = qualifiedName.substring(AndroidPermissionConverter.PERMISSION_PREFIX.length());
            Map<String, PsiElement> permissions = this.getPermissions(Collections.singleton(name));
            return permissions.get(name);
        }

        @NotNull
        public Object[] getVariants() {
            Map<String, PsiElement> permissions = this.getPermissions(null);
            ArrayList<LookupElementBuilder> result = new ArrayList<LookupElementBuilder>(permissions.size());
            for (Map.Entry<String, PsiElement> entry : permissions.entrySet()) {
                String name = entry.getKey();
                String qualifiedName = AndroidPermissionConverter.PERMISSION_PREFIX + name;
                LookupElementBuilder builder = LookupElementBuilder.create((Object)entry.getValue(), (String)qualifiedName).withCaseSensitivity(true);
                builder = builder.withLookupString(name);
                result.add(builder);
            }
            Object[] objectArray = ArrayUtil.toObjectArray(result);
            if (objectArray == null) {
                MyReference.$$$reportNull$$$0(2);
            }
            return objectArray;
        }

        @NotNull
        private Map<String, PsiElement> getPermissions(@Nullable Set<String> filter) {
            Map<String, ApiMember> removedFieldMap;
            List<ApiMember> removedFields;
            Project project = this.getElement().getProject();
            ApiLookup apiLookup = LintIdeClient.getApiLookup(project);
            Collection<Object> collection = removedFields = apiLookup == null ? Collections.emptyList() : apiLookup.getRemovedFields(AndroidPermissionConverter.PERMISSION_CLASS_NAME_FOR_API_LOOKUP);
            if (removedFields == null || removedFields.isEmpty()) {
                removedFieldMap = Collections.emptyMap();
            } else {
                removedFieldMap = new HashMap();
                for (ApiMember field : removedFields) {
                    removedFieldMap.put(field.getSignature(), field);
                }
            }
            TreeMap<String, PsiElement> result = new TreeMap<String, PsiElement>();
            for (Object field : this.myPermissionClass.getFields()) {
                String fieldName;
                ApiMember removedField;
                if (!field.hasModifierProperty("static") || !field.hasModifierProperty("public") || !((removedField = (ApiMember)removedFieldMap.remove(fieldName = field.getName())) == null ? this.isApplicable((PsiField)field, apiLookup) : this.isApplicable(removedField)) || filter != null && !filter.contains(fieldName)) continue;
                result.put(fieldName, (PsiElement)field);
            }
            for (ApiMember removedField : removedFieldMap.values()) {
                Object field;
                if (!this.isApplicable(removedField)) continue;
                String fieldName = removedField.getSignature();
                if (filter != null && !filter.contains(fieldName)) continue;
                field = new RemovedApiField(fieldName, this.myPermissionClass, removedField.getSince(), removedField.getRemovedIn(), removedField.getRemovedIn());
                result.put(fieldName, (PsiElement)field);
            }
            TreeMap<String, PsiElement> treeMap = result;
            if (treeMap == null) {
                MyReference.$$$reportNull$$$0(3);
            }
            return treeMap;
        }

        private boolean isApplicable(@NotNull ApiMember removedField) {
            if (removedField == null) {
                MyReference.$$$reportNull$$$0(4);
            }
            return removedField.getSince() <= this.myMaxVersion && removedField.getRemovedIn() > this.myMinVersion;
        }

        private boolean isApplicable(@NotNull PsiField field, @Nullable ApiLookup apiLookup) {
            if (field == null) {
                MyReference.$$$reportNull$$$0(5);
            }
            return apiLookup == null || apiLookup.getFieldVersion(AndroidPermissionConverter.PERMISSION_CLASS_NAME_FOR_API_LOOKUP, field.getName()) <= this.myMaxVersion;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "permissionClass";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/dom/converters/AndroidPermissionConverter$MyReference";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "removedField";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/dom/converters/AndroidPermissionConverter$MyReference";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPermissions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isApplicable";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

