/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.maven;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.maven.AndroidMavenProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenResource;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenArtifactUtil;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class AndroidMavenProviderImpl
implements AndroidMavenProvider {
    public static void setPathsToDefault(MavenProject mavenProject, Module module, AndroidFacetConfiguration configuration) {
        String genRelativePath;
        String moduleDirPath = AndroidRootUtil.getModuleDirPath(module);
        String genSources = FileUtil.toSystemIndependentName((String)mavenProject.getGeneratedSourcesDirectory(false));
        if (moduleDirPath != null && (genRelativePath = FileUtil.getRelativePath((String)moduleDirPath, (String)genSources, (char)'/')) != null) {
            configuration.getState().GEN_FOLDER_RELATIVE_PATH_APT = '/' + genRelativePath + "/r";
            configuration.getState().GEN_FOLDER_RELATIVE_PATH_AIDL = '/' + genRelativePath + "/aidl";
        }
    }

    public static void configureAaptCompilation(MavenProject mavenProject, Module module, AndroidFacetConfiguration configuration, boolean hasApkSources) {
        String genRelativePath;
        String moduleDirPath = AndroidRootUtil.getModuleDirPath(module);
        String genSources = FileUtil.toSystemIndependentName((String)mavenProject.getGeneratedSourcesDirectory(false));
        if (moduleDirPath != null && (genRelativePath = FileUtil.getRelativePath((String)moduleDirPath, (String)genSources, (char)'/')) != null) {
            configuration.getState().USE_CUSTOM_APK_RESOURCE_FOLDER = hasApkSources;
            configuration.getState().CUSTOM_APK_RESOURCE_FOLDER = '/' + genRelativePath + "/combined-resources/" + "res";
        }
        configuration.getState().RUN_PROCESS_RESOURCES_MAVEN_TASK = hasApkSources;
    }

    static boolean processResources(@NotNull Module module, @NotNull MavenProject mavenProject, ResourceProcessor processor) {
        if (module == null) {
            AndroidMavenProviderImpl.$$$reportNull$$$0(0);
        }
        if (mavenProject == null) {
            AndroidMavenProviderImpl.$$$reportNull$$$0(1);
        }
        for (MavenResource resource : mavenProject.getResources()) {
            VirtualFile resDir;
            if (!resource.isFiltered() || (resDir = LocalFileSystem.getInstance().findFileByPath(resource.getDirectory())) == null) continue;
            List<Pattern> includes = AndroidMavenProviderImpl.collectPatterns(resource.getIncludes(), "**/*");
            List<Pattern> excludes = AndroidMavenProviderImpl.collectPatterns(resource.getExcludes(), null);
            String resourceTargetPath = resource.getTargetPath();
            if (resourceTargetPath == null) continue;
            String targetPath = FileUtil.toSystemIndependentName((String)resourceTargetPath);
            if (!AndroidMavenProviderImpl.processResources(module.getProject(), resDir, resDir, includes, excludes, targetPath, processor)) continue;
            return true;
        }
        return false;
    }

    private static List<Pattern> collectPatterns(@Nullable List<String> values, @Nullable String defaultValue) {
        ArrayList<Pattern> result = new ArrayList<Pattern>();
        if (values == null || values.isEmpty()) {
            if (defaultValue == null) {
                return Collections.emptyList();
            }
            return (List)MavenUtil.collectPattern((String)defaultValue, result);
        }
        for (String each : values) {
            MavenUtil.collectPattern((String)each, result);
        }
        return result;
    }

    static boolean processResources(Project project, VirtualFile sourceRoot, VirtualFile file, List<Pattern> includes, List<Pattern> excludes, String resOutputDir, ResourceProcessor processor) {
        String relPath;
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        if (!fileIndex.isExcluded(file) && (relPath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)sourceRoot, (char)'/')) != null && MavenUtil.isIncluded((String)relPath, includes, excludes) && processor.process(file, resOutputDir + "/" + relPath)) {
            return true;
        }
        if (file.isDirectory()) {
            for (VirtualFile child : file.getChildren()) {
                if (!AndroidMavenProviderImpl.processResources(project, sourceRoot, child, includes, excludes, resOutputDir, processor)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isMavenizedModule(@NotNull Module module) {
        MavenProjectsManager mavenProjectsManager;
        if (module == null) {
            AndroidMavenProviderImpl.$$$reportNull$$$0(2);
        }
        return (mavenProjectsManager = MavenProjectsManager.getInstance((Project)module.getProject())) != null ? Boolean.valueOf(mavenProjectsManager.isMavenizedModule(module)) : null;
    }

    @Override
    @NotNull
    public List<File> getMavenDependencyArtifactFiles(@NotNull Module module) {
        if (module == null) {
            AndroidMavenProviderImpl.$$$reportNull$$$0(3);
        }
        MavenProject mavenProject = MavenProjectsManager.getInstance((Project)module.getProject()).findProject(module);
        ArrayList<File> result = new ArrayList<File>();
        if (mavenProject != null) {
            for (MavenArtifact depArtifact : mavenProject.getDependencies()) {
                if (!"apksources".equals(depArtifact.getType())) continue;
                result.add(MavenArtifactUtil.getArtifactFile((File)mavenProject.getLocalRepository(), (MavenId)depArtifact.getMavenId()));
            }
        }
        ArrayList<File> arrayList = result;
        if (arrayList == null) {
            AndroidMavenProviderImpl.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Override
    @Nullable
    public String getBuildDirectory(@NotNull Module module) {
        MavenProject mavenProject;
        if (module == null) {
            AndroidMavenProviderImpl.$$$reportNull$$$0(5);
        }
        if ((mavenProject = MavenProjectsManager.getInstance((Project)module.getProject()).findProject(module)) != null) {
            return mavenProject.getBuildDirectory();
        }
        return null;
    }

    @Override
    public void setPathsToDefault(@NotNull Module module, AndroidFacetConfiguration facetConfiguration) {
        MavenProject mavenProject;
        if (module == null) {
            AndroidMavenProviderImpl.$$$reportNull$$$0(6);
        }
        if ((mavenProject = MavenProjectsManager.getInstance((Project)module.getProject()).findProject(module)) != null) {
            AndroidMavenProviderImpl.setPathsToDefault(mavenProject, module, facetConfiguration);
            if (AndroidMavenProviderImpl.hasApkSourcesDependency(mavenProject)) {
                AndroidMavenProviderImpl.configureAaptCompilation(mavenProject, module, facetConfiguration, true);
            }
        }
    }

    public static boolean hasApkSourcesDependency(MavenProject mavenProject) {
        for (MavenArtifact artifact : mavenProject.getDependencies()) {
            if (!"apksources".equals(artifact.getType())) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenProject";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/maven/AndroidMavenProviderImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/maven/AndroidMavenProviderImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMavenDependencyArtifactFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processResources";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isMavenizedModule";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getMavenDependencyArtifactFiles";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getBuildDirectory";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setPathsToDefault";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static interface ResourceProcessor {
        public boolean process(@NotNull VirtualFile var1, @NotNull String var2);
    }
}

