/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.resourceManagers;

import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.AndroidPsiUtils;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.xml.DomElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.AndroidIdIndex;
import org.jetbrains.android.AndroidValueResourcesIndex;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.dom.resources.ResourceElement;
import org.jetbrains.android.dom.resources.Resources;
import org.jetbrains.android.dom.wrappers.FileResourceElementWrapper;
import org.jetbrains.android.dom.wrappers.LazyValueResourceElementWrapper;
import org.jetbrains.android.resourceManagers.FileResourceProcessor;
import org.jetbrains.android.resourceManagers.ValueResourceInfo;
import org.jetbrains.android.resourceManagers.ValueResourceInfoImpl;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.android.util.ResourceEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ResourceManager {
    protected final Project myProject;

    protected ResourceManager(@NotNull Project project) {
        if (project == null) {
            ResourceManager.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @NotNull
    public abstract Multimap<String, VirtualFile> getAllResourceDirs();

    @NotNull
    public abstract List<VirtualFile> getResourceDirs();

    public abstract boolean isResourceDir(@NotNull VirtualFile var1);

    public boolean processFileResources(@NotNull ResourceFolderType folderType, @NotNull FileResourceProcessor processor) {
        if (folderType == null) {
            ResourceManager.$$$reportNull$$$0(1);
        }
        if (processor == null) {
            ResourceManager.$$$reportNull$$$0(2);
        }
        return this.processFileResources(folderType, processor, true);
    }

    public boolean processFileResources(@NotNull ResourceFolderType folderType, @NotNull FileResourceProcessor processor, boolean withDependencies) {
        if (folderType == null) {
            ResourceManager.$$$reportNull$$$0(3);
        }
        if (processor == null) {
            ResourceManager.$$$reportNull$$$0(4);
        }
        return this.processFileResources(folderType, processor, withDependencies, true);
    }

    public boolean processFileResources(@NotNull ResourceFolderType folderType, @NotNull FileResourceProcessor processor, boolean withDependencies, boolean publicOnly) {
        Multimap<String, VirtualFile> resDirs;
        if (folderType == null) {
            ResourceManager.$$$reportNull$$$0(5);
        }
        if (processor == null) {
            ResourceManager.$$$reportNull$$$0(6);
        }
        if (withDependencies) {
            resDirs = this.getAllResourceDirs();
        } else {
            resDirs = HashMultimap.create();
            resDirs.putAll(null, this.getResourceDirs());
        }
        for (Map.Entry entry : resDirs.asMap().entrySet()) {
            for (VirtualFile resSubdir : AndroidResourceUtil.getResourceSubdirs(folderType, (Collection)entry.getValue())) {
                ResourceFolderType resType = ResourceFolderType.getFolderType((String)resSubdir.getName());
                if (resType == null) continue;
                assert (folderType.equals((Object)resType));
                String resTypeName = resType.getName();
                for (VirtualFile resFile : resSubdir.getChildren()) {
                    String resName = AndroidCommonUtils.getResourceName((String)resTypeName, (String)resFile.getName());
                    if (resFile.isDirectory() || publicOnly && !this.isResourcePublic(resTypeName, resName) || processor.process(resFile, resName, (String)entry.getKey())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @NotNull
    public VirtualFile[] getResourceOverlayDirs() {
        if (VirtualFile.EMPTY_ARRAY == null) {
            ResourceManager.$$$reportNull$$$0(7);
        }
        return VirtualFile.EMPTY_ARRAY;
    }

    protected boolean isResourcePublic(@NotNull String type, @NotNull String name) {
        if (type == null) {
            ResourceManager.$$$reportNull$$$0(8);
        }
        if (name == null) {
            ResourceManager.$$$reportNull$$$0(9);
        }
        return true;
    }

    @NotNull
    public List<VirtualFile> getResourceSubdirs(@NotNull ResourceFolderType resourceType) {
        if (resourceType == null) {
            ResourceManager.$$$reportNull$$$0(10);
        }
        List<VirtualFile> list = AndroidResourceUtil.getResourceSubdirs(resourceType, this.getAllResourceDirs().values());
        if (list == null) {
            ResourceManager.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    public List<PsiFile> findResourceFiles(@NotNull ResourceFolderType resourceType, @Nullable String resName, boolean distinguishDelimetersInName, String ... extensions) {
        if (resourceType == null) {
            ResourceManager.$$$reportNull$$$0(12);
        }
        if (extensions == null) {
            ResourceManager.$$$reportNull$$$0(13);
        }
        List<PsiFile> list = this.findResourceFiles(resourceType, resName, distinguishDelimetersInName, true, extensions);
        if (list == null) {
            ResourceManager.$$$reportNull$$$0(14);
        }
        return list;
    }

    @NotNull
    public List<PsiFile> findResourceFiles(@NotNull ResourceFolderType resourceFolderType, @Nullable String resName1, boolean distinguishDelimitersInName, boolean withDependencies, String ... extensions) {
        if (resourceFolderType == null) {
            ResourceManager.$$$reportNull$$$0(15);
        }
        if (extensions == null) {
            ResourceManager.$$$reportNull$$$0(16);
        }
        ArrayList<PsiFile> result = new ArrayList<PsiFile>();
        HashSet extensionSet = new HashSet();
        Collections.addAll(extensionSet, extensions);
        this.processFileResources(resourceFolderType, (arg_0, arg_1, arg_2) -> this.lambda$findResourceFiles$0(extensions, (Set)extensionSet, resName1, distinguishDelimitersInName, result, arg_0, arg_1, arg_2), withDependencies);
        ArrayList<PsiFile> arrayList = result;
        if (arrayList == null) {
            ResourceManager.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    @NotNull
    public <T> Multimap<String, T> findResourceFilesByLibraryName(@NotNull ResourceFolderType folderType, @NotNull Class<T> fileClass) {
        if (folderType == null) {
            ResourceManager.$$$reportNull$$$0(18);
        }
        if (fileClass == null) {
            ResourceManager.$$$reportNull$$$0(19);
        }
        HashMultimap result = HashMultimap.create();
        this.processFileResources(folderType, (arg_0, arg_1, arg_2) -> this.lambda$findResourceFilesByLibraryName$1(fileClass, (Multimap)result, arg_0, arg_1, arg_2), true);
        HashMultimap hashMultimap = result;
        if (hashMultimap == null) {
            ResourceManager.$$$reportNull$$$0(20);
        }
        return hashMultimap;
    }

    @NotNull
    public List<PsiFile> findResourceFiles(@NotNull ResourceFolderType resourceType) {
        if (resourceType == null) {
            ResourceManager.$$$reportNull$$$0(21);
        }
        List<PsiFile> list = this.findResourceFiles(resourceType, null, true, new String[0]);
        if (list == null) {
            ResourceManager.$$$reportNull$$$0(22);
        }
        return list;
    }

    protected List<Pair<Resources, VirtualFile>> getResourceElements(@Nullable Set<VirtualFile> files) {
        return this.getRootDomElements(Resources.class, files);
    }

    private <T extends DomElement> List<Pair<T, VirtualFile>> getRootDomElements(@NotNull Class<T> elementType, @Nullable Set<VirtualFile> files) {
        if (elementType == null) {
            ResourceManager.$$$reportNull$$$0(23);
        }
        ArrayList<Pair<T, VirtualFile>> result = new ArrayList<Pair<T, VirtualFile>>();
        for (VirtualFile file : this.getAllValueResourceFiles()) {
            T element;
            if (files != null && !files.contains(file) || !file.isValid() || (element = AndroidUtils.loadDomElement(this.myProject, file, elementType)) == null) continue;
            result.add(Pair.create(element, (Object)file));
        }
        return result;
    }

    @NotNull
    protected Set<VirtualFile> getAllValueResourceFiles() {
        HashSet files = new HashSet();
        for (VirtualFile valueResourceDir : this.getResourceSubdirs(ResourceFolderType.VALUES)) {
            for (VirtualFile valueResourceFile : valueResourceDir.getChildren()) {
                if (valueResourceFile.isDirectory() || !valueResourceFile.getFileType().equals(StdFileTypes.XML)) continue;
                files.add(valueResourceFile);
            }
        }
        HashSet hashSet = files;
        if (hashSet == null) {
            ResourceManager.$$$reportNull$$$0(24);
        }
        return hashSet;
    }

    protected List<ResourceElement> getValueResources(@NotNull ResourceType resourceType, @Nullable Set<VirtualFile> files) {
        if (resourceType == null) {
            ResourceManager.$$$reportNull$$$0(25);
        }
        ArrayList<ResourceElement> result = new ArrayList<ResourceElement>();
        List<Pair<Resources, VirtualFile>> resourceFiles = this.getResourceElements(files);
        for (Pair<Resources, VirtualFile> pair : resourceFiles) {
            Resources resources = (Resources)pair.getFirst();
            ApplicationManager.getApplication().runReadAction(() -> {
                if (resourceType == null) {
                    ResourceManager.$$$reportNull$$$0(58);
                }
                if (!resources.isValid() || this.myProject.isDisposed()) {
                    return;
                }
                List<ResourceElement> valueResources = AndroidResourceUtil.getValueResourcesFromElement(resourceType, resources);
                for (ResourceElement valueResource : valueResources) {
                    String resName = (String)valueResource.getName().getValue();
                    if (resName == null || !this.isResourcePublic(resourceType.getName(), resName)) continue;
                    result.add(valueResource);
                }
            });
        }
        return result;
    }

    @Nullable
    public String getValueResourceType(@NotNull XmlTag tag) {
        ResourceFolderType fileResType;
        if (tag == null) {
            ResourceManager.$$$reportNull$$$0(26);
        }
        if (ResourceFolderType.VALUES == (fileResType = this.getFileResourceFolderType(tag.getContainingFile()))) {
            return tag.getName();
        }
        return null;
    }

    @Nullable
    public ResourceFolderType getFileResourceFolderType(final @NotNull PsiFile file) {
        if (file == null) {
            ResourceManager.$$$reportNull$$$0(27);
        }
        return (ResourceFolderType)ApplicationManager.getApplication().runReadAction((Computable)new Computable<ResourceFolderType>(){

            @Nullable
            public ResourceFolderType compute() {
                PsiDirectory dir = file.getContainingDirectory();
                if (dir == null) {
                    return null;
                }
                PsiDirectory possibleResDir = dir.getParentDirectory();
                if (possibleResDir == null || !ResourceManager.this.isResourceDir(possibleResDir.getVirtualFile())) {
                    return null;
                }
                return ResourceFolderType.getFolderType((String)dir.getName());
            }
        });
    }

    @Nullable
    public String getFileResourceType(@NotNull PsiFile file) {
        ResourceFolderType folderType;
        if (file == null) {
            ResourceManager.$$$reportNull$$$0(28);
        }
        return (folderType = this.getFileResourceFolderType(file)) == null ? null : folderType.getName();
    }

    @NotNull
    private Set<String> getFileResourcesNames(@NotNull ResourceFolderType resourceType) {
        if (resourceType == null) {
            ResourceManager.$$$reportNull$$$0(29);
        }
        HashSet result = new HashSet();
        this.processFileResources(resourceType, (arg_0, arg_1, arg_2) -> ResourceManager.lambda$getFileResourcesNames$3((Set)result, arg_0, arg_1, arg_2));
        HashSet hashSet = result;
        if (hashSet == null) {
            ResourceManager.$$$reportNull$$$0(30);
        }
        return hashSet;
    }

    @NotNull
    public Collection<String> getValueResourceNames(@NotNull ResourceType resourceType) {
        if (resourceType == null) {
            ResourceManager.$$$reportNull$$$0(31);
        }
        HashSet result = new HashSet();
        boolean attr = ResourceType.ATTR == resourceType;
        for (ResourceEntry entry : this.getValueResourceEntries(resourceType)) {
            String name = entry.getName();
            if (attr && name.startsWith("android:")) continue;
            result.add(name);
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            ResourceManager.$$$reportNull$$$0(32);
        }
        return hashSet;
    }

    @NotNull
    public Collection<ResourceEntry> getValueResourceEntries(@NotNull ResourceType resourceType) {
        if (resourceType == null) {
            ResourceManager.$$$reportNull$$$0(33);
        }
        FileBasedIndex index = FileBasedIndex.getInstance();
        ResourceEntry typeMarkerEntry = AndroidValueResourcesIndex.createTypeMarkerKey(resourceType.getName());
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)this.myProject);
        HashMap file2resourceSet = new HashMap();
        index.processValues(AndroidValueResourcesIndex.INDEX_ID, (Object)typeMarkerEntry, null, (FileBasedIndex.ValueProcessor)new FileBasedIndex.ValueProcessor<ImmutableSet<AndroidValueResourcesIndex.MyResourceInfo>>((Map)file2resourceSet){
            final /* synthetic */ Map val$file2resourceSet;
            {
                this.val$file2resourceSet = map;
            }

            public boolean process(@NotNull VirtualFile file, ImmutableSet<AndroidValueResourcesIndex.MyResourceInfo> infos) {
                if (file == null) {
                    2.$$$reportNull$$$0(0);
                }
                for (AndroidValueResourcesIndex.MyResourceInfo info : infos) {
                    Set resourcesInFile = (Set)this.val$file2resourceSet.get(file);
                    if (resourcesInFile == null) {
                        resourcesInFile = new HashSet();
                        this.val$file2resourceSet.put(file, resourcesInFile);
                    }
                    resourcesInFile.add(info.getResourceEntry());
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/android/resourceManagers/ResourceManager$2", "process"));
            }
        }, scope);
        ArrayList<ResourceEntry> result = new ArrayList<ResourceEntry>();
        for (VirtualFile file : this.getAllValueResourceFiles()) {
            Set entries = (Set)file2resourceSet.get(file);
            if (entries == null) continue;
            for (ResourceEntry entry : entries) {
                if (!this.isResourcePublic(entry.getType(), entry.getName())) continue;
                result.add(entry);
            }
        }
        ArrayList<ResourceEntry> arrayList = result;
        if (arrayList == null) {
            ResourceManager.$$$reportNull$$$0(34);
        }
        return arrayList;
    }

    @NotNull
    public Collection<String> getResourceNames(@NotNull ResourceType type) {
        if (type == null) {
            ResourceManager.$$$reportNull$$$0(35);
        }
        Collection<String> collection = this.getResourceNames(type, false);
        if (collection == null) {
            ResourceManager.$$$reportNull$$$0(36);
        }
        return collection;
    }

    @NotNull
    public Collection<String> getResourceNames(@NotNull ResourceType resourceType, boolean publicOnly) {
        if (resourceType == null) {
            ResourceManager.$$$reportNull$$$0(37);
        }
        HashSet result = new HashSet();
        result.addAll(this.getValueResourceNames(resourceType));
        List folders = FolderTypeRelationship.getRelatedFolders((ResourceType)resourceType);
        if (!folders.isEmpty()) {
            for (ResourceFolderType folderType : folders) {
                if (folderType == ResourceFolderType.VALUES) continue;
                result.addAll(this.getFileResourcesNames(folderType));
            }
        }
        if (resourceType == ResourceType.ID) {
            result.addAll(this.getIds(true));
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            ResourceManager.$$$reportNull$$$0(38);
        }
        return hashSet;
    }

    @Nullable
    public abstract AttributeDefinitions getAttributeDefinitions();

    @NotNull
    public List<XmlAttributeValue> findIdDeclarations(final @NotNull String id) {
        if (id == null) {
            ResourceManager.$$$reportNull$$$0(39);
        }
        if (!this.isResourcePublic(ResourceType.ID.getName(), id)) {
            List<XmlAttributeValue> list = Collections.emptyList();
            if (list == null) {
                ResourceManager.$$$reportNull$$$0(40);
            }
            return list;
        }
        final ArrayList<XmlAttributeValue> declarations = new ArrayList<XmlAttributeValue>();
        Collection files = FileBasedIndex.getInstance().getContainingFiles(AndroidIdIndex.INDEX_ID, (Object)("+" + id), GlobalSearchScope.allScope((Project)this.myProject));
        HashSet fileSet = new HashSet(files);
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        for (VirtualFile subdir : this.getResourceSubdirsToSearchIds()) {
            for (VirtualFile file : subdir.getChildren()) {
                PsiFile psiFile;
                if (!fileSet.contains(file) || !((psiFile = psiManager.findFile(file)) instanceof XmlFile)) continue;
                psiFile.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

                    public void visitXmlAttributeValue(XmlAttributeValue attributeValue) {
                        String idInAttr;
                        if (AndroidResourceUtil.isIdDeclaration(attributeValue) && id.equals(idInAttr = AndroidResourceUtil.getResourceNameByReferenceText(attributeValue.getValue()))) {
                            declarations.add(attributeValue);
                        }
                    }
                });
            }
        }
        ArrayList<XmlAttributeValue> arrayList = declarations;
        if (arrayList == null) {
            ResourceManager.$$$reportNull$$$0(41);
        }
        return arrayList;
    }

    @NotNull
    public Collection<String> getIds(boolean declarationsOnly) {
        if (this.myProject.isDisposed()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                ResourceManager.$$$reportNull$$$0(42);
            }
            return list;
        }
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)this.myProject);
        FileBasedIndex index = FileBasedIndex.getInstance();
        HashMap file2idEntries = new HashMap();
        index.processValues(AndroidIdIndex.INDEX_ID, (Object)"$", null, (FileBasedIndex.ValueProcessor)new FileBasedIndex.ValueProcessor<Set<String>>((Map)file2idEntries){
            final /* synthetic */ Map val$file2idEntries;
            {
                this.val$file2idEntries = map;
            }

            public boolean process(@NotNull VirtualFile file, Set<String> value) {
                if (file == null) {
                    4.$$$reportNull$$$0(0);
                }
                this.val$file2idEntries.put(file, value);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/android/resourceManagers/ResourceManager$4", "process"));
            }
        }, scope);
        HashSet result = new HashSet();
        for (VirtualFile resSubdir : this.getResourceSubdirsToSearchIds()) {
            for (VirtualFile resFile : resSubdir.getChildren()) {
                Set idEntries = (Set)file2idEntries.get(resFile);
                if (idEntries == null) continue;
                for (String idEntry : idEntries) {
                    if (idEntry.startsWith("+")) {
                        idEntry = idEntry.substring(1);
                    } else if (declarationsOnly) continue;
                    if (!this.isResourcePublic(ResourceType.ID.getName(), idEntry)) continue;
                    result.add(idEntry);
                }
            }
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            ResourceManager.$$$reportNull$$$0(43);
        }
        return hashSet;
    }

    @NotNull
    public List<VirtualFile> getResourceSubdirsToSearchIds() {
        ArrayList<VirtualFile> resSubdirs = new ArrayList<VirtualFile>();
        for (ResourceFolderType type : FolderTypeRelationship.getIdGeneratingFolderTypes()) {
            resSubdirs.addAll(this.getResourceSubdirs(type));
        }
        ArrayList<VirtualFile> arrayList = resSubdirs;
        if (arrayList == null) {
            ResourceManager.$$$reportNull$$$0(44);
        }
        return arrayList;
    }

    public List<ResourceElement> findValueResources(@NotNull String resType, @NotNull String resName) {
        if (resType == null) {
            ResourceManager.$$$reportNull$$$0(45);
        }
        if (resName == null) {
            ResourceManager.$$$reportNull$$$0(46);
        }
        return this.findValueResources(resType, resName, true);
    }

    @NotNull
    public List<ResourceElement> findValueResources(@NotNull String resourceType, @NotNull String resourceName, boolean distinguishDelimitersInName) {
        if (resourceType == null) {
            ResourceManager.$$$reportNull$$$0(47);
        }
        if (resourceName == null) {
            ResourceManager.$$$reportNull$$$0(48);
        }
        List<ValueResourceInfoImpl> resources = this.findValueResourceInfos(resourceType, resourceName, distinguishDelimitersInName, false);
        ArrayList<ResourceElement> result = new ArrayList<ResourceElement>();
        for (ValueResourceInfoImpl resource : resources) {
            ResourceElement domElement = resource.computeDomElement();
            if (domElement == null) continue;
            result.add(domElement);
        }
        ArrayList<ResourceElement> arrayList = result;
        if (arrayList == null) {
            ResourceManager.$$$reportNull$$$0(49);
        }
        return arrayList;
    }

    public void collectLazyResourceElements(@NotNull String resType, @NotNull String resName, boolean withAttrs, @NotNull PsiElement context, @NotNull Collection<PsiElement> elements) {
        ResourceFolderType folderType;
        if (resType == null) {
            ResourceManager.$$$reportNull$$$0(50);
        }
        if (resName == null) {
            ResourceManager.$$$reportNull$$$0(51);
        }
        if (context == null) {
            ResourceManager.$$$reportNull$$$0(52);
        }
        if (elements == null) {
            ResourceManager.$$$reportNull$$$0(53);
        }
        List<ValueResourceInfoImpl> valueResources = this.findValueResourceInfos(resType, resName, false, withAttrs);
        for (ValueResourceInfo valueResourceInfo : valueResources) {
            elements.add((PsiElement)new LazyValueResourceElementWrapper(valueResourceInfo, context));
        }
        if (resType.equals("id")) {
            elements.addAll(this.findIdDeclarations(resName));
        }
        if (elements.isEmpty() && (folderType = ResourceFolderType.getTypeByName((String)resType)) != null) {
            for (PsiFile file : this.findResourceFiles(folderType, resName, false, new String[0])) {
                elements.add(new FileResourceElementWrapper(file));
            }
        }
    }

    @NotNull
    public List<ValueResourceInfoImpl> findValueResourceInfos(@NotNull String resourceType, final @NotNull String resourceName, final boolean distinguishDelimetersInName, boolean searchAttrs) {
        ResourceType type;
        if (resourceType == null) {
            ResourceManager.$$$reportNull$$$0(54);
        }
        if (resourceName == null) {
            ResourceManager.$$$reportNull$$$0(55);
        }
        ResourceType resourceType2 = type = resourceType.startsWith("+") ? ResourceType.ID : ResourceType.getEnum((String)resourceType);
        if (type == null || !AndroidResourceUtil.VALUE_RESOURCE_TYPES.contains(type) && (type != ResourceType.ATTR || !searchAttrs)) {
            List<ValueResourceInfoImpl> list = Collections.emptyList();
            if (list == null) {
                ResourceManager.$$$reportNull$$$0(56);
            }
            return list;
        }
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)this.myProject);
        final ArrayList<ValueResourceInfoImpl> result = new ArrayList<ValueResourceInfoImpl>();
        final Set<VirtualFile> valueResourceFiles = this.getAllValueResourceFiles();
        FileBasedIndex.getInstance().processValues(AndroidValueResourcesIndex.INDEX_ID, (Object)AndroidValueResourcesIndex.createTypeNameMarkerKey(resourceType, resourceName), null, (FileBasedIndex.ValueProcessor)new FileBasedIndex.ValueProcessor<ImmutableSet<AndroidValueResourcesIndex.MyResourceInfo>>(){

            public boolean process(@NotNull VirtualFile file, ImmutableSet<AndroidValueResourcesIndex.MyResourceInfo> infos) {
                if (file == null) {
                    5.$$$reportNull$$$0(0);
                }
                for (AndroidValueResourcesIndex.MyResourceInfo info : infos) {
                    String name = info.getResourceEntry().getName();
                    if (!AndroidUtils.equal(resourceName, name, distinguishDelimetersInName) || !valueResourceFiles.contains(file)) continue;
                    result.add(new ValueResourceInfoImpl(info.getResourceEntry().getName(), type, file, ResourceManager.this.myProject, info.getOffset()));
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/android/resourceManagers/ResourceManager$5", "process"));
            }
        }, scope);
        ArrayList<ValueResourceInfoImpl> arrayList = result;
        if (arrayList == null) {
            ResourceManager.$$$reportNull$$$0(57);
        }
        return arrayList;
    }

    private static /* synthetic */ boolean lambda$getFileResourcesNames$3(Set result, VirtualFile resFile, String resName, String libraryName) {
        result.add(resName);
        return true;
    }

    private /* synthetic */ boolean lambda$findResourceFilesByLibraryName$1(@NotNull Class fileClass, Multimap result, VirtualFile resFile, String resName, String libraryName) {
        PsiFile file;
        if (fileClass == null) {
            ResourceManager.$$$reportNull$$$0(59);
        }
        if ((file = AndroidPsiUtils.getPsiFileSafely(this.myProject, resFile)) != null && fileClass.isInstance(file)) {
            result.put((Object)libraryName, fileClass.cast(file));
        }
        return true;
    }

    private /* synthetic */ boolean lambda$findResourceFiles$0(@NotNull String[] extensions, Set extensionSet, @Nullable String resName1, boolean distinguishDelimitersInName, List result, VirtualFile resFile, String resName, String libraryName) {
        PsiFile file;
        if (extensions == null) {
            ResourceManager.$$$reportNull$$$0(60);
        }
        String extension = resFile.getExtension();
        if ((extensions.length == 0 || extensionSet.contains(extension)) && (resName1 == null || AndroidUtils.equal(resName1, resName, distinguishDelimitersInName)) && (file = AndroidPsiUtils.getPsiFileSafely(this.myProject, resFile)) != null) {
            result.add(file);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 11: 
            case 14: 
            case 17: 
            case 20: 
            case 22: 
            case 24: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 49: 
            case 56: 
            case 57: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 11: 
            case 14: 
            case 17: 
            case 20: 
            case 22: 
            case 24: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 49: 
            case 56: 
            case 57: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folderType";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 7: 
            case 11: 
            case 14: 
            case 17: 
            case 20: 
            case 22: 
            case 24: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 49: 
            case 56: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/resourceManagers/ResourceManager";
                break;
            }
            case 8: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: 
            case 12: 
            case 21: 
            case 25: 
            case 29: 
            case 31: 
            case 33: 
            case 37: 
            case 47: 
            case 54: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceType";
                break;
            }
            case 13: 
            case 16: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensions";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceFolderType";
                break;
            }
            case 19: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileClass";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 45: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resType";
                break;
            }
            case 46: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resName";
                break;
            }
            case 48: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceName";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/resourceManagers/ResourceManager";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceOverlayDirs";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceSubdirs";
                break;
            }
            case 14: 
            case 17: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "findResourceFiles";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "findResourceFilesByLibraryName";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllValueResourceFiles";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileResourcesNames";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueResourceNames";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueResourceEntries";
                break;
            }
            case 36: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceNames";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "findIdDeclarations";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getIds";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceSubdirsToSearchIds";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "findValueResources";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "findValueResourceInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processFileResources";
                break;
            }
            case 7: 
            case 11: 
            case 14: 
            case 17: 
            case 20: 
            case 22: 
            case 24: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 49: 
            case 56: 
            case 57: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isResourcePublic";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getResourceSubdirs";
                break;
            }
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findResourceFiles";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findResourceFilesByLibraryName";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getRootDomElements";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getValueResources";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getValueResourceType";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getFileResourceFolderType";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getFileResourceType";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getFileResourcesNames";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getValueResourceNames";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getValueResourceEntries";
                break;
            }
            case 35: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getResourceNames";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "findIdDeclarations";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "findValueResources";
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "collectLazyResourceElements";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "findValueResourceInfos";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getValueResources$2";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findResourceFilesByLibraryName$1";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findResourceFiles$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 11: 
            case 14: 
            case 17: 
            case 20: 
            case 22: 
            case 24: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 49: 
            case 56: 
            case 57: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

