/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.context;

import java.util.List;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.FieldInfo;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.context.ClassContext;
import org.jetbrains.kotlin.codegen.context.CodegenContext;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;

public class ScriptContext
extends ClassContext {
    private final ScriptDescriptor scriptDescriptor;
    private final List<ScriptDescriptor> earlierScripts;
    private final KtExpression lastStatement;

    public ScriptContext(@NotNull KotlinTypeMapper typeMapper, @NotNull ScriptDescriptor scriptDescriptor, @NotNull List<ScriptDescriptor> earlierScripts, @NotNull ClassDescriptor contextDescriptor, @Nullable CodegenContext parentContext) {
        super(typeMapper, contextDescriptor, OwnerKind.IMPLEMENTATION, parentContext, null);
        this.scriptDescriptor = scriptDescriptor;
        this.earlierScripts = earlierScripts;
        KtScript script = (KtScript)DescriptorToSourceUtils.getSourceFromDescriptor(scriptDescriptor);
        assert (script != null) : "Declaration should be present for script: " + scriptDescriptor;
        KtDeclaration lastDeclaration = (KtDeclaration)CollectionsKt.lastOrNull(script.getDeclarations());
        this.lastStatement = lastDeclaration instanceof KtAnonymousInitializer ? ((KtAnonymousInitializer)lastDeclaration).getBody() : null;
    }

    @NotNull
    public ScriptDescriptor getScriptDescriptor() {
        return this.scriptDescriptor;
    }

    @NotNull
    public FieldInfo getResultFieldInfo() {
        assert (this.getState().getReplSpecific().getShouldGenerateScriptResultValue()) : "Should not be called unless 'scriptResultFieldName' is set";
        GenerationState state = this.getState();
        String scriptResultFieldName = state.getReplSpecific().getScriptResultFieldName();
        assert (scriptResultFieldName != null);
        return FieldInfo.createForHiddenField(state.getTypeMapper().mapClass(this.scriptDescriptor), AsmTypes.OBJECT_TYPE, scriptResultFieldName);
    }

    @NotNull
    public List<ScriptDescriptor> getEarlierScripts() {
        return this.earlierScripts;
    }

    @NotNull
    public String getScriptFieldName(@NotNull ScriptDescriptor scriptDescriptor) {
        int index2 = this.earlierScripts.indexOf(scriptDescriptor);
        if (index2 < 0) {
            throw new IllegalStateException("Unregistered script: " + scriptDescriptor);
        }
        return "script$" + (index2 + 1);
    }

    @Nullable
    public KtExpression getLastStatement() {
        return this.lastStatement;
    }

    @Override
    public String toString() {
        return "Script: " + ((ClassDescriptor)this.getContextDescriptor()).getName().asString();
    }
}

