/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.when;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.when.MappingClassesForWhenByEnumCodegen;
import org.jetbrains.kotlin.codegen.when.WhenByEnumsMapping;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.org.objectweb.asm.Type;

public class MappingsClassesForWhenByEnum {
    private final GenerationState state;
    private final Set<String> generatedMappingClasses = new HashSet<String>();
    private final MappingClassesForWhenByEnumCodegen mappingsCodegen;

    public MappingsClassesForWhenByEnum(@NotNull GenerationState state) {
        this.state = state;
        this.mappingsCodegen = new MappingClassesForWhenByEnumCodegen(state);
    }

    public void generateMappingsClassForExpression(@NotNull KtWhenExpression expression2) {
        WhenByEnumsMapping mapping2 = this.state.getBindingContext().get(CodegenBinding.MAPPING_FOR_WHEN_BY_ENUM, expression2);
        assert (mapping2 != null) : "mapping class should not be requested for non enum when";
        if (!this.generatedMappingClasses.contains(mapping2.getMappingsClassInternalName())) {
            List<WhenByEnumsMapping> mappings = this.state.getBindingContext().get(CodegenBinding.MAPPINGS_FOR_WHENS_BY_ENUM_IN_CLASS_FILE, mapping2.getOuterClassInternalNameForExpression());
            assert (mappings != null) : "guaranteed by usage contract of EnumSwitchCodegen";
            Type mappingsClassType = Type.getObjectType((String)mapping2.getMappingsClassInternalName());
            this.mappingsCodegen.generate(mappings, mappingsClassType, expression2.getContainingKtFile());
            this.generatedMappingClasses.add(mapping2.getMappingsClassInternalName());
        }
    }
}

