/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.idea.codeInsight.KtFunctionPsiElementCellRenderer;
import org.jetbrains.kotlin.idea.core.DescriptorUtilsKt;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J!\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/GotoSuperActionHandler;", "Lcom/intellij/codeInsight/CodeInsightActionHandler;", "()V", "findSuperDeclarations", "", "Lcom/intellij/psi/PsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "getTitle", "", "invoke", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "startInWriteAction", "", "idea"})
public final class GotoSuperActionHandler
implements CodeInsightActionHandler {
    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        KtDeclaration declaration2;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        FeatureUsageTracker.getInstance().triggerFeatureUsed("navigation.goto.super");
        CaretModel caretModel = editor.getCaretModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.caretModel");
        PsiElement psiElement2 = file2.findElementAt(caretModel.getOffset());
        if (psiElement2 == null) {
            return;
        }
        PsiElement element3 = psiElement2;
        KtDeclaration ktDeclaration = (KtDeclaration)PsiTreeUtil.getParentOfType((PsiElement)element3, (Class[])new Class[]{KtNamedFunction.class, KtClass.class, KtProperty.class, KtObjectDeclaration.class});
        if (ktDeclaration == null) {
            return;
        }
        KtDeclaration ktDeclaration2 = declaration2 = ktDeclaration;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktDeclaration2, (String)"declaration");
        DeclarationDescriptor descriptor2 = ResolutionUtils.unsafeResolveToDescriptor(ktDeclaration2, BodyResolveMode.PARTIAL);
        List<PsiElement> superDeclarations = this.findSuperDeclarations(project, descriptor2);
        if (superDeclarations == null || superDeclarations.isEmpty()) {
            return;
        }
        if (superDeclarations.size() == 1) {
            Navigatable navigatable = EditSourceUtil.getDescriptor((PsiElement)superDeclarations.get(0));
            if (navigatable != null && navigatable.canNavigate()) {
                navigatable.navigate(true);
            }
        } else {
            String message2 = this.getTitle(descriptor2);
            PsiElement[] superDeclarationsArray = PsiUtilCore.toPsiElementArray((Collection)superDeclarations);
            JBPopup popup2 = descriptor2 instanceof ClassDescriptor ? NavigationUtil.getPsiElementPopup((PsiElement[])superDeclarationsArray, (String)message2) : NavigationUtil.getPsiElementPopup((PsiElement[])superDeclarationsArray, (PsiElementListCellRenderer)((PsiElementListCellRenderer)new KtFunctionPsiElementCellRenderer()), (String)message2);
            popup2.showInBestPositionFor(editor);
        }
    }

    private final String getTitle(DeclarationDescriptor descriptor2) {
        DeclarationDescriptor declarationDescriptor = descriptor2;
        return declarationDescriptor instanceof ClassDescriptor ? KotlinBundle.message("goto.super.class.chooser.title", new Object[0]) : (declarationDescriptor instanceof PropertyDescriptor ? KotlinBundle.message("goto.super.property.chooser.title", new Object[0]) : (declarationDescriptor instanceof SimpleFunctionDescriptor ? KotlinBundle.message("goto.super.function.chooser.title", new Object[0]) : null));
    }

    /*
     * WARNING - void declaration
     */
    private final List<PsiElement> findSuperDeclarations(Project project, DeclarationDescriptor descriptor2) {
        void $receiver$iv$iv;
        Collection collection;
        Iterable<KotlinType> supertypes2;
        DeclarationDescriptor declarationDescriptor = descriptor2;
        if (declarationDescriptor instanceof ClassDescriptor) {
            void $receiver$iv$iv2;
            TypeConstructor typeConstructor2 = ((ClassDescriptor)descriptor2).getTypeConstructor();
            Intrinsics.checkExpressionValueIsNotNull((Object)typeConstructor2, (String)"descriptor.typeConstructor");
            Collection<KotlinType> collection2 = supertypes2 = typeConstructor2.getSupertypes();
            Intrinsics.checkExpressionValueIsNotNull(collection2, (String)"supertypes");
            Iterable $receiver$iv = collection2;
            Iterable iterable = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            void $receiver$iv$iv$iv = $receiver$iv$iv2;
            for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                ClassDescriptor classDescriptor;
                Object element$iv$iv = element$iv$iv$iv;
                KotlinType type2 = (KotlinType)element$iv$iv;
                ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
                if (!(classifierDescriptor instanceof ClassDescriptor)) {
                    classifierDescriptor = null;
                }
                if ((ClassDescriptor)classifierDescriptor == null) continue;
                ClassDescriptor it$iv$iv = classDescriptor;
                destination$iv$iv.add(it$iv$iv);
            }
            List superclasses = (List)destination$iv$iv;
            ContainerUtil.removeDuplicates((Collection)superclasses);
            collection = superclasses;
        } else if (declarationDescriptor instanceof CallableMemberDescriptor) {
            collection = DescriptorUtilsKt.getDirectlyOverriddenDeclarations((CallableMemberDescriptor)descriptor2);
        } else {
            return null;
        }
        Collection superDescriptors = collection;
        Iterable $receiver$iv = superDescriptors;
        supertypes2 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            PsiElement psiElement2;
            Object element$iv$iv = element$iv$iv$iv;
            DeclarationDescriptor descriptor3 = (DeclarationDescriptor)element$iv$iv;
            Object object = descriptor3 instanceof ClassDescriptor && KotlinBuiltIns.isAny((ClassDescriptor)descriptor3) ? null : DescriptorToSourceUtilsIde.INSTANCE.getAnyDeclaration(project, descriptor3);
            if (object == null) continue;
            PsiElement it$iv$iv = psiElement2 = object;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public boolean startInWriteAction() {
        return false;
    }
}

