/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.CopyPastePostProcessor;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.KotlinCopyPasteReferenceProcessor;
import org.jetbrains.kotlin.idea.codeInsight.KotlinCopyPasteReferenceProcessor$$special$;
import org.jetbrains.kotlin.idea.codeInsight.KotlinReferenceData;
import org.jetbrains.kotlin.idea.codeInsight.KotlinReferenceTransferableData;
import org.jetbrains.kotlin.idea.codeInsight.RestoreReferencesDialog;
import org.jetbrains.kotlin.idea.codeInsight.shorten.DelayedRequestsWaitingSetKt;
import org.jetbrains.kotlin.idea.conversion.copy.RangeUtilsKt;
import org.jetbrains.kotlin.idea.imports.ImportsUtils;
import org.jetbrains.kotlin.idea.kdoc.KDocReference;
import org.jetbrains.kotlin.idea.references.KtMultiReference;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.KtSimpleNameReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.idea.util.ImportInsertHelper;
import org.jetbrains.kotlin.idea.util.ScopeUtils;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.kdoc.psi.api.KDocElement;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.types.ErrorUtils;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u00ca\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 M2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002MNB\u0005\u00a2\u0006\u0002\u0010\u0003J$\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011J.\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\f2\u0006\u0010\u000e\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J2\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00020\f2\u0006\u0010!\u001a\u00020\"H\u0016J\u001a\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001e\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\"\u0010*\u001a\u0004\u0018\u00010\u001a2\u0006\u0010+\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010,\u001a\u00020-H\u0002J3\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00180\f2\u0006\u0010\u000e\u001a\u00020\u00142\u0006\u0010,\u001a\u00020-2\u000e\u0010/\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\u0005H\u0002\u00a2\u0006\u0002\u00100J1\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010,\u001a\u00020-2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\r0\u0005\u00a2\u0006\u0002\u00105JD\u00106\u001a\u0002022\u0006\u00103\u001a\u0002042\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020-2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020<0;2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0016J\u001e\u0010>\u001a\b\u0012\u0004\u0012\u00020)0(2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u001e\u0010?\u001a\u0002022\f\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00180(2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J$\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00180(2\u0006\u00103\u001a\u0002042\f\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00180\fH\u0002J\u001e\u0010B\u001a\b\u0012\u0004\u0012\u00020C0\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002JB\u0010D\u001a\u000202*\b\u0012\u0004\u0012\u00020\r0E2\u0006\u0010F\u001a\u00020G2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010H\u001a\u00020-2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\f\u0010I\u001a\u00020<*\u00020JH\u0002J$\u0010K\u001a\u00020<*\u00020G2\u0006\u0010L\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002R\u001e\u0010\u0004\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006O"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/KotlinCopyPasteReferenceProcessor;", "Lcom/intellij/codeInsight/editorActions/CopyPastePostProcessor;", "Lorg/jetbrains/kotlin/idea/codeInsight/KotlinReferenceTransferableData;", "()V", "IGNORE_REFERENCES_INSIDE", "", "Ljava/lang/Class;", "Lorg/jetbrains/kotlin/psi/KtElement;", "[Ljava/lang/Class;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "collectReferenceData", "", "Lorg/jetbrains/kotlin/idea/codeInsight/KotlinReferenceData;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "startOffsets", "", "endOffsets", "collectTransferableData", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "createReferenceToRestoreData", "Lorg/jetbrains/kotlin/idea/codeInsight/KotlinCopyPasteReferenceProcessor$ReferenceToRestoreData;", "reference", "Lorg/jetbrains/kotlin/idea/references/KtReference;", "refData", "fileResolutionScope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "extractTransferableData", "content", "Ljava/awt/datatransfer/Transferable;", "findCallableToImport", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "findImportableDescriptors", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "findReference", "data", "blockStart", "", "findReferencesToRestore", "referenceData", "(Lcom/intellij/psi/PsiFile;I[Lorg/jetbrains/kotlin/idea/codeInsight/KotlinReferenceData;)Ljava/util/List;", "processReferenceData", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/psi/KtFile;I[Lorg/jetbrains/kotlin/idea/codeInsight/KotlinReferenceData;)V", "processTransferableData", "bounds", "Lcom/intellij/openapi/editor/RangeMarker;", "caretOffset", "indented", "Lcom/intellij/openapi/util/Ref;", "", "values", "resolveReference", "restoreReferences", "referencesToRestore", "showRestoreReferencesDialog", "toTextRanges", "Lcom/intellij/openapi/util/TextRange;", "addReferenceDataInsideElement", "", "element", "Lcom/intellij/psi/PsiElement;", "startOffset", "isExtension", "Lorg/jetbrains/kotlin/idea/codeInsight/KotlinReferenceData$Kind;", "isInCopiedArea", "fileCopiedFrom", "Companion", "ReferenceToRestoreData", "idea"})
public final class KotlinCopyPasteReferenceProcessor
extends CopyPastePostProcessor<KotlinReferenceTransferableData> {
    private final Logger LOG = Logger.getInstance(KotlinCopyPasteReferenceProcessor.class);
    private final Class<? extends KtElement>[] IGNORE_REFERENCES_INSIDE = new Class[]{KtImportList.class, KtPackageDirective.class};
    @NotNull
    private static Collection<String> declarationsToImportSuggested;
    public static final Companion Companion;

    @NotNull
    public List<KotlinReferenceTransferableData> extractTransferableData(@NotNull Transferable content2) {
        Intrinsics.checkParameterIsNotNull((Object)content2, (String)"content");
        if (CodeInsightSettings.getInstance().ADD_IMPORTS_ON_PASTE != 2) {
            try {
                DataFlavor dataFlavor2 = KotlinReferenceData.Companion.getDataFlavor();
                if (dataFlavor2 == null) {
                    return CollectionsKt.emptyList();
                }
                DataFlavor flavor = dataFlavor2;
                Object object = content2.getTransferData(flavor);
                if (!(object instanceof KotlinReferenceTransferableData)) {
                    object = null;
                }
                KotlinReferenceTransferableData kotlinReferenceTransferableData = (KotlinReferenceTransferableData)object;
                if (kotlinReferenceTransferableData == null) {
                    return CollectionsKt.emptyList();
                }
                KotlinReferenceTransferableData data = kotlinReferenceTransferableData;
                return CollectionsKt.listOf((Object)data.clone());
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return CollectionsKt.emptyList();
    }

    @NotNull
    public List<KotlinReferenceTransferableData> collectTransferableData(@NotNull PsiFile file2, @NotNull Editor editor, @NotNull int[] startOffsets, @NotNull int[] endOffsets) {
        KotlinReferenceData[] kotlinReferenceDataArray;
        Collection $receiver$iv;
        List<KotlinReferenceData> list2;
        block10: {
            block9: {
                Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
                Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
                Intrinsics.checkParameterIsNotNull((Object)startOffsets, (String)"startOffsets");
                Intrinsics.checkParameterIsNotNull((Object)endOffsets, (String)"endOffsets");
                if (!(file2 instanceof KtFile)) break block9;
                DumbService dumbService = DumbService.getInstance((Project)file2.getProject());
                Intrinsics.checkExpressionValueIsNotNull((Object)dumbService, (String)"DumbService.getInstance(file.getProject())");
                if (!dumbService.isDumb()) break block10;
            }
            return CollectionsKt.emptyList();
        }
        try {
            list2 = this.collectReferenceData((KtFile)file2, startOffsets, endOffsets);
        }
        catch (ProcessCanceledException e) {
            this.LOG.debug("ProcessCanceledException while analyzing references in " + file2.getName() + ". References can't be processed.");
            return CollectionsKt.emptyList();
        }
        catch (Throwable e) {
            this.LOG.error("Exception in processing references for copy paste in file " + file2.getName() + '}', e);
            return CollectionsKt.emptyList();
        }
        List<KotlinReferenceData> collectedData = list2;
        if (collectedData.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Collection collection = $receiver$iv = (Collection)collectedData;
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection;
        KotlinReferenceData[] kotlinReferenceDataArray2 = thisCollection$iv.toArray(new KotlinReferenceData[0]);
        if (kotlinReferenceDataArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        KotlinReferenceData[] kotlinReferenceDataArray3 = kotlinReferenceDataArray = kotlinReferenceDataArray2;
        return CollectionsKt.listOf((Object)new KotlinReferenceTransferableData(kotlinReferenceDataArray3));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<KotlinReferenceData> collectReferenceData(@NotNull KtFile file2, @NotNull int[] startOffsets, @NotNull int[] endOffsets) {
        Object $receiver$iv;
        Object element$iv$iv2;
        Iterable $receiver$iv2;
        Object it;
        Iterable $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)startOffsets, (String)"startOffsets");
        Intrinsics.checkParameterIsNotNull((Object)endOffsets, (String)"endOffsets");
        List<TextRange> ranges = this.toTextRanges(startOffsets, endOffsets);
        Iterable $receiver$iv3 = ranges;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10)), (int)16);
        Iterable iterable = $receiver$iv3;
        Map entry = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv2 : $receiver$iv$iv) {
            void $receiver$iv$iv2;
            TextRange textRange = (TextRange)element$iv$iv2;
            Map map2 = entry;
            void var27_24 = it;
            it = (TextRange)element$iv$iv2;
            Iterable $receiver$iv22 = PsiUtilsKt.elementsInRange((PsiFile)file2, it);
            Iterable iterable2 = $receiver$iv22;
            Collection destination$iv$iv2 = new ArrayList();
            for (Object element$iv$iv3 : $receiver$iv$iv2) {
                PsiElement it2 = (PsiElement)element$iv$iv3;
                if (!(it2 instanceof KtElement || it2 instanceof KDocElement)) continue;
                destination$iv$iv2.add(element$iv$iv3);
            }
            List list2 = (List)destination$iv$iv2;
            map2.put(var27_24, list2);
        }
        Map elementsByRange = entry;
        $receiver$iv$iv = $receiver$iv2 = (Iterable)elementsByRange.values();
        Collection collection = new ArrayList();
        for (Object element$iv$iv2 : $receiver$iv$iv) {
            it = (List)element$iv$iv2;
            Iterable list$iv$iv = (Iterable)it;
            CollectionsKt.addAll((Collection)collection, (Iterable)list$iv$iv);
        }
        $receiver$iv2 = (List)collection;
        $receiver$iv$iv = $receiver$iv2;
        Collection collection2 = new ArrayList();
        for (Object element$iv$iv2 : $receiver$iv$iv) {
            void $receiver$iv$iv$iv;
            Object element$iv$iv3;
            it = (PsiElement)element$iv$iv2;
            $receiver$iv = it;
            Function1 predicate$iv = $special$$inlined$collectDescendantsOfType$1.INSTANCE;
            Object $receiver$iv$iv3 = $receiver$iv;
            ArrayList result$iv$iv = new ArrayList();
            element$iv$iv3 = $receiver$iv$iv3;
            Function1 action$iv$iv$iv = (Function1)new Function1<KtElement, Unit>(predicate$iv, result$iv$iv){
                final /* synthetic */ Function1 $predicate;
                final /* synthetic */ ArrayList $result;
                {
                    this.$predicate = function1;
                    this.$result = arrayList;
                    super(1);
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public final void invoke(@NotNull PsiElement it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    if (((Boolean)this.$predicate.invoke((Object)it)).booleanValue()) {
                        this.$result.add(it);
                    }
                }
            };
            $receiver$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv$iv$iv){
                final /* synthetic */ Function1 $action;
                {
                    this.$action = $captured_local_variable$1;
                }

                public void visitElement(@NotNull PsiElement element3) {
                    Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                    PsiElement it = element3;
                    super.visitElement(element3);
                    if (element3 instanceof KtElement) {
                        this.$action.invoke((Object)element3);
                    }
                }
            });
            Iterable list$iv$iv = result$iv$iv;
            CollectionsKt.addAll((Collection)collection2, (Iterable)list$iv$iv);
        }
        List allElementsToResolve = (List)collection2;
        BindingContext bindingContext2 = ResolutionUtils.getResolutionFacade(file2).analyze(allElementsToResolve, BodyResolveMode.PARTIAL);
        ArrayList result2 = new ArrayList();
        element$iv$iv2 = elementsByRange;
        for (Map.Entry entry2 : element$iv$iv2.entrySet()) {
            $receiver$iv = entry2;
            TextRange range = (TextRange)$receiver$iv.getKey();
            $receiver$iv = entry2;
            List elements2 = (List)$receiver$iv.getValue();
            for (PsiElement element3 : elements2) {
                this.addReferenceDataInsideElement(result2, element3, file2, RangeUtilsKt.getStart(range), startOffsets, endOffsets, bindingContext2);
            }
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final void addReferenceDataInsideElement(@NotNull Collection<KotlinReferenceData> $receiver, PsiElement element3, KtFile file2, int startOffset, int[] startOffsets, int[] endOffsets, BindingContext bindingContext2) {
        void $receiver$iv;
        if (PsiTreeUtil.getNonStrictParentOfType((PsiElement)element3, (Class[])Arrays.copyOf(this.IGNORE_REFERENCES_INSIDE, this.IGNORE_REFERENCES_INSIDE.length)) != null) {
            return;
        }
        PsiElement psiElement2 = element3;
        Function1 action$iv = (Function1)new Function1<KtElement, Unit>(this, $receiver, bindingContext2, file2, startOffsets, endOffsets, startOffset){
            final /* synthetic */ KotlinCopyPasteReferenceProcessor this$0;
            final /* synthetic */ Collection receiver$0;
            final /* synthetic */ BindingContext $bindingContext;
            final /* synthetic */ KtFile $file;
            final /* synthetic */ int[] $startOffsets;
            final /* synthetic */ int[] $endOffsets;
            final /* synthetic */ int $startOffset;

            public final void invoke(@NotNull KtElement element3) {
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                KtReference ktReference = ReferenceUtilKt.getMainReference(element3);
                if (ktReference == null) {
                    return;
                }
                KtReference reference2 = ktReference;
                Collection descriptors2 = KotlinCopyPasteReferenceProcessor.access$resolveReference(this.this$0, reference2, this.$bindingContext);
                if (!(reference2 instanceof KtMultiReference) && descriptors2.size() > 1) {
                    return;
                }
                for (DeclarationDescriptor descriptor2 : descriptors2) {
                    KotlinReferenceData.Kind kind2;
                    FqName fqName2;
                    Sequence effectiveReferencedDescriptors = CollectionsKt.asSequence((Iterable)DescriptorToSourceUtils.getEffectiveReferencedDescriptors(descriptor2));
                    PsiElement declaration2 = (PsiElement)SequencesKt.singleOrNull((Sequence)SequencesKt.map((Sequence)effectiveReferencedDescriptors, (Function1)addReferenceDataInsideElement.declaration.1.INSTANCE));
                    if (declaration2 != null && KotlinCopyPasteReferenceProcessor.access$isInCopiedArea(this.this$0, declaration2, this.$file, this.$startOffsets, this.$endOffsets) || !ReferenceUtilKt.canBeResolvedViaImport(reference2, descriptor2, this.$bindingContext)) continue;
                    if (ImportsUtils.getImportableFqName(descriptor2) == null) {
                        Intrinsics.throwNpe();
                    }
                    if (KotlinReferenceData.Kind.Companion.fromDescriptor(descriptor2) == null) {
                        continue;
                    }
                    int n = RangeUtilsKt.getStart(RangeUtilsKt.getRange((PsiElement)element3)) - this.$startOffset;
                    int n2 = RangeUtilsKt.getEnd(RangeUtilsKt.getRange((PsiElement)element3)) - this.$startOffset;
                    String string = fqName2.asString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fqName.asString()");
                    this.receiver$0.add(new KotlinReferenceData(n, n2, string, kind2));
                }
            }
            {
                this.this$0 = kotlinCopyPasteReferenceProcessor;
                this.receiver$0 = collection;
                this.$bindingContext = bindingContext2;
                this.$file = ktFile;
                this.$startOffsets = nArray;
                this.$endOffsets = nArray2;
                this.$startOffset = n;
                super(1);
            }
        };
        $receiver$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv, this){
            final /* synthetic */ Function1 $action;
            final /* synthetic */ KotlinCopyPasteReferenceProcessor this$0;
            {
                this.$action = $captured_local_variable$1;
                this.this$0 = kotlinCopyPasteReferenceProcessor;
            }

            public void visitElement(@NotNull PsiElement element3) {
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                PsiElement it = element3;
                Class<?> clazz = it.getClass();
                if (clazz == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.Class<*>");
                }
                if (!ArraysKt.contains((Object[])KotlinCopyPasteReferenceProcessor.access$getIGNORE_REFERENCES_INSIDE$p(this.this$0), clazz)) {
                    super.visitElement(element3);
                }
                if (element3 instanceof KtElement) {
                    this.$action.invoke((Object)element3);
                }
            }
        });
    }

    public void processTransferableData(@NotNull Project project, @NotNull Editor editor, @NotNull RangeMarker bounds, int caretOffset, @NotNull Ref<Boolean> indented, @NotNull List<KotlinReferenceTransferableData> values) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)bounds, (String)"bounds");
        Intrinsics.checkParameterIsNotNull(indented, (String)"indented");
        Intrinsics.checkParameterIsNotNull(values, (String)"values");
        DumbService dumbService = DumbService.getInstance((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)dumbService, (String)"DumbService.getInstance(project)");
        if (dumbService.isDumb()) {
            return;
        }
        Document document = editor.getDocument();
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (!(file2 instanceof KtFile)) {
            return;
        }
        KotlinReferenceData[] referenceData = ((KotlinReferenceTransferableData)CollectionsKt.single(values)).getData();
        this.processReferenceData(project, (KtFile)file2, bounds.getStartOffset(), referenceData);
    }

    public final void processReferenceData(@NotNull Project project, @NotNull KtFile file2, int blockStart, @NotNull KotlinReferenceData[] referenceData) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)referenceData, (String)"referenceData");
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        List<ReferenceToRestoreData> referencesPossibleToRestore = this.findReferencesToRestore((PsiFile)file2, blockStart, referenceData);
        Collection<ReferenceToRestoreData> selectedReferencesToRestore = this.showRestoreReferencesDialog(project, referencesPossibleToRestore);
        if (selectedReferencesToRestore.isEmpty()) {
            return;
        }
        ApplicationUtilsKt.runWriteAction((Function0)new Function0<Unit>(this, selectedReferencesToRestore, file2){
            final /* synthetic */ KotlinCopyPasteReferenceProcessor this$0;
            final /* synthetic */ Collection $selectedReferencesToRestore;
            final /* synthetic */ KtFile $file;

            public final void invoke() {
                KotlinCopyPasteReferenceProcessor.access$restoreReferences(this.this$0, this.$selectedReferencesToRestore, this.$file);
            }
            {
                this.this$0 = kotlinCopyPasteReferenceProcessor;
                this.$selectedReferencesToRestore = collection;
                this.$file = ktFile;
                super(0);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final List<ReferenceToRestoreData> findReferencesToRestore(PsiFile file2, int blockStart, KotlinReferenceData[] referenceData) {
        void $receiver$iv$iv;
        Iterable destination$iv$iv;
        BindingContext $receiver$iv;
        Object object;
        Object object2;
        Object object3;
        Iterable $receiver$iv$iv2;
        Object[] $receiver$iv2;
        if (!(file2 instanceof KtFile)) {
            return CollectionsKt.emptyList();
        }
        Object[] objectArray = $receiver$iv2 = (Object[])referenceData;
        Collection destination$iv$iv2 = new ArrayList($receiver$iv2.length);
        for (Iterator item$iv$iv : $receiver$iv$iv2) {
            void it;
            object3 = (KotlinReferenceData)((Object)item$iv$iv);
            object2 = destination$iv$iv2;
            object = TuplesKt.to((Object)it, (Object)this.findReference((KotlinReferenceData)it, (KtFile)file2, blockStart));
            object2.add(object);
        }
        List references2 = (List)destination$iv$iv2;
        try {
            void $receiver$iv$iv3;
            Iterator item$iv$iv;
            $receiver$iv$iv2 = references2;
            object2 = ResolutionUtils.getResolutionFacade((KtElement)file2);
            destination$iv$iv2 = $receiver$iv;
            destination$iv$iv = new ArrayList();
            void $receiver$iv$iv$iv = $receiver$iv$iv3;
            item$iv$iv = $receiver$iv$iv$iv.iterator();
            while (item$iv$iv.hasNext()) {
                KtElement ktElement;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = item$iv$iv.next();
                Pair it = (Pair)element$iv$iv;
                KtReference ktReference = (KtReference)it.getSecond();
                KtElement ktElement2 = ktReference != null ? ktReference.getElement() : null;
                if (ktElement2 == null) continue;
                KtElement it$iv$iv = ktElement = ktElement2;
                destination$iv$iv.add(it$iv$iv);
            }
            object = (List)destination$iv$iv;
            $receiver$iv = object2.analyze((Collection)object, BodyResolveMode.PARTIAL);
        }
        catch (Throwable e) {
            this.LOG.error("Failed to analyze references after copy paste", e);
            return CollectionsKt.emptyList();
        }
        BindingContext bindingContext2 = $receiver$iv;
        LexicalScope fileResolutionScope = ScopeUtils.getFileResolutionScope(ResolutionUtils.getResolutionFacade((KtElement)file2), (KtFile)file2);
        Iterable $receiver$iv3 = references2;
        destination$iv$iv = $receiver$iv3;
        Collection destination$iv$iv3 = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        object3 = $receiver$iv$iv$iv.iterator();
        while (object3.hasNext()) {
            ReferenceToRestoreData referenceToRestoreData;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object3.next();
            Pair pair2 = (Pair)element$iv$iv;
            KotlinReferenceData data = (KotlinReferenceData)pair2.getFirst();
            KtReference reference2 = (KtReference)pair2.getSecond();
            ReferenceToRestoreData referenceToRestoreData2 = reference2 != null ? this.createReferenceToRestoreData(reference2, data, (KtFile)file2, fileResolutionScope, bindingContext2) : null;
            if (referenceToRestoreData2 == null) continue;
            ReferenceToRestoreData it$iv$iv = referenceToRestoreData = referenceToRestoreData2;
            destination$iv$iv3.add(it$iv$iv);
        }
        return (List)destination$iv$iv3;
    }

    private final KtReference findReference(KotlinReferenceData data, KtFile file2, int blockStart) {
        int startOffset = data.getStartOffset() + blockStart;
        int endOffset = data.getEndOffset() + blockStart;
        PsiElement psiElement2 = file2.findElementAt(startOffset);
        if (psiElement2 == null) {
            return null;
        }
        PsiElement element3 = psiElement2;
        TextRange desiredRange = new TextRange(startOffset, endOffset);
        PsiElement psiElement3 = element3;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"element");
        for (PsiElement current : PsiUtilsKt.getParentsWithSelf(psiElement3)) {
            TextRange range = RangeUtilsKt.getRange(current);
            if (current instanceof KtElement && Intrinsics.areEqual((Object)range, (Object)desiredRange)) {
                KtReference ktReference = ReferenceUtilKt.getMainReference((KtElement)current);
                if (ktReference != null) {
                    KtReference ktReference2;
                    KtReference it = ktReference2 = ktReference;
                    return it;
                }
            }
            if (desiredRange.contains(range)) continue;
            return null;
        }
        return null;
    }

    private final ReferenceToRestoreData createReferenceToRestoreData(KtReference reference2, KotlinReferenceData refData, KtFile file2, LexicalScope fileResolutionScope, BindingContext bindingContext2) {
        boolean bl;
        block12: {
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv;
            FqName originalFqName = new FqName(refData.getFqName());
            Name name2 = originalFqName.shortName();
            if (refData.getKind() == KotlinReferenceData.Kind.EXTENSION_FUNCTION) {
                HierarchicalScope hierarchicalScope = fileResolutionScope;
                Name name3 = name2;
                Intrinsics.checkExpressionValueIsNotNull((Object)name3, (String)"name");
                if (ScopeUtilsKt.findFunction(hierarchicalScope, name3, NoLookupLocation.FROM_IDE, (Function1<? super FunctionDescriptor, Boolean>)((Function1)new Function1<FunctionDescriptor, Boolean>(originalFqName){
                    final /* synthetic */ FqName $originalFqName;

                    public final boolean invoke(@NotNull FunctionDescriptor it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        return Intrinsics.areEqual((Object)ImportsUtils.getImportableFqName(it), (Object)this.$originalFqName);
                    }
                    {
                        this.$originalFqName = fqName2;
                        super(1);
                    }
                })) != null) {
                    return null;
                }
            } else if (refData.getKind() == KotlinReferenceData.Kind.EXTENSION_PROPERTY) {
                HierarchicalScope hierarchicalScope = fileResolutionScope;
                Name name4 = name2;
                Intrinsics.checkExpressionValueIsNotNull((Object)name4, (String)"name");
                if (ScopeUtilsKt.findVariable(hierarchicalScope, name4, NoLookupLocation.FROM_IDE, (Function1<? super VariableDescriptor, Boolean>)((Function1)new Function1<VariableDescriptor, Boolean>(originalFqName){
                    final /* synthetic */ FqName $originalFqName;

                    public final boolean invoke(@NotNull VariableDescriptor it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        return Intrinsics.areEqual((Object)ImportsUtils.getImportableFqName(it), (Object)this.$originalFqName);
                    }
                    {
                        this.$originalFqName = fqName2;
                        super(1);
                    }
                })) != null) {
                    return null;
                }
            }
            Collection<DeclarationDescriptor> referencedDescriptors = this.resolveReference(reference2, bindingContext2);
            Iterable iterable = referencedDescriptors;
            Iterator iterator2 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                DeclarationDescriptor it = (DeclarationDescriptor)element$iv$iv;
                if (ErrorUtils.isError(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList();
            Iterable $receiver$iv$iv$iv = $receiver$iv$iv;
            for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                FqName fqName2;
                Object element$iv$iv = element$iv$iv$iv;
                DeclarationDescriptor it = (DeclarationDescriptor)element$iv$iv;
                if (ImportsUtils.getImportableFqName(it) == null) continue;
                FqName it$iv$iv = fqName2;
                destination$iv$iv.add(it$iv$iv);
            }
            Set referencedFqNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            if (Intrinsics.areEqual((Object)((FqName)CollectionsKt.singleOrNull((Iterable)referencedFqNames)), (Object)originalFqName)) {
                return null;
            }
            $receiver$iv = this.findImportableDescriptors(originalFqName, file2);
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $receiver$iv) {
                    DeclarationDescriptor it = (DeclarationDescriptor)element$iv;
                    if (!(KotlinReferenceData.Kind.Companion.fromDescriptor(it) == refData.getKind())) continue;
                    bl = false;
                    break block12;
                }
                bl = true;
            }
        }
        if (bl) {
            return null;
        }
        return new ReferenceToRestoreData(reference2, refData);
    }

    private final Collection<DeclarationDescriptor> resolveReference(KtReference reference2, BindingContext bindingContext2) {
        KtElement element3 = reference2.getElement();
        if (element3 instanceof KtNameReferenceExpression && reference2 instanceof KtSimpleNameReference) {
            ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters = (ClassifierDescriptorWithTypeParameters)bindingContext2.get(BindingContext.SHORT_REFERENCE_TO_COMPANION_OBJECT, element3);
            if (classifierDescriptorWithTypeParameters != null) {
                ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters2;
                ClassifierDescriptorWithTypeParameters it = classifierDescriptorWithTypeParameters2 = classifierDescriptorWithTypeParameters;
                return CollectionsKt.listOf((Object)it);
            }
        }
        return reference2.resolveToDescriptors(bindingContext2);
    }

    private final void restoreReferences(Collection<ReferenceToRestoreData> referencesToRestore, KtFile file2) {
        Project project = file2.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"file.project");
        ImportInsertHelper importHelper = ImportInsertHelper.Companion.getInstance(project);
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)file2.getProject());
        @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00001\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0006H\u00c6\u0003J(\u0010\u000e\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"org/jetbrains/kotlin/idea/codeInsight/KotlinCopyPasteReferenceProcessor$restoreReferences$BindingRequest", "", "pointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "(Lcom/intellij/psi/SmartPsiElementPointer;Lorg/jetbrains/kotlin/name/FqName;)V", "getFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "getPointer", "()Lcom/intellij/psi/SmartPsiElementPointer;", "component1", "component2", "copy", "(Lcom/intellij/psi/SmartPsiElementPointer;Lorg/jetbrains/kotlin/name/FqName;)Lorg/jetbrains/kotlin/idea/codeInsight/KotlinCopyPasteReferenceProcessor$restoreReferences$BindingRequest;", "equals", "", "other", "hashCode", "", "toString", "", "idea"})
        public final class BindingRequest {
            @NotNull
            private final SmartPsiElementPointer<KtSimpleNameExpression> pointer;
            @NotNull
            private final FqName fqName;

            @NotNull
            public final SmartPsiElementPointer<KtSimpleNameExpression> getPointer() {
                return this.pointer;
            }

            @NotNull
            public final FqName getFqName() {
                return this.fqName;
            }

            public BindingRequest(@NotNull SmartPsiElementPointer<KtSimpleNameExpression> pointer, @NotNull FqName fqName2) {
                Intrinsics.checkParameterIsNotNull(pointer, (String)"pointer");
                Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
                this.pointer = pointer;
                this.fqName = fqName2;
            }

            @NotNull
            public final SmartPsiElementPointer<KtSimpleNameExpression> component1() {
                return this.pointer;
            }

            @NotNull
            public final FqName component2() {
                return this.fqName;
            }

            @NotNull
            public final BindingRequest copy(@NotNull SmartPsiElementPointer<KtSimpleNameExpression> pointer, @NotNull FqName fqName2) {
                Intrinsics.checkParameterIsNotNull(pointer, (String)"pointer");
                Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
                return new BindingRequest(pointer, fqName2);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ BindingRequest copy$default(BindingRequest bindingRequest, SmartPsiElementPointer smartPsiElementPointer, FqName fqName2, int n, Object object) {
                if ((n & 1) != 0) {
                    smartPsiElementPointer = bindingRequest.pointer;
                }
                if ((n & 2) != 0) {
                    fqName2 = bindingRequest.fqName;
                }
                return bindingRequest.copy(smartPsiElementPointer, fqName2);
            }

            public String toString() {
                return "BindingRequest(pointer=" + this.pointer + ", fqName=" + this.fqName + ")";
            }

            public int hashCode() {
                SmartPsiElementPointer<KtSimpleNameExpression> smartPsiElementPointer = this.pointer;
                FqName fqName2 = this.fqName;
                return (smartPsiElementPointer != null ? smartPsiElementPointer.hashCode() : 0) * 31 + (fqName2 != null ? ((Object)fqName2).hashCode() : 0);
            }

            public boolean equals(Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof BindingRequest)) break block3;
                        BindingRequest bindingRequest = (BindingRequest)object;
                        if (!Intrinsics.areEqual(this.pointer, bindingRequest.pointer) || !Intrinsics.areEqual((Object)this.fqName, (Object)bindingRequest.fqName)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        ArrayList<BindingRequest> bindingRequests = new ArrayList<BindingRequest>();
        ArrayList<DeclarationDescriptor> descriptorsToImport = new ArrayList<DeclarationDescriptor>();
        for (ReferenceToRestoreData object : referencesToRestore) {
            KtReference reference2 = object.component1();
            KotlinReferenceData refData = object.component2();
            FqName fqName2 = new FqName(refData.getFqName());
            if (!this.isExtension(refData.getKind())) {
                if (reference2 instanceof KtSimpleNameReference) {
                    SmartPsiElementPointer pointer;
                    SmartPsiElementPointer smartPsiElementPointer = pointer = smartPointerManager.createSmartPsiElementPointer(((KtSimpleNameReference)reference2).getElement(), (PsiFile)file2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)smartPsiElementPointer, (String)"pointer");
                    bindingRequests.add(new BindingRequest((SmartPsiElementPointer<KtSimpleNameExpression>)smartPsiElementPointer, fqName2));
                } else if (reference2 instanceof KDocReference) {
                    descriptorsToImport.addAll(this.findImportableDescriptors(fqName2, file2));
                }
            }
            if (!this.isExtension(refData.getKind())) continue;
            org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull((Collection)descriptorsToImport, this.findCallableToImport(fqName2, file2));
        }
        Iterator<ReferenceToRestoreData> iterator2 = descriptorsToImport.iterator();
        while (iterator2.hasNext()) {
            DeclarationDescriptor declarationDescriptor;
            DeclarationDescriptor declarationDescriptor2 = declarationDescriptor = (DeclarationDescriptor)((Object)iterator2.next());
            Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor2, (String)"descriptor");
            ImportInsertHelper.importDescriptor$default(importHelper, file2, declarationDescriptor2, false, 4, null);
        }
        for (BindingRequest bindingRequest : bindingRequests) {
            SmartPsiElementPointer<KtSimpleNameExpression> pointer = bindingRequest.component1();
            FqName fqName3 = bindingRequest.component2();
            PsiElement psiElement2 = pointer.getElement();
            if (psiElement2 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"pointer.element!!");
            KtSimpleNameReference reference3 = ReferenceUtilKt.getMainReference((KtSimpleNameExpression)psiElement2);
            reference3.bindToFqName(fqName3, KtSimpleNameReference.ShorteningMode.DELAYED_SHORTENING);
        }
        Project project2 = file2.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"file.project");
        DelayedRequestsWaitingSetKt.performDelayedRefactoringRequests(project2);
    }

    private final boolean isExtension(@NotNull KotlinReferenceData.Kind $receiver) {
        return $receiver == KotlinReferenceData.Kind.EXTENSION_FUNCTION || $receiver == KotlinReferenceData.Kind.EXTENSION_PROPERTY;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<DeclarationDescriptor> findImportableDescriptors(FqName fqName2, KtFile file2) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)ResolutionUtils.resolveImportReference(file2, fqName2);
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            DeclarationDescriptor it = (DeclarationDescriptor)element$iv$iv;
            Object object = DescriptorUtils.getParentOfType(it, PackageFragmentDescriptor.class);
            if (object != null && (object = object.getFqName()) != null ? ((FqName)object).isRoot() : false) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final CallableDescriptor findCallableToImport(FqName fqName2, KtFile file2) {
        Object v0;
        block1: {
            Iterable $receiver$iv = this.findImportableDescriptors(fqName2, file2);
            for (Object element$iv : $receiver$iv) {
                if (!(element$iv instanceof CallableDescriptor)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<ReferenceToRestoreData> showRestoreReferencesDialog(Project project, List<ReferenceToRestoreData> referencesToRestore) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Object[] objectArray;
        void $receiver$iv2;
        boolean shouldShowDialog;
        void $receiver$iv$iv2;
        Iterable $receiver$iv3;
        Iterable iterable = $receiver$iv3 = (Iterable)referencesToRestore;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            void it;
            ReferenceToRestoreData referenceToRestoreData = (ReferenceToRestoreData)item$iv$iv;
            Collection collection = destination$iv$iv;
            String string = it.getRefData().getFqName();
            collection.add(string);
        }
        SortedSet fqNames = CollectionsKt.toSortedSet((Iterable)((List)destination$iv$iv));
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) {
            Companion.setDeclarationsToImportSuggested(fqNames);
        }
        boolean bl = shouldShowDialog = CodeInsightSettings.getInstance().ADD_IMPORTS_ON_PASTE == 3;
        if (!shouldShowDialog || referencesToRestore.isEmpty()) {
            return referencesToRestore;
        }
        destination$iv$iv = fqNames;
        Project project2 = project;
        void v2 = $receiver$iv2;
        if (v2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        void thisCollection$iv = v2;
        Object[] objectArray2 = thisCollection$iv.toArray(new String[0]);
        if (objectArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Object[] objectArray3 = objectArray = objectArray2;
        Project project3 = project2;
        RestoreReferencesDialog dialog2 = new RestoreReferencesDialog(project3, objectArray3);
        dialog2.show();
        Object[] objectArray4 = dialog2.getSelectedElements();
        if (objectArray4 == null) {
            Intrinsics.throwNpe();
        }
        Set selectedFqNames = ArraysKt.toSet((Object[])objectArray4);
        Iterable $i$f$toTypedArray = $receiver$iv = (Iterable)referencesToRestore;
        Collection destination$iv$iv2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            ReferenceToRestoreData it = (ReferenceToRestoreData)element$iv$iv;
            if (!selectedFqNames.contains(it.getRefData().getFqName())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        return (List)destination$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<TextRange> toTextRanges(int[] startOffsets, int[] endOffsets) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        boolean bl;
        boolean bl2 = bl = startOffsets.length == endOffsets.length;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Iterable iterable = $receiver$iv = (Iterable)ArraysKt.getIndices((int[])startOffsets);
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        Iterator iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            TextRange textRange = new TextRange(startOffsets[it], endOffsets[it]);
            collection.add(textRange);
        }
        return (List)destination$iv$iv;
    }

    private final boolean isInCopiedArea(@NotNull PsiElement $receiver, KtFile fileCopiedFrom, int[] startOffsets, int[] endOffsets) {
        boolean bl;
        block4: {
            if (Intrinsics.areEqual((Object)$receiver.getContainingFile(), (Object)fileCopiedFrom) ^ true) {
                return false;
            }
            Iterable $receiver$iv = this.toTextRanges(startOffsets, endOffsets);
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    TextRange it = (TextRange)element$iv;
                    if (!it.contains(RangeUtilsKt.getRange($receiver))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    static {
        Companion = new Companion(null);
        declarationsToImportSuggested = CollectionsKt.emptyList();
    }

    @NotNull
    public static final /* synthetic */ Collection access$resolveReference(KotlinCopyPasteReferenceProcessor $this, @NotNull KtReference reference2, @NotNull BindingContext bindingContext2) {
        return $this.resolveReference(reference2, bindingContext2);
    }

    public static final /* synthetic */ boolean access$isInCopiedArea(KotlinCopyPasteReferenceProcessor $this, @NotNull PsiElement $receiver, @NotNull KtFile fileCopiedFrom, @NotNull int[] startOffsets, @NotNull int[] endOffsets) {
        return $this.isInCopiedArea($receiver, fileCopiedFrom, startOffsets, endOffsets);
    }

    @NotNull
    public static final /* synthetic */ Class[] access$getIGNORE_REFERENCES_INSIDE$p(KotlinCopyPasteReferenceProcessor $this) {
        return $this.IGNORE_REFERENCES_INSIDE;
    }

    public static final /* synthetic */ void access$restoreReferences(KotlinCopyPasteReferenceProcessor $this, @NotNull Collection referencesToRestore, @NotNull KtFile file2) {
        $this.restoreReferences(referencesToRestore, file2);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/KotlinCopyPasteReferenceProcessor$ReferenceToRestoreData;", "", "reference", "Lorg/jetbrains/kotlin/idea/references/KtReference;", "refData", "Lorg/jetbrains/kotlin/idea/codeInsight/KotlinReferenceData;", "(Lorg/jetbrains/kotlin/idea/references/KtReference;Lorg/jetbrains/kotlin/idea/codeInsight/KotlinReferenceData;)V", "getRefData", "()Lorg/jetbrains/kotlin/idea/codeInsight/KotlinReferenceData;", "getReference", "()Lorg/jetbrains/kotlin/idea/references/KtReference;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "idea"})
    private static final class ReferenceToRestoreData {
        @NotNull
        private final KtReference reference;
        @NotNull
        private final KotlinReferenceData refData;

        @NotNull
        public final KtReference getReference() {
            return this.reference;
        }

        @NotNull
        public final KotlinReferenceData getRefData() {
            return this.refData;
        }

        public ReferenceToRestoreData(@NotNull KtReference reference2, @NotNull KotlinReferenceData refData) {
            Intrinsics.checkParameterIsNotNull((Object)reference2, (String)"reference");
            Intrinsics.checkParameterIsNotNull((Object)refData, (String)"refData");
            this.reference = reference2;
            this.refData = refData;
        }

        @NotNull
        public final KtReference component1() {
            return this.reference;
        }

        @NotNull
        public final KotlinReferenceData component2() {
            return this.refData;
        }

        @NotNull
        public final ReferenceToRestoreData copy(@NotNull KtReference reference2, @NotNull KotlinReferenceData refData) {
            Intrinsics.checkParameterIsNotNull((Object)reference2, (String)"reference");
            Intrinsics.checkParameterIsNotNull((Object)refData, (String)"refData");
            return new ReferenceToRestoreData(reference2, refData);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ ReferenceToRestoreData copy$default(ReferenceToRestoreData referenceToRestoreData, KtReference ktReference, KotlinReferenceData kotlinReferenceData, int n, Object object) {
            if ((n & 1) != 0) {
                ktReference = referenceToRestoreData.reference;
            }
            if ((n & 2) != 0) {
                kotlinReferenceData = referenceToRestoreData.refData;
            }
            return referenceToRestoreData.copy(ktReference, kotlinReferenceData);
        }

        public String toString() {
            return "ReferenceToRestoreData(reference=" + this.reference + ", refData=" + this.refData + ")";
        }

        public int hashCode() {
            KtReference ktReference = this.reference;
            KotlinReferenceData kotlinReferenceData = this.refData;
            return (ktReference != null ? ktReference.hashCode() : 0) * 31 + (kotlinReferenceData != null ? kotlinReferenceData.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ReferenceToRestoreData)) break block3;
                    ReferenceToRestoreData referenceToRestoreData = (ReferenceToRestoreData)object;
                    if (!Intrinsics.areEqual((Object)this.reference, (Object)referenceToRestoreData.reference) || !Intrinsics.areEqual((Object)this.refData, (Object)referenceToRestoreData.refData)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R$\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/KotlinCopyPasteReferenceProcessor$Companion;", "", "()V", "declarationsToImportSuggested", "", "", "getDeclarationsToImportSuggested", "()Ljava/util/Collection;", "setDeclarationsToImportSuggested", "(Ljava/util/Collection;)V", "idea"})
    public static final class Companion {
        @NotNull
        public final Collection<String> getDeclarationsToImportSuggested() {
            return declarationsToImportSuggested;
        }

        public final void setDeclarationsToImportSuggested(@NotNull Collection<String> collection) {
            Intrinsics.checkParameterIsNotNull(collection, (String)"<set-?>");
            declarationsToImportSuggested = collection;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

