/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.externalSystem.service.project.wizard.AbstractExternalModuleBuilder;
import com.intellij.openapi.externalSystem.service.project.wizard.ExternalModuleSettingsStep;
import com.intellij.openapi.externalSystem.service.settings.AbstractExternalProjectSettingsControl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinIcons;
import org.jetbrains.kotlin.idea.configuration.GradleKotlinFrameworkSupportProvider;
import org.jetbrains.kotlin.idea.configuration.GradleKotlinMPPCommonFrameworkSupportProvider;
import org.jetbrains.kotlin.idea.configuration.GradleKotlinMPPJSFrameworkSupportProvider;
import org.jetbrains.kotlin.idea.configuration.GradleKotlinMPPJavaFrameworkSupportProvider;
import org.jetbrains.kotlin.idea.configuration.KotlinGradleMultiplatformWizardStep;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtilKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.plugins.gradle.frameworkSupport.BuildScriptDataBuilder;
import org.jetbrains.plugins.gradle.service.project.wizard.GradleModuleBuilder;
import org.jetbrains.plugins.gradle.service.settings.GradleProjectSettingsControl;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J#\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J\b\u0010\u0014\u001a\u00020\u0004H\u0016J\b\u0010\u0015\u001a\u00020\u0004H\u0016J\u0010\u0010\u0016\u001a\n \u0018*\u0004\u0018\u00010\u00170\u0017H\u0016J\b\u0010\u0019\u001a\u00020\u0004H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J*\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u00042\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020&H\u0016R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\b\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinGradleMultiplatformModuleBuilder;", "Lorg/jetbrains/plugins/gradle/service/project/wizard/GradleModuleBuilder;", "()V", "jsModuleName", "", "getJsModuleName", "()Ljava/lang/String;", "setJsModuleName", "(Ljava/lang/String;)V", "jvmModuleName", "getJvmModuleName", "setJvmModuleName", "createWizardSteps", "", "Lcom/intellij/ide/util/projectWizard/ModuleWizardStep;", "wizardContext", "Lcom/intellij/ide/util/projectWizard/WizardContext;", "modulesProvider", "Lcom/intellij/openapi/roots/ui/configuration/ModulesProvider;", "(Lcom/intellij/ide/util/projectWizard/WizardContext;Lcom/intellij/openapi/roots/ui/configuration/ModulesProvider;)[Lcom/intellij/ide/util/projectWizard/ModuleWizardStep;", "getBuilderId", "getDescription", "getNodeIcon", "Ljavax/swing/Icon;", "kotlin.jvm.PlatformType", "getPresentableName", "setupModule", "", "module", "Lcom/intellij/openapi/module/Module;", "setupPlatformModule", "contentRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "platformModuleName", "supportProvider", "Lorg/jetbrains/kotlin/idea/configuration/GradleKotlinFrameworkSupportProvider;", "setupRootModel", "modifiableRootModel", "Lcom/intellij/openapi/roots/ModifiableRootModel;", "idea-gradle"})
public final class KotlinGradleMultiplatformModuleBuilder
extends GradleModuleBuilder {
    @Nullable
    private String jvmModuleName;
    @Nullable
    private String jsModuleName;

    @Nullable
    public final String getJvmModuleName() {
        return this.jvmModuleName;
    }

    public final void setJvmModuleName(@Nullable String string) {
        this.jvmModuleName = string;
    }

    @Nullable
    public final String getJsModuleName() {
        return this.jsModuleName;
    }

    public final void setJsModuleName(@Nullable String string) {
        this.jsModuleName = string;
    }

    @NotNull
    public String getBuilderId() {
        return "kotlin.gradle.multiplatform";
    }

    public Icon getNodeIcon() {
        return KotlinIcons.MPP;
    }

    @NotNull
    public String getPresentableName() {
        return "Kotlin (Multiplatform - Experimental)";
    }

    @NotNull
    public String getDescription() {
        return "Multiplatform projects allow reusing the same code between multiple platforms supported by Kotlin. Such projects are built with Gradle.";
    }

    @NotNull
    public ModuleWizardStep[] createWizardSteps(@NotNull WizardContext wizardContext, @NotNull ModulesProvider modulesProvider) {
        Intrinsics.checkParameterIsNotNull((Object)wizardContext, (String)"wizardContext");
        Intrinsics.checkParameterIsNotNull((Object)modulesProvider, (String)"modulesProvider");
        super.createWizardSteps(wizardContext, modulesProvider);
        return new ModuleWizardStep[]{new KotlinGradleMultiplatformWizardStep(this, wizardContext), (ModuleWizardStep)new ExternalModuleSettingsStep(wizardContext, (AbstractExternalModuleBuilder)this, (AbstractExternalProjectSettingsControl)new GradleProjectSettingsControl((GradleProjectSettings)this.getExternalProjectSettings()))};
    }

    public void setupRootModel(@NotNull ModifiableRootModel modifiableRootModel) {
        Intrinsics.checkParameterIsNotNull((Object)modifiableRootModel, (String)"modifiableRootModel");
        super.setupRootModel(modifiableRootModel);
        Module module = modifiableRootModel.getModule();
        BuildScriptDataBuilder buildScriptDataBuilder = GradleModuleBuilder.getBuildScriptData((Module)module);
        if (buildScriptDataBuilder == null) {
            return;
        }
        BuildScriptDataBuilder buildScriptData = buildScriptDataBuilder;
        Sdk sdk = modifiableRootModel.getSdk();
        GradleKotlinMPPCommonFrameworkSupportProvider gradleKotlinMPPCommonFrameworkSupportProvider = new GradleKotlinMPPCommonFrameworkSupportProvider();
        BuildScriptDataBuilder buildScriptDataBuilder2 = buildScriptData;
        Intrinsics.checkExpressionValueIsNotNull((Object)buildScriptDataBuilder2, (String)"buildScriptData");
        gradleKotlinMPPCommonFrameworkSupportProvider.addSupport(buildScriptDataBuilder2, sdk);
    }

    protected void setupModule(@NotNull Module module) {
        block1: {
            VirtualFile virtualFile2;
            VirtualFile settingsGradle;
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            super.setupModule(module);
            VirtualFile[] virtualFileArray = ProjectRootsUtilKt.getRootManager(module).getContentRoots();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileArray, (String)"module.rootManager.contentRoots");
            VirtualFile virtualFile3 = (VirtualFile)ArraysKt.firstOrNull((Object[])virtualFileArray);
            if (virtualFile3 == null) {
                return;
            }
            VirtualFile contentRoot = virtualFile3;
            this.setupPlatformModule(module, contentRoot, this.jvmModuleName, new GradleKotlinMPPJavaFrameworkSupportProvider());
            this.setupPlatformModule(module, contentRoot, this.jsModuleName, new GradleKotlinMPPJSFrameworkSupportProvider());
            VirtualFile virtualFile4 = settingsGradle = contentRoot.findChild("settings.gradle");
            if (virtualFile4 == null) break block1;
            VirtualFile it = virtualFile2 = virtualFile4;
            Project project = module.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"module.project");
            ApplicationUtilsKt.executeCommand$default(project, "Update settings.gradle", null, (Function0)new Function0<Unit>(it, this, module){
                final /* synthetic */ VirtualFile $it;
                final /* synthetic */ KotlinGradleMultiplatformModuleBuilder this$0;
                final /* synthetic */ Module $module$inlined;
                {
                    this.$it = virtualFile2;
                    this.this$0 = kotlinGradleMultiplatformModuleBuilder;
                    this.$module$inlined = module;
                    super(0);
                }

                public final void invoke() {
                    Document doc;
                    Document document = FileDocumentManager.getInstance().getDocument(this.$it);
                    if (document == null) {
                        return;
                    }
                    Document document2 = doc = document;
                    Intrinsics.checkExpressionValueIsNotNull((Object)document2, (String)"doc");
                    doc.insertString(document2.getTextLength(), (CharSequence)("include '" + this.this$0.getJvmModuleName() + "', '" + this.this$0.getJsModuleName() + '\''));
                    FileDocumentManager.getInstance().saveDocument(doc);
                }
            }, 2, null);
        }
    }

    private final void setupPlatformModule(Module module, VirtualFile contentRoot, String platformModuleName, GradleKotlinFrameworkSupportProvider supportProvider) {
        CharSequence charSequence = platformModuleName;
        if (charSequence == null || charSequence.length() == 0) {
            return;
        }
        Sdk sdk = ProjectRootsUtilKt.getRootManager(module).getSdk();
        String string = platformModuleName;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        VirtualFile moduleDir = contentRoot.createChildDirectory((Object)this, string);
        VirtualFile buildGradle = moduleDir.createChildData(null, "build.gradle");
        BuildScriptDataBuilder buildScriptData = new BuildScriptDataBuilder(buildGradle);
        supportProvider.addSupport(buildScriptData, sdk);
        buildScriptData.addDependencyNotation("expectedBy project(\":\")");
        VfsUtil.saveText((VirtualFile)buildGradle, (String)(buildScriptData.buildConfigurationPart() + buildScriptData.buildMainPart()));
    }
}

