/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProviderImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.config.KotlinFacetSettings;
import org.jetbrains.kotlin.config.TargetPlatformKind;
import org.jetbrains.kotlin.idea.compiler.configuration.Kotlin2JvmCompilerArgumentsHolder;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.KotlinJavaModuleConfigurator;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;
import org.jetbrains.kotlin.idea.configuration.KotlinWithLibraryConfigurator;
import org.jetbrains.kotlin.idea.configuration.NotificationMessageCollector;
import org.jetbrains.kotlin.idea.facet.FacetUtilsKt;
import org.jetbrains.kotlin.idea.facet.KotlinFacet;
import org.jetbrains.kotlin.idea.facet.KotlinFacetConfiguration;
import org.jetbrains.kotlin.idea.framework.JavaRuntimeLibraryDescription;
import org.jetbrains.kotlin.idea.framework.JsLibraryStdDetectionUtil;
import org.jetbrains.kotlin.idea.util.projectStructure.ProjectStructureUtilKt;
import org.jetbrains.kotlin.idea.versions.LibraryJarDescriptor;
import org.jetbrains.kotlin.resolve.TargetPlatform;
import org.jetbrains.kotlin.resolve.jvm.platform.JvmPlatform;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 02\u00020\u0001:\u00010B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0014J:\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020\fH\u0016J\u0018\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u001e2\b\u0010+\u001a\u0004\u0018\u00010,H\u0016J\u0010\u0010-\u001a\u00020\f2\u0006\u0010!\u001a\u00020\u001fH\u0002J\u0010\u0010.\u001a\u00020\f2\u0006\u0010!\u001a\u00020\u001fH\u0014J\u0010\u0010/\u001a\u00020\f2\u0006\u0010!\u001a\u00020\u001fH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R \u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0006R\u0014\u0010\u0011\u001a\u00020\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0006R\u0014\u0010\u0013\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0006R\u0014\u0010\u0015\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0006R\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u00061"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinJavaModuleConfigurator;", "Lorg/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator;", "()V", "dialogTitle", "", "getDialogTitle", "()Ljava/lang/String;", "libraryCaption", "getLibraryCaption", "libraryMatcher", "Lkotlin/Function1;", "Lcom/intellij/openapi/roots/libraries/Library;", "", "getLibraryMatcher", "()Lkotlin/jvm/functions/Function1;", "libraryName", "getLibraryName", "messageForOverrideDialog", "getMessageForOverrideDialog", "name", "getName", "presentableText", "getPresentableText", "targetPlatform", "Lorg/jetbrains/kotlin/resolve/TargetPlatform;", "getTargetPlatform", "()Lorg/jetbrains/kotlin/resolve/TargetPlatform;", "configureKotlinSettings", "", "modules", "", "Lcom/intellij/openapi/module/Module;", "configureModule", "module", "classesPath", "sourcesPath", "collector", "Lorg/jetbrains/kotlin/idea/configuration/NotificationMessageCollector;", "forceJarState", "Lorg/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator$FileState;", "useBundled", "getLibraryJarDescriptors", "Lorg/jetbrains/kotlin/idea/versions/LibraryJarDescriptor;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "hasBrokenJsRuntime", "isApplicable", "isConfigured", "Companion", "idea-jvm"})
public class KotlinJavaModuleConfigurator
extends KotlinWithLibraryConfigurator {
    @NotNull
    private final Function1<Library, Boolean> libraryMatcher = libraryMatcher.1.INSTANCE;
    @NotNull
    public static final String NAME = "java";
    public static final Companion Companion = new Companion(null);

    @Override
    protected boolean isApplicable(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        return super.isApplicable(module) && !this.hasBrokenJsRuntime(module);
    }

    @Override
    public boolean isConfigured(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        return ConfigureKotlinInProjectUtilsKt.hasKotlinJvmRuntimeInScope(module);
    }

    @Override
    @NotNull
    protected String getLibraryName() {
        return JavaRuntimeLibraryDescription.Companion.getLIBRARY_NAME();
    }

    @Override
    @NotNull
    protected String getDialogTitle() {
        return JavaRuntimeLibraryDescription.Companion.getDIALOG_TITLE();
    }

    @Override
    @NotNull
    protected String getLibraryCaption() {
        return JavaRuntimeLibraryDescription.Companion.getLIBRARY_CAPTION();
    }

    @Override
    @NotNull
    protected String getMessageForOverrideDialog() {
        return JavaRuntimeLibraryDescription.Companion.getJAVA_RUNTIME_LIBRARY_CREATION();
    }

    @Override
    @NotNull
    public String getPresentableText() {
        return "Java";
    }

    @Override
    @NotNull
    public String getName() {
        return NAME;
    }

    @Override
    @NotNull
    public TargetPlatform getTargetPlatform() {
        return JvmPlatform.INSTANCE;
    }

    @Override
    @NotNull
    public List<LibraryJarDescriptor> getLibraryJarDescriptors(@Nullable Sdk sdk) {
        List result2 = CollectionsKt.listOf((Object[])new LibraryJarDescriptor[]{LibraryJarDescriptor.RUNTIME_JAR, LibraryJarDescriptor.RUNTIME_SRC_JAR, LibraryJarDescriptor.REFLECT_JAR, LibraryJarDescriptor.REFLECT_SRC_JAR, LibraryJarDescriptor.TEST_JAR, LibraryJarDescriptor.TEST_SRC_JAR});
        Sdk sdk2 = sdk;
        if (sdk2 == null || (sdk2 = ProjectStructureUtilKt.getVersion(sdk2)) == null) {
            return result2;
        }
        Sdk sdkVersion = sdk2;
        if (sdkVersion.isAtLeast(JavaSdkVersion.JDK_1_7)) {
            result2 = CollectionsKt.plus((Collection)result2, (Iterable)CollectionsKt.listOf((Object[])new LibraryJarDescriptor[]{LibraryJarDescriptor.RUNTIME_JDK7_JAR, LibraryJarDescriptor.RUNTIME_JDK7_SOURCES_JAR}));
        }
        if (sdkVersion.isAtLeast(JavaSdkVersion.JDK_1_8)) {
            result2 = CollectionsKt.plus((Collection)result2, (Iterable)CollectionsKt.listOf((Object[])new LibraryJarDescriptor[]{LibraryJarDescriptor.RUNTIME_JDK8_JAR, LibraryJarDescriptor.RUNTIME_JDK8_SOURCES_JAR}));
        }
        return result2;
    }

    @Override
    @NotNull
    protected Function1<Library, Boolean> getLibraryMatcher() {
        return this.libraryMatcher;
    }

    @Override
    protected void configureKotlinSettings(@NotNull List<? extends Module> modules) {
        boolean canChangeProjectSettings;
        Module project;
        block8: {
            boolean bl;
            Intrinsics.checkParameterIsNotNull(modules, (String)"modules");
            Module module = (Module)CollectionsKt.firstOrNull(modules);
            if (module == null || (module = module.getProject()) == null) {
                return;
            }
            Module module2 = project = module;
            Intrinsics.checkExpressionValueIsNotNull((Object)module2, (String)"project");
            Iterable iterable = ProjectStructureUtilKt.allModules((Project)module2);
            if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : iterable) {
                    Module it;
                    Module module3 = it = (Module)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)module3, (String)"it");
                    Sdk sdk = ProjectStructureUtilKt.getSdk(module3);
                    if (sdk != null && (sdk = ProjectStructureUtilKt.getVersion(sdk)) != null ? sdk.isAtLeast(JavaSdkVersion.JDK_1_8) : true) continue;
                    bl = false;
                    break block8;
                }
                bl = canChangeProjectSettings = true;
            }
        }
        if (canChangeProjectSettings) {
            Kotlin2JvmCompilerArgumentsHolder.Companion.getInstance((Project)project).update(configureKotlinSettings.1.INSTANCE);
        } else {
            for (Module module : modules) {
                Sdk sdk = ProjectStructureUtilKt.getSdk(module);
                Object sdkVersion = sdk != null ? ProjectStructureUtilKt.getVersion(sdk) : null;
                if (sdkVersion == null || !sdkVersion.isAtLeast(JavaSdkVersion.JDK_1_8)) continue;
                IdeModifiableModelsProviderImpl modelsProvider = new IdeModifiableModelsProviderImpl((Project)project);
                KotlinFacet facet = FacetUtilsKt.getOrCreateFacet(module, (IdeModifiableModelsProvider)modelsProvider, false, true);
                KotlinFacetSettings facetSettings = ((KotlinFacetConfiguration)facet.getConfiguration()).getSettings();
                FacetUtilsKt.initializeIfNeeded$default(facetSettings, module, null, new TargetPlatformKind.Jvm(JvmTarget.JVM_1_8), null, 8, null);
                CommonCompilerArguments commonCompilerArguments = facetSettings.getCompilerArguments();
                if (!(commonCompilerArguments instanceof K2JVMCompilerArguments)) {
                    commonCompilerArguments = null;
                }
                K2JVMCompilerArguments k2JVMCompilerArguments = (K2JVMCompilerArguments)commonCompilerArguments;
                if (k2JVMCompilerArguments == null) continue;
                k2JVMCompilerArguments.setJvmTarget("1.8");
            }
        }
    }

    @Override
    public void configureModule(@NotNull Module module, @NotNull String classesPath, @NotNull String sourcesPath, @NotNull NotificationMessageCollector collector2, @Nullable KotlinWithLibraryConfigurator.FileState forceJarState, boolean useBundled) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)classesPath, (String)"classesPath");
        Intrinsics.checkParameterIsNotNull((Object)sourcesPath, (String)"sourcesPath");
        Intrinsics.checkParameterIsNotNull((Object)collector2, (String)"collector");
        super.configureModule(module, classesPath, sourcesPath, collector2, forceJarState, useBundled);
        ConfigureKotlinInProjectUtilsKt.addStdlibToJavaModuleInfo(module, collector2);
    }

    private final boolean hasBrokenJsRuntime(Module module) {
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(module)");
        for (OrderEntry orderEntry : moduleRootManager.getOrderEntries()) {
            LibraryEx library2;
            OrderEntry orderEntry2 = orderEntry;
            if (!(orderEntry2 instanceof LibraryOrderEntry)) {
                orderEntry2 = null;
            }
            LibraryOrderEntry libraryOrderEntry = (LibraryOrderEntry)orderEntry2;
            Object object = libraryOrderEntry != null ? libraryOrderEntry.getLibrary() : null;
            if (!(object instanceof LibraryEx)) {
                object = null;
            }
            if ((LibraryEx)object == null) {
                continue;
            }
            if (!JsLibraryStdDetectionUtil.INSTANCE.hasJsStdlibJar((Library)library2, true)) continue;
            return true;
        }
        return false;
    }

    protected KotlinJavaModuleConfigurator() {
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinJavaModuleConfigurator$Companion;", "", "()V", "NAME", "", "instance", "Lorg/jetbrains/kotlin/idea/configuration/KotlinJavaModuleConfigurator;", "getInstance", "()Lorg/jetbrains/kotlin/idea/configuration/KotlinJavaModuleConfigurator;", "idea-jvm"})
    public static final class Companion {
        @NotNull
        public final KotlinJavaModuleConfigurator getInstance() {
            Object object = Extensions.findExtension(KotlinProjectConfigurator.Companion.getEP_NAME(), KotlinJavaModuleConfigurator.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"Extensions.findExtension\u2026Configurator::class.java)");
            return (KotlinJavaModuleConfigurator)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

