/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script;

import com.intellij.execution.configurations.CommandLineTokenizer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.tooling.ProjectConnection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.script.GradleScriptDefinitionsContributor;
import org.jetbrains.kotlin.idea.core.script.ScriptDefinitionContributor;
import org.jetbrains.kotlin.idea.core.script.ScriptDefinitionsManager;
import org.jetbrains.kotlin.idea.core.script.ScriptDefinitionsManagerKt;
import org.jetbrains.kotlin.script.KotlinScriptDefinition;
import org.jetbrains.plugins.gradle.config.GradleSettingsListenerAdapter;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionHelper;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettingsListener;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JG\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102'\u0010\u0011\u001a#\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\f0\u0012H\u0002J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00130\f2\u0006\u0010\u0016\u001a\u00020\u0013H\u0002J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002JG\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102'\u0010\u0011\u001a#\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\f0\u0012H\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\u0006\u0010\u001d\u001a\u00020\u001cJ\b\u0010\u001e\u001a\u00020\u001cH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/GradleScriptDefinitionsContributor;", "Lorg/jetbrains/kotlin/idea/core/script/ScriptDefinitionContributor;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "failedToLoad", "Ljava/util/concurrent/atomic/AtomicBoolean;", "id", "", "getId", "()Ljava/lang/String;", "doLoadGradleTemplates", "", "Lorg/jetbrains/kotlin/script/KotlinScriptDefinition;", "templateClass", "dependencySelector", "Lkotlin/text/Regex;", "additionalResolverClasspath", "Lkotlin/Function1;", "Ljava/io/File;", "Lkotlin/ParameterName;", "name", "gradleLibDir", "getDefinitions", "kotlinStdlibAndCompiler", "loadDefinitions", "loadGradleTemplates", "reload", "", "reloadIfNeccessary", "subscribeToGradleSettingChanges", "idea-gradle"})
public final class GradleScriptDefinitionsContributor
implements ScriptDefinitionContributor {
    @NotNull
    private final String id = "Gradle Kotlin DSL";
    private final AtomicBoolean failedToLoad;
    private final Project project;

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    private final void subscribeToGradleSettingChanges() {
        GradleSettingsListenerAdapter listener2 = new GradleSettingsListenerAdapter(this){
            final /* synthetic */ GradleScriptDefinitionsContributor this$0;

            public void onGradleVmOptionsChange(@Nullable String oldOptions, @Nullable String newOptions) {
                GradleScriptDefinitionsContributor.access$reload(this.this$0);
            }

            public void onGradleHomeChange(@Nullable String oldPath, @Nullable String newPath, @NotNull String linkedProjectPath) {
                Intrinsics.checkParameterIsNotNull((Object)linkedProjectPath, (String)"linkedProjectPath");
                GradleScriptDefinitionsContributor.access$reload(this.this$0);
            }

            public void onServiceDirectoryPathChange(@Nullable String oldPath, @Nullable String newPath) {
                GradleScriptDefinitionsContributor.access$reload(this.this$0);
            }

            public void onGradleDistributionTypeChange(@Nullable DistributionType currentValue, @NotNull String linkedProjectPath) {
                Intrinsics.checkParameterIsNotNull((Object)linkedProjectPath, (String)"linkedProjectPath");
                GradleScriptDefinitionsContributor.access$reload(this.this$0);
            }
            {
                this.this$0 = $outer;
            }
        };
        this.project.getMessageBus().connect((Disposable)this.project).subscribe(GradleSettingsListener.TOPIC, (Object)listener2);
    }

    @Override
    @NotNull
    public List<KotlinScriptDefinition> getDefinitions() {
        List<KotlinScriptDefinition> definitions = this.loadDefinitions();
        this.failedToLoad.set(definitions.isEmpty());
        return definitions;
    }

    private final List<KotlinScriptDefinition> loadDefinitions() {
        Regex kotlinDslDependencySelector = new Regex("^gradle-(?:kotlin-dsl|core).*\\.jar$");
        Function1<File, List<? extends File>> kotlinDslAdditionalResolverCp2 = new Function1<File, List<? extends File>>(this){

            @NotNull
            public final List<File> invoke(@NotNull File p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                return GradleScriptDefinitionsContributor.access$kotlinStdlibAndCompiler((GradleScriptDefinitionsContributor)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(GradleScriptDefinitionsContributor.class);
            }

            public final String getName() {
                return "kotlinStdlibAndCompiler";
            }

            public final String getSignature() {
                return "kotlinStdlibAndCompiler(Ljava/io/File;)Ljava/util/List;";
            }
        };
        List kotlinDslTemplates = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)this.loadGradleTemplates("org.gradle.kotlin.dsl.KotlinInitScript", kotlinDslDependencySelector, (Function1<? super File, ? extends List<? extends File>>)((Function1)kotlinDslAdditionalResolverCp2)), (Iterable)this.loadGradleTemplates("org.gradle.kotlin.dsl.KotlinSettingsScript", kotlinDslDependencySelector, (Function1<? super File, ? extends List<? extends File>>)((Function1)kotlinDslAdditionalResolverCp2))), (Iterable)this.loadGradleTemplates("org.gradle.kotlin.dsl.KotlinBuildScript", kotlinDslDependencySelector, (Function1<? super File, ? extends List<? extends File>>)((Function1)kotlinDslAdditionalResolverCp2)));
        Collection collection = kotlinDslTemplates;
        if (!collection.isEmpty()) {
            return kotlinDslTemplates;
        }
        List<KotlinScriptDefinition> gradleScriptKotlinLegacyTemplates2 = this.loadGradleTemplates("org.gradle.script.lang.kotlin.KotlinBuildScript", new Regex("^gradle-(?:script-kotlin|core).*\\.jar$"), (Function1<? super File, ? extends List<? extends File>>)((Function1)loadDefinitions.gradleScriptKotlinLegacyTemplates.1.INSTANCE));
        return gradleScriptKotlinLegacyTemplates2;
    }

    private final List<File> kotlinStdlibAndCompiler(File gradleLibDir) {
        Object object;
        List list2;
        File file2;
        File[] fileArray = gradleLibDir.listFiles(kotlinStdlibAndCompiler.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)fileArray, (String)"gradleLibDir.listFiles {\u2026tsWith(\"kotlin-stdlib\") }");
        File file3 = (File)ArraysKt.firstOrNull((Object[])fileArray);
        if (file3 != null) {
            File p1 = file2 = file3;
            list2 = CollectionsKt.listOf((Object)p1);
        } else {
            list2 = null;
        }
        if ((object = (file2 = list2)) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private final List<KotlinScriptDefinition> loadGradleTemplates(String templateClass2, Regex dependencySelector, Function1<? super File, ? extends List<? extends File>> additionalResolverClasspath) {
        List<KotlinScriptDefinition> list2;
        try {
            list2 = this.doLoadGradleTemplates(templateClass2, dependencySelector, additionalResolverClasspath);
        }
        catch (Throwable t) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    private final List<KotlinScriptDefinition> doLoadGradleTemplates(String templateClass2, Regex dependencySelector, Function1<? super File, ? extends List<? extends File>> additionalResolverClasspath) {
        Object[] objectArray;
        File file2;
        GradleExecutionSettings gradleExeSettings;
        Function1<GradleExecutionSettings, Map<String, ? extends Object>> createEnvironment$ = new Function1<GradleExecutionSettings, Map<String, ? extends Object>>(this){
            final /* synthetic */ GradleScriptDefinitionsContributor this$0;

            @NotNull
            public final Map<String, Object> invoke(@NotNull GradleExecutionSettings gradleExeSettings) {
                File file2;
                File file3;
                File file4;
                String p1;
                Pair[] pairArray;
                Pair[] pairArray2;
                int n;
                String string;
                String string2;
                Object object;
                block14: {
                    block13: {
                        Iterable $receiver$iv$iv;
                        Iterable $receiver$iv;
                        Intrinsics.checkParameterIsNotNull((Object)gradleExeSettings, (String)"gradleExeSettings");
                        object = gradleExeSettings.getDaemonVmOptions();
                        if (object == null) break block13;
                        String vmOptions = string2 = object;
                        Object object2 = (Enumeration)new CommandLineTokenizer(vmOptions);
                        ArrayList<T> arrayList = Collections.list(object2);
                        Intrinsics.checkExpressionValueIsNotNull(arrayList, (String)"java.util.Collections.list(this)");
                        object2 = arrayList;
                        void var6_5 = $receiver$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        void $receiver$iv$iv$iv = $receiver$iv$iv;
                        for (T element$iv$iv$iv : $receiver$iv$iv$iv) {
                            String string3;
                            String string4;
                            T element$iv$iv = element$iv$iv$iv;
                            T it = element$iv$iv;
                            if (it != null) {
                                T t;
                                T it2 = t;
                                T t2 = it2;
                                if (!(t2 instanceof String)) {
                                    t2 = null;
                                }
                                string4 = (String)t2;
                            } else {
                                string4 = null;
                            }
                            if (string4 == null) continue;
                            String it$iv$iv = string3 = string4;
                            destination$iv$iv.add(it$iv$iv);
                        }
                        $receiver$iv = (List)destination$iv$iv;
                        $receiver$iv$iv = $receiver$iv;
                        destination$iv$iv = new ArrayList<E>();
                        for (T element$iv$iv : $receiver$iv$iv) {
                            String p12 = (String)element$iv$iv;
                            if (StringsKt.isBlank((CharSequence)p12)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        object = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
                        if (object != null) break block14;
                    }
                    object = CollectionsKt.emptyList();
                }
                Object gradleJvmOptions = object;
                Pair[] pairArray3 = new Pair[6];
                Pair[] pairArray4 = pairArray3;
                Pair[] pairArray5 = pairArray3;
                int n2 = 0;
                String string5 = "gradleHome";
                String string6 = gradleExeSettings.getGradleHome();
                if (string6 != null) {
                    string2 = string6;
                    string = string5;
                    n = n2;
                    pairArray2 = pairArray4;
                    pairArray = pairArray5;
                    p1 = string2;
                    file4 = new File(p1);
                    pairArray5 = pairArray;
                    pairArray4 = pairArray2;
                    n2 = n;
                    string5 = string;
                    file3 = file4;
                } else {
                    file3 = null;
                }
                pairArray4[n2] = TuplesKt.to((Object)string5, file3);
                Pair[] pairArray6 = pairArray5;
                Pair[] pairArray7 = pairArray5;
                int n3 = 1;
                String string7 = "projectRoot";
                String string8 = GradleScriptDefinitionsContributor.access$getProject$p(this.this$0).getBasePath();
                if (string8 == null) {
                    VirtualFile virtualFile2 = GradleScriptDefinitionsContributor.access$getProject$p(this.this$0).getBaseDir();
                    Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"project.baseDir");
                    string8 = virtualFile2.getCanonicalPath();
                }
                if (string8 != null) {
                    string2 = string8;
                    string = string7;
                    n = n3;
                    pairArray2 = pairArray6;
                    pairArray = pairArray7;
                    p1 = string2;
                    file4 = new File(p1);
                    pairArray7 = pairArray;
                    pairArray6 = pairArray2;
                    n3 = n;
                    string7 = string;
                    file2 = file4;
                } else {
                    file2 = null;
                }
                pairArray6[n3] = TuplesKt.to((Object)string7, file2);
                pairArray7[2] = TuplesKt.to((Object)"gradleWithConnection", (Object)new Function1<Function1<? super ProjectConnection, ? extends Unit>, Unit>(this){
                    final /* synthetic */ doLoadGradleTemplates.1 this$0;

                    public final Unit invoke(@NotNull Function1<? super ProjectConnection, Unit> action2) {
                        Intrinsics.checkParameterIsNotNull(action2, (String)"action");
                        GradleExecutionHelper gradleExecutionHelper = new GradleExecutionHelper();
                        String string = GradleScriptDefinitionsContributor.access$getProject$p(this.this$0.this$0).getBasePath();
                        if (string == null) {
                            Intrinsics.throwNpe();
                        }
                        return (Unit)gradleExecutionHelper.execute(string, null, (Function)new Function<ProjectConnection, Unit>(action2){
                            final /* synthetic */ Function1 $action;

                            public final void fun(ProjectConnection it) {
                                ProjectConnection projectConnection = it;
                                Intrinsics.checkExpressionValueIsNotNull((Object)projectConnection, (String)"it");
                                this.$action.invoke((Object)projectConnection);
                            }
                            {
                                this.$action = function1;
                            }
                        });
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                });
                pairArray7[3] = TuplesKt.to((Object)"gradleJavaHome", (Object)gradleExeSettings.getJavaHome());
                pairArray7[4] = TuplesKt.to((Object)"gradleJvmOptions", (Object)gradleJvmOptions);
                pairArray7[5] = TuplesKt.to((Object)"getScriptSectionTokens", (Object)((Object)doLoadGradleTemplates.4.INSTANCE));
                return MapsKt.mapOf((Pair[])pairArray7);
            }
            {
                this.this$0 = gradleScriptDefinitionsContributor;
                super(1);
            }
        };
        String string = this.project.getBasePath();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        GradleExecutionSettings gradleExecutionSettings = gradleExeSettings = (GradleExecutionSettings)ExternalSystemApiUtil.getExecutionSettings((Project)this.project, (String)ExternalSystemApiUtil.toCanonicalPath((String)string), (ProjectSystemId)GradleConstants.SYSTEM_ID);
        Intrinsics.checkExpressionValueIsNotNull((Object)gradleExecutionSettings, (String)"gradleExeSettings");
        String string2 = gradleExecutionSettings.getGradleHome();
        if (string2 == null) {
            String string3 = "Unable to get Gradle home directory";
            throw (Throwable)new IllegalStateException(string3.toString());
        }
        String gradleHome = string2;
        File it = file2 = new File(gradleHome, "lib");
        Object object = it;
        File it2 = object;
        Object object2 = it2.exists() && it2.isDirectory() ? object : null;
        if (object2 == null) {
            object = "Invalid Gradle libraries directory " + it;
            throw (Throwable)new IllegalStateException(object.toString());
        }
        File gradleLibDir = object2;
        Object object3 = gradleLibDir.listFiles(new FileFilter(dependencySelector){
            final /* synthetic */ Regex $dependencySelector;

            public final boolean accept(File it) {
                File file2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"it");
                String string = file2.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.name");
                return this.$dependencySelector.matches((CharSequence)string);
            }
            {
                this.$dependencySelector = regex;
            }
        });
        File[] it3 = object3;
        Intrinsics.checkExpressionValueIsNotNull((Object)it3, (String)"it");
        Object[] objectArray2 = objectArray = (Object[])it3;
        Object object4 = !(objectArray2.length == 0) ? object3 : null;
        if (object4 == null || (object4 = ArraysKt.asList((Object[])object4)) == null) {
            object3 = "Missing jars in gradle directory";
            throw (Throwable)new IllegalStateException(object3.toString());
        }
        Object templateClasspath2 = object4;
        return ScriptDefinitionsManagerKt.loadDefinitionsFromTemplates(CollectionsKt.listOf((Object)templateClass2), (List<? extends File>)templateClasspath2, createEnvironment$.invoke(gradleExeSettings), (List)additionalResolverClasspath.invoke((Object)gradleLibDir));
    }

    public final void reloadIfNeccessary() {
        if (this.failedToLoad.compareAndSet(true, false)) {
            this.reload();
        }
    }

    private final void reload() {
        ScriptDefinitionsManager.Companion.getInstance(this.project).reloadDefinitionsBy(this);
    }

    public GradleScriptDefinitionsContributor(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        this.id = "Gradle Kotlin DSL";
        this.failedToLoad = new AtomicBoolean(false);
        this.subscribeToGradleSettingChanges();
    }

    public static final /* synthetic */ void access$reload(GradleScriptDefinitionsContributor $this) {
        $this.reload();
    }

    @NotNull
    public static final /* synthetic */ List access$kotlinStdlibAndCompiler(GradleScriptDefinitionsContributor $this, @NotNull File gradleLibDir) {
        return $this.kotlinStdlibAndCompiler(gradleLibDir);
    }

    @NotNull
    public static final /* synthetic */ Project access$getProject$p(GradleScriptDefinitionsContributor $this) {
        return $this.project;
    }
}

