/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.nodejs.cli;

import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.nodejs.run.NodeJsRunConfiguration;
import com.jetbrains.nodejs.run.NodeJsRunConfigurationType;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.MainFunctionDetector;
import org.jetbrains.kotlin.idea.js.JsUtilsKt;
import org.jetbrains.kotlin.idea.nodejs.NodeJsUtilKt;
import org.jetbrains.kotlin.idea.nodejs.TestElementPath;
import org.jetbrains.kotlin.idea.nodejs.cli.KotlinNodeJsRunConfigurationProducer;
import org.jetbrains.kotlin.idea.run.RcUtilsKt;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtilKt;
import org.jetbrains.kotlin.psi.KtNamedFunction;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0006H\u0016J&\u0010\u000b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0014R\u001a\u0010\u0004\u001a\u00020\u0005*\u0004\u0018\u00010\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/nodejs/cli/KotlinNodeJsRunConfigurationProducer;", "Lcom/intellij/execution/actions/RunConfigurationProducer;", "Lcom/jetbrains/nodejs/run/NodeJsRunConfiguration;", "()V", "isAcceptable", "", "Lcom/intellij/execution/actions/ConfigurationContext;", "(Lcom/intellij/execution/actions/ConfigurationContext;)Z", "isConfigurationFromContext", "configuration", "context", "setupConfigurationFromContext", "sourceElement", "Lcom/intellij/openapi/util/Ref;", "Lcom/intellij/psi/PsiElement;", "ultimate"})
final class KotlinNodeJsRunConfigurationProducer
extends RunConfigurationProducer<NodeJsRunConfiguration> {
    private final boolean isAcceptable(@Nullable ConfigurationContext $receiver) {
        ConfigurationContext configurationContext = $receiver;
        RunConfiguration original = configurationContext != null ? configurationContext.getOriginalConfiguration(null) : null;
        return original == null || original instanceof NodeJsRunConfiguration;
    }

    protected boolean setupConfigurationFromContext(@NotNull NodeJsRunConfiguration configuration2, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        MainFunctionDetector detector2;
        Intrinsics.checkParameterIsNotNull((Object)configuration2, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(sourceElement, (String)"sourceElement");
        if (!this.isAcceptable(context)) {
            return false;
        }
        PsiElement psiElement2 = (PsiElement)sourceElement.get();
        if (psiElement2 == null) {
            return false;
        }
        PsiElement psiElement3 = psiElement2;
        PsiFile psiFile = psiElement3.getContainingFile();
        if (psiFile == null) {
            return false;
        }
        PsiFile psiFile2 = psiFile;
        Module module = ProjectRootsUtilKt.getModule((PsiElement)psiFile2);
        if (module == null || (module = JsUtilsKt.jsOrJsImpl(module)) == null) {
            return false;
        }
        Module jsModule = module;
        Project project = psiFile2.getProject();
        if (psiElement3 instanceof KtNamedFunction ? !(detector2 = new MainFunctionDetector((Function1<? super KtNamedFunction, ? extends FunctionDescriptor>)((Function1)setupConfigurationFromContext.detector.1.INSTANCE))).isMain((KtNamedFunction)psiElement3, false) : !TestElementPath.Companion.isModuleAssociatedDir(psiElement3, jsModule)) {
            return false;
        }
        String string = JsUtilsKt.getJsProductionOutputFilePath(jsModule);
        if (string == null) {
            return false;
        }
        String jsFilePath = string;
        CharSequence charSequence = configuration2.getWorkingDirectory();
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            Project project2 = project;
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
            VirtualFile virtualFile2 = project2.getBaseDir();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"project.baseDir");
            configuration2.setWorkingDirectory(FileUtil.toSystemDependentName((String)virtualFile2.getPath()));
        }
        configuration2.setInputPath(jsFilePath);
        configuration2.setEnvs(NodeJsUtilKt.getNodeJsEnvironmentVars(jsModule).getEnvs());
        configuration2.setGeneratedName();
        RcUtilsKt.addBuildTask((RunConfiguration)configuration2);
        return true;
    }

    public boolean isConfigurationFromContext(@NotNull NodeJsRunConfiguration configuration2, @NotNull ConfigurationContext context) {
        PsiElement contextPsi;
        Intrinsics.checkParameterIsNotNull((Object)configuration2, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (!this.isAcceptable(context)) {
            return false;
        }
        PsiElement psiElement2 = context.getPsiLocation();
        if (psiElement2 == null) {
            return false;
        }
        PsiElement psiElement3 = contextPsi = psiElement2;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"contextPsi");
        Module module = ProjectRootsUtilKt.getModule(psiElement3);
        if (module == null || (module = JsUtilsKt.jsOrJsImpl(module)) == null) {
            return false;
        }
        Module jsModule = module;
        String string = JsUtilsKt.getJsProductionOutputFilePath(jsModule);
        if (string == null) {
            return false;
        }
        String jsFilePath = string;
        return Intrinsics.areEqual((Object)configuration2.getInputPath(), (Object)jsFilePath);
    }

    public KotlinNodeJsRunConfigurationProducer() {
        super((ConfigurationType)NodeJsRunConfigurationType.getInstance());
    }
}

