/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.rename;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.ResolveState;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.rename.RenamePsiFileProcessor;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.fileClasses.JvmFileClassInfo;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.load.java.structure.LightClassOriginKind;
import org.jetbrains.kotlin.load.kotlin.PackagePartClassUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J6\u0010\u0007\u001a\u00020\b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/rename/RenameKotlinFileProcessor;", "Lcom/intellij/refactoring/rename/RenamePsiFileProcessor;", "()V", "canProcessElement", "", "element", "Lcom/intellij/psi/PsiElement;", "prepareRenaming", "", "newName", "", "allRenames", "", "scope", "Lcom/intellij/psi/search/SearchScope;", "FileRenamingPsiClassWrapper", "idea"})
public final class RenameKotlinFileProcessor
extends RenamePsiFileProcessor {
    public boolean canProcessElement(@NotNull PsiElement element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        return element3 instanceof KtFile && ProjectRootsUtil.isInProjectSource(element3);
    }

    public void prepareRenaming(@Nullable PsiElement element3, @NotNull String newName2, @NotNull Map<PsiElement, String> allRenames, @NotNull SearchScope scope2) {
        Intrinsics.checkParameterIsNotNull((Object)newName2, (String)"newName");
        Intrinsics.checkParameterIsNotNull(allRenames, (String)"allRenames");
        Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
        PsiElement psiElement2 = element3;
        if (!(psiElement2 instanceof KtFile)) {
            psiElement2 = null;
        }
        KtFile ktFile = (KtFile)psiElement2;
        if (ktFile == null) {
            return;
        }
        KtFile jetFile = ktFile;
        if (Intrinsics.areEqual((Object)FileTypeManager.getInstance().getFileTypeByFileName(newName2), (Object)((Object)KotlinFileType.INSTANCE)) ^ true) {
            return;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element3);
        if (module == null) {
            return;
        }
        Module module2 = module;
        JvmFileClassInfo fileInfo = JvmFileClassUtil.getFileClassInfoNoResolve(jetFile);
        if (!fileInfo.getWithJvmName()) {
            KtLightClass facadeClass;
            FqName facadeFqName = fileInfo.getFacadeClassFqName();
            Project project = jetFile.getProject();
            PsiClass psiClass2 = JavaPsiFacade.getInstance((Project)project).findClass(facadeFqName.asString(), GlobalSearchScope.moduleScope((Module)module2));
            if (!(psiClass2 instanceof KtLightClass)) {
                psiClass2 = null;
            }
            if ((facadeClass = (KtLightClass)psiClass2) != null) {
                Map<PsiElement, String> map2 = allRenames;
                FileRenamingPsiClassWrapper fileRenamingPsiClassWrapper = new FileRenamingPsiClassWrapper(facadeClass, jetFile);
                String string = PackagePartClassUtils.getFilePartShortName(newName2);
                map2.put(fileRenamingPsiClassWrapper, string);
            }
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u00c6\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\f\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u0019\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u0015H\u0096\u0001J\u0013\u0010\u0016\u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u0015H\u0096\u0001J\u001b\u0010\u0017\u001a\n \u0019*\u0004\u0018\u00010\u00180\u00182\b\b\u0001\u0010\u0014\u001a\u00020\u0018H\u0096\u0001J'\u0010\u001a\u001a\n \u0019*\u0004\u0018\u00010\u00180\u00182\b\b\u0001\u0010\u0014\u001a\u00020\u00182\n\b\u0001\u0010\u001b\u001a\u0004\u0018\u00010\u0018H\u0096\u0001J'\u0010\u001c\u001a\n \u0019*\u0004\u0018\u00010\u00180\u00182\b\b\u0001\u0010\u0014\u001a\u00020\u00182\n\b\u0001\u0010\u001b\u001a\u0004\u0018\u00010\u0018H\u0096\u0001J1\u0010\u001d\u001a\n \u0019*\u0004\u0018\u00010\u00180\u00182\u000e\u0010\u0014\u001a\n \u0019*\u0004\u0018\u00010\u00180\u00182\u000e\u0010\u001b\u001a\n \u0019*\u0004\u0018\u00010\u00180\u0018H\u0096\u0001JA\u0010\u001e\u001a\n \u0019*\u0004\u0018\u00010\u00180\u00182\u000e\u0010\u0014\u001a\n \u0019*\u0004\u0018\u00010\u00180\u00182\u000e\u0010\u001b\u001a\n \u0019*\u0004\u0018\u00010\u00180\u00182\u000e\u0010\u001f\u001a\n \u0019*\u0004\u0018\u00010\u00180\u0018H\u0096\u0001J5\u0010 \u001a\n \u0019*\u0004\u0018\u00010\u00180\u00182\b\b\u0001\u0010\u0014\u001a\u00020\u00182\b\b\u0001\u0010\u001b\u001a\u00020\u00182\u000e\u0010\u001f\u001a\n \u0019*\u0004\u0018\u00010\u00180\u0018H\u0096\u0001J\t\u0010!\u001a\u00020\"H\u0096\u0001J\t\u0010#\u001a\u00020\"H\u0096\u0001J\u0013\u0010$\u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u0018H\u0097\u0001J\t\u0010%\u001a\u00020\u0013H\u0097\u0001J\u0011\u0010&\u001a\n \u0019*\u0004\u0018\u00010\u00180\u0018H\u0096\u0001J\t\u0010'\u001a\u00020\u0013H\u0096\u0001J)\u0010(\u001a\u00020\u00132\u000e\u0010\u0014\u001a\n \u0019*\u0004\u0018\u00010\u00180\u00182\u000e\u0010\u001b\u001a\n \u0019*\u0004\u0018\u00010\u00180\u0018H\u0096\u0001J\u0013\u0010)\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0014\u001a\u00020*H\u0097\u0001J%\u0010+\u001a\u0004\u0018\u00010,2\u0010\b\u0001\u0010\u0014\u001a\n \u0019*\u0004\u0018\u00010-0-2\u0006\u0010\u001b\u001a\u00020\"H\u0097\u0001J%\u0010.\u001a\u0004\u0018\u00010\u00072\u0010\b\u0001\u0010\u0014\u001a\n \u0019*\u0004\u0018\u00010-0-2\u0006\u0010\u001b\u001a\u00020\"H\u0097\u0001J#\u0010/\u001a\u0004\u0018\u0001002\u000e\u0010\u0014\u001a\n \u0019*\u0004\u0018\u000100002\u0006\u0010\u001b\u001a\u00020\"H\u0097\u0001J\u00b6\u0001\u00101\u001a\u0094\u0001\u0012D\u0012B\u0012\f\u0012\n \u0019*\u0004\u0018\u00010000\u0012\f\u0012\n \u0019*\u0004\u0018\u00010404 \u0019* \u0012\f\u0012\n \u0019*\u0004\u0018\u00010000\u0012\f\u0012\n \u0019*\u0004\u0018\u00010404\u0018\u00010303 \u0019*H\u0012D\u0012B\u0012\f\u0012\n \u0019*\u0004\u0018\u00010000\u0012\f\u0012\n \u0019*\u0004\u0018\u00010404 \u0019* \u0012\f\u0012\n \u0019*\u0004\u0018\u00010000\u0012\f\u0012\n \u0019*\u0004\u0018\u00010404\u0018\u0001030305022\u0010\b\u0001\u0010\u0014\u001a\n \u0019*\u0004\u0018\u00010-0-2\u0006\u0010\u001b\u001a\u00020\"H\u0097\u0001JL\u00106\u001a&\u0012\f\u0012\n \u0019*\u0004\u0018\u00010000 \u0019*\u0012\u0012\u000e\b\u0001\u0012\n \u0019*\u0004\u0018\u0001000007072\u0010\b\u0001\u0010\u0014\u001a\n \u0019*\u0004\u0018\u00010-0-2\u0006\u0010\u001b\u001a\u00020\"H\u0097\u0001\u00a2\u0006\u0002\u00108JJ\u00109\u001a&\u0012\f\u0012\n \u0019*\u0004\u0018\u00010000 \u0019*\u0012\u0012\u000e\b\u0001\u0012\n \u0019*\u0004\u0018\u0001000007072\u000e\u0010\u0014\u001a\n \u0019*\u0004\u0018\u000100002\u0006\u0010\u001b\u001a\u00020\"H\u0097\u0001\u00a2\u0006\u0002\u0010:J\u0013\u0010;\u001a\u0004\u0018\u00010<2\u0006\u0010\u0014\u001a\u00020*H\u0097\u0001J2\u0010=\u001a&\u0012\f\u0012\n \u0019*\u0004\u0018\u00010,0, \u0019*\u0012\u0012\u000e\b\u0001\u0012\n \u0019*\u0004\u0018\u00010,0,0707H\u0097\u0001\u00a2\u0006\u0002\u0010>J2\u0010?\u001a&\u0012\f\u0012\n \u0019*\u0004\u0018\u00010\u00070\u0007 \u0019*\u0012\u0012\u000e\b\u0001\u0012\n \u0019*\u0004\u0018\u00010\u00070\u00070707H\u0097\u0001\u00a2\u0006\u0002\u0010@J2\u0010A\u001a&\u0012\f\u0012\n \u0019*\u0004\u0018\u00010000 \u0019*\u0012\u0012\u000e\b\u0001\u0012\n \u0019*\u0004\u0018\u000100000707H\u0097\u0001\u00a2\u0006\u0002\u0010BJ\u009c\u0001\u0010C\u001a\u0094\u0001\u0012D\u0012B\u0012\f\u0012\n \u0019*\u0004\u0018\u00010000\u0012\f\u0012\n \u0019*\u0004\u0018\u00010404 \u0019* \u0012\f\u0012\n \u0019*\u0004\u0018\u00010000\u0012\f\u0012\n \u0019*\u0004\u0018\u00010404\u0018\u00010303 \u0019*H\u0012D\u0012B\u0012\f\u0012\n \u0019*\u0004\u0018\u00010000\u0012\f\u0012\n \u0019*\u0004\u0018\u00010404 \u0019* \u0012\f\u0012\n \u0019*\u0004\u0018\u00010000\u0012\f\u0012\n \u0019*\u0004\u0018\u00010404\u0018\u000103030502H\u0097\u0001J2\u0010D\u001a&\u0012\f\u0012\n \u0019*\u0004\u0018\u00010\u00180\u0018 \u0019*\u0012\u0012\u000e\b\u0001\u0012\n \u0019*\u0004\u0018\u00010\u00180\u00180707H\u0097\u0001\u00a2\u0006\u0002\u0010EJ2\u0010F\u001a&\u0012\f\u0012\n \u0019*\u0004\u0018\u00010000 \u0019*\u0012\u0012\u000e\b\u0001\u0012\n \u0019*\u0004\u0018\u000100000707H\u0097\u0001\u00a2\u0006\u0002\u0010BJ\u000b\u0010G\u001a\u0004\u0018\u00010\u0007H\u0097\u0001J\u0011\u0010H\u001a\n \u0019*\u0004\u0018\u00010I0IH\u0097\u0001J\u000b\u0010J\u001a\u0004\u0018\u00010\u0018H\u0097\u0001JN\u0010K\u001a\u0004\u0018\u0001HL\"\u0010\b\u0000\u0010L*\n \u0019*\u0004\u0018\u00010M0M2*\u0010\u0014\u001a&\u0012\f\u0012\n \u0019*\u0004\u0018\u0001HLHL \u0019*\u0012\u0012\f\u0012\n \u0019*\u0004\u0018\u0001HLHL\u0018\u00010N0NH\u0097\u0001\u00a2\u0006\u0002\u0010OJ\u000b\u0010P\u001a\u0004\u0018\u00010QH\u0097\u0001J\u000b\u0010R\u001a\u0004\u0018\u00010SH\u0097\u0001J2\u0010T\u001a&\u0012\f\u0012\n \u0019*\u0004\u0018\u00010U0U \u0019*\u0012\u0012\u000e\b\u0001\u0012\n \u0019*\u0004\u0018\u00010U0U0707H\u0097\u0001\u00a2\u0006\u0002\u0010VJ2\u0010W\u001a&\u0012\f\u0012\n \u0019*\u0004\u0018\u00010,0, \u0019*\u0012\u0012\u000e\b\u0001\u0012\n \u0019*\u0004\u0018\u00010,0,0707H\u0097\u0001\u00a2\u0006\u0002\u0010>J\u0011\u0010X\u001a\n \u0019*\u0004\u0018\u00010\u00180\u0018H\u0097\u0001J\u001b\u0010Y\u001a\n \u0019*\u0004\u0018\u00010Z0Z2\b\b\u0001\u0010\u0014\u001a\u00020*H\u0096\u0001J\u000b\u0010[\u001a\u0004\u0018\u00010SH\u0097\u0001J2\u0010\\\u001a&\u0012\f\u0012\n \u0019*\u0004\u0018\u00010U0U \u0019*\u0012\u0012\u000e\b\u0001\u0012\n \u0019*\u0004\u0018\u00010U0U0707H\u0097\u0001\u00a2\u0006\u0002\u0010VJ2\u0010]\u001a&\u0012\f\u0012\n \u0019*\u0004\u0018\u00010^0^ \u0019*\u0012\u0012\u000e\b\u0001\u0012\n \u0019*\u0004\u0018\u00010^0^0707H\u0097\u0001\u00a2\u0006\u0002\u0010_J2\u0010`\u001a&\u0012\f\u0012\n \u0019*\u0004\u0018\u00010\u00070\u0007 \u0019*\u0012\u0012\u000e\b\u0001\u0012\n \u0019*\u0004\u0018\u00010\u00070\u00070707H\u0097\u0001\u00a2\u0006\u0002\u0010@J2\u0010a\u001a&\u0012\f\u0012\n \u0019*\u0004\u0018\u00010\u00070\u0007 \u0019*\u0012\u0012\u000e\b\u0001\u0012\n \u0019*\u0004\u0018\u00010\u00070\u00070707H\u0097\u0001\u00a2\u0006\u0002\u0010@J\u000b\u0010b\u001a\u0004\u0018\u00010\u0018H\u0097\u0001J\t\u0010c\u001a\u00020dH\u0097\u0001J\u0011\u0010e\u001a\n \u0019*\u0004\u0018\u00010\u00180\u0018H\u0097\u0001J\u0011\u0010f\u001a\n \u0019*\u0004\u0018\u00010g0gH\u0097\u0001J2\u0010h\u001a&\u0012\f\u0012\n \u0019*\u0004\u0018\u00010000 \u0019*\u0012\u0012\u000e\b\u0001\u0012\n \u0019*\u0004\u0018\u000100000707H\u0097\u0001\u00a2\u0006\u0002\u0010BJ\u000b\u0010i\u001a\u0004\u0018\u00010jH\u0097\u0001J\u000b\u0010k\u001a\u0004\u0018\u00010-H\u0097\u0001J\u000b\u0010l\u001a\u0004\u0018\u00010mH\u0097\u0001J\t\u0010n\u001a\u00020\u0018H\u0097\u0001J\u0011\u0010o\u001a\n \u0019*\u0004\u0018\u00010\u00180\u0018H\u0097\u0001J\u0011\u0010p\u001a\n \u0019*\u0004\u0018\u00010q0qH\u0097\u0001J\u0011\u0010r\u001a\n \u0019*\u0004\u0018\u00010\u00180\u0018H\u0097\u0001J\u0011\u0010s\u001a\n \u0019*\u0004\u0018\u00010\u00180\u0018H\u0097\u0001J\u000b\u0010t\u001a\u0004\u0018\u00010uH\u0097\u0001J\u0011\u0010v\u001a\n \u0019*\u0004\u0018\u00010\u00180\u0018H\u0097\u0001J\t\u0010w\u001a\u00020xH\u0097\u0001J\u000b\u0010y\u001a\u0004\u0018\u00010-H\u0097\u0001J\u000b\u0010z\u001a\u0004\u0018\u00010\u0018H\u0097\u0001J\u000b\u0010{\u001a\u0004\u0018\u00010<H\u0097\u0001J2\u0010|\u001a&\u0012\f\u0012\n \u0019*\u0004\u0018\u00010<0< \u0019*\u0012\u0012\u000e\b\u0001\u0012\n \u0019*\u0004\u0018\u00010<0<0707H\u0097\u0001\u00a2\u0006\u0002\u0010}J\t\u0010~\u001a\u00020\u007fH\u0097\u0001J\u0012\u0010\u0080\u0001\u001a\n \u0019*\u0004\u0018\u00010\u00180\u0018H\u0096\u0001J\n\u0010\u0081\u0001\u001a\u00020*H\u0097\u0001J\f\u0010\u0082\u0001\u001a\u0004\u0018\u00010\u0007H\u0097\u0001J3\u0010\u0083\u0001\u001a&\u0012\f\u0012\n \u0019*\u0004\u0018\u00010U0U \u0019*\u0012\u0012\u000e\b\u0001\u0012\n \u0019*\u0004\u0018\u00010U0U0707H\u0097\u0001\u00a2\u0006\u0002\u0010VJ3\u0010\u0084\u0001\u001a&\u0012\f\u0012\n \u0019*\u0004\u0018\u00010\u00070\u0007 \u0019*\u0012\u0012\u000e\b\u0001\u0012\n \u0019*\u0004\u0018\u00010\u00070\u00070707H\u0097\u0001\u00a2\u0006\u0002\u0010@J\u0012\u0010\u0085\u0001\u001a\n \u0019*\u0004\u0018\u00010-0-H\u0097\u0001J\n\u0010\u0086\u0001\u001a\u00020*H\u0097\u0001J\n\u0010\u0087\u0001\u001a\u00020*H\u0097\u0001J\u0014\u0010\u0088\u0001\u001a\f \u0019*\u0005\u0018\u00010\u0089\u00010\u0089\u0001H\u0097\u0001J\r\u0010\u008a\u0001\u001a\u0005\u0018\u00010\u008b\u0001H\u0097\u0001J8\u0010\u008c\u0001\u001a*\u0012\u000e\u0012\f \u0019*\u0005\u0018\u00010\u008d\u00010\u008d\u0001 \u0019*\u0014\u0012\u0010\b\u0001\u0012\f \u0019*\u0005\u0018\u00010\u008d\u00010\u008d\u00010707H\u0097\u0001\u00a2\u0006\u0003\u0010\u008e\u0001J\u000b\u0010\u008f\u0001\u001a\u00030\u0090\u0001H\u0097\u0001J;\u0010\u0091\u0001\u001a\u0004\u0018\u0001HL\"\u0010\b\u0000\u0010L*\n \u0019*\u0004\u0018\u00010M0M2\u0016\b\u0001\u0010\u0014\u001a\u0010\u0012\f\u0012\n \u0019*\u0004\u0018\u0001HLHL0NH\u0097\u0001\u00a2\u0006\u0002\u0010OJ2\u0010\u0092\u0001\u001a*\u0012\u000e\u0012\f \u0019*\u0005\u0018\u00010\u0094\u00010\u0094\u0001 \u0019*\u0013\u0012\u000e\u0012\f \u0019*\u0005\u0018\u00010\u0094\u00010\u0094\u00010\u0095\u00010\u0093\u0001H\u0097\u0001J\u0014\u0010\u0096\u0001\u001a\u00020\"2\b\b\u0001\u0010\u0014\u001a\u00020-H\u0096\u0001J\n\u0010\u0097\u0001\u001a\u00020\"H\u0096\u0001J\n\u0010\u0098\u0001\u001a\u00020\"H\u0096\u0001J\n\u0010\u0099\u0001\u001a\u00020\"H\u0096\u0001J\n\u0010\u009a\u0001\u001a\u00020\"H\u0096\u0001J\u001a\u0010\u009b\u0001\u001a\u00020\"2\u000e\u0010\u0014\u001a\n \u0019*\u0004\u0018\u00010\u00180\u0018H\u0097\u0001J\u001c\u0010\u009c\u0001\u001a\u00020\"2\b\b\u0001\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\"H\u0096\u0001J&\u0010\u009d\u0001\u001a\u00020\"2\u000e\u0010\u0014\u001a\n \u0019*\u0004\u0018\u00010\u00070\u00072\n\b\u0001\u0010\u001b\u001a\u0004\u0018\u00010\u0007H\u0096\u0001J\n\u0010\u009e\u0001\u001a\u00020\"H\u0096\u0001J\n\u0010\u009f\u0001\u001a\u00020\"H\u0097\u0001J\t\u0010\u00a0\u0001\u001a\u00020\"H\u0016J\n\u0010\u00a1\u0001\u001a\u00020\"H\u0097\u0001J\u0012\u0010\u00a2\u0001\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\"H\u0096\u0001J7\u0010\u00a3\u0001\u001a\u00020\"2\t\b\u0001\u0010\u0014\u001a\u00030\u00a4\u00012\t\b\u0001\u0010\u001b\u001a\u00030\u00a5\u00012\n\b\u0001\u0010\u001f\u001a\u0004\u0018\u00010\u00182\t\b\u0001\u0010\u00a6\u0001\u001a\u00020\u0018H\u0096\u0001JZ\u0010\u00a7\u0001\u001a\u00020\u0013\"\u0010\b\u0000\u0010L*\n \u0019*\u0004\u0018\u00010M0M2*\u0010\u0014\u001a&\u0012\f\u0012\n \u0019*\u0004\u0018\u0001HLHL \u0019*\u0012\u0012\f\u0012\n \u0019*\u0004\u0018\u0001HLHL\u0018\u00010N0N2\n\b\u0001\u0010\u001b\u001a\u0004\u0018\u0001HLH\u0096\u0001\u00a2\u0006\u0003\u0010\u00a8\u0001JF\u0010\u00a9\u0001\u001a\u00020\u0013\"\u0010\b\u0000\u0010L*\n \u0019*\u0004\u0018\u00010M0M2\u0016\b\u0001\u0010\u0014\u001a\u0010\u0012\f\u0012\n \u0019*\u0004\u0018\u0001HLHL0N2\n\b\u0001\u0010\u001b\u001a\u0004\u0018\u0001HLH\u0096\u0001\u00a2\u0006\u0003\u0010\u00a8\u0001J\u001c\u0010\u00aa\u0001\u001a\n \u0019*\u0004\u0018\u00010\u00180\u00182\b\b\u0001\u0010\u0014\u001a\u00020\u0018H\u0096\u0001J\u001c\u0010\u00ab\u0001\u001a\n \u0019*\u0004\u0018\u00010\u00180\u00182\b\b\u0001\u0010\u0014\u001a\u00020-H\u0096\u0001J\u0013\u0010\u00ac\u0001\u001a\u00020\"2\u0007\u0010\u0014\u001a\u00030\u00ad\u0001H\u0097\u0001J\u0014\u0010\u00ae\u0001\u001a\u00020\"2\b\b\u0001\u0010\u0014\u001a\u00020\u0018H\u0097\u0001J\u0015\u0010\u00ae\u0001\u001a\u00020\"2\t\b\u0001\u0010\u0014\u001a\u00030\u00af\u0001H\u0097\u0001J\u000b\u0010\u00b0\u0001\u001a\u00030\u00b1\u0001H\u0097\u0001R\u0012\u0010\u0006\u001a\u00020\u0007X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000fX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00b2\u0001"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/rename/RenameKotlinFileProcessor$FileRenamingPsiClassWrapper;", "Lorg/jetbrains/kotlin/asJava/classes/KtLightClass;", "psiClass", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "(Lorg/jetbrains/kotlin/asJava/classes/KtLightClass;Lorg/jetbrains/kotlin/psi/KtFile;)V", "clsDelegate", "Lcom/intellij/psi/PsiClass;", "getClsDelegate", "()Lcom/intellij/psi/PsiClass;", "kotlinOrigin", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "getKotlinOrigin", "()Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "originKind", "Lorg/jetbrains/kotlin/load/java/structure/LightClassOriginKind;", "getOriginKind", "()Lorg/jetbrains/kotlin/load/java/structure/LightClassOriginKind;", "accept", "", "p0", "Lcom/intellij/psi/PsiElementVisitor;", "acceptChildren", "add", "Lcom/intellij/psi/PsiElement;", "kotlin.jvm.PlatformType", "addAfter", "p1", "addBefore", "addRange", "addRangeAfter", "p2", "addRangeBefore", "canNavigate", "", "canNavigateToSource", "checkAdd", "checkDelete", "copy", "delete", "deleteChildRange", "findElementAt", "", "findFieldByName", "Lcom/intellij/psi/PsiField;", "", "findInnerClassByName", "findMethodBySignature", "Lcom/intellij/psi/PsiMethod;", "findMethodsAndTheirSubstitutorsByName", "", "Lcom/intellij/openapi/util/Pair;", "Lcom/intellij/psi/PsiSubstitutor;", "", "findMethodsByName", "", "(Ljava/lang/String;Z)[Lcom/intellij/psi/PsiMethod;", "findMethodsBySignature", "(Lcom/intellij/psi/PsiMethod;Z)[Lcom/intellij/psi/PsiMethod;", "findReferenceAt", "Lcom/intellij/psi/PsiReference;", "getAllFields", "()[Lcom/intellij/psi/PsiField;", "getAllInnerClasses", "()[Lcom/intellij/psi/PsiClass;", "getAllMethods", "()[Lcom/intellij/psi/PsiMethod;", "getAllMethodsAndTheirSubstitutors", "getChildren", "()[Lcom/intellij/psi/PsiElement;", "getConstructors", "getContainingClass", "getContainingFile", "Lcom/intellij/psi/PsiFile;", "getContext", "getCopyableUserData", "T", "", "Lcom/intellij/openapi/util/Key;", "(Lcom/intellij/openapi/util/Key;)Ljava/lang/Object;", "getDocComment", "Lcom/intellij/psi/javadoc/PsiDocComment;", "getExtendsList", "Lcom/intellij/psi/PsiReferenceList;", "getExtendsListTypes", "Lcom/intellij/psi/PsiClassType;", "()[Lcom/intellij/psi/PsiClassType;", "getFields", "getFirstChild", "getIcon", "Ljavax/swing/Icon;", "getImplementsList", "getImplementsListTypes", "getInitializers", "Lcom/intellij/psi/PsiClassInitializer;", "()[Lcom/intellij/psi/PsiClassInitializer;", "getInnerClasses", "getInterfaces", "getLBrace", "getLanguage", "Lcom/intellij/lang/Language;", "getLastChild", "getManager", "Lcom/intellij/psi/PsiManager;", "getMethods", "getModifierList", "Lcom/intellij/psi/PsiModifierList;", "getName", "getNameIdentifier", "Lcom/intellij/psi/PsiIdentifier;", "getNavigationElement", "getNextSibling", "getNode", "Lcom/intellij/lang/ASTNode;", "getOriginalElement", "getParent", "getPresentation", "Lcom/intellij/navigation/ItemPresentation;", "getPrevSibling", "getProject", "Lcom/intellij/openapi/project/Project;", "getQualifiedName", "getRBrace", "getReference", "getReferences", "()[Lcom/intellij/psi/PsiReference;", "getResolveScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "getScope", "getStartOffsetInParent", "getSuperClass", "getSuperTypes", "getSupers", "getText", "getTextLength", "getTextOffset", "getTextRange", "Lcom/intellij/openapi/util/TextRange;", "getTypeParameterList", "Lcom/intellij/psi/PsiTypeParameterList;", "getTypeParameters", "Lcom/intellij/psi/PsiTypeParameter;", "()[Lcom/intellij/psi/PsiTypeParameter;", "getUseScope", "Lcom/intellij/psi/search/SearchScope;", "getUserData", "getVisibleSignatures", "", "Lcom/intellij/psi/HierarchicalMethodSignature;", "", "hasModifierProperty", "hasTypeParameters", "isAnnotationType", "isDeprecated", "isEnum", "isEquivalentTo", "isInheritor", "isInheritorDeep", "isInterface", "isPhysical", "isValid", "isWritable", "navigate", "processDeclarations", "Lcom/intellij/psi/scope/PsiScopeProcessor;", "Lcom/intellij/psi/ResolveState;", "p3", "putCopyableUserData", "(Lcom/intellij/openapi/util/Key;Ljava/lang/Object;)V", "putUserData", "replace", "setName", "textContains", "", "textMatches", "", "textToCharArray", "", "idea"})
    public static final class FileRenamingPsiClassWrapper
    implements KtLightClass {
        private final KtLightClass psiClass;
        private final KtFile file;

        public boolean isValid() {
            return this.file.isValid();
        }

        public FileRenamingPsiClassWrapper(@NotNull KtLightClass psiClass2, @NotNull KtFile file2) {
            Intrinsics.checkParameterIsNotNull((Object)psiClass2, (String)"psiClass");
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            this.psiClass = psiClass2;
            this.file = file2;
        }

        @Override
        @NotNull
        public PsiClass getClsDelegate() {
            return (PsiClass)this.psiClass.getClsDelegate();
        }

        @Override
        @Nullable
        public KtClassOrObject getKotlinOrigin() {
            return (KtClassOrObject)this.psiClass.getKotlinOrigin();
        }

        @Override
        @NotNull
        public LightClassOriginKind getOriginKind() {
            return this.psiClass.getOriginKind();
        }

        public void accept(@NotNull PsiElementVisitor p0) {
            Intrinsics.checkParameterIsNotNull((Object)p0, (String)"p0");
            this.psiClass.accept(p0);
        }

        public void acceptChildren(@NotNull PsiElementVisitor p0) {
            Intrinsics.checkParameterIsNotNull((Object)p0, (String)"p0");
            this.psiClass.acceptChildren(p0);
        }

        public PsiElement add(@NotNull PsiElement p0) {
            Intrinsics.checkParameterIsNotNull((Object)p0, (String)"p0");
            return this.psiClass.add(p0);
        }

        public PsiElement addAfter(@NotNull PsiElement p0, @Nullable PsiElement p1) {
            Intrinsics.checkParameterIsNotNull((Object)p0, (String)"p0");
            return this.psiClass.addAfter(p0, p1);
        }

        public PsiElement addBefore(@NotNull PsiElement p0, @Nullable PsiElement p1) {
            Intrinsics.checkParameterIsNotNull((Object)p0, (String)"p0");
            return this.psiClass.addBefore(p0, p1);
        }

        public PsiElement addRange(PsiElement p0, PsiElement p1) {
            return this.psiClass.addRange(p0, p1);
        }

        public PsiElement addRangeAfter(PsiElement p0, PsiElement p1, PsiElement p2) {
            return this.psiClass.addRangeAfter(p0, p1, p2);
        }

        public PsiElement addRangeBefore(@NotNull PsiElement p0, @NotNull PsiElement p1, PsiElement p2) {
            Intrinsics.checkParameterIsNotNull((Object)p0, (String)"p0");
            Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
            return this.psiClass.addRangeBefore(p0, p1, p2);
        }

        public boolean canNavigate() {
            return this.psiClass.canNavigate();
        }

        public boolean canNavigateToSource() {
            return this.psiClass.canNavigateToSource();
        }

        @Deprecated(message="Deprecated in Java")
        public void checkAdd(@NotNull PsiElement p0) {
            Intrinsics.checkParameterIsNotNull((Object)p0, (String)"p0");
            this.psiClass.checkAdd(p0);
        }

        @Deprecated(message="Deprecated in Java")
        public void checkDelete() {
            this.psiClass.checkDelete();
        }

        public PsiElement copy() {
            return this.psiClass.copy();
        }

        public void delete() {
            this.psiClass.delete();
        }

        public void deleteChildRange(PsiElement p0, PsiElement p1) {
            this.psiClass.deleteChildRange(p0, p1);
        }

        @Nullable
        @Contract(pure=true)
        public PsiElement findElementAt(int p0) {
            return this.psiClass.findElementAt(p0);
        }

        @Nullable
        public PsiField findFieldByName(@NonNls String p0, boolean p1) {
            return this.psiClass.findFieldByName(p0, p1);
        }

        @Nullable
        public PsiClass findInnerClassByName(@NonNls String p0, boolean p1) {
            return this.psiClass.findInnerClassByName(p0, p1);
        }

        @Nullable
        public PsiMethod findMethodBySignature(PsiMethod p0, boolean p1) {
            return this.psiClass.findMethodBySignature(p0, p1);
        }

        @NotNull
        public List<Pair<PsiMethod, PsiSubstitutor>> findMethodsAndTheirSubstitutorsByName(@NonNls String p0, boolean p1) {
            return this.psiClass.findMethodsAndTheirSubstitutorsByName(p0, p1);
        }

        @NotNull
        public PsiMethod[] findMethodsByName(@NonNls String p0, boolean p1) {
            return this.psiClass.findMethodsByName(p0, p1);
        }

        @NotNull
        public PsiMethod[] findMethodsBySignature(PsiMethod p0, boolean p1) {
            return this.psiClass.findMethodsBySignature(p0, p1);
        }

        @Nullable
        @Contract(pure=true)
        public PsiReference findReferenceAt(int p0) {
            return this.psiClass.findReferenceAt(p0);
        }

        @NotNull
        public PsiField[] getAllFields() {
            return this.psiClass.getAllFields();
        }

        @NotNull
        public PsiClass[] getAllInnerClasses() {
            return this.psiClass.getAllInnerClasses();
        }

        @NotNull
        public PsiMethod[] getAllMethods() {
            return this.psiClass.getAllMethods();
        }

        @NotNull
        public List<Pair<PsiMethod, PsiSubstitutor>> getAllMethodsAndTheirSubstitutors() {
            return this.psiClass.getAllMethodsAndTheirSubstitutors();
        }

        @NotNull
        @Contract(pure=true)
        public PsiElement[] getChildren() {
            return this.psiClass.getChildren();
        }

        @NotNull
        public PsiMethod[] getConstructors() {
            return this.psiClass.getConstructors();
        }

        @Nullable
        public PsiClass getContainingClass() {
            return this.psiClass.getContainingClass();
        }

        @Contract(pure=true)
        public PsiFile getContainingFile() {
            return this.psiClass.getContainingFile();
        }

        @Nullable
        @Contract(pure=true)
        public PsiElement getContext() {
            return this.psiClass.getContext();
        }

        @Nullable
        @Contract(pure=true)
        public <T> T getCopyableUserData(Key<T> p0) {
            return (T)this.psiClass.getCopyableUserData(p0);
        }

        @Nullable
        public PsiDocComment getDocComment() {
            return this.psiClass.getDocComment();
        }

        @Nullable
        public PsiReferenceList getExtendsList() {
            return this.psiClass.getExtendsList();
        }

        @NotNull
        public PsiClassType[] getExtendsListTypes() {
            return this.psiClass.getExtendsListTypes();
        }

        @NotNull
        public PsiField[] getFields() {
            return this.psiClass.getFields();
        }

        @Contract(pure=true)
        public PsiElement getFirstChild() {
            return this.psiClass.getFirstChild();
        }

        public Icon getIcon(@Iconable.IconFlags int p0) {
            return this.psiClass.getIcon(p0);
        }

        @Nullable
        public PsiReferenceList getImplementsList() {
            return this.psiClass.getImplementsList();
        }

        @NotNull
        public PsiClassType[] getImplementsListTypes() {
            return this.psiClass.getImplementsListTypes();
        }

        @NotNull
        public PsiClassInitializer[] getInitializers() {
            return this.psiClass.getInitializers();
        }

        @NotNull
        public PsiClass[] getInnerClasses() {
            return this.psiClass.getInnerClasses();
        }

        @NotNull
        public PsiClass[] getInterfaces() {
            return this.psiClass.getInterfaces();
        }

        @Nullable
        public PsiElement getLBrace() {
            return this.psiClass.getLBrace();
        }

        @NotNull
        @Contract(pure=true)
        public Language getLanguage() {
            return this.psiClass.getLanguage();
        }

        @Contract(pure=true)
        public PsiElement getLastChild() {
            return this.psiClass.getLastChild();
        }

        @Contract(pure=true)
        public PsiManager getManager() {
            return this.psiClass.getManager();
        }

        @NotNull
        public PsiMethod[] getMethods() {
            return this.psiClass.getMethods();
        }

        @Nullable
        public PsiModifierList getModifierList() {
            return this.psiClass.getModifierList();
        }

        @Nullable
        public String getName() {
            return this.psiClass.getName();
        }

        @Nullable
        public PsiIdentifier getNameIdentifier() {
            return this.psiClass.getNameIdentifier();
        }

        @NotNull
        public PsiElement getNavigationElement() {
            return this.psiClass.getNavigationElement();
        }

        @Contract(pure=true)
        public PsiElement getNextSibling() {
            return this.psiClass.getNextSibling();
        }

        @Contract(pure=true)
        public ASTNode getNode() {
            return this.psiClass.getNode();
        }

        @Contract(pure=true)
        public PsiElement getOriginalElement() {
            return this.psiClass.getOriginalElement();
        }

        @Contract(pure=true)
        public PsiElement getParent() {
            return this.psiClass.getParent();
        }

        @Nullable
        public ItemPresentation getPresentation() {
            return this.psiClass.getPresentation();
        }

        @Contract(pure=true)
        public PsiElement getPrevSibling() {
            return this.psiClass.getPrevSibling();
        }

        @NotNull
        @Contract(pure=true)
        public Project getProject() {
            return this.psiClass.getProject();
        }

        @Nullable
        public String getQualifiedName() {
            return this.psiClass.getQualifiedName();
        }

        @Nullable
        public PsiElement getRBrace() {
            return this.psiClass.getRBrace();
        }

        @Nullable
        @Contract(pure=true)
        public PsiReference getReference() {
            return this.psiClass.getReference();
        }

        @NotNull
        @Contract(pure=true)
        public PsiReference[] getReferences() {
            return this.psiClass.getReferences();
        }

        @NotNull
        @Contract(pure=true)
        public GlobalSearchScope getResolveScope() {
            return this.psiClass.getResolveScope();
        }

        public PsiElement getScope() {
            return this.psiClass.getScope();
        }

        @Contract(pure=true)
        public int getStartOffsetInParent() {
            return this.psiClass.getStartOffsetInParent();
        }

        @Nullable
        public PsiClass getSuperClass() {
            return this.psiClass.getSuperClass();
        }

        @NotNull
        public PsiClassType[] getSuperTypes() {
            return this.psiClass.getSuperTypes();
        }

        @NotNull
        public PsiClass[] getSupers() {
            return this.psiClass.getSupers();
        }

        @NonNls
        @Contract(pure=true)
        public String getText() {
            return this.psiClass.getText();
        }

        @Contract(pure=true)
        public int getTextLength() {
            return this.psiClass.getTextLength();
        }

        @Contract(pure=true)
        public int getTextOffset() {
            return this.psiClass.getTextOffset();
        }

        @Contract(pure=true)
        public TextRange getTextRange() {
            return this.psiClass.getTextRange();
        }

        @Nullable
        public PsiTypeParameterList getTypeParameterList() {
            return this.psiClass.getTypeParameterList();
        }

        @NotNull
        public PsiTypeParameter[] getTypeParameters() {
            return this.psiClass.getTypeParameters();
        }

        @NotNull
        @Contract(pure=true)
        public SearchScope getUseScope() {
            return this.psiClass.getUseScope();
        }

        @Nullable
        public <T> T getUserData(@NotNull Key<T> p0) {
            Intrinsics.checkParameterIsNotNull(p0, (String)"p0");
            return (T)this.psiClass.getUserData(p0);
        }

        @NotNull
        public Collection<HierarchicalMethodSignature> getVisibleSignatures() {
            return this.psiClass.getVisibleSignatures();
        }

        public boolean hasModifierProperty(@PsiModifier.ModifierConstant @NonNls @NotNull String p0) {
            Intrinsics.checkParameterIsNotNull((Object)p0, (String)"p0");
            return this.psiClass.hasModifierProperty(p0);
        }

        public boolean hasTypeParameters() {
            return this.psiClass.hasTypeParameters();
        }

        public boolean isAnnotationType() {
            return this.psiClass.isAnnotationType();
        }

        public boolean isDeprecated() {
            return this.psiClass.isDeprecated();
        }

        public boolean isEnum() {
            return this.psiClass.isEnum();
        }

        @Contract(pure=true)
        public boolean isEquivalentTo(PsiElement p0) {
            return this.psiClass.isEquivalentTo(p0);
        }

        public boolean isInheritor(@NotNull PsiClass p0, boolean p1) {
            Intrinsics.checkParameterIsNotNull((Object)p0, (String)"p0");
            return this.psiClass.isInheritor(p0, p1);
        }

        public boolean isInheritorDeep(PsiClass p0, @Nullable PsiClass p1) {
            return this.psiClass.isInheritorDeep(p0, p1);
        }

        public boolean isInterface() {
            return this.psiClass.isInterface();
        }

        @Contract(pure=true)
        public boolean isPhysical() {
            return this.psiClass.isPhysical();
        }

        @Contract(pure=true)
        public boolean isWritable() {
            return this.psiClass.isWritable();
        }

        public void navigate(boolean p0) {
            this.psiClass.navigate(p0);
        }

        public boolean processDeclarations(@NotNull PsiScopeProcessor p0, @NotNull ResolveState p1, @Nullable PsiElement p2, @NotNull PsiElement p3) {
            Intrinsics.checkParameterIsNotNull((Object)p0, (String)"p0");
            Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
            Intrinsics.checkParameterIsNotNull((Object)p3, (String)"p3");
            return this.psiClass.processDeclarations(p0, p1, p2, p3);
        }

        public <T> void putCopyableUserData(Key<T> p0, @Nullable T p1) {
            this.psiClass.putCopyableUserData(p0, p1);
        }

        public <T> void putUserData(@NotNull Key<T> p0, @Nullable T p1) {
            Intrinsics.checkParameterIsNotNull(p0, (String)"p0");
            this.psiClass.putUserData(p0, p1);
        }

        public PsiElement replace(@NotNull PsiElement p0) {
            Intrinsics.checkParameterIsNotNull((Object)p0, (String)"p0");
            return this.psiClass.replace(p0);
        }

        public PsiElement setName(@NonNls @NotNull String p0) {
            Intrinsics.checkParameterIsNotNull((Object)p0, (String)"p0");
            return this.psiClass.setName(p0);
        }

        @Contract(pure=true)
        public boolean textContains(char p0) {
            return this.psiClass.textContains(p0);
        }

        @Contract(pure=true)
        public boolean textMatches(@NotNull PsiElement p0) {
            Intrinsics.checkParameterIsNotNull((Object)p0, (String)"p0");
            return this.psiClass.textMatches(p0);
        }

        @Contract(pure=true)
        public boolean textMatches(@NotNull @NonNls CharSequence p0) {
            Intrinsics.checkParameterIsNotNull((Object)p0, (String)"p0");
            return this.psiClass.textMatches(p0);
        }

        @NotNull
        @Contract(pure=true)
        public char[] textToCharArray() {
            return this.psiClass.textToCharArray();
        }
    }
}

