/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDoubleColonExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionImpl;
import org.jetbrains.kotlin.psi.KtVisitor;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J5\u0010\u0012\u001a\u0002H\u0013\"\u0004\b\u0000\u0010\u0013\"\u0004\b\u0001\u0010\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u0002H\u0013\u0012\u0004\u0012\u0002H\u00140\u00162\u0006\u0010\u0017\u001a\u0002H\u0014H\u0016\u00a2\u0006\u0002\u0010\u0018J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000fR\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\fR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/psi/KtDoubleColonExpression;", "Lorg/jetbrains/kotlin/psi/KtExpressionImpl;", "node", "Lcom/intellij/lang/ASTNode;", "(Lcom/intellij/lang/ASTNode;)V", "doubleColonTokenReference", "Lcom/intellij/psi/PsiElement;", "getDoubleColonTokenReference", "()Lcom/intellij/psi/PsiElement;", "hasQuestionMarks", "", "getHasQuestionMarks", "()Z", "isEmptyLHS", "receiverExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getReceiverExpression", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "accept", "R", "D", "visitor", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "data", "(Lorg/jetbrains/kotlin/psi/KtVisitor;Ljava/lang/Object;)Ljava/lang/Object;", "setReceiverExpression", "", "newReceiverExpression", "frontend"})
public abstract class KtDoubleColonExpression
extends KtExpressionImpl {
    @Nullable
    public final KtExpression getReceiverExpression() {
        ASTNode aSTNode = this.getNode();
        Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"node");
        ASTNode aSTNode2 = aSTNode.getFirstChildNode();
        Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode2, (String)"node.firstChildNode");
        PsiElement psiElement2 = aSTNode2.getPsi();
        if (!(psiElement2 instanceof KtExpression)) {
            psiElement2 = null;
        }
        return (KtExpression)psiElement2;
    }

    public final boolean getHasQuestionMarks() {
        ASTNode aSTNode = this.getNode();
        Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"node");
        for (ASTNode element3 : SequencesKt.generateSequence((Object)aSTNode.getFirstChildNode(), (Function1)hasQuestionMarks.1.INSTANCE)) {
            IElementType iElementType = element3.getElementType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.QUEST))) {
                return true;
            }
            if (!Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.COLONCOLON))) continue;
            return false;
        }
        String string = "Double colon expression must have '::': " + this.getText();
        throw (Throwable)new IllegalStateException(string.toString());
    }

    @NotNull
    public final PsiElement getDoubleColonTokenReference() {
        PsiElement psiElement2 = this.findChildByType(KtTokens.COLONCOLON);
        if (psiElement2 == null) {
            Intrinsics.throwNpe();
        }
        return psiElement2;
    }

    public final void setReceiverExpression(@NotNull KtExpression newReceiverExpression) {
        Intrinsics.checkParameterIsNotNull((Object)newReceiverExpression, (String)"newReceiverExpression");
        KtExpression oldReceiverExpression = this.getReceiverExpression();
        KtExpression ktExpression = oldReceiverExpression;
        if (ktExpression == null || (ktExpression = ktExpression.replace((PsiElement)newReceiverExpression)) == null) {
            ktExpression = this.addBefore((PsiElement)newReceiverExpression, this.getDoubleColonTokenReference());
        }
    }

    public final boolean isEmptyLHS() {
        return this.getDoubleColonTokenReference().getPrevSibling() == null;
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data) {
        Intrinsics.checkParameterIsNotNull(visitor2, (String)"visitor");
        return visitor2.visitDoubleColonExpression(this, data);
    }

    public KtDoubleColonExpression(@NotNull ASTNode node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        super(node);
    }
}

