/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.google.common.collect.Lists;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.codeInsight.CommentUtilCore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SyntheticFieldDescriptor;
import org.jetbrains.kotlin.kdoc.psi.api.KDocElement;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.parsing.KotlinExpressionParsing;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtContainerNodeForControlStructureBody;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtDoubleColonExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtFunctionType;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtLabelReferenceExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStatementExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.StatementFilter;
import org.jetbrains.kotlin.resolve.StatementFilterKt;

public class KtPsiUtil {
    private KtPsiUtil() {
    }

    public static <D> void visitChildren(@NotNull KtElement element3, @NotNull KtVisitor<Void, D> visitor2, D data) {
        for (PsiElement child = element3.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof KtElement)) continue;
            ((KtElement)child).accept(visitor2, data);
        }
    }

    @NotNull
    public static KtExpression safeDeparenthesize(@NotNull KtExpression expression2) {
        return KtPsiUtil.safeDeparenthesize(expression2, false);
    }

    @NotNull
    public static KtExpression safeDeparenthesize(@NotNull KtExpression expression2, boolean keepAnnotations) {
        KtExpression deparenthesized = KtPsiUtil.deparenthesize(expression2, keepAnnotations);
        return deparenthesized != null ? deparenthesized : expression2;
    }

    @Nullable
    public static KtExpression deparenthesize(@Nullable KtExpression expression2) {
        return KtPsiUtil.deparenthesize(expression2, false);
    }

    @Nullable
    public static KtExpression deparenthesize(@Nullable KtExpression expression2, boolean keepAnnotations) {
        KtExpression baseExpression;
        while ((baseExpression = KtPsiUtil.deparenthesizeOnce(expression2, keepAnnotations)) != expression2) {
            expression2 = baseExpression;
        }
        return baseExpression;
    }

    @Nullable
    public static KtExpression deparenthesizeOnce(@Nullable KtExpression expression2) {
        return KtPsiUtil.deparenthesizeOnce(expression2, false);
    }

    @Nullable
    public static KtExpression deparenthesizeOnce(@Nullable KtExpression expression2, boolean keepAnnotations) {
        if (expression2 instanceof KtAnnotatedExpression && !keepAnnotations) {
            return ((KtAnnotatedExpression)expression2).getBaseExpression();
        }
        if (expression2 instanceof KtLabeledExpression) {
            return ((KtLabeledExpression)expression2).getBaseExpression();
        }
        if (expression2 instanceof KtExpressionWrapper) {
            return ((KtExpressionWrapper)((Object)expression2)).getBaseExpression();
        }
        if (expression2 instanceof KtParenthesizedExpression) {
            return ((KtParenthesizedExpression)expression2).getExpression();
        }
        return expression2;
    }

    @NotNull
    public static Name safeName(@Nullable String name2) {
        return name2 == null ? SpecialNames.NO_NAME_PROVIDED : Name.identifier(name2);
    }

    @NotNull
    public static Set<KtElement> findRootExpressions(@NotNull Collection<KtElement> unreachableElements) {
        HashSet<KtElement> rootElements = new HashSet<KtElement>();
        final HashSet shadowedElements = new HashSet();
        KtVisitorVoid shadowAllChildren = new KtVisitorVoid(){

            @Override
            public void visitKtElement(@NotNull KtElement element3) {
                if (shadowedElements.add(element3)) {
                    element3.acceptChildren(this);
                }
            }
        };
        for (KtElement element3 : unreachableElements) {
            if (shadowedElements.contains(element3)) continue;
            element3.acceptChildren(shadowAllChildren);
            rootElements.removeAll(shadowedElements);
            rootElements.add(element3);
        }
        return rootElements;
    }

    @NotNull
    public static String unquoteIdentifier(@NotNull String quoted) {
        if (quoted.indexOf(96) < 0) {
            return quoted;
        }
        if (quoted.startsWith("`") && quoted.endsWith("`") && quoted.length() >= 2) {
            return quoted.substring(1, quoted.length() - 1);
        }
        return quoted;
    }

    @NotNull
    public static String unquoteIdentifierOrFieldReference(@NotNull String quoted) {
        if (quoted.indexOf(96) < 0) {
            return quoted;
        }
        if (quoted.startsWith("$")) {
            return "$" + KtPsiUtil.unquoteIdentifier(quoted.substring(1));
        }
        return KtPsiUtil.unquoteIdentifier(quoted);
    }

    @Nullable
    public static Name getShortName(@NotNull KtAnnotationEntry annotation2) {
        KtUserType userType2;
        String shortName;
        KtTypeReference typeReference = annotation2.getTypeReference();
        assert (typeReference != null) : "Annotation entry hasn't typeReference " + annotation2.getText();
        KtTypeElement typeElement = typeReference.getTypeElement();
        if (typeElement instanceof KtUserType && (shortName = (userType2 = (KtUserType)typeElement).getReferencedName()) != null) {
            return Name.identifier(shortName);
        }
        return null;
    }

    public static boolean isDeprecated(@NotNull KtModifierListOwner owner) {
        KtModifierList modifierList = owner.getModifierList();
        if (modifierList != null) {
            List<KtAnnotationEntry> annotationEntries = modifierList.getAnnotationEntries();
            for (KtAnnotationEntry annotation2 : annotationEntries) {
                Name shortName = KtPsiUtil.getShortName(annotation2);
                if (!KotlinBuiltIns.FQ_NAMES.deprecated.shortName().equals(shortName)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static <T extends PsiElement> T getDirectParentOfTypeForBlock(@NotNull KtBlockExpression block, @NotNull Class<T> aClass2) {
        KtFunctionLiteral functionLiteral;
        KtIfExpression ifExpression2;
        PsiElement parent2 = PsiTreeUtil.getParentOfType((PsiElement)block, aClass2);
        if (parent2 instanceof KtIfExpression && ((ifExpression2 = (KtIfExpression)parent2).getElse() == block || ifExpression2.getThen() == block)) {
            return (T)parent2;
        }
        if (parent2 instanceof KtWhenExpression) {
            KtWhenExpression whenExpression2 = (KtWhenExpression)parent2;
            for (KtWhenEntry whenEntry : whenExpression2.getEntries()) {
                if (whenEntry.getExpression() != block) continue;
                return (T)parent2;
            }
        }
        if (parent2 instanceof KtFunctionLiteral && (functionLiteral = (KtFunctionLiteral)parent2).getBodyExpression() == block) {
            return (T)parent2;
        }
        if (parent2 instanceof KtTryExpression) {
            KtTryExpression tryExpression = (KtTryExpression)parent2;
            if (tryExpression.getTryBlock() == block) {
                return (T)parent2;
            }
            for (KtCatchClause clause : tryExpression.getCatchClauses()) {
                if (clause.getCatchBody() != block) continue;
                return (T)parent2;
            }
        }
        return null;
    }

    @Nullable
    public static Name getAliasName(@NotNull KtImportDirective importDirective) {
        if (importDirective.isAllUnder()) {
            return null;
        }
        String aliasName = importDirective.getAliasName();
        KtExpression importedReference = importDirective.getImportedReference();
        if (importedReference == null) {
            return null;
        }
        KtSimpleNameExpression referenceExpression = KtPsiUtil.getLastReference(importedReference);
        if (aliasName == null) {
            aliasName = referenceExpression != null ? referenceExpression.getReferencedName() : null;
        }
        return aliasName != null && !aliasName.isEmpty() ? Name.identifier(aliasName) : null;
    }

    @Nullable
    public static KtSimpleNameExpression getLastReference(@NotNull KtExpression importedReference) {
        KtElement selector = KtPsiUtilKt.getQualifiedElementSelector(importedReference);
        return selector instanceof KtSimpleNameExpression ? (KtSimpleNameExpression)selector : null;
    }

    public static boolean isSelectorInQualified(@NotNull KtSimpleNameExpression nameExpression2) {
        KtElement qualifiedElement = KtPsiUtilKt.getQualifiedElement(nameExpression2);
        return qualifiedElement instanceof KtQualifiedExpression || qualifiedElement instanceof KtUserType && ((KtUserType)qualifiedElement).getQualifier() != null;
    }

    public static boolean isLHSOfDot(@NotNull KtExpression expression2) {
        PsiElement parent2 = expression2.getParent();
        if (!(parent2 instanceof KtQualifiedExpression)) {
            return false;
        }
        KtQualifiedExpression qualifiedParent = (KtQualifiedExpression)parent2;
        return qualifiedParent.getReceiverExpression() == expression2 || KtPsiUtil.isLHSOfDot(qualifiedParent);
    }

    public static boolean isScriptDeclaration(@NotNull KtDeclaration namedDeclaration) {
        return KtPsiUtil.getScript(namedDeclaration) != null;
    }

    @Nullable
    public static KtScript getScript(@NotNull KtDeclaration namedDeclaration) {
        PsiElement parent2 = namedDeclaration.getParent();
        if (parent2 != null && parent2.getParent() instanceof KtScript) {
            return (KtScript)parent2.getParent();
        }
        return null;
    }

    public static boolean isRemovableVariableDeclaration(@NotNull KtDeclaration declaration2) {
        if (!(declaration2 instanceof KtVariableDeclaration)) {
            return false;
        }
        if (declaration2 instanceof KtProperty) {
            return true;
        }
        assert (declaration2 instanceof KtDestructuringDeclarationEntry);
        return true;
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static PsiElement getTopmostParentOfTypes(@Nullable PsiElement element3, Class<? extends PsiElement> ... parentTypes) {
        PsiElement next2;
        if (element3 instanceof PsiFile) {
            return null;
        }
        PsiElement answer = PsiTreeUtil.getParentOfType((PsiElement)element3, (Class[])parentTypes);
        if (answer instanceof PsiFile) {
            return answer;
        }
        while ((next2 = PsiTreeUtil.getParentOfType((PsiElement)answer, (Class[])parentTypes)) != null) {
            answer = next2;
        }
        return answer;
    }

    public static boolean isNullConstant(@NotNull KtExpression expression2) {
        KtExpression deparenthesized = KtPsiUtil.deparenthesize(expression2);
        return deparenthesized instanceof KtConstantExpression && deparenthesized.getNode().getElementType() == KtNodeTypes.NULL;
    }

    public static boolean isTrueConstant(@Nullable KtExpression condition2) {
        return KtPsiUtil.isBooleanConstant(condition2) && condition2.getNode().findChildByType((IElementType)KtTokens.TRUE_KEYWORD) != null;
    }

    public static boolean isFalseConstant(@Nullable KtExpression condition2) {
        return KtPsiUtil.isBooleanConstant(condition2) && condition2.getNode().findChildByType((IElementType)KtTokens.FALSE_KEYWORD) != null;
    }

    public static boolean isBooleanConstant(@Nullable KtExpression condition2) {
        return condition2 != null && condition2.getNode().getElementType() == KtNodeTypes.BOOLEAN_CONSTANT;
    }

    public static boolean isAbstract(@NotNull KtDeclarationWithBody declaration2) {
        return declaration2.getBodyExpression() == null;
    }

    public static boolean isBackingFieldReference(@Nullable DeclarationDescriptor descriptor2) {
        return descriptor2 instanceof SyntheticFieldDescriptor;
    }

    @Nullable
    public static KtExpression getExpressionOrLastStatementInBlock(@Nullable KtExpression expression2) {
        if (expression2 instanceof KtBlockExpression) {
            return KtPsiUtil.getLastStatementInABlock((KtBlockExpression)expression2);
        }
        return expression2;
    }

    @Nullable
    public static KtExpression getLastStatementInABlock(@Nullable KtBlockExpression blockExpression2) {
        if (blockExpression2 == null) {
            return null;
        }
        List<KtExpression> statements = blockExpression2.getStatements();
        return statements.isEmpty() ? null : statements.get(statements.size() - 1);
    }

    public static boolean isTrait(@NotNull KtClassOrObject classOrObject) {
        return classOrObject instanceof KtClass && ((KtClass)classOrObject).isInterface();
    }

    @Nullable
    public static KtClassOrObject getOutermostClassOrObject(@NotNull KtClassOrObject classOrObject) {
        KtClassOrObject current = classOrObject;
        while (true) {
            PsiElement parent2 = current.getParent();
            assert (classOrObject.getParent() != null) : "Class with no parent: " + classOrObject.getText();
            if (parent2 instanceof PsiFile) {
                return current;
            }
            if (!(parent2 instanceof KtClassBody)) {
                return current;
            }
            current = (KtClassOrObject)parent2.getParent();
        }
    }

    @Nullable
    public static KtClassOrObject getClassIfParameterIsProperty(@NotNull KtParameter jetParameter) {
        PsiElement grandParent;
        if (jetParameter.hasValOrVar() && (grandParent = jetParameter.getParent().getParent()) instanceof KtPrimaryConstructor) {
            return ((KtPrimaryConstructor)grandParent).getContainingClassOrObject();
        }
        return null;
    }

    @Nullable
    private static IElementType getOperation(@NotNull KtExpression expression2) {
        if (expression2 instanceof KtQualifiedExpression) {
            return ((KtQualifiedExpression)expression2).getOperationSign();
        }
        if (expression2 instanceof KtOperationExpression) {
            return ((KtOperationExpression)expression2).getOperationReference().getReferencedNameElementType();
        }
        return null;
    }

    private static int getPriority(@NotNull KtExpression expression2) {
        int maxPriority = KotlinExpressionParsing.Precedence.values().length + 1;
        if (expression2 instanceof KtPostfixExpression || expression2 instanceof KtQualifiedExpression || expression2 instanceof KtCallExpression || expression2 instanceof KtArrayAccessExpression || expression2 instanceof KtDoubleColonExpression) {
            return maxPriority - 1;
        }
        if (expression2 instanceof KtPrefixExpression || expression2 instanceof KtLabeledExpression) {
            return maxPriority - 2;
        }
        if (expression2 instanceof KtIfExpression) {
            return KotlinExpressionParsing.Precedence.ASSIGNMENT.ordinal();
        }
        if (expression2 instanceof KtSuperExpression) {
            return maxPriority;
        }
        if (expression2 instanceof KtDeclaration || expression2 instanceof KtStatementExpression) {
            return 0;
        }
        IElementType operation = KtPsiUtil.getOperation(expression2);
        for (KotlinExpressionParsing.Precedence precedence : KotlinExpressionParsing.Precedence.values()) {
            if (precedence == KotlinExpressionParsing.Precedence.PREFIX || precedence == KotlinExpressionParsing.Precedence.POSTFIX || !precedence.getOperations().contains(operation)) continue;
            return maxPriority - precedence.ordinal() - 1;
        }
        return maxPriority;
    }

    public static boolean areParenthesesUseless(@NotNull KtParenthesizedExpression expression2) {
        KtExpression innerExpression = expression2.getExpression();
        if (innerExpression == null) {
            return true;
        }
        PsiElement parent2 = expression2.getParent();
        if (!(parent2 instanceof KtExpression)) {
            return true;
        }
        return !KtPsiUtil.areParenthesesNecessary(innerExpression, expression2, (KtExpression)parent2);
    }

    public static boolean areParenthesesNecessary(@NotNull KtExpression innerExpression, @NotNull KtExpression currentInner, @NotNull KtElement parentElement) {
        int parentPriority;
        int innerPriority;
        if (parentElement instanceof KtParenthesizedExpression || innerExpression instanceof KtParenthesizedExpression) {
            return false;
        }
        if (parentElement instanceof KtPackageDirective) {
            return false;
        }
        if (parentElement instanceof KtWhenExpression || innerExpression instanceof KtWhenExpression) {
            return false;
        }
        if (innerExpression instanceof KtIfExpression) {
            if (parentElement instanceof KtQualifiedExpression) {
                return true;
            }
            KtElement current = parentElement;
            while (!(current instanceof KtBlockExpression || current instanceof KtDeclaration || current instanceof KtStatementExpression || current instanceof KtFile)) {
                if (current.getTextRange().getEndOffset() != currentInner.getTextRange().getEndOffset()) {
                    return !(current instanceof KtParenthesizedExpression) && !(current instanceof KtValueArgumentList);
                }
                current = current.getParent();
            }
        }
        if (parentElement instanceof KtCallExpression && currentInner == ((KtCallExpression)parentElement).getCalleeExpression()) {
            KtCallExpression parentCall2 = (KtCallExpression)parentElement;
            if (innerExpression instanceof KtSimpleNameExpression) {
                return false;
            }
            if (KtPsiUtilKt.getQualifiedExpressionForSelector(parentElement) != null) {
                return true;
            }
            if (innerExpression instanceof KtCallExpression && parentCall2.getValueArgumentList() == null) {
                return true;
            }
            return !(innerExpression instanceof KtThisExpression) && !(innerExpression instanceof KtArrayAccessExpression) && !(innerExpression instanceof KtConstantExpression) && !(innerExpression instanceof KtStringTemplateExpression) && !(innerExpression instanceof KtCallExpression);
        }
        if (parentElement instanceof KtValueArgument) {
            KtExpression nextExpression;
            KtValueArgument nextArg = (KtValueArgument)PsiTreeUtil.getNextSiblingOfType((PsiElement)parentElement, KtValueArgument.class);
            KtExpression ktExpression = nextExpression = nextArg != null ? nextArg.getArgumentExpression() : null;
            if (innerExpression instanceof KtBinaryExpression && ((KtBinaryExpression)innerExpression).getOperationToken() == KtTokens.LT && nextExpression instanceof KtBinaryExpression && ((KtBinaryExpression)nextExpression).getOperationToken() == KtTokens.GT) {
                return true;
            }
        }
        if (!(parentElement instanceof KtExpression)) {
            return false;
        }
        IElementType innerOperation = KtPsiUtil.getOperation(innerExpression);
        IElementType parentOperation = KtPsiUtil.getOperation((KtExpression)parentElement);
        if (parentElement instanceof KtReturnExpression && (innerExpression instanceof KtLabeledExpression || innerExpression instanceof KtAnnotatedExpression)) {
            return true;
        }
        if (innerExpression instanceof KtBinaryExpressionWithTypeRHS && parentOperation == KtTokens.LT) {
            return true;
        }
        if (parentElement instanceof KtLabeledExpression) {
            return false;
        }
        if (parentElement instanceof KtBinaryExpression && parentOperation == KtTokens.ELVIS && !(innerExpression instanceof KtBinaryExpression) && currentInner == ((KtBinaryExpression)parentElement).getRight()) {
            return false;
        }
        if (innerExpression instanceof KtBinaryExpression) {
            KtBinaryExpression innerBinary;
            if (parentElement instanceof KtBinaryExpression && (innerBinary = (KtBinaryExpression)innerExpression).getRight() instanceof KtReturnExpression) {
                return true;
            }
            if (innerOperation != KtTokens.ELVIS && KtPsiUtil.isKeepBinaryExpressionParenthesized((KtBinaryExpression)innerExpression)) {
                return true;
            }
        }
        if ((innerPriority = KtPsiUtil.getPriority(innerExpression)) == (parentPriority = KtPsiUtil.getPriority((KtExpression)parentElement))) {
            if (parentElement instanceof KtBinaryExpression) {
                if (innerOperation == KtTokens.ANDAND || innerOperation == KtTokens.OROR) {
                    return false;
                }
                return ((KtBinaryExpression)parentElement).getRight() == currentInner;
            }
            if (parentElement instanceof KtPrefixExpression && innerExpression instanceof KtPrefixExpression) {
                return innerOperation == parentOperation && (innerOperation == KtTokens.PLUS || innerOperation == KtTokens.MINUS);
            }
            return false;
        }
        return innerPriority < parentPriority;
    }

    private static boolean isKeepBinaryExpressionParenthesized(KtBinaryExpression expression2) {
        for (PsiElement expr2 = expression2.getFirstChild(); expr2 != null; expr2 = expr2.getNextSibling()) {
            if (expr2 instanceof PsiWhiteSpace && expr2.textContains('\n')) {
                return true;
            }
            if (expr2 instanceof KtOperationReferenceExpression) break;
        }
        return expression2.getRight() instanceof KtBinaryExpression && KtPsiUtil.isKeepBinaryExpressionParenthesized((KtBinaryExpression)expression2.getRight()) || expression2.getLeft() instanceof KtBinaryExpression && KtPsiUtil.isKeepBinaryExpressionParenthesized((KtBinaryExpression)expression2.getLeft());
    }

    public static boolean isAssignment(@NotNull PsiElement element3) {
        return element3 instanceof KtBinaryExpression && KtTokens.ALL_ASSIGNMENTS.contains(((KtBinaryExpression)element3).getOperationToken());
    }

    public static boolean isOrdinaryAssignment(@NotNull PsiElement element3) {
        return element3 instanceof KtBinaryExpression && ((KtBinaryExpression)element3).getOperationToken().equals((Object)KtTokens.EQ);
    }

    public static boolean isSafeCast(@NotNull KtBinaryExpressionWithTypeRHS expression2) {
        return expression2.getOperationReference().getReferencedNameElementType() == KtTokens.AS_SAFE;
    }

    public static boolean isUnsafeCast(@NotNull KtBinaryExpressionWithTypeRHS expression2) {
        return expression2.getOperationReference().getReferencedNameElementType() == KtTokens.AS_KEYWORD;
    }

    public static boolean checkVariableDeclarationInBlock(@NotNull KtBlockExpression block, @NotNull String varName) {
        for (KtExpression element3 : block.getStatements()) {
            if (!(element3 instanceof KtVariableDeclaration) || !((KtVariableDeclaration)element3).getNameAsSafeName().asString().equals(varName)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkWhenExpressionHasSingleElse(@NotNull KtWhenExpression whenExpression2) {
        int elseCount = 0;
        for (KtWhenEntry entry : whenExpression2.getEntries()) {
            if (!entry.isElse()) continue;
            ++elseCount;
        }
        return elseCount == 1;
    }

    @Nullable
    public static PsiElement skipTrailingWhitespacesAndComments(@Nullable PsiElement element3) {
        return PsiTreeUtil.skipSiblingsForward((PsiElement)element3, (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class});
    }

    @Nullable
    public static PsiElement prevLeafIgnoringWhitespaceAndComments(@NotNull PsiElement element3) {
        PsiElement prev2 = PsiTreeUtil.prevLeaf((PsiElement)element3, (boolean)true);
        while (prev2 != null && KtTokens.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(prev2.getNode().getElementType())) {
            prev2 = PsiTreeUtil.prevLeaf((PsiElement)prev2, (boolean)true);
        }
        return prev2;
    }

    @Nullable
    public static PsiElement getPreviousWord(@NotNull PsiElement element3, @NotNull String word) {
        PsiElement prev2 = KtPsiUtil.prevLeafIgnoringWhitespaceAndComments(element3);
        if (prev2 != null && prev2.getNode().getElementType() == KtTokens.IDENTIFIER && word.equals(prev2.getText())) {
            return prev2;
        }
        return null;
    }

    @NotNull
    public static String getText(@Nullable PsiElement element3) {
        return element3 != null ? element3.getText() : "";
    }

    @Nullable
    public static String getNullableText(@Nullable PsiElement element3) {
        return element3 != null ? element3.getText() : null;
    }

    public static boolean isInComment(PsiElement element3) {
        return CommentUtilCore.isComment((PsiElement)element3) || element3 instanceof KDocElement;
    }

    @Nullable
    public static PsiElement getOutermostParent(@NotNull PsiElement element3, @NotNull PsiElement upperBound, boolean strict) {
        PsiElement parent2;
        PsiElement psiElement2 = parent2 = strict ? element3.getParent() : element3;
        while (parent2 != null && parent2.getParent() != upperBound) {
            parent2 = parent2.getParent();
        }
        return parent2;
    }

    public static <T extends PsiElement> T getLastChildByType(@NotNull PsiElement root, Class<? extends T> ... elementTypes) {
        PsiElement[] children2 = root.getChildren();
        for (int i = children2.length - 1; i >= 0; --i) {
            if (!PsiTreeUtil.instanceOf((Object)children2[i], (Class[])elementTypes)) continue;
            return (T)children2[i];
        }
        return null;
    }

    @Nullable
    public static KtElement getOutermostDescendantElement(@Nullable PsiElement root, boolean first, final @NotNull Predicate<KtElement> predicate2) {
        if (!(root instanceof KtElement)) {
            return null;
        }
        final ArrayList results2 = Lists.newArrayList();
        root.accept((PsiElementVisitor)new KtVisitorVoid(){

            @Override
            public void visitKtElement(@NotNull KtElement element3) {
                if (predicate2.test(element3)) {
                    results2.add(element3);
                } else {
                    element3.acceptChildren(this);
                }
            }
        });
        if (results2.isEmpty()) {
            return null;
        }
        return first ? (KtElement)results2.get(0) : (KtElement)results2.get(results2.size() - 1);
    }

    @Nullable
    public static PsiElement findChildByType(@NotNull PsiElement element3, @NotNull IElementType type2) {
        ASTNode node = element3.getNode().findChildByType(type2);
        return node == null ? null : node.getPsi();
    }

    @Nullable
    public static PsiElement skipSiblingsBackwardByPredicate(@Nullable PsiElement element3, Predicate<PsiElement> elementsToSkip) {
        if (element3 == null) {
            return null;
        }
        for (PsiElement e = element3.getPrevSibling(); e != null; e = e.getPrevSibling()) {
            if (elementsToSkip.test(e)) continue;
            return e;
        }
        return null;
    }

    public static PsiElement ascendIfPropertyAccessor(PsiElement element3) {
        if (element3 instanceof KtPropertyAccessor) {
            return element3.getParent();
        }
        return element3;
    }

    @Nullable
    @Contract(value="_, !null -> !null")
    public static KtModifierList replaceModifierList(@NotNull KtModifierListOwner owner, @Nullable KtModifierList modifierList) {
        KtModifierList oldModifierList = owner.getModifierList();
        if (modifierList == null) {
            if (oldModifierList != null) {
                oldModifierList.delete();
            }
            return null;
        }
        if (oldModifierList == null) {
            PsiElement firstChild = owner.getFirstChild();
            return (KtModifierList)owner.addBefore((PsiElement)modifierList, firstChild);
        }
        return (KtModifierList)oldModifierList.replace((PsiElement)modifierList);
    }

    @Nullable
    public static String getPackageName(@NotNull KtElement element3) {
        KtFile file2 = element3.getContainingKtFile();
        KtPackageDirective header = (KtPackageDirective)PsiTreeUtil.findChildOfType((PsiElement)file2, KtPackageDirective.class);
        return header != null ? header.getQualifiedName() : null;
    }

    @Nullable
    public static KtElement getEnclosingElementForLocalDeclaration(@NotNull KtDeclaration declaration2) {
        return KtPsiUtil.getEnclosingElementForLocalDeclaration(declaration2, true);
    }

    private static boolean isMemberOfObjectExpression(@NotNull KtCallableDeclaration propertyOrFunction) {
        PsiElement parent2 = PsiTreeUtil.getStubOrPsiParent((PsiElement)propertyOrFunction);
        if (!(parent2 instanceof KtClassBody)) {
            return false;
        }
        PsiElement grandparent = PsiTreeUtil.getStubOrPsiParent((PsiElement)parent2);
        if (!(grandparent instanceof KtObjectDeclaration)) {
            return false;
        }
        return PsiTreeUtil.getStubOrPsiParent((PsiElement)grandparent) instanceof KtObjectLiteralExpression;
    }

    private static boolean isNonLocalCallable(@Nullable KtDeclaration declaration2) {
        if (declaration2 instanceof KtProperty) {
            return !((KtProperty)declaration2).isLocal();
        }
        if (declaration2 instanceof KtFunction) {
            return !((KtFunction)declaration2).isLocal();
        }
        return false;
    }

    @Nullable
    public static KtElement getEnclosingElementForLocalDeclaration(@NotNull KtDeclaration declaration2, boolean skipParameters) {
        if (declaration2 instanceof KtTypeParameter && skipParameters) {
            declaration2 = (KtDeclaration)PsiTreeUtil.getParentOfType((PsiElement)declaration2, KtNamedDeclaration.class);
        } else if (declaration2 instanceof KtParameter) {
            KtFunctionType functionType2 = (KtFunctionType)PsiTreeUtil.getParentOfType((PsiElement)declaration2, KtFunctionType.class);
            if (functionType2 != null) {
                return functionType2;
            }
            PsiElement parent2 = declaration2.getParent();
            if (((KtParameter)declaration2).hasValOrVar() && parent2 != null && parent2.getParent() instanceof KtPrimaryConstructor) {
                return KtPsiUtil.getEnclosingElementForLocalDeclaration(((KtPrimaryConstructor)parent2.getParent()).getContainingClassOrObject(), skipParameters);
            }
            if (skipParameters && parent2 != null && !(parent2 instanceof KtForExpression) && parent2.getParent() instanceof KtNamedFunction) {
                declaration2 = (KtNamedFunction)parent2.getParent();
            }
        }
        if (declaration2 instanceof PsiFile) {
            return declaration2;
        }
        PsiElement current = PsiTreeUtil.getStubOrPsiParent((PsiElement)declaration2);
        boolean isNonLocalCallable = KtPsiUtil.isNonLocalCallable(declaration2);
        while (current != null) {
            PsiElement grandParent;
            PsiElement parent3 = PsiTreeUtil.getStubOrPsiParent((PsiElement)current);
            if (parent3 instanceof KtScript) {
                return null;
            }
            if (current instanceof KtAnonymousInitializer) {
                return ((KtAnonymousInitializer)current).getBody();
            }
            if (current instanceof KtProperty || current instanceof KtFunction) {
                if (parent3 instanceof KtFile) {
                    return (KtElement)current;
                }
                if (parent3 instanceof KtClassBody && !KtPsiUtil.isMemberOfObjectExpression((KtCallableDeclaration)current)) {
                    return (KtElement)parent3;
                }
            }
            if (current instanceof KtParameter) {
                return (KtElement)current;
            }
            if (current instanceof KtValueArgument && !isNonLocalCallable) {
                return (KtElement)current;
            }
            if (!(!(current instanceof KtBlockExpression) || isNonLocalCallable && current.getParent() instanceof KtFunctionLiteral)) {
                return (KtElement)current;
            }
            if ((current instanceof KtDelegatedSuperTypeEntry || current instanceof KtSuperTypeCallEntry) && (grandParent = current.getParent().getParent()) instanceof KtClassOrObject && !(grandParent.getParent() instanceof KtObjectLiteralExpression)) {
                return (KtElement)grandParent;
            }
            current = parent3;
        }
        return null;
    }

    public static boolean isLocal(@NotNull KtDeclaration declaration2) {
        return KtPsiUtil.getEnclosingElementForLocalDeclaration(declaration2) != null;
    }

    @Nullable
    public static KtToken getOperationToken(@NotNull KtOperationExpression expression2) {
        KtSimpleNameExpression operationExpression = expression2.getOperationReference();
        IElementType elementType = operationExpression.getReferencedNameElementType();
        assert (elementType == null || elementType instanceof KtToken) : "JetOperationExpression should have operation token of type KtToken: " + expression2;
        return (KtToken)elementType;
    }

    public static boolean isLabelIdentifierExpression(PsiElement element3) {
        return element3 instanceof KtLabelReferenceExpression;
    }

    @Nullable
    public static KtExpression getParentCallIfPresent(@NotNull KtExpression expression2) {
        PsiElement parent2 = expression2.getParent();
        while (parent2 != null) {
            if (parent2 instanceof KtBinaryExpression || parent2 instanceof KtUnaryExpression || parent2 instanceof KtLabeledExpression || parent2 instanceof KtDotQualifiedExpression || parent2 instanceof KtCallExpression || parent2 instanceof KtArrayAccessExpression || parent2 instanceof KtDestructuringDeclaration) {
                if (parent2 instanceof KtLabeledExpression) {
                    parent2 = parent2.getParent();
                    continue;
                }
                return (KtExpression)parent2;
            }
            if (parent2 instanceof KtParenthesizedExpression || parent2 instanceof KtBinaryExpressionWithTypeRHS) {
                parent2 = parent2.getParent();
                continue;
            }
            if (parent2 instanceof KtValueArgument || parent2 instanceof KtValueArgumentList) {
                parent2 = parent2.getParent();
                continue;
            }
            if (parent2 instanceof KtLambdaExpression || parent2 instanceof KtAnnotatedExpression) {
                parent2 = parent2.getParent();
                continue;
            }
            return null;
        }
        return null;
    }

    public static boolean isLabeledFunctionLiteral(@NotNull KtFunctionLiteral functionLiteral) {
        return functionLiteral.getParent().getParent() instanceof KtLabeledExpression;
    }

    @Nullable
    public static KtExpression getLastElementDeparenthesized(@Nullable KtExpression expression2, @NotNull StatementFilter statementFilter) {
        KtBlockExpression blockExpression2;
        KtExpression lastStatementInABlock;
        KtExpression deparenthesizedExpression = KtPsiUtil.deparenthesize(expression2);
        if (deparenthesizedExpression instanceof KtBlockExpression && (lastStatementInABlock = StatementFilterKt.getLastStatementInABlock(statementFilter, blockExpression2 = (KtBlockExpression)deparenthesizedExpression)) != null) {
            return KtPsiUtil.getLastElementDeparenthesized(lastStatementInABlock, statementFilter);
        }
        return deparenthesizedExpression;
    }

    public static boolean isStatementContainer(@Nullable PsiElement container2) {
        return container2 instanceof KtBlockExpression || container2 instanceof KtContainerNodeForControlStructureBody || container2 instanceof KtWhenEntry;
    }

    public static boolean isStatement(@NotNull PsiElement element3) {
        return KtPsiUtil.isStatementContainer(element3.getParent());
    }

    public static boolean isInOrNotInOperation(@NotNull KtBinaryExpression binaryExpression) {
        return KtPsiUtil.isInOperation(binaryExpression) || KtPsiUtil.isNotInOperation(binaryExpression);
    }

    public static boolean isNotInOperation(@NotNull KtBinaryExpression binaryExpression) {
        return binaryExpression.getOperationToken() == KtTokens.NOT_IN;
    }

    private static boolean isInOperation(@NotNull KtBinaryExpression binaryExpression) {
        return binaryExpression.getOperationToken() == KtTokens.IN_KEYWORD;
    }

    public static interface KtExpressionWrapper {
        public KtExpression getBaseExpression();
    }
}

