/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants;

import com.google.common.collect.Sets;
import com.intellij.psi.tree.IElementType;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;

public class CompileTimeConstantChecker {
    private static final Set<DiagnosticFactory<?>> errorsThatDependOnExpectedType = Sets.newHashSet((Object[])new DiagnosticFactory[]{Errors.CONSTANT_EXPECTED_TYPE_MISMATCH, Errors.NULL_FOR_NONNULL_TYPE});
    private final ResolutionContext<?> context;
    private final ModuleDescriptor module;
    private final KotlinBuiltIns builtIns;
    private final boolean checkOnlyErrorsThatDependOnExpectedType;
    private final BindingTrace trace;

    public CompileTimeConstantChecker(@NotNull ResolutionContext<?> context, @NotNull ModuleDescriptor module, boolean checkOnlyErrorsThatDependOnExpectedType) {
        this.context = context;
        this.module = module;
        this.builtIns = module.getBuiltIns();
        this.checkOnlyErrorsThatDependOnExpectedType = checkOnlyErrorsThatDependOnExpectedType;
        this.trace = context.trace;
    }

    public boolean checkConstantExpressionType(@Nullable ConstantValue<?> compileTimeConstant, @NotNull KtConstantExpression expression2, @NotNull KotlinType expectedType2) {
        IElementType elementType = expression2.getNode().getElementType();
        if (elementType == KtNodeTypes.INTEGER_CONSTANT) {
            return this.checkIntegerValue(compileTimeConstant, expectedType2, expression2);
        }
        if (elementType == KtNodeTypes.FLOAT_CONSTANT) {
            return this.checkFloatValue(compileTimeConstant, expectedType2, expression2);
        }
        if (elementType == KtNodeTypes.BOOLEAN_CONSTANT) {
            return this.checkBooleanValue(expectedType2, expression2);
        }
        if (elementType == KtNodeTypes.CHARACTER_CONSTANT) {
            return this.checkCharValue(compileTimeConstant, expectedType2, expression2);
        }
        if (elementType == KtNodeTypes.NULL) {
            return this.checkNullValue(expectedType2, expression2);
        }
        return false;
    }

    private boolean checkIntegerValue(@Nullable ConstantValue<?> value2, @NotNull KotlinType expectedType2, @NotNull KtConstantExpression expression2) {
        KotlinType valueType;
        if (value2 == null) {
            return this.reportError(Errors.INT_LITERAL_OUT_OF_RANGE.on(expression2));
        }
        if (expression2.getText().endsWith("l")) {
            return this.reportError(Errors.WRONG_LONG_SUFFIX.on(expression2));
        }
        if (!CompileTimeConstantChecker.noExpectedTypeOrError(expectedType2) && !KotlinTypeChecker.DEFAULT.isSubtypeOf(valueType = value2.getType(this.module), expectedType2)) {
            return this.reportConstantExpectedTypeMismatch(expression2, "integer", expectedType2, null);
        }
        return false;
    }

    private boolean checkFloatValue(@Nullable ConstantValue<?> value2, @NotNull KotlinType expectedType2, @NotNull KtConstantExpression expression2) {
        KotlinType valueType;
        if (value2 == null) {
            return this.reportError(Errors.FLOAT_LITERAL_OUT_OF_RANGE.on(expression2));
        }
        if (!CompileTimeConstantChecker.noExpectedTypeOrError(expectedType2) && !KotlinTypeChecker.DEFAULT.isSubtypeOf(valueType = value2.getType(this.module), expectedType2)) {
            return this.reportConstantExpectedTypeMismatch(expression2, "floating-point", expectedType2, null);
        }
        return false;
    }

    private boolean checkBooleanValue(@NotNull KotlinType expectedType2, @NotNull KtConstantExpression expression2) {
        if (!CompileTimeConstantChecker.noExpectedTypeOrError(expectedType2) && !KotlinTypeChecker.DEFAULT.isSubtypeOf(this.builtIns.getBooleanType(), expectedType2)) {
            return this.reportConstantExpectedTypeMismatch(expression2, "boolean", expectedType2, this.builtIns.getBooleanType());
        }
        return false;
    }

    private boolean checkCharValue(ConstantValue<?> constant, KotlinType expectedType2, KtConstantExpression expression2) {
        if (!CompileTimeConstantChecker.noExpectedTypeOrError(expectedType2) && !KotlinTypeChecker.DEFAULT.isSubtypeOf(this.builtIns.getCharType(), expectedType2)) {
            return this.reportConstantExpectedTypeMismatch(expression2, "character", expectedType2, this.builtIns.getCharType());
        }
        if (constant != null) {
            return false;
        }
        Diagnostic diagnostic = CompileTimeConstantChecker.parseCharacter(expression2).getDiagnostic();
        if (diagnostic != null) {
            return this.reportError(diagnostic);
        }
        return false;
    }

    private boolean checkNullValue(@NotNull KotlinType expectedType2, @NotNull KtConstantExpression expression2) {
        if (!CompileTimeConstantChecker.noExpectedTypeOrError(expectedType2) && !TypeUtils.acceptsNullable(expectedType2)) {
            if (DiagnosticUtilsKt.reportTypeMismatchDueToTypeProjection(this.context, expression2, expectedType2, this.builtIns.getNullableNothingType())) {
                return true;
            }
            return this.reportError(Errors.NULL_FOR_NONNULL_TYPE.on(expression2, expectedType2));
        }
        return false;
    }

    @NotNull
    private static CharacterWithDiagnostic parseCharacter(@NotNull KtConstantExpression expression2) {
        String text2 = expression2.getText();
        if (text2.length() < 2 || text2.charAt(0) != '\'' || text2.charAt(text2.length() - 1) != '\'') {
            return CompileTimeConstantChecker.createErrorCharacter(Errors.INCORRECT_CHARACTER_LITERAL.on(expression2));
        }
        if ((text2 = text2.substring(1, text2.length() - 1)).length() == 0) {
            return CompileTimeConstantChecker.createErrorCharacter(Errors.EMPTY_CHARACTER_LITERAL.on(expression2));
        }
        if (text2.charAt(0) != '\\') {
            if (text2.length() == 1) {
                return new CharacterWithDiagnostic(text2.charAt(0));
            }
            return CompileTimeConstantChecker.createErrorCharacter(Errors.TOO_MANY_CHARACTERS_IN_CHARACTER_LITERAL.on(expression2, expression2));
        }
        return CompileTimeConstantChecker.escapedStringToCharacter(text2, expression2);
    }

    @NotNull
    public static CharacterWithDiagnostic escapedStringToCharacter(@NotNull String text2, @NotNull KtElement expression2) {
        assert (text2.length() > 0 && text2.charAt(0) == '\\') : "Only escaped sequences must be passed to this routine: " + text2;
        String escape = text2.substring(1);
        switch (escape.length()) {
            case 0: {
                return CompileTimeConstantChecker.illegalEscape(expression2);
            }
            case 1: {
                Character escaped = CompileTimeConstantChecker.translateEscape(escape.charAt(0));
                if (escaped == null) {
                    return CompileTimeConstantChecker.illegalEscape(expression2);
                }
                return new CharacterWithDiagnostic(escaped.charValue());
            }
            case 5: {
                if (escape.charAt(0) != 'u') break;
                try {
                    Integer intValue = Integer.valueOf(escape.substring(1), 16);
                    return new CharacterWithDiagnostic((char)intValue.intValue());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return CompileTimeConstantChecker.illegalEscape(expression2);
    }

    @NotNull
    private static CharacterWithDiagnostic illegalEscape(@NotNull KtElement expression2) {
        return CompileTimeConstantChecker.createErrorCharacter(Errors.ILLEGAL_ESCAPE.on(expression2, expression2));
    }

    @NotNull
    private static CharacterWithDiagnostic createErrorCharacter(@NotNull Diagnostic diagnostic) {
        return new CharacterWithDiagnostic(diagnostic);
    }

    @Nullable
    public static Character parseChar(@NotNull KtConstantExpression expression2) {
        return CompileTimeConstantChecker.parseCharacter(expression2).getValue();
    }

    @Nullable
    private static Character translateEscape(char c) {
        switch (c) {
            case 't': {
                return Character.valueOf('\t');
            }
            case 'b': {
                return Character.valueOf('\b');
            }
            case 'n': {
                return Character.valueOf('\n');
            }
            case 'r': {
                return Character.valueOf('\r');
            }
            case '\'': {
                return Character.valueOf('\'');
            }
            case '\"': {
                return Character.valueOf('\"');
            }
            case '\\': {
                return Character.valueOf('\\');
            }
            case '$': {
                return Character.valueOf('$');
            }
        }
        return null;
    }

    private static boolean noExpectedTypeOrError(KotlinType expectedType2) {
        return TypeUtils.noExpectedType(expectedType2) || KotlinTypeKt.isError(expectedType2);
    }

    private boolean reportConstantExpectedTypeMismatch(@NotNull KtConstantExpression expression2, @NotNull String typeName, @NotNull KotlinType expectedType2, @Nullable KotlinType expressionType) {
        if (DiagnosticUtilsKt.reportTypeMismatchDueToTypeProjection(this.context, expression2, expectedType2, expressionType)) {
            return true;
        }
        this.trace.report(Errors.CONSTANT_EXPECTED_TYPE_MISMATCH.on(expression2, typeName, expectedType2));
        return true;
    }

    private boolean reportError(@NotNull Diagnostic diagnostic) {
        if (!this.checkOnlyErrorsThatDependOnExpectedType || errorsThatDependOnExpectedType.contains(diagnostic.getFactory())) {
            this.trace.report(diagnostic);
            return true;
        }
        return false;
    }

    public static class CharacterWithDiagnostic {
        private Diagnostic diagnostic;
        private Character value;

        public CharacterWithDiagnostic(@NotNull Diagnostic diagnostic) {
            this.diagnostic = diagnostic;
        }

        public CharacterWithDiagnostic(char value2) {
            this.value = Character.valueOf(value2);
        }

        @Nullable
        public Diagnostic getDiagnostic() {
            return this.diagnostic;
        }

        @Nullable
        public Character getValue() {
            return this.value;
        }
    }
}

