/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.guice.inspections;

import com.intellij.guice.GuiceBundle;
import com.intellij.guice.inspections.BaseInspection;
import com.intellij.guice.inspections.BaseInspectionVisitor;
import com.intellij.guice.utils.AnnotationUtils;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class InvalidImplementedByInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = GuiceBundle.message("invalid.implemented.by.problem.descriptor", new Object[0]);
        if (string == null) {
            InvalidImplementedByInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/guice/inspections/InvalidImplementedByInspection", "buildErrorString"));
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitAnnotation(PsiAnnotation annotation) {
            super.visitAnnotation(annotation);
            String qualifiedName = annotation.getQualifiedName();
            if (!"com.google.inject.ImplementedBy".equals(qualifiedName)) {
                return;
            }
            PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiClass.class);
            if (containingClass == null) {
                return;
            }
            PsiElement defaultValue = AnnotationUtils.findDefaultValue(annotation);
            if (defaultValue == null) {
                return;
            }
            if (!(defaultValue instanceof PsiClassObjectAccessExpression)) {
                return;
            }
            PsiTypeElement classTypeElement = ((PsiClassObjectAccessExpression)defaultValue).getOperand();
            PsiType classType = classTypeElement.getType();
            if (!(classType instanceof PsiClassType)) {
                return;
            }
            PsiClass referentClass = ((PsiClassType)classType).resolve();
            if (referentClass == null) {
                return;
            }
            if (InheritanceUtil.isInheritorOrSelf((PsiClass)referentClass, (PsiClass)containingClass, (boolean)true)) {
                return;
            }
            this.registerError((PsiElement)classTypeElement, new Object[0]);
        }
    }
}

