/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.guice.inspections;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.guice.GuiceBundle;
import com.intellij.guice.constants.GuiceAnnotations;
import com.intellij.guice.inspections.BaseInspection;
import com.intellij.guice.inspections.BaseInspectionVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.annotations.NotNull;

public class MultipleInjectedConstructorsForClassInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = GuiceBundle.message("multiple.injected.constructors.for.class.problem.descriptor", new Object[0]);
        if (string == null) {
            MultipleInjectedConstructorsForClassInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/guice/inspections/MultipleInjectedConstructorsForClassInspection", "buildErrorString"));
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitMethod(PsiMethod method) {
            super.visitMethod(method);
            if (!method.isConstructor()) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            PsiMethod[] constructors = containingClass.getConstructors();
            if (constructors.length <= 1) {
                return;
            }
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)method, GuiceAnnotations.INJECTS, (int)1)) {
                return;
            }
            int annotatedConstructorCount = 0;
            for (PsiMethod constructor : constructors) {
                if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)constructor, GuiceAnnotations.INJECTS, (int)1)) continue;
                ++annotatedConstructorCount;
            }
            if (annotatedConstructorCount > 1) {
                this.registerMethodError(method, new Object[0]);
            }
        }
    }
}

