/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions.elements;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.actions.AnnotationRequest;
import com.intellij.lang.jvm.actions.CreateConstructorRequest;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.annotator.intentions.elements.JvmPsiUtilKt;
import org.jetbrains.plugins.groovy.annotator.intentions.elements.TemplatesKt;
import org.jetbrains.plugins.groovy.intentions.base.IntentionUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.template.expressions.ChooseTypeExpression;
import org.jetbrains.plugins.groovy.template.expressions.ParameterNameExpression;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J\b\u0010\u0018\u001a\u00020\u0016H\u0002J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0016H\u0002R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/plugins/groovy/annotator/intentions/elements/ConstructorMethodRenderer;", "", "project", "Lcom/intellij/openapi/project/Project;", "targetClass", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrTypeDefinition;", "request", "Lcom/intellij/lang/jvm/actions/CreateConstructorRequest;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrTypeDefinition;Lcom/intellij/lang/jvm/actions/CreateConstructorRequest;)V", "factory", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyPsiElementFactory;", "getFactory", "()Lorg/jetbrains/plugins/groovy/lang/psi/GroovyPsiElementFactory;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getRequest", "()Lcom/intellij/lang/jvm/actions/CreateConstructorRequest;", "getTargetClass", "()Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrTypeDefinition;", "execute", "", "insertConstructor", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/members/GrMethod;", "method", "renderConstructor", "setupTemplate", "intellij.groovy"})
final class ConstructorMethodRenderer {
    @NotNull
    private final GroovyPsiElementFactory factory;
    @NotNull
    private final Project project;
    @NotNull
    private final GrTypeDefinition targetClass;
    @NotNull
    private final CreateConstructorRequest request;

    @NotNull
    public final GroovyPsiElementFactory getFactory() {
        return this.factory;
    }

    public final void execute() {
        GrMethod constructor = this.renderConstructor();
        constructor = this.insertConstructor(constructor);
        GrMethod grMethod = (GrMethod)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)constructor);
        if (grMethod == null) {
            return;
        }
        constructor = grMethod;
        this.setupTemplate(constructor);
    }

    private final void setupTemplate(GrMethod method) {
        Collection $receiver$iv;
        Collection $receiver$iv2;
        List list = this.request.getParameters();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"request.parameters");
        Collection collection = $receiver$iv2 = (Collection)TemplatesKt.setupParameters(method, list);
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection;
        ChooseTypeExpression[] chooseTypeExpressionArray = thisCollection$iv.toArray(new ChooseTypeExpression[0]);
        if (chooseTypeExpressionArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        ChooseTypeExpression[] typeExpressions = chooseTypeExpressionArray;
        List list2 = this.request.getParameters();
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"request.parameters");
        Collection collection2 = $receiver$iv = (Collection)TemplatesKt.setupNameExpressions(list2);
        if (collection2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv2 = collection2;
        ParameterNameExpression[] parameterNameExpressionArray = thisCollection$iv2.toArray(new ParameterNameExpression[0]);
        if (parameterNameExpressionArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        ParameterNameExpression[] nameExpressions = parameterNameExpressionArray;
        IntentionUtils.createTemplateForMethod(typeExpressions, nameExpressions, method, this.targetClass, null, true, null);
    }

    private final GrMethod renderConstructor() {
        GrMethod constructor = this.factory.createConstructor();
        Collection collection = this.request.getModifiers();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"request.modifiers");
        List modifiersToRender = CollectionsKt.toMutableList((Collection)collection);
        Collection collection2 = modifiersToRender;
        JvmModifier jvmModifier = JvmModifier.PUBLIC;
        collection2.remove(jvmModifier);
        for (JvmModifier modifier : modifiersToRender) {
            GrMethod grMethod = constructor;
            Intrinsics.checkExpressionValueIsNotNull((Object)grMethod, (String)"constructor");
            GrModifierList grModifierList = grMethod.getModifierList();
            JvmModifier jvmModifier2 = modifier;
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmModifier2, (String)"modifier");
            grModifierList.setModifierProperty(JvmPsiUtilKt.toPsiModifier(jvmModifier2), true);
        }
        for (AnnotationRequest annotation : this.request.getAnnotations()) {
            GrMethod grMethod = constructor;
            Intrinsics.checkExpressionValueIsNotNull((Object)grMethod, (String)"constructor");
            GrModifierList grModifierList = grMethod.getModifierList();
            AnnotationRequest annotationRequest = annotation;
            Intrinsics.checkExpressionValueIsNotNull((Object)annotationRequest, (String)"annotation");
            grModifierList.addAnnotation(annotationRequest.getQualifiedName());
        }
        GrMethod grMethod = constructor;
        Intrinsics.checkExpressionValueIsNotNull((Object)grMethod, (String)"constructor");
        return grMethod;
    }

    private final GrMethod insertConstructor(GrMethod method) {
        PsiElement psiElement = this.targetClass.add(method);
        if (psiElement == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod");
        }
        return (GrMethod)psiElement;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final GrTypeDefinition getTargetClass() {
        return this.targetClass;
    }

    @NotNull
    public final CreateConstructorRequest getRequest() {
        return this.request;
    }

    public ConstructorMethodRenderer(@NotNull Project project, @NotNull GrTypeDefinition targetClass, @NotNull CreateConstructorRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)targetClass, (String)"targetClass");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        this.project = project;
        this.targetClass = targetClass;
        this.request = request;
        this.factory = GroovyPsiElementFactory.getInstance(this.project);
    }
}

