/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.compiler;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.compiler.options.ExcludedEntriesConfiguration;
import com.intellij.openapi.compiler.options.ExcludesConfiguration;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.incremental.groovy.JpsGroovySettings;

@State(name="GroovyCompilerProjectConfiguration", storages={@Storage(value="groovyc.xml")})
public class GroovyCompilerConfiguration
implements PersistentStateComponent<JpsGroovySettings>,
Disposable {
    private String myConfigScript = "";
    private String myHeapSize = "400";
    private boolean myInvokeDynamic = false;
    public boolean transformsOk = false;
    private final ExcludedEntriesConfiguration myExcludeFromStubGeneration = new ExcludedEntriesConfiguration(null);

    public JpsGroovySettings getState() {
        JpsGroovySettings bean = new JpsGroovySettings();
        bean.heapSize = this.myHeapSize;
        bean.configScript = this.myConfigScript;
        bean.invokeDynamic = this.myInvokeDynamic;
        bean.transformsOk = this.transformsOk;
        this.myExcludeFromStubGeneration.writeExternal(bean.excludes);
        return bean;
    }

    public static ExcludesConfiguration getExcludeConfiguration(Project project) {
        return GroovyCompilerConfiguration.getInstance((Project)project).myExcludeFromStubGeneration;
    }

    public ExcludesConfiguration getExcludeFromStubGeneration() {
        return this.myExcludeFromStubGeneration;
    }

    public void loadState(@NotNull JpsGroovySettings state) {
        if (state == null) {
            GroovyCompilerConfiguration.$$$reportNull$$$0(0);
        }
        this.myHeapSize = state.heapSize;
        this.myConfigScript = state.configScript;
        this.myInvokeDynamic = state.invokeDynamic;
        this.transformsOk = state.transformsOk;
        this.myExcludeFromStubGeneration.readExternal(state.excludes);
    }

    public static GroovyCompilerConfiguration getInstance(Project project) {
        return (GroovyCompilerConfiguration)ServiceManager.getService((Project)project, GroovyCompilerConfiguration.class);
    }

    public String getHeapSize() {
        return this.myHeapSize;
    }

    public boolean isInvokeDynamic() {
        return this.myInvokeDynamic;
    }

    public void setHeapSize(String heapSize) {
        this.myHeapSize = heapSize;
    }

    public void setInvokeDynamic(boolean invokeDynamic) {
        this.myInvokeDynamic = invokeDynamic;
    }

    public String getConfigScript() {
        return this.myConfigScript;
    }

    public void setConfigScript(String configScript) {
        this.myConfigScript = configScript;
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myExcludeFromStubGeneration);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/groovy/compiler/GroovyCompilerConfiguration", "loadState"));
    }
}

