/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.findUsages;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.search.AnnotatedElementsSearcher;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrAnnotatedMemberIndex;

public class AnnotatedMembersSearcher
implements QueryExecutor<PsiModifierListOwner, AnnotatedElementsSearch.Parameters> {
    @NotNull
    private static List<PsiModifierListOwner> getAnnotatedMemberCandidates(PsiClass clazz, GlobalSearchScope scope) {
        String name = (String)ReadAction.compute(() -> clazz.getName());
        if (name == null) {
            List<PsiModifierListOwner> list = Collections.emptyList();
            if (list == null) {
                AnnotatedMembersSearcher.$$$reportNull$$$0(0);
            }
            return list;
        }
        Collection members = (Collection)ReadAction.compute(() -> StubIndex.getElements(GrAnnotatedMemberIndex.KEY, (Object)name, (Project)clazz.getProject(), (GlobalSearchScope)scope, PsiElement.class));
        if (members.isEmpty()) {
            List<PsiModifierListOwner> list = Collections.emptyList();
            if (list == null) {
                AnnotatedMembersSearcher.$$$reportNull$$$0(1);
            }
            return list;
        }
        ArrayList<PsiModifierListOwner> result = new ArrayList<PsiModifierListOwner>();
        for (PsiElement element : members) {
            ApplicationManager.getApplication().runReadAction(() -> {
                PsiElement e;
                PsiElement psiElement = e = element instanceof GroovyFile ? ((GroovyFile)element).getPackageDefinition() : element;
                if (e instanceof PsiModifierListOwner) {
                    result.add((PsiModifierListOwner)e);
                }
            });
        }
        ArrayList<PsiModifierListOwner> arrayList = result;
        if (arrayList == null) {
            AnnotatedMembersSearcher.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    public boolean execute(@NotNull AnnotatedElementsSearch.Parameters p, @NotNull Processor<PsiModifierListOwner> consumer) {
        List<Object> candidates;
        if (p == null) {
            AnnotatedMembersSearcher.$$$reportNull$$$0(3);
        }
        if (consumer == null) {
            AnnotatedMembersSearcher.$$$reportNull$$$0(4);
        }
        PsiClass annClass = p.getAnnotationClass();
        assert (annClass.isAnnotationType()) : "Annotation type should be passed to annotated members search";
        String annotationFQN = (String)ReadAction.compute(() -> annClass.getQualifiedName());
        assert (annotationFQN != null);
        SearchScope scope = p.getScope();
        if (scope instanceof GlobalSearchScope) {
            candidates = AnnotatedMembersSearcher.getAnnotatedMemberCandidates(annClass, (GlobalSearchScope)scope);
        } else {
            candidates = new ArrayList();
            for (PsiElement element : ((LocalSearchScope)scope).getScope()) {
                ApplicationManager.getApplication().runReadAction(() -> {
                    if (element instanceof GroovyPsiElement) {
                        ((GroovyPsiElement)element).accept(new GroovyRecursiveElementVisitor(){

                            @Override
                            public void visitMethod(@NotNull GrMethod method) {
                                if (method == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                candidates.add(method);
                            }

                            @Override
                            public void visitField(@NotNull GrField field) {
                                if (field == null) {
                                    1.$$$reportNull$$$0(1);
                                }
                                candidates.add(field);
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                Object[] objectArray;
                                Object[] objectArray2;
                                Object[] objectArray3 = new Object[3];
                                switch (n) {
                                    default: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "method";
                                        break;
                                    }
                                    case 1: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "field";
                                        break;
                                    }
                                }
                                objectArray2[1] = "org/jetbrains/plugins/groovy/findUsages/AnnotatedMembersSearcher$1";
                                switch (n) {
                                    default: {
                                        objectArray = objectArray2;
                                        objectArray2[2] = "visitMethod";
                                        break;
                                    }
                                    case 1: {
                                        objectArray = objectArray2;
                                        objectArray2[2] = "visitField";
                                        break;
                                    }
                                }
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                            }
                        });
                    }
                });
            }
        }
        for (PsiModifierListOwner psiModifierListOwner : candidates) {
            boolean accepted = (Boolean)ReadAction.compute(() -> {
                PsiModifierList list;
                if (p == null) {
                    AnnotatedMembersSearcher.$$$reportNull$$$0(5);
                }
                if (consumer == null) {
                    AnnotatedMembersSearcher.$$$reportNull$$$0(6);
                }
                if (AnnotatedElementsSearcher.isInstanceof((PsiElement)candidate, (Class[])p.getTypes()) && (list = candidate.getModifierList()) != null) {
                    for (PsiAnnotation annotation : list.getAnnotations()) {
                        if (!p.isApproximate() && !annotationFQN.equals(annotation.getQualifiedName()) || consumer.process((Object)candidate)) continue;
                        return false;
                    }
                }
                return true;
            });
            if (accepted) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/findUsages/AnnotatedMembersSearcher";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotatedMemberCandidates";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/findUsages/AnnotatedMembersSearcher";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$execute$5";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

