/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.synthetic;

import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifier;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.modifiers.GrModifierListImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.modifiers.GrModifierListUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightAnnotation;

public class GrLightModifierList
extends LightElement
implements GrModifierList {
    private int myModifiers;
    private final List<GrAnnotation> myAnnotations;
    private final PsiElement myParent;

    public GrLightModifierList(@NotNull PsiElement parent) {
        if (parent == null) {
            GrLightModifierList.$$$reportNull$$$0(0);
        }
        super(parent.getManager(), parent.getLanguage());
        this.myAnnotations = new ArrayList<GrAnnotation>();
        this.myParent = parent;
    }

    public PsiElement getParent() {
        return this.myParent;
    }

    public PsiFile getContainingFile() {
        return this.getParent().getContainingFile();
    }

    public void addModifier(String modifier) {
        int code = GrModifierListImpl.NAME_TO_MODIFIER_FLAG_MAP.get((Object)modifier);
        assert (code != 0);
        this.myModifiers |= code;
    }

    public void addModifier(int modifier) {
        this.myModifiers |= modifier;
    }

    public void removeModifier(int modifier) {
        this.myModifiers &= ~modifier;
    }

    public void setModifiers(int modifiers) {
        this.myModifiers = modifiers;
    }

    public void setModifiers(String ... modifiers) {
        this.myModifiers = 0;
        for (String modifier : modifiers) {
            this.addModifier(modifier);
        }
    }

    @Override
    public int getModifierFlags() {
        return this.myModifiers;
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            GrLightModifierList.$$$reportNull$$$0(1);
        }
        return GrModifierListUtil.hasModifierProperty(this, name);
    }

    @Override
    public boolean hasExplicitModifier(@NotNull String name) {
        if (name == null) {
            GrLightModifierList.$$$reportNull$$$0(2);
        }
        return GrModifierListUtil.hasExplicitModifier(this, name);
    }

    @Override
    public void setModifierProperty(@NotNull String name, boolean value) throws IncorrectOperationException {
        if (name == null) {
            GrLightModifierList.$$$reportNull$$$0(3);
        }
        throw new IncorrectOperationException();
    }

    @Override
    @NotNull
    public GrAnnotation[] getRawAnnotations() {
        GrAnnotation[] grAnnotationArray = this.getAnnotations();
        if (grAnnotationArray == null) {
            GrLightModifierList.$$$reportNull$$$0(4);
        }
        return grAnnotationArray;
    }

    public void checkSetModifierProperty(@NotNull String name, boolean value) throws IncorrectOperationException {
        if (name == null) {
            GrLightModifierList.$$$reportNull$$$0(5);
        }
        throw new IncorrectOperationException();
    }

    @Override
    @NotNull
    public GrAnnotation[] getAnnotations() {
        GrAnnotation[] grAnnotationArray = this.myAnnotations.toArray(GrAnnotation.EMPTY_ARRAY);
        if (grAnnotationArray == null) {
            GrLightModifierList.$$$reportNull$$$0(6);
        }
        return grAnnotationArray;
    }

    @NotNull
    public PsiAnnotation[] getApplicableAnnotations() {
        PsiAnnotation[] psiAnnotationArray = this.getAnnotations();
        if (psiAnnotationArray == null) {
            GrLightModifierList.$$$reportNull$$$0(7);
        }
        return psiAnnotationArray;
    }

    public PsiAnnotation findAnnotation(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            GrLightModifierList.$$$reportNull$$$0(8);
        }
        return null;
    }

    @NotNull
    public PsiAnnotation addAnnotation(@NotNull @NonNls String qualifiedName) {
        if (qualifiedName == null) {
            GrLightModifierList.$$$reportNull$$$0(9);
        }
        GrLightAnnotation annotation = new GrLightAnnotation(this.getManager(), this.getLanguage(), qualifiedName, (PsiAnnotationOwner)this);
        this.myAnnotations.add(annotation);
        GrLightAnnotation grLightAnnotation = annotation;
        if (grLightAnnotation == null) {
            GrLightModifierList.$$$reportNull$$$0(10);
        }
        return grLightAnnotation;
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            GrLightModifierList.$$$reportNull$$$0(11);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitModifierList((PsiModifierList)this);
        } else {
            visitor2.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "GrModifierList";
    }

    public String getText() {
        StringBuilder buffer = new StringBuilder();
        for (GrAnnotation annotation : this.myAnnotations) {
            buffer.append(annotation.getText());
            buffer.append(' ');
        }
        for (String modifier : GrModifier.GROOVY_MODIFIERS) {
            if (!this.hasExplicitModifier(modifier)) continue;
            buffer.append(modifier);
            buffer.append(' ');
        }
        if (buffer.length() > 0) {
            buffer.delete(buffer.length() - 1, buffer.length());
        }
        return buffer.toString();
    }

    @Override
    @NotNull
    public PsiElement[] getModifiers() {
        if (PsiElement.EMPTY_ARRAY == null) {
            GrLightModifierList.$$$reportNull$$$0(12);
        }
        return PsiElement.EMPTY_ARRAY;
    }

    @Override
    @Nullable
    public PsiElement getModifier(@GrModifier.GrModifierConstant @NotNull @NonNls String name) {
        if (name == null) {
            GrLightModifierList.$$$reportNull$$$0(13);
        }
        return null;
    }

    @Override
    public boolean hasExplicitVisibilityModifiers() {
        return GrModifierListUtil.hasExplicitVisibilityModifiers(this);
    }

    @Override
    public void accept(GroovyElementVisitor visitor2) {
        visitor2.visitModifierList(this);
    }

    @Override
    public void acceptChildren(GroovyElementVisitor visitor2) {
    }

    public void copyModifiers(@NotNull PsiModifierListOwner modifierOwner) {
        if (modifierOwner == null) {
            GrLightModifierList.$$$reportNull$$$0(14);
        }
        int mod = 0;
        PsiModifierList modifierList = modifierOwner.getModifierList();
        if (modifierList instanceof GrModifierList) {
            mod = ((GrModifierList)modifierList).getModifierFlags();
        } else if (modifierList != null) {
            for (String modifier : PsiModifier.MODIFIERS) {
                if (!modifierList.hasExplicitModifier(modifier)) continue;
                mod |= GrModifierListImpl.NAME_TO_MODIFIER_FLAG_MAP.get((Object)modifier);
            }
        }
        this.setModifiers(mod);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrLightModifierList";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierOwner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrLightModifierList";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRawAnnotations";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotations";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicableAnnotations";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "addAnnotation";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hasModifierProperty";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasExplicitModifier";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setModifierProperty";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 12: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkSetModifierProperty";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotation";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addAnnotation";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getModifier";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "copyModifiers";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

