/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.typing;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.PsiType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrCallExpressionTypeCalculator;
import org.jetbrains.plugins.groovy.lang.typing.GrTypeCalculator;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/groovy/lang/typing/MethodCallTypeCalculator;", "Lorg/jetbrains/plugins/groovy/lang/typing/GrTypeCalculator;", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrMethodCall;", "()V", "getType", "Lcom/intellij/psi/PsiType;", "expression", "intellij.groovy.psi"})
public final class MethodCallTypeCalculator
implements GrTypeCalculator<GrMethodCall> {
    @Override
    @Nullable
    public PsiType getType(@NotNull GrMethodCall expression) {
        GroovyResolveResult[] groovyResolveResultArray;
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        GrExpression grExpression = expression.getInvokedExpression();
        if (!(grExpression instanceof GrReferenceExpression)) {
            grExpression = null;
        }
        if ((groovyResolveResultArray = (GroovyResolveResult[])grExpression) == null || (groovyResolveResultArray = groovyResolveResultArray.multiResolve(false)) == null) {
            groovyResolveResultArray = GroovyResolveResult.EMPTY_ARRAY;
        }
        GroovyResolveResult[] resolveResults = groovyResolveResultArray;
        ExtensionPointName<GrCallExpressionTypeCalculator> extensionPointName = GrCallExpressionTypeCalculator.EP_NAME;
        Intrinsics.checkExpressionValueIsNotNull(extensionPointName, (String)"GrCallExpressionTypeCalculator.EP_NAME");
        for (GrCallExpressionTypeCalculator calculator : (GrCallExpressionTypeCalculator[])extensionPointName.getExtensions()) {
            PsiType type = calculator.calculateReturnType(expression, resolveResults);
            if (type == null) continue;
            return type;
        }
        return null;
    }
}

