/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.extractInterface;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.extractInterface.ExtractClassUtil;
import com.intellij.refactoring.extractSuperclass.ExtractSuperClassUtil;
import com.intellij.refactoring.lang.ElementsHandler;
import com.intellij.refactoring.memberPullUp.PullUpProcessor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.DocCommentPolicy;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.util.IncorrectOperationException;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;

public class GrExtractInterfaceHandler
implements RefactoringActionHandler,
ElementsHandler {
    private static final Logger LOG = Logger.getInstance(GrExtractInterfaceHandler.class);
    public static final String REFACTORING_NAME = RefactoringBundle.message((String)"extract.interface.title");
    private Project myProject;
    private PsiClass myClass;
    private String myInterfaceName;
    private MemberInfo[] mySelectedMembers;
    private PsiDirectory myTargetDir;
    private DocCommentPolicy myJavaDocPolicy;

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            GrExtractInterfaceHandler.$$$reportNull$$$0(0);
        }
        int offset = editor.getCaretModel().getOffset();
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement element = file.findElementAt(offset);
        while (true) {
            if (element == null || element instanceof PsiFile) {
                String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.wrong.caret.position.class"));
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.extractInterface");
                return;
            }
            if (element instanceof GrTypeDefinition && !(element instanceof GrAnonymousClassDefinition)) {
                this.invoke(project, new PsiElement[]{element}, dataContext);
                return;
            }
            element = element.getParent();
        }
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            GrExtractInterfaceHandler.$$$reportNull$$$0(1);
        }
        if (elements == null) {
            GrExtractInterfaceHandler.$$$reportNull$$$0(2);
        }
        if (elements.length != 1) {
            return;
        }
        this.myProject = project;
        this.myClass = (PsiClass)elements[0];
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)this.myClass)) {
            return;
        }
    }

    private void doRefactoring() throws IncorrectOperationException {
        PsiClass anInterface;
        LocalHistoryAction a = LocalHistory.getInstance().startAction(this.getCommandName());
        try {
            anInterface = GrExtractInterfaceHandler.extractInterface(this.myTargetDir, this.myClass, this.myInterfaceName, this.mySelectedMembers, this.myJavaDocPolicy);
        }
        finally {
            a.finish();
        }
        if (anInterface != null) {
            SmartPsiElementPointer classPointer = SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer((PsiElement)this.myClass);
            SmartPsiElementPointer interfacePointer = SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer((PsiElement)anInterface);
            Runnable turnRefsToSuperRunnable = () -> ExtractClassUtil.askAndTurnRefsToSuper((Project)this.myProject, (SmartPsiElementPointer)classPointer, (SmartPsiElementPointer)interfacePointer);
            SwingUtilities.invokeLater(turnRefsToSuperRunnable);
        }
    }

    public static PsiClass extractInterface(PsiDirectory targetDir, PsiClass aClass, String interfaceName, MemberInfo[] selectedMembers, DocCommentPolicy javaDocPolicy) throws IncorrectOperationException {
        PsiReferenceList referenceList;
        PsiClass anInterface = JavaDirectoryService.getInstance().createInterface(targetDir, interfaceName);
        PsiJavaCodeReferenceElement ref = ExtractSuperClassUtil.createExtendingReference((PsiClass)anInterface, (PsiClass)aClass, (MemberInfo[])selectedMembers);
        PsiReferenceList psiReferenceList = referenceList = aClass.isInterface() ? aClass.getExtendsList() : aClass.getImplementsList();
        assert (referenceList != null);
        referenceList.add((PsiElement)ref);
        PullUpProcessor pullUpHelper = new PullUpProcessor(aClass, anInterface, selectedMembers, javaDocPolicy);
        pullUpHelper.moveMembersToBase();
        return anInterface;
    }

    private String getCommandName() {
        return RefactoringBundle.message((String)"extract.interface.command.name", (Object[])new Object[]{this.myInterfaceName, DescriptiveNameUtil.getDescriptiveName((PsiElement)this.myClass)});
    }

    public boolean isEnabledOnElements(PsiElement[] elements) {
        return elements.length == 1 && elements[0] instanceof PsiClass;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "elements";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/groovy/refactoring/extractInterface/GrExtractInterfaceHandler";
        objectArray[2] = "invoke";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

