/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.introduce.field;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeStyle.GrReferenceAdjuster;
import org.jetbrains.plugins.groovy.lang.psi.GrQualifiedReference;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrClassInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrConstructorInvocation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrEnumTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstantList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMembersDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrVariableDeclarationOwner;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringUtil;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceContext;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceHandlerBase;
import org.jetbrains.plugins.groovy.refactoring.introduce.StringPartInfo;
import org.jetbrains.plugins.groovy.refactoring.introduce.field.GrIntroduceFieldHandler;
import org.jetbrains.plugins.groovy.refactoring.introduce.field.GrIntroduceFieldSettings;

public class GrIntroduceFieldProcessor {
    private static final Logger LOG = Logger.getInstance(GrIntroduceFieldProcessor.class);
    private final GrIntroduceContext myContext;
    private final GrIntroduceFieldSettings mySettings;
    @Nullable
    private GrExpression myInitializer;
    @Nullable
    private GrVariable myLocalVariable;

    public GrIntroduceFieldProcessor(@NotNull GrIntroduceContext context, @NotNull GrIntroduceFieldSettings settings) {
        if (context == null) {
            GrIntroduceFieldProcessor.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            GrIntroduceFieldProcessor.$$$reportNull$$$0(1);
        }
        this.myContext = context;
        this.mySettings = settings;
    }

    @Nullable
    public GrVariable run() {
        GrExpression originalInitializer;
        PsiClass targetClass;
        PsiElement scope = this.myContext.getScope();
        PsiClass psiClass = targetClass = scope instanceof GroovyFileBase ? ((GroovyFileBase)scope).getScriptClass() : (PsiClass)scope;
        if (targetClass == null) {
            return null;
        }
        GrVariableDeclaration declaration = this.insertField(targetClass);
        GrVariable field = declaration.getVariables()[0];
        if (this.mySettings.removeLocalVar()) {
            this.myLocalVariable = GrIntroduceHandlerBase.resolveLocalVar(this.myContext);
            assert (this.myLocalVariable != null) : this.myContext.getExpression() + ", " + this.myContext.getVar() + ", " + this.myContext.getStringPart();
        }
        this.myInitializer = (originalInitializer = this.getInitializer()) == null ? null : (GrExpression)originalInitializer.copy();
        List<PsiElement> replaced = this.processOccurrences(targetClass, field);
        switch (this.mySettings.initializeIn()) {
            case CUR_METHOD: {
                this.initializeInMethod(field, replaced);
                break;
            }
            case FIELD_DECLARATION: {
                field.setInitializerGroovy(this.myInitializer);
                break;
            }
            case CONSTRUCTOR: {
                this.initializeInConstructor(field, replaced);
                break;
            }
            case SETUP_METHOD: {
                this.initializeInSetup(field, replaced);
            }
        }
        JavaCodeStyleManager.getInstance((Project)declaration.getProject()).shortenClassReferences((PsiElement)declaration);
        if (this.mySettings.removeLocalVar()) {
            GrIntroduceHandlerBase.deleteLocalVar(this.myLocalVariable);
        }
        return field;
    }

    @NotNull
    private List<PsiElement> processOccurrences(@NotNull PsiClass targetClass, @NotNull GrVariable field) {
        if (targetClass == null) {
            GrIntroduceFieldProcessor.$$$reportNull$$$0(2);
        }
        if (field == null) {
            GrIntroduceFieldProcessor.$$$reportNull$$$0(3);
        }
        if (this.myContext.getStringPart() != null) {
            GrExpression expr = this.myContext.getStringPart().replaceLiteralWithConcatenation(field.getName());
            PsiElement occurrence = this.replaceOccurrence(field, expr, targetClass);
            this.updateCaretPosition(occurrence);
            List<PsiElement> list = Collections.singletonList(occurrence);
            if (list == null) {
                GrIntroduceFieldProcessor.$$$reportNull$$$0(4);
            }
            return list;
        }
        if (this.mySettings.replaceAllOccurrences()) {
            GroovyRefactoringUtil.sortOccurrences(this.myContext.getOccurrences());
            ArrayList result = ContainerUtil.newArrayList();
            for (PsiElement occurrence : this.myContext.getOccurrences()) {
                result.add(this.replaceOccurrence(field, occurrence, targetClass));
            }
            ArrayList arrayList = result;
            if (arrayList == null) {
                GrIntroduceFieldProcessor.$$$reportNull$$$0(5);
            }
            return arrayList;
        }
        GrVariable var = this.myContext.getVar();
        if (var != null) {
            GrExpression initializer = var.getInitializerGroovy();
            if (initializer != null) {
                List<PsiElement> list = Collections.singletonList(this.replaceOccurrence(field, initializer, targetClass));
                if (list == null) {
                    GrIntroduceFieldProcessor.$$$reportNull$$$0(6);
                }
                return list;
            }
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                GrIntroduceFieldProcessor.$$$reportNull$$$0(7);
            }
            return list;
        }
        GrExpression expression = this.myContext.getExpression();
        assert (expression != null);
        List<PsiElement> list = Collections.singletonList(this.replaceOccurrence(field, expression, targetClass));
        if (list == null) {
            GrIntroduceFieldProcessor.$$$reportNull$$$0(8);
        }
        return list;
    }

    private void updateCaretPosition(@NotNull PsiElement occurrence) {
        if (occurrence == null) {
            GrIntroduceFieldProcessor.$$$reportNull$$$0(9);
        }
        this.myContext.getEditor().getCaretModel().moveToOffset(occurrence.getTextRange().getEndOffset());
        this.myContext.getEditor().getSelectionModel().removeSelection();
    }

    @NotNull
    protected GrVariableDeclaration insertField(@NotNull PsiClass targetClass) {
        if (targetClass == null) {
            GrIntroduceFieldProcessor.$$$reportNull$$$0(10);
        }
        GrVariableDeclaration declaration = this.createField(targetClass);
        if (targetClass instanceof GrEnumTypeDefinition) {
            GrEnumConstantList enumConstants = ((GrEnumTypeDefinition)targetClass).getEnumConstantList();
            GrVariableDeclaration grVariableDeclaration = (GrVariableDeclaration)targetClass.addAfter((PsiElement)declaration, (PsiElement)enumConstants);
            if (grVariableDeclaration == null) {
                GrIntroduceFieldProcessor.$$$reportNull$$$0(11);
            }
            return grVariableDeclaration;
        }
        if (targetClass instanceof GrTypeDefinition) {
            PsiElement anchor = GrIntroduceFieldProcessor.getAnchorForDeclaration((GrTypeDefinition)targetClass);
            GrVariableDeclaration grVariableDeclaration = (GrVariableDeclaration)targetClass.addAfter((PsiElement)declaration, anchor);
            if (grVariableDeclaration == null) {
                GrIntroduceFieldProcessor.$$$reportNull$$$0(12);
            }
            return grVariableDeclaration;
        }
        assert (targetClass instanceof GroovyScriptClass);
        GroovyFile file = ((GroovyScriptClass)targetClass).getContainingFile();
        Object[] elements = file.getMethods();
        if (elements.length == 0) {
            elements = file.getStatements();
        }
        PsiElement anchor = (PsiElement)ArrayUtil.getFirstElement((Object[])elements);
        GrVariableDeclaration grVariableDeclaration = (GrVariableDeclaration)file.addBefore(declaration, anchor);
        if (grVariableDeclaration == null) {
            GrIntroduceFieldProcessor.$$$reportNull$$$0(13);
        }
        return grVariableDeclaration;
    }

    @Nullable
    private static PsiElement getAnchorForDeclaration(@NotNull GrTypeDefinition targetClass) {
        GrMembersDeclaration[] declarations;
        GrTypeDefinitionBody body;
        if (targetClass == null) {
            GrIntroduceFieldProcessor.$$$reportNull$$$0(14);
        }
        if ((body = targetClass.getBody()) == null) {
            return null;
        }
        PsiElement anchor = body.getLBrace();
        for (GrMembersDeclaration declaration : declarations = targetClass.getMemberDeclarations()) {
            if (declaration instanceof GrVariableDeclaration) {
                anchor = declaration;
            }
            if (declaration instanceof GrVariableDeclaration) continue;
            return anchor;
        }
        return anchor;
    }

    void initializeInSetup(@NotNull GrVariable field, @NotNull Collection<PsiElement> replaced) {
        if (field == null) {
            GrIntroduceFieldProcessor.$$$reportNull$$$0(15);
        }
        if (replaced == null) {
            GrIntroduceFieldProcessor.$$$reportNull$$$0(16);
        }
        PsiMethod setUpMethod = TestFrameworks.getInstance().findOrCreateSetUpMethod((PsiClass)this.myContext.getScope());
        assert (setUpMethod instanceof GrMethod);
        GrOpenBlock body = ((GrMethod)setUpMethod).getBlock();
        GrStatement anchor = GrIntroduceFieldProcessor.findAnchorForAssignment(body, replaced);
        this.generateAssignment(field, anchor, body, null);
    }

    void initializeInMethod(@NotNull GrVariable field, @NotNull List<PsiElement> replaced) {
        PsiElement anchor;
        GrOpenBlock container;
        PsiElement _scope;
        if (field == null) {
            GrIntroduceFieldProcessor.$$$reportNull$$$0(17);
        }
        if (replaced == null) {
            GrIntroduceFieldProcessor.$$$reportNull$$$0(18);
        }
        PsiElement scope = (_scope = this.myContext.getScope()) instanceof GroovyScriptClass ? ((GroovyScriptClass)_scope).getContainingFile() : _scope;
        PsiElement place = replaced.get(0);
        GrMember member = GrIntroduceFieldHandler.getContainer(place, scope);
        GrVariableDeclarationOwner grVariableDeclarationOwner = member instanceof GrMethod ? ((GrMethod)member).getBlock() : (member instanceof GrClassInitializer ? ((GrClassInitializer)member).getBlock() : (container = place.getContainingFile() instanceof GroovyFile ? (GroovyFile)place.getContainingFile() : null));
        assert (container != null);
        if (this.mySettings.removeLocalVar()) {
            GrVariable variable = this.myLocalVariable;
            anchor = PsiTreeUtil.getParentOfType((PsiElement)variable, GrStatement.class);
        } else {
            anchor = GrIntroduceHandlerBase.findAnchor(replaced.toArray(PsiElement.EMPTY_ARRAY), container);
            GrIntroduceHandlerBase.assertStatement(anchor, this.myContext.getScope());
        }
        this.initializeInMethodInner(field, container, (GrStatement)anchor, replaced.get(0));
    }

    private void initializeInMethodInner(@NotNull GrVariable field, @Nullable GrStatementOwner container, @Nullable GrStatement anchor, @Nullable PsiElement occurence) {
        if (field == null) {
            GrIntroduceFieldProcessor.$$$reportNull$$$0(19);
        }
        if (!this.mySettings.replaceAllOccurrences() && PsiUtil.isExpressionStatement(occurence) && Comparing.equal((Object)anchor, (Object)occurence)) {
            this.generateAssignment(field, anchor, container, occurence);
        } else {
            this.generateAssignment(field, anchor, container, null);
        }
    }

    void initializeInConstructor(@NotNull GrVariable field, @NotNull Collection<PsiElement> replaced) {
        PsiClass scope;
        if (field == null) {
            GrIntroduceFieldProcessor.$$$reportNull$$$0(20);
        }
        if (replaced == null) {
            GrIntroduceFieldProcessor.$$$reportNull$$$0(21);
        }
        if ((scope = (PsiClass)this.myContext.getScope()) instanceof GrAnonymousClassDefinition) {
            this.initializeInAnonymousClassInitializer(field, (GrAnonymousClassDefinition)scope, replaced);
        } else {
            this.initializeInConstructor(field, scope, replaced);
        }
    }

    private void initializeInConstructor(@NotNull GrVariable field, @NotNull PsiClass scope, @NotNull Collection<PsiElement> replaced) {
        PsiMethod[] constructors;
        if (field == null) {
            GrIntroduceFieldProcessor.$$$reportNull$$$0(22);
        }
        if (scope == null) {
            GrIntroduceFieldProcessor.$$$reportNull$$$0(23);
        }
        if (replaced == null) {
            GrIntroduceFieldProcessor.$$$reportNull$$$0(24);
        }
        if ((constructors = scope.getConstructors()).length == 0) {
            constructors = new PsiMethod[]{this.generateConstructor(scope)};
        }
        for (PsiMethod constructor : constructors) {
            GrConstructorInvocation invocation = PsiImplUtil.getChainingConstructorInvocation((GrMethod)constructor);
            if (invocation != null && invocation.isThisCall()) continue;
            GrOpenBlock body = ((GrMethod)constructor).getBlock();
            GrStatement anchor = GrIntroduceFieldProcessor.findAnchorForAssignment(body, replaced);
            this.initializeInMethodInner(field, body, anchor, (PsiElement)ContainerUtil.getFirstItem(replaced));
        }
    }

    @NotNull
    private PsiMethod generateConstructor(@NotNull PsiClass scope) {
        String name;
        if (scope == null) {
            GrIntroduceFieldProcessor.$$$reportNull$$$0(25);
        }
        LOG.assertTrue((name = scope.getName()) != null, (Object)scope.getText());
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.myContext.getProject());
        GrMethod constructor = factory.createConstructorFromText(name, ArrayUtil.EMPTY_STRING_ARRAY, ArrayUtil.EMPTY_STRING_ARRAY, "{}", (PsiElement)scope);
        if (scope instanceof GroovyScriptClass) {
            constructor.getModifierList().setModifierProperty("def", true);
        }
        PsiMethod psiMethod = (PsiMethod)scope.add((PsiElement)constructor);
        if (psiMethod == null) {
            GrIntroduceFieldProcessor.$$$reportNull$$$0(26);
        }
        return psiMethod;
    }

    private void initializeInAnonymousClassInitializer(@NotNull GrVariable field, @NotNull GrAnonymousClassDefinition scope, @NotNull Collection<PsiElement> replaced) {
        if (field == null) {
            GrIntroduceFieldProcessor.$$$reportNull$$$0(27);
        }
        if (scope == null) {
            GrIntroduceFieldProcessor.$$$reportNull$$$0(28);
        }
        if (replaced == null) {
            GrIntroduceFieldProcessor.$$$reportNull$$$0(29);
        }
        GrClassInitializer[] initializers = scope.getInitializers();
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.myContext.getProject());
        GrClassInitializer initializer = initializers.length == 0 ? (GrClassInitializer)scope.add(factory.createClassInitializer()) : initializers[0];
        GrStatement anchor = GrIntroduceFieldProcessor.findAnchorForAssignment(initializer.getBlock(), replaced);
        this.initializeInMethodInner(field, initializer.getBlock(), anchor, (PsiElement)ContainerUtil.getFirstItem(replaced));
    }

    private void generateAssignment(@NotNull GrVariable field, @Nullable GrStatement anchor, @Nullable GrStatementOwner defaultContainer, @Nullable PsiElement occurrenceToDelete) {
        GrStatementOwner block;
        if (field == null) {
            GrIntroduceFieldProcessor.$$$reportNull$$$0(30);
        }
        if (this.myInitializer == null || defaultContainer == null) {
            return;
        }
        GrAssignmentExpression init = (GrAssignmentExpression)GroovyPsiElementFactory.getInstance(this.myContext.getProject()).createExpressionFromText(this.mySettings.getName() + " = " + this.myInitializer.getText());
        if (anchor != null) {
            anchor = GroovyRefactoringUtil.addBlockIntoParent(anchor);
            LOG.assertTrue(anchor.getParent() instanceof GrStatementOwner);
            block = (GrStatementOwner)anchor.getParent();
        } else {
            block = defaultContainer;
        }
        init = (GrAssignmentExpression)block.addStatementBefore(init, anchor);
        this.replaceOccurrence(field, init.getLValue(), (PsiClass)this.myContext.getScope());
        if (occurrenceToDelete != null) {
            occurrenceToDelete.delete();
        }
    }

    @Nullable
    private GrExpression extractVarInitializer() {
        assert (this.myLocalVariable != null);
        return this.myLocalVariable.getInitializerGroovy();
    }

    @Nullable
    private static GrStatement findAnchorForAssignment(@Nullable GrCodeBlock block, @NotNull Collection<PsiElement> replaced) {
        if (replaced == null) {
            GrIntroduceFieldProcessor.$$$reportNull$$$0(31);
        }
        if (block == null) {
            return null;
        }
        List elements = ContainerUtil.findAll(replaced, element -> PsiTreeUtil.isAncestor((PsiElement)block, (PsiElement)element, (boolean)true));
        if (elements.isEmpty()) {
            return null;
        }
        return (GrStatement)GrIntroduceHandlerBase.findAnchor((PsiElement[])ContainerUtil.toArray((List)elements, (Object[])new PsiElement[elements.size()]), block);
    }

    @NotNull
    private PsiElement replaceOccurrence(@NotNull GrVariable field, @NotNull PsiElement occurrence, @NotNull PsiClass containingClass) {
        if (field == null) {
            GrIntroduceFieldProcessor.$$$reportNull$$$0(32);
        }
        if (occurrence == null) {
            GrIntroduceFieldProcessor.$$$reportNull$$$0(33);
        }
        if (containingClass == null) {
            GrIntroduceFieldProcessor.$$$reportNull$$$0(34);
        }
        boolean isOriginal = occurrence == this.myContext.getExpression();
        GrReferenceExpression newExpr = GrIntroduceFieldProcessor.createRefExpression(field, occurrence, containingClass);
        PsiElement replaced = occurrence instanceof GrExpression ? ((GrExpression)occurrence).replaceWithExpression(newExpr, false) : occurrence.replace((PsiElement)newExpr);
        if (replaced instanceof GrQualifiedReference) {
            GrReferenceAdjuster.shortenReference((GrQualifiedReference)replaced);
        }
        if (isOriginal) {
            this.updateCaretPosition(replaced);
        }
        PsiElement psiElement = replaced;
        if (psiElement == null) {
            GrIntroduceFieldProcessor.$$$reportNull$$$0(35);
        }
        return psiElement;
    }

    @NotNull
    private static GrReferenceExpression createRefExpression(@NotNull GrVariable field, @NotNull PsiElement place, @NotNull PsiClass containingClass) {
        if (field == null) {
            GrIntroduceFieldProcessor.$$$reportNull$$$0(36);
        }
        if (place == null) {
            GrIntroduceFieldProcessor.$$$reportNull$$$0(37);
        }
        if (containingClass == null) {
            GrIntroduceFieldProcessor.$$$reportNull$$$0(38);
        }
        String qname = containingClass instanceof GroovyScriptClass ? null : containingClass.getQualifiedName();
        String prefix = qname != null ? qname + "." : "";
        String refText = field.hasModifierProperty("static") ? prefix + field.getName() : prefix + "this." + field.getName();
        GrReferenceExpression grReferenceExpression = GroovyPsiElementFactory.getInstance(place.getProject()).createReferenceExpressionFromText(refText, place);
        if (grReferenceExpression == null) {
            GrIntroduceFieldProcessor.$$$reportNull$$$0(39);
        }
        return grReferenceExpression;
    }

    @NotNull
    private GrVariableDeclaration createField(@NotNull PsiClass targetClass) {
        if (targetClass == null) {
            GrIntroduceFieldProcessor.$$$reportNull$$$0(40);
        }
        String name = this.mySettings.getName();
        PsiType type = this.mySettings.getSelectedType();
        String modifier = this.mySettings.getVisibilityModifier();
        ArrayList<String> modifiers = new ArrayList<String>();
        if (targetClass instanceof GroovyScriptClass) {
            modifiers.add("@groovy.transform.Field");
        }
        if (this.mySettings.isStatic()) {
            modifiers.add("static");
        }
        if (!"packageLocal".equals(modifier)) {
            modifiers.add(modifier);
        }
        if (this.mySettings.declareFinal()) {
            modifiers.add("final");
        }
        String[] arr_modifiers = ArrayUtil.toStringArray(modifiers);
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.myContext.getProject());
        if (targetClass instanceof GroovyScriptClass) {
            GrVariableDeclaration grVariableDeclaration = factory.createVariableDeclaration(arr_modifiers, (GrExpression)null, type, name);
            if (grVariableDeclaration == null) {
                GrIntroduceFieldProcessor.$$$reportNull$$$0(41);
            }
            return grVariableDeclaration;
        }
        GrVariableDeclaration grVariableDeclaration = factory.createFieldDeclaration(arr_modifiers, name, null, type);
        if (grVariableDeclaration == null) {
            GrIntroduceFieldProcessor.$$$reportNull$$$0(42);
        }
        return grVariableDeclaration;
    }

    @Nullable
    protected GrExpression getInitializer() {
        if (this.mySettings.removeLocalVar()) {
            return this.extractVarInitializer();
        }
        GrExpression expression = this.myContext.getExpression();
        StringPartInfo stringPart = this.myContext.getStringPart();
        if (expression != null) {
            return expression;
        }
        if (stringPart != null) {
            return stringPart.createLiteralFromSelected();
        }
        throw new IncorrectOperationException("cannot be here!");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 26: 
            case 35: 
            case 39: 
            case 41: 
            case 42: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 26: 
            case 35: 
            case 39: 
            case 41: 
            case 42: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 10: 
            case 14: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 3: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 27: 
            case 30: 
            case 32: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 26: 
            case 35: 
            case 39: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrIntroduceFieldProcessor";
                break;
            }
            case 9: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "occurrence";
                break;
            }
            case 16: 
            case 18: 
            case 21: 
            case 24: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replaced";
                break;
            }
            case 23: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 34: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrIntroduceFieldProcessor";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "processOccurrences";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "insertField";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "generateConstructor";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceOccurrence";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "createRefExpression";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "createField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processOccurrences";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 26: 
            case 35: 
            case 39: 
            case 41: 
            case 42: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updateCaretPosition";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "insertField";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getAnchorForDeclaration";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "initializeInSetup";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "initializeInMethod";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "initializeInMethodInner";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "initializeInConstructor";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "generateConstructor";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "initializeInAnonymousClassInitializer";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "generateAssignment";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "findAnchorForAssignment";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "replaceOccurrence";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "createRefExpression";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "createField";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 26: 
            case 35: 
            case 39: 
            case 41: 
            case 42: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

