/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.memberPullUp;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.intention.AddAnnotationFix;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiQualifiedReferenceElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.memberPullUp.PullUpData;
import com.intellij.refactoring.memberPullUp.PullUpHelper;
import com.intellij.refactoring.util.DocCommentPolicy;
import com.intellij.refactoring.util.RefactoringHierarchyUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocCommentOwner;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.impl.GrDocCommentUtil;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrExtendsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrImplementsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrReferenceList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameterList;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringUtil;
import org.jetbrains.plugins.groovy.refactoring.classMembers.GrClassMemberReferenceVisitor;
import org.jetbrains.plugins.groovy.util.GroovyChangeContextUtil;

public class GrPullUpHelper
implements PullUpHelper<MemberInfo> {
    private static final Logger LOG = Logger.getInstance(GrPullUpHelper.class);
    private static final Key<Boolean> SUPER_REF = Key.create((String)"SUPER_REF");
    private static final Key<Boolean> THIS_REF = Key.create((String)"THIS_REF");
    private static final Key<Boolean> PRESERVE_QUALIFIER = Key.create((String)"PRESERVE_QUALIFIER");
    private final PsiClass myTargetSuperClass;
    private final Set<PsiMember> myMembersToMove;
    private final PsiClass mySourceClass;
    private final Project myProject;
    private final DocCommentPolicy myDocCommentPolicy;
    private final Set<PsiMember> myMembersAfterMove;
    final ExplicitSuperDeleter myExplicitSuperDeleter;
    final QualifiedThisSuperAdjuster myThisSuperAdjuster;
    private final QualifiedThisSuperSearcher myQualifiedSearcher;

    public GrPullUpHelper(PullUpData data) {
        this.myTargetSuperClass = data.getTargetClass();
        this.myMembersToMove = data.getMembersToMove();
        this.mySourceClass = data.getSourceClass();
        this.myProject = data.getProject();
        this.myDocCommentPolicy = data.getDocCommentPolicy();
        this.myMembersAfterMove = data.getMovedMembers();
        this.myExplicitSuperDeleter = new ExplicitSuperDeleter();
        this.myThisSuperAdjuster = new QualifiedThisSuperAdjuster();
        this.myQualifiedSearcher = new QualifiedThisSuperSearcher();
    }

    public void encodeContextInfo(MemberInfo info) {
        GroovyChangeContextUtil.encodeContextInfo(info.getMember());
        ((GroovyPsiElement)info.getMember()).accept(this.myQualifiedSearcher);
    }

    public void move(MemberInfo info, PsiSubstitutor substitutor) {
        if (info.getMember() instanceof PsiMethod) {
            this.doMoveMethod(substitutor, info);
        } else if (info.getMember() instanceof PsiField) {
            this.doMoveField(substitutor, info);
        } else if (info.getMember() instanceof PsiClass) {
            this.doMoveClass(substitutor, info);
        }
    }

    public void postProcessMember(PsiMember member) {
        ((GrMember)member).accept(this.myExplicitSuperDeleter);
        ((GrMember)member).accept(this.myThisSuperAdjuster);
        GroovyChangeContextUtil.decodeContextInfo((PsiElement)member, null, null);
        ((GroovyPsiElement)member).accept(new GroovyRecursiveElementVisitor(){

            @Override
            public void visitReferenceExpression(@NotNull GrReferenceExpression referenceExpression) {
                if (referenceExpression == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (this.processRef(referenceExpression)) {
                    return;
                }
                super.visitReferenceExpression(referenceExpression);
            }

            @Override
            public void visitCodeReferenceElement(@NotNull GrCodeReferenceElement refElement) {
                if (refElement == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (this.processRef(refElement)) {
                    return;
                }
                super.visitCodeReferenceElement(refElement);
            }

            private boolean processRef(@NotNull GrReferenceElement<? extends GroovyPsiElement> refElement) {
                Boolean preserveQualifier;
                PsiElement qualifier;
                if (refElement == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((qualifier = refElement.getQualifier()) != null && (preserveQualifier = (Boolean)qualifier.getCopyableUserData(PRESERVE_QUALIFIER)) != null && !preserveQualifier.booleanValue()) {
                    refElement.setQualifier(null);
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "referenceExpression";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "refElement";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/memberPullUp/GrPullUpHelper$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitReferenceExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitCodeReferenceElement";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processRef";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void setCorrectVisibility(MemberInfo info) {
        PsiModifierListOwner modifierListOwner = (PsiModifierListOwner)info.getMember();
        if (this.myTargetSuperClass.isInterface()) {
            com.intellij.psi.util.PsiUtil.setModifierProperty((PsiModifierListOwner)modifierListOwner, (String)"public", (boolean)true);
        } else if (modifierListOwner.hasModifierProperty("private")) {
            if (info.isToAbstract() || GrPullUpHelper.willBeUsedInSubclass((PsiElement)modifierListOwner, this.myMembersToMove, this.myTargetSuperClass, this.mySourceClass)) {
                com.intellij.psi.util.PsiUtil.setModifierProperty((PsiModifierListOwner)modifierListOwner, (String)"protected", (boolean)true);
            }
            if (modifierListOwner instanceof GrTypeDefinition) {
                ((GrTypeDefinition)modifierListOwner).accept(new GroovyRecursiveElementVisitor(){

                    @Override
                    public void visitMethod(@NotNull GrMethod method) {
                        if (method == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        this.check(method);
                    }

                    @Override
                    public void visitField(@NotNull GrField field) {
                        if (field == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        this.check(field);
                    }

                    @Override
                    public void visitTypeDefinition(@NotNull GrTypeDefinition typeDefinition) {
                        if (typeDefinition == null) {
                            2.$$$reportNull$$$0(2);
                        }
                        this.check(typeDefinition);
                        super.visitTypeDefinition(typeDefinition);
                    }

                    private void check(PsiMember member) {
                        if (member.hasModifierProperty("private") && GrPullUpHelper.willBeUsedInSubclass((PsiElement)member, GrPullUpHelper.this.myMembersToMove, GrPullUpHelper.this.myTargetSuperClass, GrPullUpHelper.this.mySourceClass)) {
                            com.intellij.psi.util.PsiUtil.setModifierProperty((PsiModifierListOwner)member, (String)"protected", (boolean)true);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "method";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "field";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "typeDefinition";
                                break;
                            }
                        }
                        objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/memberPullUp/GrPullUpHelper$2";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "visitMethod";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "visitField";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[2] = "visitTypeDefinition";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }
        }
    }

    public void moveFieldInitializations(LinkedHashSet<PsiField> movedFields) {
    }

    public void updateUsage(PsiElement element) {
        GrExpression qualifierExpression;
        if (element instanceof GrReferenceExpression && (qualifierExpression = ((GrReferenceExpression)element).getQualifierExpression()) instanceof GrReferenceExpression && ((GrReferenceExpression)qualifierExpression).resolve() == this.mySourceClass) {
            ((GrReferenceExpression)qualifierExpression).bindToElement((PsiElement)this.myTargetSuperClass);
        }
    }

    private static boolean willBeUsedInSubclass(PsiElement member, Set<PsiMember> movedMembers, PsiClass superclass, PsiClass subclass) {
        for (PsiReference ref : ReferencesSearch.search((PsiElement)member, (SearchScope)new LocalSearchScope((PsiElement)subclass), (boolean)false)) {
            PsiElement element = ref.getElement();
            if (RefactoringHierarchyUtil.willBeInTargetClass((PsiElement)element, movedMembers, (PsiClass)superclass, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    private void doMoveMethod(PsiSubstitutor substitutor, MemberInfo info) {
        boolean isOriginalMethodAbstract;
        GrMethod method;
        GroovyPsiElementFactory elementFactory = GroovyPsiElementFactory.getInstance(this.myProject);
        GrMethod sibling = method = (GrMethod)info.getMember();
        PsiMethod anchor = null;
        while (sibling != null && ((sibling = (PsiMethod)PsiTreeUtil.getNextSiblingOfType((PsiElement)sibling, PsiMethod.class)) == null || (anchor = MethodSignatureUtil.findMethodInSuperClassBySignatureInDerived((PsiClass)method.getContainingClass(), (PsiClass)this.myTargetSuperClass, (MethodSignature)sibling.getSignature(PsiSubstitutor.EMPTY), (boolean)false)) == null)) {
        }
        GrMethod methodCopy = (GrMethod)method.copy();
        if (method.findSuperMethods(this.myTargetSuperClass).length == 0) {
            GrPullUpHelper.deleteOverrideAnnotationIfFound(methodCopy);
        }
        boolean bl = isOriginalMethodAbstract = method.hasModifierProperty("abstract") || method.hasModifierProperty("default");
        if (this.myTargetSuperClass.isInterface() || info.isToAbstract()) {
            GrDocComment oldDoc;
            GroovyChangeContextUtil.clearContextInfo(method);
            RefactoringUtil.makeMethodAbstract((PsiClass)this.myTargetSuperClass, (PsiMethod)methodCopy);
            if (this.myTargetSuperClass.isInterface()) {
                com.intellij.psi.util.PsiUtil.setModifierProperty((PsiModifierListOwner)methodCopy, (String)"abstract", (boolean)false);
            }
            GrPullUpHelper.replaceMovedMemberTypeParameters(methodCopy, com.intellij.psi.util.PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)this.mySourceClass), substitutor, elementFactory);
            GrMethod movedElement = anchor != null ? (GrMethod)this.myTargetSuperClass.addBefore((PsiElement)methodCopy, (PsiElement)anchor) : (GrMethod)this.myTargetSuperClass.add((PsiElement)methodCopy);
            CodeStyleSettings styleSettings = CodeStyleSettingsManager.getSettings((Project)method.getProject());
            if (styleSettings.INSERT_OVERRIDE_ANNOTATION && (com.intellij.psi.util.PsiUtil.isLanguageLevel5OrHigher((PsiElement)this.mySourceClass) && !this.myTargetSuperClass.isInterface() || com.intellij.psi.util.PsiUtil.isLanguageLevel6OrHigher((PsiElement)this.mySourceClass))) {
                new AddAnnotationFix("java.lang.Override", (PsiModifierListOwner)method, new String[0]).invoke(method.getProject(), null, this.mySourceClass.getContainingFile());
            }
            if ((oldDoc = method.getDocComment()) != null) {
                GrDocCommentUtil.setDocComment(movedElement, oldDoc);
            }
            this.myDocCommentPolicy.processCopiedJavaDoc((PsiComment)methodCopy.getDocComment(), (PsiComment)oldDoc, isOriginalMethodAbstract);
            this.myMembersAfterMove.add(movedElement);
            if (isOriginalMethodAbstract) {
                GrPullUpHelper.deleteMemberWithDocComment(method);
            }
        } else {
            PsiMethod movedElement;
            if (isOriginalMethodAbstract) {
                com.intellij.psi.util.PsiUtil.setModifierProperty((PsiModifierListOwner)this.myTargetSuperClass, (String)"abstract", (boolean)true);
            }
            this.fixReferencesToStatic(methodCopy);
            GrPullUpHelper.replaceMovedMemberTypeParameters(methodCopy, com.intellij.psi.util.PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)this.mySourceClass), substitutor, elementFactory);
            PsiMethod superClassMethod = this.myTargetSuperClass.findMethodBySignature((PsiMethod)methodCopy, false);
            Language language = this.myTargetSuperClass.getLanguage();
            if (superClassMethod != null && superClassMethod.hasModifierProperty("abstract")) {
                movedElement = (PsiMethod)superClassMethod.replace((PsiElement)GrPullUpHelper.convertMethodToLanguage(methodCopy, language));
            } else {
                movedElement = anchor != null ? (PsiMethod)this.myTargetSuperClass.addBefore((PsiElement)GrPullUpHelper.convertMethodToLanguage(methodCopy, language), (PsiElement)anchor) : (PsiMethod)this.myTargetSuperClass.add((PsiElement)GrPullUpHelper.convertMethodToLanguage(methodCopy, language));
                this.myMembersAfterMove.add((PsiMember)movedElement);
            }
            if (movedElement instanceof GrMethod) {
                GrDocCommentUtil.setDocComment((GrDocCommentOwner)movedElement, method.getDocComment());
            }
            GrPullUpHelper.deleteMemberWithDocComment(method);
        }
    }

    private static void deleteMemberWithDocComment(GrDocCommentOwner docCommentOwner) {
        GrDocComment oldDoc = docCommentOwner.getDocComment();
        if (oldDoc != null) {
            oldDoc.delete();
        }
        docCommentOwner.delete();
    }

    private static void deleteOverrideAnnotationIfFound(PsiMethod oMethod) {
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)oMethod, (String[])new String[]{"java.lang.Override"});
        if (annotation != null) {
            PsiElement prev = annotation.getPrevSibling();
            PsiElement next = annotation.getNextSibling();
            if ((prev == null || PsiUtil.isLineFeed(prev)) && PsiUtil.isLineFeed(next)) {
                next.delete();
            }
            annotation.delete();
        }
    }

    public static void replaceMovedMemberTypeParameters(PsiElement member, Iterable<PsiTypeParameter> parametersIterable, PsiSubstitutor substitutor, GroovyPsiElementFactory factory) {
        LinkedHashMap<PsiElement, PsiElement> replacement = new LinkedHashMap<PsiElement, PsiElement>();
        for (PsiTypeParameter parameter : parametersIterable) {
            PsiType substitutedType = substitutor.substitute(parameter);
            PsiType type = substitutedType != null ? substitutedType : TypeConversionUtil.erasure((PsiType)factory.createType((PsiClass)parameter));
            PsiElement scopeElement = member instanceof GrField ? member.getParent() : member;
            for (PsiReference reference : ReferencesSearch.search((PsiElement)parameter, (SearchScope)new LocalSearchScope(scopeElement))) {
                PsiElement element = reference.getElement();
                PsiElement parent = element.getParent();
                if (parent instanceof PsiTypeElement) {
                    replacement.put(parent, factory.createTypeElement(type));
                    continue;
                }
                if (!(element instanceof GrCodeReferenceElement) || !(type instanceof PsiClassType)) continue;
                replacement.put(element, factory.createReferenceElementByType((PsiClassType)type));
            }
        }
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)member.getProject());
        for (PsiElement element : replacement.keySet()) {
            if (!element.isValid()) continue;
            PsiElement replaced = element.replace((PsiElement)replacement.get(element));
            codeStyleManager.shortenClassReferences(replaced);
        }
    }

    private void fixReferencesToStatic(GroovyPsiElement classMember) throws IncorrectOperationException {
        StaticReferencesCollector collector = new StaticReferencesCollector(this.myMembersToMove);
        classMember.accept(collector);
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.myProject);
        for (StaticReferenceResult result : collector.results) {
            GrReferenceElement<?> ref = result.reference;
            GrMember namedElement = result.referee;
            PsiClass aClass = result.refereeClass;
            if (!(namedElement instanceof PsiNamedElement)) continue;
            String name = GroovyRefactoringUtil.getNewName((PsiNamedElement)namedElement, result.invokedOnProperty);
            GrReferenceExpression newRef = (GrReferenceExpression)factory.createExpressionFromText("a." + name, null);
            GrExpression qualifier = newRef.getQualifierExpression();
            assert (qualifier != null);
            qualifier = (GrExpression)qualifier.replace(factory.createReferenceExpressionFromText(aClass.getQualifiedName()));
            qualifier.putCopyableUserData(PRESERVE_QUALIFIER, ref.isQualified());
            PsiElement replaced = ref.replace(newRef);
            JavaCodeStyleManager.getInstance((Project)this.myProject).shortenClassReferences(replaced);
        }
    }

    private void doMoveField(PsiSubstitutor substitutor, MemberInfo info) {
        GroovyPsiElementFactory elementFactory = GroovyPsiElementFactory.getInstance(this.myProject);
        GrField field = (GrField)info.getMember();
        field.normalizeDeclaration();
        GrPullUpHelper.replaceMovedMemberTypeParameters(field, com.intellij.psi.util.PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)this.mySourceClass), substitutor, elementFactory);
        this.fixReferencesToStatic(field);
        if (this.myTargetSuperClass.isInterface()) {
            com.intellij.psi.util.PsiUtil.setModifierProperty((PsiModifierListOwner)field, (String)"public", (boolean)true);
        }
        PsiMember movedElement = (PsiMember)this.myTargetSuperClass.add((PsiElement)GrPullUpHelper.convertFieldToLanguage(field, this.myTargetSuperClass.getLanguage()));
        this.myMembersAfterMove.add(movedElement);
        GrPullUpHelper.deleteMemberWithDocComment(field);
    }

    private void doMoveClass(PsiSubstitutor substitutor, MemberInfo info) {
        if (Boolean.FALSE.equals(info.getOverrides())) {
            PsiClass aClass = (PsiClass)info.getMember();
            if (this.myTargetSuperClass instanceof GrTypeDefinition) {
                this.addClassToSupers(info, aClass, substitutor, (GrTypeDefinition)this.myTargetSuperClass);
            }
        } else {
            GrTypeDefinition aClass = (GrTypeDefinition)info.getMember();
            GroovyPsiElementFactory elementFactory = GroovyPsiElementFactory.getInstance(this.myProject);
            GrPullUpHelper.replaceMovedMemberTypeParameters(aClass, com.intellij.psi.util.PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)this.mySourceClass), substitutor, elementFactory);
            this.fixReferencesToStatic(aClass);
            PsiMember movedElement = (PsiMember)this.myTargetSuperClass.addAfter((PsiElement)GrPullUpHelper.convertClassToLanguage(aClass, this.myTargetSuperClass.getLanguage()), null);
            this.myMembersAfterMove.add(movedElement);
            GrPullUpHelper.deleteMemberWithDocComment(aClass);
        }
    }

    private static PsiMethod convertMethodToLanguage(PsiMethod method, Language language) {
        if (method.getLanguage().equals(language)) {
            return method;
        }
        return JVMElementFactories.getFactory((Language)language, (Project)method.getProject()).createMethodFromText(method.getText(), null);
    }

    private static PsiField convertFieldToLanguage(PsiField field, Language language) {
        if (field.getLanguage().equals(language)) {
            return field;
        }
        return JVMElementFactories.getFactory((Language)language, (Project)field.getProject()).createField(field.getName(), field.getType());
    }

    private static PsiClass convertClassToLanguage(PsiClass clazz, Language language) {
        return clazz;
    }

    private void addClassToSupers(MemberInfo info, PsiClass aClass, PsiSubstitutor substitutor, GrTypeDefinition targetSuperClass) {
        PsiQualifiedReferenceElement ref;
        PsiReferenceList sourceReferenceList = info.getSourceReferenceList();
        LOG.assertTrue(sourceReferenceList != null);
        PsiQualifiedReferenceElement psiQualifiedReferenceElement = ref = this.mySourceClass.equals(sourceReferenceList.getParent()) ? GrPullUpHelper.removeFromReferenceList(sourceReferenceList, aClass) : GrPullUpHelper.findReferenceToClass(sourceReferenceList, aClass);
        if (ref != null && !targetSuperClass.isInheritor(aClass, false)) {
            GrReferenceList referenceList;
            GroovyPsiElementFactory elementFactory = GroovyPsiElementFactory.getInstance(this.myProject);
            GrPullUpHelper.replaceMovedMemberTypeParameters((PsiElement)ref, com.intellij.psi.util.PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)this.mySourceClass), substitutor, elementFactory);
            if (targetSuperClass.isInterface()) {
                referenceList = targetSuperClass.getExtendsClause();
                if (referenceList == null) {
                    GrExtendsClause newClause = GroovyPsiElementFactory.getInstance(this.myProject).createExtendsClause();
                    GrTypeParameterList anchor = targetSuperClass.getTypeParameterList() != null ? targetSuperClass.getTypeParameterList() : targetSuperClass.getNameIdentifierGroovy();
                    referenceList = (GrReferenceList)targetSuperClass.addAfter(newClause, anchor);
                    GrPullUpHelper.addSpacesAround(referenceList);
                }
            } else {
                referenceList = targetSuperClass.getImplementsClause();
                if (referenceList == null) {
                    GrImplementsClause newClause = GroovyPsiElementFactory.getInstance(this.myProject).createImplementsClause();
                    GrExtendsClause anchor = targetSuperClass.getExtendsClause() != null ? targetSuperClass.getExtendsClause() : (targetSuperClass.getTypeParameterList() != null ? targetSuperClass.getTypeParameterList() : targetSuperClass.getNameIdentifierGroovy());
                    referenceList = (GrReferenceList)targetSuperClass.addAfter(newClause, anchor);
                    GrPullUpHelper.addSpacesAround(referenceList);
                }
            }
            assert (referenceList != null);
            referenceList.add((PsiElement)ref);
        }
    }

    private static void addSpacesAround(@NotNull GrReferenceList list) {
        PsiElement next;
        PsiElement prev;
        if (list == null) {
            GrPullUpHelper.$$$reportNull$$$0(0);
        }
        if (!PsiImplUtil.isWhiteSpaceOrNls(prev = list.getPrevSibling())) {
            list.getParent().getNode().addLeaf(TokenType.WHITE_SPACE, (CharSequence)" ", list.getNode());
        }
        if (!PsiImplUtil.isWhiteSpaceOrNls(next = list.getNextSibling())) {
            list.getParent().getNode().addLeaf(TokenType.WHITE_SPACE, (CharSequence)" ", list.getNode().getTreeNext());
        }
    }

    public static PsiQualifiedReferenceElement findReferenceToClass(PsiReferenceList refList, PsiClass aClass) {
        Object[] refs;
        for (PsiJavaCodeReferenceElement ref : refs = refList instanceof GrReferenceList ? ((GrReferenceList)refList).getReferenceElementsGroovy() : refList.getReferenceElements()) {
            if (!ref.isReferenceTo((PsiElement)aClass)) continue;
            return ref;
        }
        return null;
    }

    public static PsiQualifiedReferenceElement removeFromReferenceList(PsiReferenceList refList, PsiClass aClass) throws IncorrectOperationException {
        List<PsiJavaCodeReferenceElement> refs = Arrays.asList(refList instanceof GrReferenceList ? ((GrReferenceList)refList).getReferenceElementsGroovy() : refList.getReferenceElements());
        for (PsiQualifiedReferenceElement psiQualifiedReferenceElement : refs) {
            if (!psiQualifiedReferenceElement.isReferenceTo((PsiElement)aClass)) continue;
            PsiQualifiedReferenceElement refCopy = (PsiQualifiedReferenceElement)psiQualifiedReferenceElement.copy();
            psiQualifiedReferenceElement.delete();
            return refCopy;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/jetbrains/plugins/groovy/refactoring/memberPullUp/GrPullUpHelper", "addSpacesAround"));
    }

    private class QualifiedThisSuperSearcher
    extends GroovyRecursiveElementVisitor {
        private QualifiedThisSuperSearcher() {
        }

        @Override
        public void visitReferenceExpression(@NotNull GrReferenceExpression expression) {
            GrExpression qualifier;
            if (expression == null) {
                QualifiedThisSuperSearcher.$$$reportNull$$$0(0);
            }
            super.visitReferenceExpression(expression);
            if (PsiUtil.isSuperReference(expression)) {
                GrExpression qualifier2 = (GrExpression)expression.getQualifier();
                if (qualifier2 instanceof GrReferenceExpression && ((GrReferenceExpression)qualifier2).isReferenceTo((PsiElement)GrPullUpHelper.this.mySourceClass)) {
                    try {
                        expression.putCopyableUserData(SUPER_REF, Boolean.TRUE);
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                }
            } else if (PsiUtil.isThisReference(expression) && (qualifier = (GrExpression)expression.getQualifier()) instanceof GrReferenceExpression && ((GrReferenceExpression)qualifier).isReferenceTo((PsiElement)GrPullUpHelper.this.mySourceClass)) {
                try {
                    expression.putCopyableUserData(THIS_REF, Boolean.TRUE);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/refactoring/memberPullUp/GrPullUpHelper$QualifiedThisSuperSearcher", "visitReferenceExpression"));
        }
    }

    private class QualifiedThisSuperAdjuster
    extends GroovyRecursiveElementVisitor {
        private QualifiedThisSuperAdjuster() {
        }

        @Override
        public void visitReferenceExpression(@NotNull GrReferenceExpression expression) {
            if (expression == null) {
                QualifiedThisSuperAdjuster.$$$reportNull$$$0(0);
            }
            super.visitReferenceExpression(expression);
            if (expression.getCopyableUserData(SUPER_REF) != null) {
                expression.putCopyableUserData(SUPER_REF, null);
                GrExpression qualifier = (GrExpression)expression.getQualifier();
                if (qualifier instanceof GrReferenceExpression && ((GrReferenceExpression)qualifier).isReferenceTo((PsiElement)GrPullUpHelper.this.mySourceClass)) {
                    try {
                        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(GrPullUpHelper.this.myProject);
                        GrExpression newExpr = factory.createExpressionFromText(GrPullUpHelper.this.myTargetSuperClass.getName() + ".this", null);
                        expression.replace(newExpr);
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                }
            } else if (expression.getCopyableUserData(THIS_REF) != null) {
                expression.putCopyableUserData(THIS_REF, null);
                GrExpression qualifier = (GrExpression)expression.getQualifier();
                if (qualifier instanceof GrReferenceExpression && ((GrReferenceExpression)qualifier).isReferenceTo((PsiElement)GrPullUpHelper.this.mySourceClass)) {
                    try {
                        ((GrReferenceExpression)qualifier).bindToElement((PsiElement)GrPullUpHelper.this.myTargetSuperClass);
                        GroovyChangeContextUtil.clearContextInfo(qualifier);
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/refactoring/memberPullUp/GrPullUpHelper$QualifiedThisSuperAdjuster", "visitReferenceExpression"));
        }
    }

    private class ExplicitSuperDeleter
    extends GroovyRecursiveElementVisitor {
        private final GrExpression myThisExpression;

        private ExplicitSuperDeleter() {
            this.myThisExpression = GroovyPsiElementFactory.getInstance(GrPullUpHelper.this.myProject).createExpressionFromText("this", null);
        }

        @Override
        public void visitReferenceExpression(@NotNull GrReferenceExpression expression) {
            if (expression == null) {
                ExplicitSuperDeleter.$$$reportNull$$$0(0);
            }
            if (PsiUtil.isSuperReference(expression.getQualifierExpression())) {
                PsiElement resolved = expression.resolve();
                if (resolved == null || resolved instanceof PsiMethod && this.shouldFixSuper((PsiMethod)resolved)) {
                    expression.setQualifier(null);
                }
            } else if (PsiUtil.isSuperReference(expression)) {
                expression.replaceWithExpression(this.myThisExpression, true);
            }
        }

        @Override
        public void visitTypeDefinition(@NotNull GrTypeDefinition typeDefinition) {
            if (typeDefinition == null) {
                ExplicitSuperDeleter.$$$reportNull$$$0(1);
            }
        }

        private boolean shouldFixSuper(PsiMethod method) {
            for (PsiMember element : GrPullUpHelper.this.myMembersAfterMove) {
                if (!(element instanceof PsiMethod)) continue;
                PsiMethod member = (PsiMethod)element;
                PsiManager manager = method.getManager();
                if (!manager.areElementsEquivalent((PsiElement)member.getContainingClass(), (PsiElement)method.getContainingClass()) || !MethodSignatureUtil.areSignaturesEqual((PsiMethod)member, (PsiMethod)method)) continue;
                return false;
            }
            PsiMethod methodFromSuper = GrPullUpHelper.this.myTargetSuperClass.findMethodBySignature(method, false);
            return methodFromSuper == null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeDefinition";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/memberPullUp/GrPullUpHelper$ExplicitSuperDeleter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReferenceExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitTypeDefinition";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class StaticReferencesCollector
    extends GrClassMemberReferenceVisitor {
        private final Set<PsiMember> myMovedMembers;
        final List<StaticReferenceResult> results;

        private StaticReferencesCollector(Set<PsiMember> movedMembers) {
            super(GrPullUpHelper.this.mySourceClass);
            this.results = new ArrayList<StaticReferenceResult>();
            this.myMovedMembers = movedMembers;
        }

        @Override
        protected void visitClassMemberReferenceElement(GrReferenceElement<?> ref, GrMember classMember, GroovyResolveResult resolveResult) {
            if (classMember.hasModifierProperty("static")) {
                if (!this.myMovedMembers.contains(classMember) && RefactoringHierarchyUtil.isMemberBetween((PsiClass)GrPullUpHelper.this.myTargetSuperClass, (PsiClass)GrPullUpHelper.this.mySourceClass, (PsiMember)classMember)) {
                    this.results.add(new StaticReferenceResult(ref, classMember, classMember.getContainingClass(), resolveResult.isInvokedOnProperty()));
                } else if (this.myMovedMembers.contains(classMember) || GrPullUpHelper.this.myMembersAfterMove.contains(classMember)) {
                    this.results.add(new StaticReferenceResult(ref, classMember, GrPullUpHelper.this.myTargetSuperClass, resolveResult.isInvokedOnProperty()));
                }
            }
        }
    }

    private static class StaticReferenceResult {
        final GrReferenceElement<?> reference;
        final GrMember referee;
        final PsiClass refereeClass;
        final boolean invokedOnProperty;

        private StaticReferenceResult(GrReferenceElement<?> reference, GrMember referee, PsiClass refereeClass, boolean invokedOnProperty) {
            this.reference = reference;
            this.referee = referee;
            this.refereeClass = refereeClass;
            this.invokedOnProperty = invokedOnProperty;
        }
    }
}

