/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.ivyservice.NamespaceId;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.IvyModuleDescriptorConverter;
import org.gradle.internal.component.external.descriptor.Artifact;
import org.gradle.internal.component.external.descriptor.Configuration;
import org.gradle.internal.component.external.model.DefaultModuleComponentIdentifier;
import org.gradle.internal.component.external.model.DefaultMutableIvyModuleResolveMetadata;
import org.gradle.internal.component.external.model.IvyDependencyMetadata;
import org.gradle.internal.component.external.model.MutableIvyModuleResolveMetadata;
import org.gradle.internal.component.model.Exclude;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.gradle.internal.impldep.org.apache.ivy.core.module.id.ModuleRevisionId;

class IvyModuleResolveMetaDataBuilder {
    private final List<Artifact> artifacts = Lists.newArrayList();
    private final DefaultModuleDescriptor ivyDescriptor;
    private final IvyModuleDescriptorConverter converter;
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;

    public IvyModuleResolveMetaDataBuilder(DefaultModuleDescriptor module, IvyModuleDescriptorConverter converter, ImmutableModuleIdentifierFactory moduleIdentifierFactory) {
        this.ivyDescriptor = module;
        this.converter = converter;
        this.moduleIdentifierFactory = moduleIdentifierFactory;
    }

    public void addArtifact(IvyArtifactName newArtifact, Set<String> configurations) {
        if (configurations.isEmpty()) {
            throw new IllegalArgumentException("Artifact should be attached to at least one configuration.");
        }
        Artifact artifact = this.findOrCreate(newArtifact);
        artifact.getConfigurations().addAll(configurations);
    }

    private Artifact findOrCreate(IvyArtifactName artifactName) {
        for (Artifact existingArtifact : this.artifacts) {
            if (!existingArtifact.getArtifactName().equals(artifactName)) continue;
            return existingArtifact;
        }
        Artifact newArtifact = new Artifact(artifactName);
        this.artifacts.add(newArtifact);
        return newArtifact;
    }

    public List<Artifact> getArtifacts() {
        return this.artifacts;
    }

    public MutableIvyModuleResolveMetadata build() {
        ModuleRevisionId moduleRevisionId = this.ivyDescriptor.getModuleRevisionId();
        ModuleComponentIdentifier cid = DefaultModuleComponentIdentifier.newId(moduleRevisionId.getOrganisation(), moduleRevisionId.getName(), moduleRevisionId.getRevision());
        List<Configuration> configurations = this.converter.extractConfigurations((ModuleDescriptor)this.ivyDescriptor);
        List<IvyDependencyMetadata> dependencies = this.converter.extractDependencies((ModuleDescriptor)this.ivyDescriptor);
        List<Exclude> excludes = this.converter.extractExcludes((ModuleDescriptor)this.ivyDescriptor);
        Map<NamespaceId, String> extraAttributes = this.converter.extractExtraAttributes((ModuleDescriptor)this.ivyDescriptor);
        ModuleVersionIdentifier mvi = this.moduleIdentifierFactory.moduleWithVersion(cid.getGroup(), cid.getModule(), cid.getVersion());
        DefaultMutableIvyModuleResolveMetadata metadata = new DefaultMutableIvyModuleResolveMetadata(mvi, cid, configurations, dependencies, this.artifacts);
        metadata.setStatus(this.ivyDescriptor.getStatus());
        metadata.setExcludes(excludes);
        metadata.setExtraAttributes(extraAttributes);
        metadata.setBranch(this.ivyDescriptor.getModuleRevisionId().getBranch());
        return metadata;
    }
}

