/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.zip.ZipEntry;
import org.gradle.api.internal.changedetection.state.RegularFileSnapshot;
import org.gradle.api.internal.changedetection.state.ResourceHasher;
import org.gradle.api.internal.tasks.compile.ApiClassExtractor;
import org.gradle.caching.internal.BuildCacheHasher;
import org.gradle.internal.IoActions;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.impldep.com.google.common.io.ByteStreams;
import org.gradle.internal.impldep.org.objectweb.asm.ClassReader;
import org.gradle.util.DeprecationLogger;

public class AbiExtractingClasspathResourceHasher
implements ResourceHasher {
    private HashCode hashClassBytes(InputStream inputStream) throws IOException {
        byte[] signature;
        ClassReader reader;
        byte[] classBytes = ByteStreams.toByteArray((InputStream)inputStream);
        ApiClassExtractor extractor = new ApiClassExtractor(Collections.<String>emptySet());
        if (extractor.shouldExtractApiClassFrom(reader = new ClassReader(classBytes)) && (signature = extractor.extractApiClassFrom(reader)) != null) {
            return Hashing.md5().hashBytes(signature);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashCode hash(RegularFileSnapshot fileSnapshot) {
        HashCode hashCode;
        String name = fileSnapshot.getName();
        if (!this.isClassFile(name)) {
            return null;
        }
        InputStream inputStream = null;
        try {
            inputStream = Files.newInputStream(Paths.get(fileSnapshot.getPath(), new String[0]), new OpenOption[0]);
            hashCode = this.hashClassBytes(inputStream);
        }
        catch (Exception e) {
            HashCode hashCode2;
            try {
                DeprecationLogger.nagUserWith("Malformed class file [" + name + "] found on compile classpath, which means that this class will cause a compile error if referenced in a source file. Gradle 5.0 will no longer allow malformed classes on compile classpath.");
                hashCode2 = fileSnapshot.getContent().getContentMd5();
            }
            catch (Throwable throwable) {
                IoActions.closeQuietly(inputStream);
                throw throwable;
            }
            IoActions.closeQuietly(inputStream);
            return hashCode2;
        }
        IoActions.closeQuietly(inputStream);
        return hashCode;
    }

    public HashCode hash(ZipEntry zipEntry, InputStream zipInput) throws IOException {
        if (!this.isClassFile(zipEntry.getName())) {
            return null;
        }
        return this.hashClassBytes(zipInput);
    }

    private boolean isClassFile(String name) {
        return name.endsWith(".class");
    }

    public void appendConfigurationToHasher(BuildCacheHasher hasher) {
        hasher.putString(this.getClass().getName());
    }
}

