/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.gradle.api.internal.changedetection.state.FileSnapshot;
import org.gradle.api.internal.changedetection.state.FileSystemMirror;
import org.gradle.api.internal.changedetection.state.InMemoryCacheDecoratorFactory;
import org.gradle.api.internal.changedetection.state.TaskOutputFilesRepository;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.PersistentIndexedCacheParameters;
import org.gradle.internal.file.FileType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTaskOutputFilesRepository
implements TaskOutputFilesRepository,
Closeable {
    private final PersistentCache cacheAccess;
    private final FileSystemMirror fileSystemMirror;
    private final PersistentIndexedCache<String, Boolean> outputFiles;

    public DefaultTaskOutputFilesRepository(PersistentCache cacheAccess, FileSystemMirror fileSystemMirror, InMemoryCacheDecoratorFactory inMemoryCacheDecoratorFactory) {
        this.cacheAccess = cacheAccess;
        this.fileSystemMirror = fileSystemMirror;
        this.outputFiles = cacheAccess.createCache(DefaultTaskOutputFilesRepository.cacheParameters(inMemoryCacheDecoratorFactory));
    }

    @Override
    public boolean isGeneratedByGradle(File file) {
        File absoluteFile = file.getAbsoluteFile();
        return this.containsFilesGeneratedByGradle(absoluteFile) || this.isContainedInAnOutput(absoluteFile);
    }

    private boolean isContainedInAnOutput(File absoluteFile) {
        for (File currentFile = absoluteFile; currentFile != null; currentFile = currentFile.getParentFile()) {
            if (this.outputFiles.get(currentFile.getPath()) != Boolean.TRUE) continue;
            return true;
        }
        return false;
    }

    private boolean containsFilesGeneratedByGradle(File absoluteFile) {
        return this.outputFiles.get(absoluteFile.getPath()) != null;
    }

    @Override
    public void recordOutputs(Iterable<String> outputFilePaths) {
        for (String outputFilePath : outputFilePaths) {
            String parentPath;
            FileSnapshot fileSnapshot = this.fileSystemMirror.getFile(outputFilePath);
            File outputFile = new File(outputFilePath);
            boolean exists = fileSnapshot == null ? outputFile.exists() : fileSnapshot.getType() != FileType.Missing;
            if (!exists) continue;
            this.outputFiles.put(outputFilePath, Boolean.TRUE);
            for (File outputFileParent = outputFile.getParentFile(); outputFileParent != null && this.outputFiles.get(parentPath = outputFileParent.getPath()) == null; outputFileParent = outputFileParent.getParentFile()) {
                this.outputFiles.put(parentPath, Boolean.FALSE);
            }
        }
    }

    private static PersistentIndexedCacheParameters<String, Boolean> cacheParameters(InMemoryCacheDecoratorFactory inMemoryCacheDecoratorFactory) {
        return new PersistentIndexedCacheParameters<String, Boolean>("outputFiles", String.class, Boolean.class).cacheDecorator(inMemoryCacheDecoratorFactory.decorator(100000, true));
    }

    @Override
    public void close() throws IOException {
        this.cacheAccess.close();
    }
}

