/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import org.gradle.api.internal.changedetection.state.FileContentSnapshot;
import org.gradle.api.internal.changedetection.state.NormalizedFileSnapshot;
import org.gradle.caching.internal.BuildCacheHasher;
import org.gradle.internal.impldep.com.google.common.base.Objects;

public class IgnoredPathFileSnapshot
implements NormalizedFileSnapshot {
    private final FileContentSnapshot snapshot;

    public IgnoredPathFileSnapshot(FileContentSnapshot snapshot) {
        this.snapshot = snapshot;
    }

    public String getNormalizedPath() {
        return "";
    }

    public FileContentSnapshot getSnapshot() {
        return this.snapshot;
    }

    public void appendToHasher(BuildCacheHasher hasher) {
        hasher.putHash(this.snapshot.getContentMd5());
    }

    public int compareTo(NormalizedFileSnapshot o) {
        if (!(o instanceof IgnoredPathFileSnapshot)) {
            return -1;
        }
        return this.getSnapshot().getContentMd5().compareTo(o.getSnapshot().getContentMd5());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IgnoredPathFileSnapshot that = (IgnoredPathFileSnapshot)o;
        return Objects.equal((Object)this.snapshot, (Object)that.snapshot);
    }

    public int hashCode() {
        return this.snapshot.hashCode();
    }
}

