/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.UncheckedIOException;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FileNormaliser {
    private static final String FILE_PATH_SEPARATORS = File.separatorChar != '/' ? "/" + File.separator : File.separator;
    private final FileSystem fileSystem;
    private final boolean isWindowsOs;

    FileNormaliser(FileSystem fileSystem) {
        this(fileSystem, OperatingSystem.current());
    }

    FileNormaliser(FileSystem fileSystem, OperatingSystem operatingSystem) {
        this.fileSystem = fileSystem;
        this.isWindowsOs = operatingSystem.isWindows();
    }

    public File normalise(File file) {
        try {
            File candidate;
            if (!file.isAbsolute()) {
                throw new IllegalArgumentException(String.format("Cannot normalize a relative file: '%s'", file));
            }
            if (this.isWindowsOs) {
                return file.getCanonicalFile();
            }
            String filePath = file.getPath();
            List<String> path = null;
            if (this.isNormalisingRequiredForAbsolutePath(filePath)) {
                path = this.splitAndNormalisePath(filePath);
                String resolvedPath = CollectionUtils.join(File.separator, path);
                boolean needLeadingSeparator = File.listRoots()[0].getPath().startsWith(File.separator);
                if (needLeadingSeparator) {
                    resolvedPath = File.separator + resolvedPath;
                }
                candidate = new File(resolvedPath);
            } else {
                candidate = file;
            }
            if (this.fileSystem.isCaseSensitive()) {
                return candidate;
            }
            File canonical = candidate.getCanonicalFile();
            if (candidate.getPath().equalsIgnoreCase(canonical.getPath())) {
                return canonical;
            }
            if (path == null) {
                path = this.splitAndNormalisePath(filePath);
            }
            return this.normaliseUnixPathIgnoringCase(path);
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Could not normalize path for file '%s'.", file), e);
        }
    }

    boolean isNormalisingRequiredForAbsolutePath(String filePath) {
        if (File.pathSeparatorChar != '/') {
            filePath = filePath.replace(File.pathSeparatorChar, '/');
        }
        if (filePath.charAt(0) != '/') {
            throw new IllegalArgumentException("Only absolute unix paths are currently handled. filePath=" + filePath);
        }
        if (filePath.contains("/../") || filePath.contains("/./") || filePath.contains("//")) {
            return true;
        }
        return filePath.endsWith("/") || filePath.endsWith("/.") || filePath.endsWith("/..");
    }

    private List<String> splitAndNormalisePath(String filePath) {
        String[] segments = this.splitPath(filePath);
        ArrayList<String> path = new ArrayList<String>(segments.length);
        for (String segment : segments) {
            if (segment.equals("..")) {
                if (path.isEmpty()) continue;
                path.remove(path.size() - 1);
                continue;
            }
            if (segment.equals(".") || segment.length() <= 0) continue;
            path.add(segment);
        }
        return path;
    }

    private String[] splitPath(String filePath) {
        return StringUtils.split((String)filePath, (String)FILE_PATH_SEPARATORS);
    }

    private File normaliseUnixPathIgnoringCase(List<String> path) throws IOException {
        File current = File.listRoots()[0];
        for (int pos = 0; pos < path.size(); ++pos) {
            File child = this.findChildIgnoringCase(current, path.get(pos));
            if (child == null) {
                current = new File(current, CollectionUtils.join(File.separator, path.subList(pos, path.size())));
                break;
            }
            current = child;
        }
        return current;
    }

    private File findChildIgnoringCase(File current, String segment) throws IOException {
        String[] children = current.list();
        if (children == null) {
            return null;
        }
        for (String child : children) {
            if (!child.equalsIgnoreCase(segment)) continue;
            return new File(current, child);
        }
        return new File(current, segment);
    }
}

