/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import org.gradle.api.internal.file.AbstractFileResolver;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.api.tasks.util.internal.PatternSets;
import org.gradle.internal.Factory;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.nativeintegration.services.FileSystems;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityFileResolver
extends AbstractFileResolver {
    public IdentityFileResolver() {
        this(FileSystems.getDefault(), PatternSets.getNonCachingPatternSetFactory());
    }

    public IdentityFileResolver(FileSystem fileSystem, Factory<PatternSet> patternSetFactory) {
        super(fileSystem, patternSetFactory);
    }

    @Override
    protected File doResolve(Object path) {
        File file = this.convertObjectToFile(path);
        if (file == null) {
            throw new IllegalArgumentException(String.format("Cannot convert path to File. path='%s'", path));
        }
        if (!file.isAbsolute()) {
            throw new UnsupportedOperationException(String.format("Cannot convert relative path %s to an absolute file.", path));
        }
        return file;
    }

    @Override
    public String resolveAsRelativePath(Object path) {
        throw new UnsupportedOperationException(String.format("Cannot convert path %s to a relative path.", path));
    }
}

