/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.archive;

import java.io.File;
import java.io.OutputStream;
import java.util.GregorianCalendar;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.file.CopyActionProcessingStreamAction;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.internal.file.copy.CopyActionProcessingStream;
import org.gradle.api.internal.file.copy.FileCopyDetailsInternal;
import org.gradle.api.internal.file.copy.ZipCompressor;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.WorkResults;
import org.gradle.api.tasks.bundling.Zip;
import org.gradle.api.tasks.bundling.internal.Zip64RequiredException;
import org.gradle.internal.IoActions;
import org.gradle.internal.impldep.org.apache.tools.zip.ZipEntry;
import org.gradle.internal.impldep.org.apache.tools.zip.ZipOutputStream;

public class ZipCopyAction
implements CopyAction {
    public static final long CONSTANT_TIME_FOR_ZIP_ENTRIES = new GregorianCalendar(1980, 1, 1, 0, 0, 0).getTimeInMillis();
    private final File zipFile;
    private final ZipCompressor compressor;
    private final DocumentationRegistry documentationRegistry;
    private final String encoding;
    private final boolean preserveFileTimestamps;

    public ZipCopyAction(File zipFile, ZipCompressor compressor, DocumentationRegistry documentationRegistry, String encoding, boolean preserveFileTimestamps) {
        this.zipFile = zipFile;
        this.compressor = compressor;
        this.documentationRegistry = documentationRegistry;
        this.encoding = encoding;
        this.preserveFileTimestamps = preserveFileTimestamps;
    }

    public WorkResult execute(final CopyActionProcessingStream stream) {
        block4: {
            ZipOutputStream zipOutStr;
            try {
                zipOutStr = this.compressor.createArchiveOutputStream(this.zipFile);
            }
            catch (Exception e) {
                throw new GradleException(String.format("Could not create ZIP '%s'.", this.zipFile), e);
            }
            try {
                IoActions.withResource(zipOutStr, new Action<ZipOutputStream>(){

                    @Override
                    public void execute(ZipOutputStream outputStream) {
                        stream.process(new StreamAction(outputStream, ZipCopyAction.this.encoding));
                    }
                });
            }
            catch (UncheckedIOException e) {
                if (!(e.getCause() instanceof org.gradle.internal.impldep.org.apache.tools.zip.Zip64RequiredException)) break block4;
                throw new Zip64RequiredException(String.format("%s\n\nTo build this archive, please enable the zip64 extension.\nSee: %s", e.getCause().getMessage(), this.documentationRegistry.getDslRefForProperty(Zip.class, "zip64")));
            }
        }
        return WorkResults.didWork(true);
    }

    private long getArchiveTimeFor(FileCopyDetails details) {
        return this.preserveFileTimestamps ? details.getLastModified() : CONSTANT_TIME_FOR_ZIP_ENTRIES;
    }

    private class StreamAction
    implements CopyActionProcessingStreamAction {
        private final ZipOutputStream zipOutStr;

        public StreamAction(ZipOutputStream zipOutStr, String encoding) {
            this.zipOutStr = zipOutStr;
            if (encoding != null) {
                this.zipOutStr.setEncoding(encoding);
            }
        }

        public void processFile(FileCopyDetailsInternal details) {
            if (details.isDirectory()) {
                this.visitDir(details);
            } else {
                this.visitFile(details);
            }
        }

        private void visitFile(FileCopyDetails fileDetails) {
            try {
                ZipEntry archiveEntry = new ZipEntry(fileDetails.getRelativePath().getPathString());
                archiveEntry.setTime(ZipCopyAction.this.getArchiveTimeFor(fileDetails));
                archiveEntry.setUnixMode(0x8000 | fileDetails.getMode());
                this.zipOutStr.putNextEntry(archiveEntry);
                fileDetails.copyTo((OutputStream)this.zipOutStr);
                this.zipOutStr.closeEntry();
            }
            catch (Exception e) {
                throw new GradleException(String.format("Could not add %s to ZIP '%s'.", fileDetails, ZipCopyAction.this.zipFile), e);
            }
        }

        private void visitDir(FileCopyDetails dirDetails) {
            try {
                ZipEntry archiveEntry = new ZipEntry(dirDetails.getRelativePath().getPathString() + '/');
                archiveEntry.setTime(ZipCopyAction.this.getArchiveTimeFor(dirDetails));
                archiveEntry.setUnixMode(0x4000 | dirDetails.getMode());
                this.zipOutStr.putNextEntry(archiveEntry);
                this.zipOutStr.closeEntry();
            }
            catch (Exception e) {
                throw new GradleException(String.format("Could not add %s to ZIP '%s'.", dirDetails, ZipCopyAction.this.zipFile), e);
            }
        }
    }
}

