/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Task;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.tasks.TaskValidationException;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.util.DeprecationLogger;

public interface TaskValidationContext {
    public FileResolver getResolver();

    public void recordValidationMessage(Severity var1, String var2);

    public Severity getHighestSeverity();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Severity {
        WARNING{

            @Override
            public boolean report(Task task, List<String> messages, TaskStateInternal state) {
                StringBuilder builder = new StringBuilder();
                builder.append(Severity.getMainMessage(task, messages));
                builder.append(" Registering invalid inputs and outputs via TaskInputs and TaskOutputs methods ");
                builder.append(DeprecationLogger.getDeprecationMessage());
                builder.append(".");
                for (String message : messages) {
                    builder.append("\n - ");
                    builder.append(message);
                }
                DeprecationLogger.nagUserWith(builder.toString());
                return true;
            }
        }
        ,
        ERROR{

            @Override
            public boolean report(Task task, List<String> messages, TaskStateInternal state) {
                ArrayList causes = Lists.newArrayListWithCapacity((int)messages.size());
                for (String message : messages) {
                    causes.add(new InvalidUserDataException(message));
                }
                String errorMessage = Severity.getMainMessage(task, messages);
                state.setOutcome(new TaskValidationException(errorMessage, causes));
                return false;
            }
        };


        private static String getMainMessage(Task task, List<String> messages) {
            if (messages.size() == 1) {
                return String.format("A problem was found with the configuration of %s.", task);
            }
            return String.format("Some problems were found with the configuration of %s.", task);
        }

        public abstract boolean report(Task var1, List<String> var2, TaskStateInternal var3);
    }
}

