/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.TaskExecutionOutcome;
import org.gradle.api.internal.tasks.TaskPropertyUtils;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.internal.tasks.execution.TaskOutputsGenerationListener;
import org.gradle.caching.internal.controller.BuildCacheController;
import org.gradle.caching.internal.tasks.TaskOutputCacheCommandFactory;
import org.gradle.caching.internal.tasks.UnrecoverableTaskOutputUnpackingException;
import org.gradle.internal.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkipCachedTaskExecuter
implements TaskExecuter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SkipCachedTaskExecuter.class);
    private final BuildCacheController buildCache;
    private final TaskExecuter delegate;
    private final TaskOutputsGenerationListener taskOutputsGenerationListener;
    private final TaskOutputCacheCommandFactory buildCacheCommandFactory;

    public SkipCachedTaskExecuter(BuildCacheController buildCache, TaskOutputsGenerationListener taskOutputsGenerationListener, TaskOutputCacheCommandFactory buildCacheCommandFactory, TaskExecuter delegate) {
        this.taskOutputsGenerationListener = taskOutputsGenerationListener;
        this.buildCacheCommandFactory = buildCacheCommandFactory;
        this.buildCache = buildCache;
        this.delegate = delegate;
    }

    /*
     * Unable to fully structure code
     */
    public void execute(TaskInternal task, TaskStateInternal state, TaskExecutionContext context) {
        clock = Time.startTimer();
        SkipCachedTaskExecuter.LOGGER.debug("Determining if {} is cached already", (Object)task);
        taskOutputs = task.getOutputs();
        cacheKey = context.getBuildCacheKey();
        taskOutputCachingEnabled = state.getTaskOutputCaching().isEnabled();
        outputProperties = null;
        if (taskOutputCachingEnabled) {
            if (task.isHasCustomActions()) {
                SkipCachedTaskExecuter.LOGGER.info("Custom actions are attached to {}.", (Object)task);
            }
            if (cacheKey.isValid()) {
                taskState = context.getTaskArtifactState();
                outputProperties = TaskPropertyUtils.resolveFileProperties(taskOutputs.getFileProperties());
                if (taskState.isAllowedToUseCachedResults()) {
                    try {
                        originMetadata = this.buildCache.load(this.buildCacheCommandFactory.createLoad(cacheKey, outputProperties, task, this.taskOutputsGenerationListener, taskState, clock));
                        if (originMetadata == null) ** GOTO lbl28
                        state.setOutcome(TaskExecutionOutcome.FROM_CACHE);
                        context.setOriginBuildInvocationId(originMetadata.getBuildInvocationId());
                        return;
                    }
                    catch (UnrecoverableTaskOutputUnpackingException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        SkipCachedTaskExecuter.LOGGER.warn("Failed to load cache entry for {}, falling back to executing task", (Object)task, (Object)e);
                    }
                } else {
                    SkipCachedTaskExecuter.LOGGER.info("Not loading {} from cache because pulling from cache is disabled for this task", (Object)task);
                }
            } else {
                SkipCachedTaskExecuter.LOGGER.info("Not caching {} because no valid cache key was generated", (Object)task);
            }
        }
lbl28:
        // 6 sources

        this.delegate.execute(task, state, context);
        if (taskOutputCachingEnabled) {
            if (cacheKey.isValid()) {
                if (state.getFailure() == null) {
                    try {
                        taskState = context.getTaskArtifactState();
                        outputSnapshots = taskState.getOutputContentSnapshots();
                        this.buildCache.store(this.buildCacheCommandFactory.createStore(cacheKey, outputProperties, outputSnapshots, task, clock));
                    }
                    catch (Exception e) {
                        SkipCachedTaskExecuter.LOGGER.warn("Failed to store cache entry {}", new Object[]{cacheKey.getDisplayName(), task, e});
                    }
                } else {
                    SkipCachedTaskExecuter.LOGGER.debug("Not pushing result from {} to cache because the task failed", (Object)task);
                }
            } else {
                SkipCachedTaskExecuter.LOGGER.info("Not pushing results from {} to cache because no valid cache key was generated", (Object)task);
            }
        }
    }
}

