/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.testng;

import org.gradle.api.internal.tasks.testing.detection.TestClassVisitor;
import org.gradle.api.internal.tasks.testing.detection.TestFrameworkDetector;
import org.gradle.api.internal.tasks.testing.testng.TestNGTestMethodDetecter;
import org.gradle.internal.impldep.org.objectweb.asm.AnnotationVisitor;
import org.gradle.internal.impldep.org.objectweb.asm.MethodVisitor;

class TestNGTestClassDetecter
extends TestClassVisitor {
    private boolean isAbstract;
    private String className;
    private String superClassName;
    private boolean test;

    TestNGTestClassDetecter(TestFrameworkDetector detector) {
        super(detector);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.isAbstract = (access & 0x400) != 0;
        this.className = name;
        this.superClassName = superName;
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if ("Lorg/testng/annotations/Test;".equals(desc)) {
            this.test = true;
        }
        return null;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (!this.isAbstract && !this.test) {
            return new TestNGTestMethodDetecter(this);
        }
        return null;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract;
    }

    @Override
    public boolean isTest() {
        return this.test;
    }

    void setTest(boolean test) {
        this.test = test;
    }

    @Override
    public String getSuperClassName() {
        return this.superClassName;
    }
}

