/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.buildinit.plugins.internal.BuildInitTestFramework;
import org.gradle.buildinit.plugins.internal.BuildScriptBuilder;
import org.gradle.buildinit.plugins.internal.LanguageLibraryProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.ProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.TemplateLibraryVersionProvider;
import org.gradle.buildinit.plugins.internal.TemplateOperation;
import org.gradle.buildinit.plugins.internal.TemplateOperationFactory;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;

public abstract class JavaProjectInitDescriptor
extends LanguageLibraryProjectInitDescriptor {
    private static final Description DESCRIPTION = new Description("Java", "Java Quickstart", "tutorial_java_projects", "java");
    private final DocumentationRegistry documentationRegistry;

    public JavaProjectInitDescriptor(TemplateOperationFactory templateOperationFactory, FileResolver fileResolver, TemplateLibraryVersionProvider libraryVersionProvider, ProjectInitDescriptor globalSettingsDescriptor, DocumentationRegistry documentationRegistry) {
        super("java", templateOperationFactory, fileResolver, libraryVersionProvider, globalSettingsDescriptor);
        this.documentationRegistry = documentationRegistry;
    }

    @Override
    public void generate(BuildInitTestFramework testFramework) {
        this.globalSettingsDescriptor.generate(testFramework);
        Description desc = this.getDescription();
        BuildScriptBuilder buildScriptBuilder = new BuildScriptBuilder(this.fileResolver.resolve("build.gradle")).fileComment("This generated file contains a sample " + desc.projectType + " project to get you started.").fileComment("For more details take a look at the " + desc.chapterName + " chapter in the Gradle").fileComment("user guide available at " + this.documentationRegistry.getDocumentationFor(desc.userguideId)).plugin("Apply the " + desc.pluginName + " plugin to add support for " + desc.projectType, desc.pluginName);
        this.configureBuildScript(buildScriptBuilder);
        this.addTestFramework(testFramework, buildScriptBuilder);
        buildScriptBuilder.create().generate();
        TemplateOperation javaSourceTemplate = this.sourceTemplateOperation();
        this.whenNoSourcesAvailable(javaSourceTemplate, this.testTemplateOperation(testFramework)).generate();
    }

    protected Description getDescription() {
        return DESCRIPTION;
    }

    protected String getImplementationConfigurationName() {
        return "compile";
    }

    protected String getTestImplementationConfigurationName() {
        return "test" + StringUtils.capitalize((String)this.getImplementationConfigurationName());
    }

    private void addTestFramework(BuildInitTestFramework testFramework, BuildScriptBuilder buildScriptBuilder) {
        switch (testFramework) {
            case SPOCK: {
                buildScriptBuilder.plugin("Apply the groovy plugin to also add support for Groovy (needed for Spock)", "groovy").dependency(this.getTestImplementationConfigurationName(), "Use the latest Groovy version for Spock testing", "org.codehaus.groovy:groovy-all:" + this.libraryVersionProvider.getVersion("groovy")).dependency(this.getTestImplementationConfigurationName(), "Use the awesome Spock testing and specification framework even with Java", "org.spockframework:spock-core:" + this.libraryVersionProvider.getVersion("spock"), "junit:junit:" + this.libraryVersionProvider.getVersion("junit"));
                break;
            }
            case TESTNG: {
                buildScriptBuilder.dependency(this.getTestImplementationConfigurationName(), "Use TestNG framework, also requires calling test.useTestNG() below", "org.gradle.internal.impldep.org.testng:testng:" + this.libraryVersionProvider.getVersion("testng")).configuration("Use TestNG for unit tests", "test.useTestNG()");
                break;
            }
            default: {
                buildScriptBuilder.dependency(this.getTestImplementationConfigurationName(), "Use JUnit test framework", "junit:junit:" + this.libraryVersionProvider.getVersion("junit"));
            }
        }
    }

    protected void configureBuildScript(BuildScriptBuilder buildScriptBuilder) {
        buildScriptBuilder.dependency(this.getImplementationConfigurationName(), "This dependency is found on compile classpath of this component and consumers.", "com.google.guava:guava:" + this.libraryVersionProvider.getVersion("guava"));
    }

    protected abstract TemplateOperation sourceTemplateOperation();

    protected abstract TemplateOperation testTemplateOperation(BuildInitTestFramework var1);

    @Override
    public boolean supports(BuildInitTestFramework testFramework) {
        return testFramework == BuildInitTestFramework.SPOCK || testFramework == BuildInitTestFramework.TESTNG;
    }

    protected static class Description {
        private final String projectType;
        private final String chapterName;
        private final String userguideId;
        private final String pluginName;

        public Description(String projectType, String chapterName, String userguideId, String pluginName) {
            this.projectType = projectType;
            this.chapterName = chapterName;
            this.userguideId = userguideId;
            this.pluginName = pluginName;
        }
    }
}

