/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.tasks.internal;

import java.io.File;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.wrapper.Wrapper;
import org.gradle.buildinit.tasks.InitBuild;

public class TaskConfiguration {
    public static final String INIT_BUILD_TASK_NAME = "init";
    public static final String GROUP = "Build Setup";

    public static void configureInit(final InitBuild init) {
        init.setGroup(GROUP);
        init.setDescription("Initializes a new Gradle build.");
        final Transformer<String, Project> setupCanBeSkipped = new Transformer<String, Project>(){

            @Override
            public String transform(Project project) {
                if (project.file("build.gradle").exists()) {
                    return "The build file 'build.gradle' already exists. Skipping build initialization.";
                }
                File buildFile = project.getBuildFile();
                if (buildFile != null && buildFile.exists()) {
                    return "The build file '" + buildFile.getName() + "' already exists. Skipping build initialization.";
                }
                if (project.file("settings.gradle").exists()) {
                    return "The settings file 'settings.gradle' already exists. Skipping build initialization.";
                }
                if (project.getSubprojects().size() > 0) {
                    return "This Gradle project appears to be part of an existing multi-project Gradle build. Skipping build initialization.";
                }
                return null;
            }
        };
        init.onlyIf((Spec<? super Task>)new Spec<Task>(){

            @Override
            public boolean isSatisfiedBy(Task element) {
                Object skippedMsg = setupCanBeSkipped.transform(element.getProject());
                if (skippedMsg != null) {
                    element.getProject().getLogger().warn((String)skippedMsg);
                    return false;
                }
                return true;
            }
        });
        init.dependsOn(new Callable<String>(){

            @Override
            public String call() throws Exception {
                if (setupCanBeSkipped.transform(init.getProject()) == null) {
                    return "wrapper";
                }
                return null;
            }
        });
    }

    public static void configureWrapper(Wrapper wrapper) {
        wrapper.setGroup(GROUP);
        wrapper.setDescription("Generates Gradle wrapper files.");
    }

    public static void createInitTask(Project project) {
        TaskConfiguration.configureInit(project.getTasks().create(INIT_BUILD_TASK_NAME, InitBuild.class));
    }

    public static void createWrapperTask(Project project) {
        TaskConfiguration.configureWrapper(project.getTasks().create("wrapper", Wrapper.class));
    }

    public static void addInitPlaceholder(ProjectInternal projectInternal) {
        if (projectInternal.getParent() == null) {
            projectInternal.getTasks().addPlaceholderAction(INIT_BUILD_TASK_NAME, InitBuild.class, new InitBuildAction());
        }
    }

    public static void addWrapperPlaceholder(ProjectInternal projectInternal) {
        if (projectInternal.getParent() == null) {
            projectInternal.getTasks().addPlaceholderAction("wrapper", Wrapper.class, new WrapperAction());
        }
    }

    private static class WrapperAction
    implements Action<Wrapper> {
        private WrapperAction() {
        }

        @Override
        public void execute(Wrapper wrapper) {
            TaskConfiguration.configureWrapper(wrapper);
        }
    }

    private static class InitBuildAction
    implements Action<InitBuild> {
        private InitBuildAction() {
        }

        @Override
        public void execute(InitBuild initBuild) {
            TaskConfiguration.configureInit(initBuild);
        }
    }
}

