/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.io.File;
import org.gradle.StartParameter;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.initialization.IncludedBuild;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.composite.internal.DefaultIncludedBuild;
import org.gradle.composite.internal.IncludedBuildFactory;
import org.gradle.composite.internal.IncludedBuildInternal;
import org.gradle.initialization.GradleLauncher;
import org.gradle.initialization.NestedBuildFactory;
import org.gradle.initialization.layout.BuildLayoutFactory;
import org.gradle.internal.Factory;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.work.WorkerLeaseService;

public class DefaultIncludedBuildFactory
implements IncludedBuildFactory {
    private final Instantiator instantiator;
    private final StartParameter startParameter;
    private final WorkerLeaseService workerLeaseService;
    private final BuildLayoutFactory buildLayoutFactory;

    public DefaultIncludedBuildFactory(Instantiator instantiator, StartParameter startParameter, WorkerLeaseService workerLeaseService, BuildLayoutFactory buildLayoutFactory) {
        this.instantiator = instantiator;
        this.startParameter = startParameter;
        this.workerLeaseService = workerLeaseService;
        this.buildLayoutFactory = buildLayoutFactory;
    }

    private void validateBuildDirectory(File dir) {
        if (!dir.exists()) {
            throw new InvalidUserDataException(String.format("Included build '%s' does not exist.", dir));
        }
        if (!dir.isDirectory()) {
            throw new InvalidUserDataException(String.format("Included build '%s' is not a directory.", dir));
        }
    }

    private void validateIncludedBuild(IncludedBuild includedBuild, SettingsInternal settings) {
        File settingsFile = this.buildLayoutFactory.findExistingSettingsFileIn(settings.getSettingsDir());
        if (settingsFile == null) {
            throw new InvalidUserDataException(String.format("Included build '%s' must have a settings file.", includedBuild.getName()));
        }
    }

    @Override
    public IncludedBuildInternal createBuild(File buildDirectory, NestedBuildFactory nestedBuildFactory) {
        this.validateBuildDirectory(buildDirectory);
        ContextualGradleLauncherFactory factory = new ContextualGradleLauncherFactory(buildDirectory, nestedBuildFactory, this.startParameter);
        DefaultIncludedBuild includedBuild = this.instantiator.newInstance(DefaultIncludedBuild.class, buildDirectory, factory, this.workerLeaseService.getCurrentWorkerLease());
        SettingsInternal settingsInternal = includedBuild.getLoadedSettings();
        this.validateIncludedBuild(includedBuild, settingsInternal);
        return includedBuild;
    }

    private class ContextualGradleLauncherFactory
    implements Factory<GradleLauncher> {
        private final File buildDirectory;
        private final NestedBuildFactory nestedBuildFactory;
        private final StartParameter buildStartParam;

        public ContextualGradleLauncherFactory(File buildDirectory, NestedBuildFactory nestedBuildFactory, StartParameter buildStartParam) {
            this.buildDirectory = buildDirectory;
            this.nestedBuildFactory = nestedBuildFactory;
            this.buildStartParam = buildStartParam;
        }

        @Override
        public GradleLauncher create() {
            StartParameter participantStartParam = this.createStartParameter(this.buildDirectory);
            GradleLauncher gradleLauncher = this.nestedBuildFactory.nestedInstance(participantStartParam);
            return gradleLauncher;
        }

        private StartParameter createStartParameter(File buildDirectory) {
            StartParameter includedBuildStartParam = this.buildStartParam.newBuild();
            includedBuildStartParam.setProjectDir(buildDirectory);
            includedBuildStartParam.setSearchUpwards(false);
            includedBuildStartParam.setConfigureOnDemand(false);
            includedBuildStartParam.setInitScripts(this.buildStartParam.getInitScripts());
            return includedBuildStartParam;
        }
    }
}

