/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.taskgraph;

import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import org.gradle.api.Action;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.concurrent.ParallelismConfiguration;
import org.gradle.execution.taskgraph.TaskExecutionPlan;
import org.gradle.execution.taskgraph.TaskInfo;
import org.gradle.execution.taskgraph.TaskPlanExecutor;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.ManagedExecutor;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.TimeFormatting;
import org.gradle.internal.time.Timer;
import org.gradle.internal.work.WorkerLeaseRegistry;
import org.gradle.internal.work.WorkerLeaseService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultTaskPlanExecutor
implements TaskPlanExecutor {
    private static final Logger LOGGER = Logging.getLogger(DefaultTaskPlanExecutor.class);
    private final int executorCount;
    private final ExecutorFactory executorFactory;
    private final WorkerLeaseService workerLeaseService;

    public DefaultTaskPlanExecutor(ParallelismConfiguration parallelismConfiguration, ExecutorFactory executorFactory, WorkerLeaseService workerLeaseService) {
        this.executorFactory = executorFactory;
        int numberOfParallelExecutors = parallelismConfiguration.getMaxWorkerCount();
        if (numberOfParallelExecutors < 1) {
            throw new IllegalArgumentException("Not a valid number of parallel executors: " + numberOfParallelExecutors);
        }
        this.executorCount = numberOfParallelExecutors;
        this.workerLeaseService = workerLeaseService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(TaskExecutionPlan taskExecutionPlan, Action<? super TaskInternal> taskWorker) {
        ManagedExecutor executor = this.executorFactory.create("Task worker for '" + taskExecutionPlan.getDisplayName() + "'");
        try {
            WorkerLeaseRegistry.WorkerLease parentWorkerLease = this.workerLeaseService.getCurrentWorkerLease();
            this.startAdditionalWorkers(taskExecutionPlan, taskWorker, executor, parentWorkerLease);
            this.taskWorker(taskExecutionPlan, taskWorker, parentWorkerLease).run();
            taskExecutionPlan.awaitCompletion();
        }
        finally {
            executor.stop();
        }
    }

    private void startAdditionalWorkers(TaskExecutionPlan taskExecutionPlan, Action<? super TaskInternal> taskWorker, Executor executor, WorkerLeaseRegistry.WorkerLease parentWorkerLease) {
        LOGGER.debug("Using {} parallel executor threads", this.executorCount);
        for (int i = 1; i < this.executorCount; ++i) {
            Runnable worker = this.taskWorker(taskExecutionPlan, taskWorker, parentWorkerLease);
            executor.execute(worker);
        }
    }

    private Runnable taskWorker(TaskExecutionPlan taskExecutionPlan, Action<? super TaskInternal> taskWorker, WorkerLeaseRegistry.WorkerLease parentWorkerLease) {
        return new TaskExecutorWorker(taskExecutionPlan, taskWorker, parentWorkerLease);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TaskExecutorWorker
    implements Runnable {
        private final TaskExecutionPlan taskExecutionPlan;
        private final Action<? super TaskInternal> taskWorker;
        private final WorkerLeaseRegistry.WorkerLease parentWorkerLease;

        private TaskExecutorWorker(TaskExecutionPlan taskExecutionPlan, Action<? super TaskInternal> taskWorker, WorkerLeaseRegistry.WorkerLease parentWorkerLease) {
            this.taskExecutionPlan = taskExecutionPlan;
            this.taskWorker = taskWorker;
            this.parentWorkerLease = parentWorkerLease;
        }

        @Override
        public void run() {
            final AtomicLong busy = new AtomicLong(0L);
            Timer totalTimer = Time.startTimer();
            final Timer taskTimer = Time.startTimer();
            WorkerLeaseRegistry.WorkerLease childLease = this.parentWorkerLease.createChild();
            boolean moreTasksToExecute = true;
            while (moreTasksToExecute) {
                moreTasksToExecute = this.taskExecutionPlan.executeWithTask(childLease, new Action<TaskInfo>(){

                    @Override
                    public void execute(TaskInfo task) {
                        String taskPath = task.getTask().getPath();
                        LOGGER.info("{} ({}) started.", taskPath, Thread.currentThread());
                        taskTimer.reset();
                        TaskExecutorWorker.this.processTask(task);
                        long taskDuration = taskTimer.getElapsedMillis();
                        busy.addAndGet(taskDuration);
                        if (LOGGER.isInfoEnabled()) {
                            LOGGER.info("{} ({}) completed. Took {}.", taskPath, Thread.currentThread(), TimeFormatting.formatDurationVerbose(taskDuration));
                        }
                    }
                });
            }
            long total = totalTimer.getElapsedMillis();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Task worker [{}] finished, busy: {}, idle: {}", Thread.currentThread(), TimeFormatting.formatDurationVerbose(busy.get()), TimeFormatting.formatDurationVerbose(total - busy.get()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processTask(TaskInfo taskInfo) {
            try {
                this.taskWorker.execute(taskInfo.getTask());
            }
            catch (Throwable e) {
                taskInfo.setExecutionFailure(e);
            }
            finally {
                this.taskExecutionPlan.taskComplete(taskInfo);
            }
        }
    }
}

