/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.visualstudio.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.gradle.api.Action;
import org.gradle.api.BuildableComponentSpec;
import org.gradle.api.XmlProvider;
import org.gradle.api.internal.AbstractBuildableComponentSpec;
import org.gradle.ide.visualstudio.VisualStudioProject;
import org.gradle.ide.visualstudio.XmlConfigFile;
import org.gradle.ide.visualstudio.internal.VisualStudioProjectConfiguration;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.nativeplatform.HeaderExportingSourceSet;
import org.gradle.language.rc.WindowsResourceSet;
import org.gradle.nativeplatform.NativeBinarySpec;
import org.gradle.nativeplatform.NativeComponentSpec;
import org.gradle.nativeplatform.internal.NativeBinarySpecInternal;
import org.gradle.platform.base.internal.ComponentSpecIdentifier;
import org.gradle.util.CollectionUtils;

public class DefaultVisualStudioProject
extends AbstractBuildableComponentSpec
implements VisualStudioProject {
    private final DefaultConfigFile projectFile;
    private final DefaultConfigFile filtersFile;
    private final NativeComponentSpec component;
    private final List<File> additionalFiles = new ArrayList<File>();
    private final Set<LanguageSourceSet> sources = new LinkedHashSet<LanguageSourceSet>();
    private final Map<NativeBinarySpec, VisualStudioProjectConfiguration> configurations = new LinkedHashMap<NativeBinarySpec, VisualStudioProjectConfiguration>();

    public DefaultVisualStudioProject(ComponentSpecIdentifier componentIdentifier, NativeComponentSpec component, PathToFileResolver fileResolver, Instantiator instantiator) {
        super(componentIdentifier, (Class<? extends BuildableComponentSpec>)VisualStudioProject.class);
        this.component = component;
        this.projectFile = instantiator.newInstance(DefaultConfigFile.class, fileResolver, this.getName() + ".vcxproj");
        this.filtersFile = instantiator.newInstance(DefaultConfigFile.class, fileResolver, this.getName() + ".vcxproj.filters");
    }

    @Override
    public DefaultConfigFile getProjectFile() {
        return this.projectFile;
    }

    @Override
    public DefaultConfigFile getFiltersFile() {
        return this.filtersFile;
    }

    @Override
    public NativeComponentSpec getComponent() {
        return this.component;
    }

    public void addSourceFile(File sourceFile) {
        this.additionalFiles.add(sourceFile);
    }

    public String getUuid() {
        String projectPath = this.component.getProjectPath();
        String vsComponentPath = projectPath + ":" + this.getName();
        return "{" + UUID.nameUUIDFromBytes(vsComponentPath.getBytes()).toString().toUpperCase() + "}";
    }

    public void source(Collection<LanguageSourceSet> sources) {
        this.sources.addAll(sources);
        this.builtBy(sources);
    }

    public Set<LanguageSourceSet> getSources() {
        return this.sources;
    }

    public List<File> getSourceFiles() {
        LinkedHashSet<File> allSource = new LinkedHashSet<File>();
        allSource.addAll(this.additionalFiles);
        for (LanguageSourceSet sourceSet : this.sources) {
            if (sourceSet instanceof WindowsResourceSet) continue;
            allSource.addAll(sourceSet.getSource().getFiles());
        }
        return new ArrayList<File>(allSource);
    }

    public List<File> getResourceFiles() {
        LinkedHashSet<File> allResources = new LinkedHashSet<File>();
        for (LanguageSourceSet sourceSet : this.sources) {
            if (!(sourceSet instanceof WindowsResourceSet)) continue;
            allResources.addAll(sourceSet.getSource().getFiles());
        }
        return new ArrayList<File>(allResources);
    }

    public List<File> getHeaderFiles() {
        LinkedHashSet<File> allHeaders = new LinkedHashSet<File>();
        for (LanguageSourceSet sourceSet : this.sources) {
            if (!(sourceSet instanceof HeaderExportingSourceSet)) continue;
            HeaderExportingSourceSet exportingSourceSet = (HeaderExportingSourceSet)sourceSet;
            allHeaders.addAll(exportingSourceSet.getExportedHeaders().getFiles());
            allHeaders.addAll(exportingSourceSet.getImplicitHeaders().getFiles());
        }
        return new ArrayList<File>(allHeaders);
    }

    public List<VisualStudioProjectConfiguration> getConfigurations() {
        return CollectionUtils.toList(this.configurations.values());
    }

    public void addConfiguration(NativeBinarySpec nativeBinary, VisualStudioProjectConfiguration configuration) {
        this.configurations.put(nativeBinary, configuration);
        NativeBinarySpecInternal specInternal = (NativeBinarySpecInternal)nativeBinary;
        this.source(specInternal.getInputs());
    }

    public VisualStudioProjectConfiguration getConfiguration(NativeBinarySpec nativeBinary) {
        return this.configurations.get(nativeBinary);
    }

    public static class DefaultConfigFile
    implements XmlConfigFile {
        private final List<Action<? super XmlProvider>> actions = new ArrayList<Action<? super XmlProvider>>();
        private final PathToFileResolver fileResolver;
        private Object location;

        public DefaultConfigFile(PathToFileResolver fileResolver, String defaultLocation) {
            this.fileResolver = fileResolver;
            this.location = defaultLocation;
        }

        @Override
        public File getLocation() {
            return this.fileResolver.resolve(this.location);
        }

        @Override
        public void setLocation(Object location) {
            this.location = location;
        }

        @Override
        public void withXml(Action<? super XmlProvider> action) {
            this.actions.add(action);
        }

        public List<Action<? super XmlProvider>> getXmlActions() {
            return this.actions;
        }
    }
}

