/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.xcode.tasks;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Internal;
import org.gradle.ide.xcode.XcodeProject;
import org.gradle.ide.xcode.internal.DefaultXcodeProject;
import org.gradle.ide.xcode.internal.XcodeTarget;
import org.gradle.ide.xcode.internal.XcodeUtils;
import org.gradle.ide.xcode.internal.xcodeproj.GidGenerator;
import org.gradle.ide.xcode.internal.xcodeproj.PBXBuildFile;
import org.gradle.ide.xcode.internal.xcodeproj.PBXFileReference;
import org.gradle.ide.xcode.internal.xcodeproj.PBXGroup;
import org.gradle.ide.xcode.internal.xcodeproj.PBXLegacyTarget;
import org.gradle.ide.xcode.internal.xcodeproj.PBXNativeTarget;
import org.gradle.ide.xcode.internal.xcodeproj.PBXProject;
import org.gradle.ide.xcode.internal.xcodeproj.PBXReference;
import org.gradle.ide.xcode.internal.xcodeproj.PBXShellScriptBuildPhase;
import org.gradle.ide.xcode.internal.xcodeproj.PBXSourcesBuildPhase;
import org.gradle.ide.xcode.internal.xcodeproj.PBXTarget;
import org.gradle.ide.xcode.internal.xcodeproj.XCBuildConfiguration;
import org.gradle.ide.xcode.internal.xcodeproj.XcodeprojSerializer;
import org.gradle.ide.xcode.tasks.internal.XcodeProjectFile;
import org.gradle.internal.impldep.com.dd.plist.NSDictionary;
import org.gradle.internal.impldep.com.dd.plist.NSObject;
import org.gradle.internal.impldep.com.dd.plist.NSString;
import org.gradle.internal.impldep.com.google.common.base.Optional;
import org.gradle.plugins.ide.api.PropertyListGeneratorTask;

@Incubating
public class GenerateXcodeProjectFileTask
extends PropertyListGeneratorTask<XcodeProjectFile> {
    private static final String PRODUCTS_GROUP_NAME = "Products";
    private final GidGenerator gidGenerator;
    private DefaultXcodeProject xcodeProject;
    private Map<String, PBXFileReference> pathToFileReference = new HashMap<String, PBXFileReference>();

    @Inject
    public GenerateXcodeProjectFileTask(GidGenerator gidGenerator) {
        this.gidGenerator = gidGenerator;
    }

    @Override
    protected void configure(XcodeProjectFile projectFile) {
        PBXProject project = new PBXProject(this.getProject().getPath());
        project.getBuildConfigurationList().getBuildConfigurationsByName().getUnchecked((Object)"Debug");
        project.getBuildConfigurationList().getBuildConfigurationsByName().getUnchecked((Object)"Release");
        this.addToGroup(project.getMainGroup(), this.xcodeProject.getGroups().getSources(), "Sources");
        this.addToGroup(project.getMainGroup(), this.xcodeProject.getGroups().getHeaders(), "Headers");
        this.addToGroup(project.getMainGroup(), this.xcodeProject.getGroups().getTests(), "Tests");
        this.addToGroup(project.getMainGroup(), this.xcodeProject.getGroups().getRoot());
        for (XcodeTarget xcodeTarget : this.xcodeProject.getTargets()) {
            project.getTargets().add(this.toGradlePbxTarget(xcodeTarget));
            project.getTargets().add(this.toIndexPbxTarget(xcodeTarget));
            if (xcodeTarget.isUnitTest()) {
                project.getBuildConfigurationList().getBuildConfigurationsByName().getUnchecked((Object)"__GradleTestRunner_Debug");
                continue;
            }
            File debugOutputFile = xcodeTarget.getDebugOutputFile().get().getAsFile();
            PBXFileReference fileReference = new PBXFileReference(debugOutputFile.getName(), debugOutputFile.getAbsolutePath(), PBXReference.SourceTree.ABSOLUTE);
            fileReference.setExplicitFileType((Optional<String>)Optional.of((Object)xcodeTarget.getOutputFileType()));
            project.getMainGroup().getOrCreateChildGroupByName(PRODUCTS_GROUP_NAME).getChildren().add(fileReference);
        }
        XcodeprojSerializer serializer = new XcodeprojSerializer(this.gidGenerator, project);
        final NSDictionary rootObject = serializer.toPlist();
        projectFile.transformAction(new Action<NSDictionary>(){

            @Override
            public void execute(NSDictionary dict) {
                dict.clear();
                dict.putAll((Map)rootObject);
            }
        });
    }

    private void addToGroup(PBXGroup mainGroup, FileCollection sources, String groupName) {
        if (!sources.isEmpty()) {
            this.addToGroup(mainGroup.getOrCreateChildGroupByName(groupName), sources);
        }
    }

    private void addToGroup(PBXGroup group, FileCollection sources) {
        for (File source : sources.getAsFileTree()) {
            PBXFileReference fileReference = this.toFileReference(source);
            this.pathToFileReference.put(source.getAbsolutePath(), fileReference);
            group.getChildren().add(fileReference);
        }
    }

    @Override
    protected XcodeProjectFile create() {
        return new XcodeProjectFile(this.getPropertyListTransformer());
    }

    private PBXFileReference toFileReference(File file) {
        return new PBXFileReference(file.getName(), file.getAbsolutePath(), PBXReference.SourceTree.ABSOLUTE);
    }

    private PBXTarget toGradlePbxTarget(XcodeTarget xcodeTarget) {
        if (xcodeTarget.isUnitTest()) {
            return this.toXCTestPbxTarget(xcodeTarget);
        }
        return this.toToolAndLibraryPbxTarget(xcodeTarget);
    }

    private PBXTarget toToolAndLibraryPbxTarget(XcodeTarget xcodeTarget) {
        PBXLegacyTarget target = new PBXLegacyTarget(xcodeTarget.getName(), xcodeTarget.getProductType());
        target.setProductName(xcodeTarget.getProductName());
        NSDictionary debugSettings = ((XCBuildConfiguration)target.getBuildConfigurationList().getBuildConfigurationsByName().getUnchecked((Object)"Debug")).getBuildSettings();
        NSDictionary releaseSettings = ((XCBuildConfiguration)target.getBuildConfigurationList().getBuildConfigurationsByName().getUnchecked((Object)"Release")).getBuildSettings();
        target.setBuildToolPath(xcodeTarget.getGradleCommand());
        target.setBuildArgumentsString(xcodeTarget.getTaskName());
        target.setGlobalID(xcodeTarget.getId());
        File outputFile = xcodeTarget.getDebugOutputFile().get().getAsFile();
        target.setProductReference(new PBXFileReference(outputFile.getName(), outputFile.getAbsolutePath(), PBXReference.SourceTree.ABSOLUTE));
        File debugOutputFile = xcodeTarget.getDebugOutputFile().get().getAsFile();
        debugSettings.put("CONFIGURATION_BUILD_DIR", (NSObject)new NSString(debugOutputFile.getParentFile().getAbsolutePath()));
        debugSettings.put("PRODUCT_NAME", (Object)target.getProductName());
        File releaseOutputFile = xcodeTarget.getReleaseOutputFile().get().getAsFile();
        releaseSettings.put("CONFIGURATION_BUILD_DIR", (NSObject)new NSString(releaseOutputFile.getParentFile().getAbsolutePath()));
        releaseSettings.put("PRODUCT_NAME", (Object)target.getProductName());
        return target;
    }

    private PBXTarget toXCTestPbxTarget(XcodeTarget xcodeTarget) {
        PBXShellScriptBuildPhase hackBuildPhase = new PBXShellScriptBuildPhase();
        hackBuildPhase.setShellPath("/bin/sh");
        hackBuildPhase.setShellScript("# Script to generate specific Swift files Xcode expects when running tests.\nset -eu\nARCH_ARRAY=($ARCHS)\nSUFFIXES=(swiftdoc swiftmodule h)\nfor ARCH in \"${ARCH_ARRAY[@]}\"\ndo\n  for SUFFIX in \"${SUFFIXES[@]}\"\n  do\n    touch \"$OBJECT_FILE_DIR_normal/$ARCH/$PRODUCT_NAME.$SUFFIX\"\n  done\ndone");
        PBXSourcesBuildPhase sourcesBuildPhase = new PBXSourcesBuildPhase();
        for (File file : xcodeTarget.getSources()) {
            PBXFileReference fileReference = this.pathToFileReference.get(file.getAbsolutePath());
            sourcesBuildPhase.getFiles().add(new PBXBuildFile(fileReference));
        }
        PBXShellScriptBuildPhase gradleBuildPhase = new PBXShellScriptBuildPhase();
        gradleBuildPhase.setShellPath("/bin/sh");
        gradleBuildPhase.setShellScript("exec \"" + xcodeTarget.getGradleCommand() + "\" " + xcodeTarget.getTaskName() + " < /dev/null");
        PBXNativeTarget target = new PBXNativeTarget(xcodeTarget.getName(), xcodeTarget.getProductType());
        target.setProductName(xcodeTarget.getProductName());
        target.setGlobalID(xcodeTarget.getId());
        target.getBuildPhases().add(hackBuildPhase);
        target.getBuildPhases().add(sourcesBuildPhase);
        target.getBuildPhases().add(gradleBuildPhase);
        File outputFile = xcodeTarget.getDebugOutputFile().get().getAsFile();
        target.setProductReference(new PBXFileReference(outputFile.getName(), outputFile.getAbsolutePath(), PBXReference.SourceTree.ABSOLUTE));
        NSDictionary debugSettings = ((XCBuildConfiguration)target.getBuildConfigurationList().getBuildConfigurationsByName().getUnchecked((Object)"Debug")).getBuildSettings();
        NSDictionary releaseSettings = ((XCBuildConfiguration)target.getBuildConfigurationList().getBuildConfigurationsByName().getUnchecked((Object)"Release")).getBuildSettings();
        NSDictionary testRunnerSettings = ((XCBuildConfiguration)target.getBuildConfigurationList().getBuildConfigurationsByName().getUnchecked((Object)"__GradleTestRunner_Debug")).getBuildSettings();
        if (!xcodeTarget.getCompileModules().isEmpty()) {
            debugSettings.put("SWIFT_INCLUDE_PATHS", (Object)XcodeUtils.toSpaceSeparatedList(xcodeTarget.getCompileModules()));
            releaseSettings.put("SWIFT_INCLUDE_PATHS", (Object)XcodeUtils.toSpaceSeparatedList(xcodeTarget.getCompileModules()));
            testRunnerSettings.put("SWIFT_INCLUDE_PATHS", (Object)XcodeUtils.toSpaceSeparatedList(xcodeTarget.getCompileModules()));
        }
        testRunnerSettings.put("SWIFT_VERSION", (Object)"3.0");
        testRunnerSettings.put("PRODUCT_NAME", (Object)target.getProductName());
        testRunnerSettings.put("OTHER_LDFLAGS", (Object)"-help");
        testRunnerSettings.put("OTHER_CFLAGS", (Object)"-help");
        testRunnerSettings.put("OTHER_SWIFT_FLAGS", (Object)"-help");
        testRunnerSettings.put("SWIFT_INSTALL_OBJC_HEADER", (Object)"NO");
        testRunnerSettings.put("SWIFT_OBJC_INTERFACE_HEADER_NAME", (Object)"$(PRODUCT_NAME).h");
        debugSettings.put("PRODUCT_NAME", (Object)target.getProductName());
        debugSettings.put("SWIFT_VERSION", (Object)"3.0");
        releaseSettings.put("PRODUCT_NAME", (Object)target.getProductName());
        releaseSettings.put("SWIFT_VERSION", (Object)"3.0");
        return target;
    }

    private PBXTarget toIndexPbxTarget(XcodeTarget xcodeTarget) {
        PBXSourcesBuildPhase buildPhase = new PBXSourcesBuildPhase();
        for (File file : xcodeTarget.getSources()) {
            PBXFileReference fileReference = this.pathToFileReference.get(file.getAbsolutePath());
            buildPhase.getFiles().add(new PBXBuildFile(fileReference));
        }
        PBXNativeTarget target = new PBXNativeTarget("[INDEXING ONLY] " + xcodeTarget.getName(), xcodeTarget.getProductType());
        target.setProductName(xcodeTarget.getProductName());
        NSDictionary buildSettings = new NSDictionary();
        buildSettings.put("SWIFT_VERSION", (Object)"3.0");
        buildSettings.put("PRODUCT_NAME", (Object)xcodeTarget.getProductName());
        if (!xcodeTarget.getHeaderSearchPaths().isEmpty()) {
            buildSettings.put("HEADER_SEARCH_PATHS", (Object)XcodeUtils.toSpaceSeparatedList(xcodeTarget.getHeaderSearchPaths()));
        }
        if (!xcodeTarget.getCompileModules().isEmpty()) {
            buildSettings.put("SWIFT_INCLUDE_PATHS", (Object)XcodeUtils.toSpaceSeparatedList(this.parentDirs(xcodeTarget.getCompileModules())));
        }
        ((XCBuildConfiguration)target.getBuildConfigurationList().getBuildConfigurationsByName().getUnchecked((Object)"Debug")).setBuildSettings(buildSettings);
        target.getBuildPhases().add(buildPhase);
        return target;
    }

    private Iterable<File> parentDirs(Iterable<File> files) {
        ArrayList<File> parents = new ArrayList<File>();
        for (File file : files) {
            parents.add(file.getParentFile());
        }
        return parents;
    }

    @Internal
    public XcodeProject getXcodeProject() {
        return this.xcodeProject;
    }

    public void setXcodeProject(XcodeProject xcodeProject) {
        this.xcodeProject = (DefaultXcodeProject)xcodeProject;
    }
}

