/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.StartParameter;
import org.gradle.api.Transformer;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.api.internal.file.BasicFileResolver;
import org.gradle.api.logging.configuration.LoggingConfiguration;
import org.gradle.cli.AbstractCommandLineConverter;
import org.gradle.cli.CommandLineArgumentException;
import org.gradle.cli.CommandLineConverter;
import org.gradle.cli.CommandLineParser;
import org.gradle.cli.ParsedCommandLine;
import org.gradle.cli.ProjectPropertiesCommandLineConverter;
import org.gradle.cli.SystemPropertiesCommandLineConverter;
import org.gradle.concurrent.ParallelismConfiguration;
import org.gradle.initialization.BuildLayoutParameters;
import org.gradle.initialization.LayoutCommandLineConverter;
import org.gradle.initialization.ParallelismConfigurationCommandLineConverter;
import org.gradle.initialization.StartParameterBuildOptions;
import org.gradle.internal.buildoption.BuildOption;
import org.gradle.internal.logging.LoggingCommandLineConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCommandLineConverter
extends AbstractCommandLineConverter<StartParameterInternal> {
    private final CommandLineConverter<LoggingConfiguration> loggingConfigurationCommandLineConverter = new LoggingCommandLineConverter();
    private final CommandLineConverter<ParallelismConfiguration> parallelConfigurationCommandLineConverter = new ParallelismConfigurationCommandLineConverter();
    private final SystemPropertiesCommandLineConverter systemPropertiesCommandLineConverter = new SystemPropertiesCommandLineConverter();
    private final ProjectPropertiesCommandLineConverter projectPropertiesCommandLineConverter = new ProjectPropertiesCommandLineConverter();
    private final List<BuildOption<StartParameterInternal>> buildOptions = StartParameterBuildOptions.get();
    private final LayoutCommandLineConverter layoutCommandLineConverter = new LayoutCommandLineConverter();

    @Override
    public void configure(CommandLineParser parser) {
        this.loggingConfigurationCommandLineConverter.configure(parser);
        this.parallelConfigurationCommandLineConverter.configure(parser);
        this.systemPropertiesCommandLineConverter.configure(parser);
        this.projectPropertiesCommandLineConverter.configure(parser);
        this.layoutCommandLineConverter.configure(parser);
        parser.allowMixedSubcommandsAndOptions();
        for (BuildOption<StartParameterInternal> option : this.buildOptions) {
            option.configure(parser);
        }
    }

    @Override
    public StartParameterInternal convert(ParsedCommandLine options, StartParameterInternal startParameter) throws CommandLineArgumentException {
        this.loggingConfigurationCommandLineConverter.convert(options, (LoggingConfiguration)startParameter);
        this.parallelConfigurationCommandLineConverter.convert(options, (ParallelismConfiguration)startParameter);
        BasicFileResolver resolver = new BasicFileResolver(startParameter.getCurrentDir());
        Map<String, String> systemProperties = this.systemPropertiesCommandLineConverter.convert(options, (Map<String, String>)new HashMap<String, String>());
        this.convertCommandLineSystemProperties(systemProperties, startParameter, resolver);
        Map<String, String> projectProperties = this.projectPropertiesCommandLineConverter.convert(options, (Map<String, String>)new HashMap<String, String>());
        startParameter.getProjectProperties().putAll(projectProperties);
        BuildLayoutParameters layout = new BuildLayoutParameters().setGradleUserHomeDir(startParameter.getGradleUserHomeDir()).setProjectDir(startParameter.getProjectDir()).setCurrentDir(startParameter.getCurrentDir());
        this.layoutCommandLineConverter.convert(options, layout);
        startParameter.setGradleUserHomeDir(layout.getGradleUserHomeDir());
        if (layout.getProjectDir() != null) {
            startParameter.setProjectDir(layout.getProjectDir());
        }
        startParameter.setSearchUpwards(layout.getSearchUpwards());
        if (!options.getExtraArguments().isEmpty()) {
            startParameter.setTaskNames(options.getExtraArguments());
        }
        for (BuildOption<StartParameterInternal> option : this.buildOptions) {
            option.applyFromCommandLine(options, startParameter);
        }
        return startParameter;
    }

    void convertCommandLineSystemProperties(Map<String, String> systemProperties, StartParameter startParameter, Transformer<File, String> resolver) {
        startParameter.getSystemPropertiesArgs().putAll(systemProperties);
        if (systemProperties.containsKey("gradle.user.home")) {
            startParameter.setGradleUserHomeDir(resolver.transform(systemProperties.get("gradle.user.home")));
        }
    }

    public LayoutCommandLineConverter getLayoutConverter() {
        return this.layoutCommandLineConverter;
    }

    public SystemPropertiesCommandLineConverter getSystemPropertiesConverter() {
        return this.systemPropertiesCommandLineConverter;
    }
}

