/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.NamespaceId;
import org.gradle.internal.component.external.descriptor.Artifact;
import org.gradle.internal.component.external.descriptor.Configuration;
import org.gradle.internal.component.external.model.AbstractMutableModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.DefaultIvyModuleResolveMetadata;
import org.gradle.internal.component.external.model.DefaultModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.IvyConfigurationMetadata;
import org.gradle.internal.component.external.model.IvyModuleResolveMetadata;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.external.model.MutableIvyModuleResolveMetadata;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.Exclude;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;

public class DefaultMutableIvyModuleResolveMetadata
extends AbstractMutableModuleComponentResolveMetadata<IvyConfigurationMetadata>
implements MutableIvyModuleResolveMetadata {
    private final ImmutableList<Artifact> artifactDefinitions;
    private Map<Artifact, ModuleComponentArtifactMetadata> artifacts;
    private final ImmutableMap<String, Configuration> configurations;
    private ImmutableList<Exclude> excludes;
    private ImmutableMap<NamespaceId, String> extraAttributes;
    private String branch;

    public static DefaultMutableIvyModuleResolveMetadata missing(ModuleVersionIdentifier id, ModuleComponentIdentifier componentIdentifier) {
        DefaultMutableIvyModuleResolveMetadata metadata = new DefaultMutableIvyModuleResolveMetadata(id, componentIdentifier);
        metadata.setMissing(true);
        return metadata;
    }

    public DefaultMutableIvyModuleResolveMetadata(ModuleVersionIdentifier id, ModuleComponentIdentifier componentIdentifier) {
        this(id, componentIdentifier, (Collection<Configuration>)ImmutableList.of((Object)new Configuration("default", true, true, (Collection<String>)ImmutableSet.of())), (Collection<? extends ModuleDependencyMetadata>)ImmutableList.of(), (Collection<? extends Artifact>)ImmutableList.of((Object)new Artifact(new DefaultIvyArtifactName(componentIdentifier.getModule(), "jar", "jar"), (Set<String>)ImmutableSet.of((Object)"default"))));
    }

    public DefaultMutableIvyModuleResolveMetadata(ModuleVersionIdentifier id, ModuleComponentIdentifier componentIdentifier, Collection<Configuration> configurations, Collection<? extends ModuleDependencyMetadata> dependencies, Collection<? extends Artifact> artifacts) {
        super(id, componentIdentifier, (List<? extends ModuleDependencyMetadata>)ImmutableList.copyOf(dependencies));
        this.configurations = DefaultMutableIvyModuleResolveMetadata.toMap(configurations);
        this.artifactDefinitions = ImmutableList.copyOf(artifacts);
        this.excludes = ImmutableList.of();
        this.extraAttributes = ImmutableMap.of();
    }

    public DefaultMutableIvyModuleResolveMetadata(IvyModuleResolveMetadata metadata) {
        super(metadata);
        this.configurations = metadata.getConfigurationDefinitions();
        this.artifactDefinitions = metadata.getArtifactDefinitions();
        this.excludes = metadata.getExcludes();
        this.branch = metadata.getBranch();
        this.extraAttributes = metadata.getExtraAttributes();
    }

    private static ImmutableMap<String, Configuration> toMap(Collection<Configuration> configurations) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Configuration configuration : configurations) {
            builder.put((Object)configuration.getName(), (Object)configuration);
        }
        return builder.build();
    }

    @Override
    protected IvyConfigurationMetadata createConfiguration(ModuleComponentIdentifier componentId, String name, boolean transitive, boolean visible, ImmutableList<IvyConfigurationMetadata> parents, ImmutableList<? extends ModuleComponentArtifactMetadata> artifactOverrides) {
        LinkedHashSet<ModuleComponentArtifactMetadata> artifacts = new LinkedHashSet<ModuleComponentArtifactMetadata>();
        this.collectArtifactsFor(name, (Collection<? extends ModuleComponentArtifactMetadata>)artifactOverrides, (Collection<ModuleComponentArtifactMetadata>)artifacts);
        for (IvyConfigurationMetadata parent : parents) {
            artifacts.addAll(parent.getArtifacts());
        }
        return new IvyConfigurationMetadata(componentId, name, transitive, visible, parents, (List<Exclude>)this.excludes, (ImmutableList<ModuleComponentArtifactMetadata>)ImmutableList.copyOf(artifacts));
    }

    private void collectArtifactsFor(String name, Collection<? extends ModuleComponentArtifactMetadata> artifactOverrides, Collection<ModuleComponentArtifactMetadata> dest) {
        if (artifactOverrides != null) {
            dest.addAll(artifactOverrides);
            return;
        }
        if (this.artifacts == null) {
            this.artifacts = new IdentityHashMap<Artifact, ModuleComponentArtifactMetadata>();
        }
        for (Artifact artifact : this.artifactDefinitions) {
            if (!artifact.getConfigurations().contains(name)) continue;
            ModuleComponentArtifactMetadata artifactMetadata = this.artifacts.get(artifact);
            if (artifactMetadata == null) {
                artifactMetadata = new DefaultModuleComponentArtifactMetadata(this.getComponentId(), artifact.getArtifactName());
                this.artifacts.put(artifact, artifactMetadata);
            }
            dest.add(artifactMetadata);
        }
    }

    @Override
    public ImmutableMap<String, Configuration> getConfigurationDefinitions() {
        return this.configurations;
    }

    @Override
    public boolean definesVariant(String name) {
        return this.configurations.containsKey((Object)name);
    }

    @Override
    public ImmutableList<Artifact> getArtifactDefinitions() {
        return this.artifactDefinitions;
    }

    @Override
    public ImmutableList<Exclude> getExcludes() {
        return this.excludes;
    }

    @Override
    public void setExcludes(Iterable<? extends Exclude> excludes) {
        this.excludes = ImmutableList.copyOf(excludes);
        this.resetConfigurations();
    }

    @Override
    public ImmutableMap<NamespaceId, String> getExtraAttributes() {
        return this.extraAttributes;
    }

    @Override
    public void setExtraAttributes(Map<NamespaceId, String> extraAttributes) {
        this.extraAttributes = ImmutableMap.copyOf(extraAttributes);
    }

    @Override
    @Nullable
    public String getBranch() {
        return this.branch;
    }

    @Override
    public void setBranch(String branch) {
        this.branch = branch;
    }

    @Override
    public IvyModuleResolveMetadata asImmutable() {
        return new DefaultIvyModuleResolveMetadata(this);
    }
}

