/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.artifacts.DependenciesMetadata;
import org.gradle.api.artifacts.DependencyMetadata;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.GradlePomModuleDescriptorBuilder;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.component.external.descriptor.Configuration;
import org.gradle.internal.component.external.model.AbstractMutableModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.ComponentVariant;
import org.gradle.internal.component.external.model.DefaultMavenModuleResolveMetadata;
import org.gradle.internal.component.external.model.DefaultModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.MavenConfigurationMetadata;
import org.gradle.internal.component.external.model.MavenModuleResolveMetadata;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.external.model.MutableComponentVariant;
import org.gradle.internal.component.external.model.MutableMavenModuleResolveMetadata;
import org.gradle.internal.component.external.model.UrlBackedArtifactMetadata;
import org.gradle.internal.component.external.model.VariantBackedConfigurationMetadata;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.DependencyMetadataRules;
import org.gradle.internal.component.model.VariantMetadata;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationParser;

public class DefaultMutableMavenModuleResolveMetadata
extends AbstractMutableModuleComponentResolveMetadata<MavenConfigurationMetadata>
implements MutableMavenModuleResolveMetadata {
    private String packaging = "jar";
    private boolean relocated;
    private String snapshotTimestamp;
    private List<MutableVariantImpl> newVariants;
    private ImmutableList<? extends ComponentVariant> variants;
    private ImmutableList<? extends ConfigurationMetadata> graphVariants;

    public static DefaultMutableMavenModuleResolveMetadata missing(ModuleVersionIdentifier id, ModuleComponentIdentifier componentIdentifier) {
        DefaultMutableMavenModuleResolveMetadata metadata = new DefaultMutableMavenModuleResolveMetadata(id, componentIdentifier);
        metadata.setMissing(true);
        return metadata;
    }

    public DefaultMutableMavenModuleResolveMetadata(ModuleVersionIdentifier id, ModuleComponentIdentifier componentIdentifier) {
        this(id, componentIdentifier, (Collection<? extends ModuleDependencyMetadata>)ImmutableList.of());
    }

    public DefaultMutableMavenModuleResolveMetadata(ModuleVersionIdentifier id, ModuleComponentIdentifier componentIdentifier, Collection<? extends ModuleDependencyMetadata> dependencies) {
        super(id, componentIdentifier, (List<? extends ModuleDependencyMetadata>)ImmutableList.copyOf(dependencies));
    }

    DefaultMutableMavenModuleResolveMetadata(MavenModuleResolveMetadata metadata) {
        super(metadata);
        this.packaging = metadata.getPackaging();
        this.relocated = metadata.isRelocated();
        this.snapshotTimestamp = metadata.getSnapshotTimestamp();
        this.variants = metadata.getVariants();
        this.graphVariants = metadata.getVariantsForGraphTraversal();
    }

    @Override
    protected MavenConfigurationMetadata createConfiguration(ModuleComponentIdentifier componentId, String name, boolean transitive, boolean visible, ImmutableList<MavenConfigurationMetadata> parents, ImmutableList<? extends ModuleComponentArtifactMetadata> artifactOverrides) {
        ImmutableList artifacts = artifactOverrides != null ? artifactOverrides : (name.equals("compile") || name.equals("runtime") || name.equals("default") || name.equals("test") ? ImmutableList.of((Object)new DefaultModuleComponentArtifactMetadata(this.getComponentId(), new DefaultIvyArtifactName(this.getComponentId().getModule(), "jar", "jar"))) : ImmutableList.of());
        return new MavenConfigurationMetadata(componentId, name, transitive, visible, parents, (ImmutableList<? extends ModuleComponentArtifactMetadata>)artifacts);
    }

    @Override
    public MavenModuleResolveMetadata asImmutable() {
        return new DefaultMavenModuleResolveMetadata(this);
    }

    @Override
    protected Map<String, Configuration> getConfigurationDefinitions() {
        return GradlePomModuleDescriptorBuilder.MAVEN2_CONFIGURATIONS;
    }

    @Override
    public boolean definesVariant(String name) {
        if (this.explicitlyDefinesVariants()) {
            return this.containsNamedVariant(name);
        }
        return this.getConfigurationDefinitions().containsKey(name);
    }

    private boolean explicitlyDefinesVariants() {
        return this.variants != null && !this.variants.isEmpty() || this.newVariants != null && !this.newVariants.isEmpty();
    }

    private boolean containsNamedVariant(String name) {
        if (this.variants != null) {
            for (Object variant : this.variants) {
                if (!variant.getName().equals(name)) continue;
                return true;
            }
        }
        if (this.newVariants != null) {
            for (Object variant : this.newVariants) {
                if (!((MutableVariantImpl)variant).name.equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @Nullable
    public String getSnapshotTimestamp() {
        return this.snapshotTimestamp;
    }

    @Override
    public void setSnapshotTimestamp(@Nullable String snapshotTimestamp) {
        this.snapshotTimestamp = snapshotTimestamp;
    }

    @Override
    public boolean isRelocated() {
        return this.relocated;
    }

    @Override
    public void setRelocated(boolean relocated) {
        this.relocated = relocated;
    }

    @Override
    public String getPackaging() {
        return this.packaging;
    }

    @Override
    public void setPackaging(String packaging) {
        this.packaging = packaging;
    }

    @Override
    public boolean isPomPackaging() {
        return "pom".equals(this.packaging);
    }

    @Override
    public boolean isKnownJarPackaging() {
        return DefaultMavenModuleResolveMetadata.JAR_PACKAGINGS.contains(this.packaging);
    }

    @Override
    public void addDependencyMetadataRule(String variantName, Action<DependenciesMetadata> action, Instantiator instantiator, NotationParser<Object, DependencyMetadata> dependencyNotationParser) {
        super.addDependencyMetadataRule(variantName, action, instantiator, dependencyNotationParser);
        this.graphVariants = null;
    }

    @Override
    public MutableComponentVariant addVariant(String variantName, ImmutableAttributes attributes) {
        MutableVariantImpl variant = new MutableVariantImpl(variantName, attributes);
        if (this.newVariants == null) {
            this.newVariants = new ArrayList<MutableVariantImpl>();
        }
        this.newVariants.add(variant);
        this.graphVariants = null;
        return variant;
    }

    @Override
    public ImmutableList<? extends ConfigurationMetadata> getVariantsForGraphTraversal() {
        if (this.graphVariants == null) {
            ImmutableList<? extends ComponentVariant> variants = this.getVariants();
            if (variants.isEmpty()) {
                this.graphVariants = ImmutableList.of();
            } else {
                ArrayList<VariantBackedConfigurationMetadata> configurations = new ArrayList<VariantBackedConfigurationMetadata>(variants.size());
                for (ComponentVariant variant : variants) {
                    configurations.add(new VariantBackedConfigurationMetadata(this.getComponentId(), variant, (DependencyMetadataRules)this.dependencyMetadataRules.get(variant.getName())));
                }
                this.graphVariants = ImmutableList.copyOf(configurations);
            }
        }
        return this.graphVariants;
    }

    @Override
    public ImmutableList<? extends ComponentVariant> getVariants() {
        if (this.variants == null && this.newVariants == null) {
            return ImmutableList.of();
        }
        if (this.variants != null && this.newVariants == null) {
            return this.variants;
        }
        ImmutableList.Builder builder = new ImmutableList.Builder();
        if (this.variants != null) {
            builder.addAll(this.variants);
        }
        for (MutableVariantImpl variant : this.newVariants) {
            builder.add((Object)new ImmutableVariantImpl(this.getComponentId(), variant.name, variant.attributes, (ImmutableList<DependencyImpl>)ImmutableList.copyOf((Collection)variant.dependencies), (ImmutableList<FileImpl>)ImmutableList.copyOf((Collection)variant.files)));
        }
        return builder.build();
    }

    private static class ImmutableVariantImpl
    implements ComponentVariant,
    VariantMetadata {
        private final ModuleComponentIdentifier componentId;
        private final String name;
        private final ImmutableAttributes attributes;
        private final ImmutableList<DependencyImpl> dependencies;
        private final ImmutableList<FileImpl> files;

        ImmutableVariantImpl(ModuleComponentIdentifier componentId, String name, ImmutableAttributes attributes, ImmutableList<DependencyImpl> dependencies, ImmutableList<FileImpl> files) {
            this.componentId = componentId;
            this.name = name;
            this.attributes = attributes;
            this.dependencies = dependencies;
            this.files = files;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public DisplayName asDescribable() {
            return Describables.of(this.componentId, "variant", this.name);
        }

        @Override
        public ImmutableAttributes getAttributes() {
            return this.attributes;
        }

        @Override
        public ImmutableList<? extends ComponentVariant.Dependency> getDependencies() {
            return this.dependencies;
        }

        @Override
        public ImmutableList<? extends ComponentVariant.File> getFiles() {
            return this.files;
        }

        @Override
        public List<? extends ComponentArtifactMetadata> getArtifacts() {
            ArrayList<UrlBackedArtifactMetadata> artifacts = new ArrayList<UrlBackedArtifactMetadata>(this.files.size());
            for (ComponentVariant.File file : this.files) {
                artifacts.add(new UrlBackedArtifactMetadata(this.componentId, file.getName(), file.getUri()));
            }
            return artifacts;
        }
    }

    private static class DependencyImpl
    implements ComponentVariant.Dependency {
        private final String group;
        private final String module;
        private final VersionConstraint versionConstraint;

        DependencyImpl(String group, String module, VersionConstraint versionConstraint) {
            this.group = group;
            this.module = module;
            this.versionConstraint = versionConstraint;
        }

        @Override
        public String getGroup() {
            return this.group;
        }

        @Override
        public String getModule() {
            return this.module;
        }

        @Override
        public VersionConstraint getVersionConstraint() {
            return this.versionConstraint;
        }
    }

    private static class FileImpl
    implements ComponentVariant.File {
        private final String name;
        private final String uri;

        FileImpl(String name, String uri) {
            this.name = name;
            this.uri = uri;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getUri() {
            return this.uri;
        }
    }

    private static class MutableVariantImpl
    implements MutableComponentVariant {
        private final String name;
        private final ImmutableAttributes attributes;
        private final List<DependencyImpl> dependencies = new ArrayList<DependencyImpl>();
        private final List<FileImpl> files = new ArrayList<FileImpl>();

        MutableVariantImpl(String name, ImmutableAttributes attributes) {
            this.name = name;
            this.attributes = attributes;
        }

        @Override
        public void addDependency(String group, String module, VersionConstraint versionConstraint) {
            this.dependencies.add(new DependencyImpl(group, module, versionConstraint));
        }

        @Override
        public void addFile(String name, String uri) {
            this.files.add(new FileImpl(name, uri));
        }
    }
}

