/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.model;

import java.util.Collections;
import java.util.Set;
import org.gradle.api.artifacts.ClientModule;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.internal.component.local.model.DslOriginDependencyMetadata;
import org.gradle.internal.component.model.ComponentOverrideMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.impldep.com.google.common.collect.Sets;

public class DefaultComponentOverrideMetadata
implements ComponentOverrideMetadata {
    private final boolean changing;
    private final Set<IvyArtifactName> artifacts;
    private final ClientModule clientModule;

    public static ComponentOverrideMetadata forDependency(DependencyMetadata dependencyMetadata) {
        return new DefaultComponentOverrideMetadata(dependencyMetadata.isChanging(), dependencyMetadata.getArtifacts(), DefaultComponentOverrideMetadata.extractClientModule(dependencyMetadata));
    }

    public DefaultComponentOverrideMetadata() {
        this(false, Collections.emptySet(), null);
    }

    private DefaultComponentOverrideMetadata(boolean changing, Set<IvyArtifactName> artifacts, ClientModule clientModule) {
        this.changing = changing;
        this.artifacts = Sets.newHashSet(artifacts);
        this.clientModule = clientModule;
    }

    private static ClientModule extractClientModule(DependencyMetadata dependencyMetadata) {
        ModuleDependency source;
        if (dependencyMetadata instanceof DslOriginDependencyMetadata && (source = ((DslOriginDependencyMetadata)dependencyMetadata).getSource()) instanceof ClientModule) {
            return (ClientModule)source;
        }
        return null;
    }

    @Override
    public ComponentOverrideMetadata withChanging() {
        return new DefaultComponentOverrideMetadata(true, this.artifacts, this.clientModule);
    }

    @Override
    public Set<IvyArtifactName> getArtifacts() {
        return this.artifacts;
    }

    @Override
    public boolean isChanging() {
        return this.changing;
    }

    @Override
    public ClientModule getClientModule() {
        return this.clientModule;
    }
}

